/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.component.AttackRange;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.inventory.meta.components.AttackRangeComponent;

@SerializableAs(value="AttackRange")
public final class CraftAttackRangeComponent
implements AttackRangeComponent {
    private AttackRange handle;

    public CraftAttackRangeComponent(AttackRange handle) {
        this.handle = handle;
    }

    public CraftAttackRangeComponent(CraftAttackRangeComponent craft) {
        this.handle = craft.handle;
    }

    public CraftAttackRangeComponent(Map<String, Object> map) {
        Float minReach = SerializableMeta.getObject(Float.class, map, "min-reach", true);
        Float maxReach = SerializableMeta.getObject(Float.class, map, "max-reach", true);
        Float minCreativeReach = SerializableMeta.getObject(Float.class, map, "min-creative-reach", true);
        Float maxCreativeReach = SerializableMeta.getObject(Float.class, map, "max-creative-reach", true);
        Float hitboxMargin = SerializableMeta.getObject(Float.class, map, "hitbox-margin", true);
        Float mobFactor = SerializableMeta.getObject(Float.class, map, "mob-factor", true);
        this.handle = new AttackRange(minReach != null ? minReach.floatValue() : 0.0f, maxReach != null ? maxReach.floatValue() : 3.0f, minCreativeReach != null ? minCreativeReach.floatValue() : 0.0f, maxCreativeReach != null ? maxCreativeReach.floatValue() : 3.0f, hitboxMargin != null ? hitboxMargin.floatValue() : 0.3f, mobFactor != null ? mobFactor.floatValue() : 1.0f);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("min-reach", Float.valueOf(this.getMinReach()));
        result.put("max-reach", Float.valueOf(this.getMaxReach()));
        result.put("min-creative-reach", Float.valueOf(this.getMinCreativeReach()));
        result.put("max-creative-reach", Float.valueOf(this.getMaxCreativeReach()));
        result.put("hitbox-margin", Float.valueOf(this.getHitboxMargin()));
        result.put("mob-factor", Float.valueOf(this.getMobFactor()));
        return result;
    }

    public AttackRange getHandle() {
        return this.handle;
    }

    public float getMinReach() {
        return this.handle.minRange();
    }

    public void setMinReach(float reach) {
        this.handle = new AttackRange(reach, this.handle.maxRange(), this.handle.minCreativeRange(), this.handle.maxCreativeRange(), this.handle.hitboxMargin(), this.handle.mobFactor());
    }

    public float getMaxReach() {
        return this.handle.maxRange();
    }

    public void setMaxReach(float reach) {
        this.handle = new AttackRange(this.handle.minRange(), reach, this.handle.minCreativeRange(), this.handle.maxCreativeRange(), this.handle.hitboxMargin(), this.handle.mobFactor());
    }

    public float getMinCreativeReach() {
        return this.handle.minCreativeRange();
    }

    public void setMinCreativeReach(float reach) {
        this.handle = new AttackRange(this.handle.minRange(), this.handle.maxRange(), reach, this.handle.maxCreativeRange(), this.handle.hitboxMargin(), this.handle.mobFactor());
    }

    public float getMaxCreativeReach() {
        return this.handle.maxCreativeRange();
    }

    public void setMaxCreativeReach(float reach) {
        this.handle = new AttackRange(this.handle.minRange(), this.handle.maxRange(), this.handle.minCreativeRange(), reach, this.handle.hitboxMargin(), this.handle.mobFactor());
    }

    public float getHitboxMargin() {
        return this.handle.hitboxMargin();
    }

    public void setHitboxMargin(float margin) {
        this.handle = new AttackRange(this.handle.minRange(), this.handle.maxRange(), this.handle.minCreativeRange(), this.handle.maxCreativeRange(), margin, this.handle.mobFactor());
    }

    public float getMobFactor() {
        return this.handle.mobFactor();
    }

    public void setMobFactor(float factor) {
        this.handle = new AttackRange(this.handle.minRange(), this.handle.maxRange(), this.handle.minCreativeRange(), this.handle.maxCreativeRange(), this.handle.hitboxMargin(), this.handle.mobFactor());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftAttackRangeComponent other = (CraftAttackRangeComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public String toString() {
        return "CraftAttackRangeComponent{handle=" + String.valueOf(this.handle) + "}";
    }
}

