/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.view.builder;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.inventory.view.builder.CraftAbstractLocationInventoryViewBuilder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.LocationInventoryViewBuilder;

public class CraftBlockEntityInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractLocationInventoryViewBuilder<V> {
    private final Block block;
    private final CraftTileInventoryBuilder builder;

    public CraftBlockEntityInventoryViewBuilder(MenuType<?> handle, Block block, CraftTileInventoryBuilder builder) {
        super(handle);
        this.block = block;
        this.builder = builder;
    }

    @Override
    protected AbstractContainerMenu buildContainer(ServerPlayer player) {
        BlockEntity entity;
        if (this.world == null) {
            this.world = player.level();
        }
        if (this.position == null) {
            this.position = player.blockPosition();
        }
        if (!((entity = this.world.getBlockEntity(this.position)) instanceof MenuConstructor)) {
            return this.buildFakeTile(player);
        }
        MenuConstructor container = (MenuConstructor)((Object)entity);
        AbstractContainerMenu atBlock = container.createMenu(player.nextContainerCounter(), player.getInventory(), player);
        if (atBlock.getType() != this.handle) {
            return this.buildFakeTile(player);
        }
        return atBlock;
    }

    private AbstractContainerMenu buildFakeTile(ServerPlayer player) {
        if (this.builder == null) {
            return this.handle.create(player.nextContainerCounter(), player.getInventory());
        }
        MenuProvider inventory = this.builder.build(this.position, this.block.defaultBlockState());
        if (inventory instanceof BlockEntity) {
            BlockEntity tile = (BlockEntity)((Object)inventory);
            tile.setLevel(this.world);
        }
        return inventory.createMenu(player.nextContainerCounter(), player.getInventory(), player);
    }

    @Override
    public LocationInventoryViewBuilder<V> copy() {
        CraftBlockEntityInventoryViewBuilder<V> copy = new CraftBlockEntityInventoryViewBuilder<V>(this.handle, this.block, this.builder);
        copy.world = this.world;
        copy.position = this.position;
        copy.checkReachable = this.checkReachable;
        copy.title = this.title;
        return copy;
    }

    public static interface CraftTileInventoryBuilder {
        public MenuProvider build(BlockPos var1, BlockState var2);
    }
}

