/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.view.builder;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.view.builder.CraftAbstractLocationInventoryViewBuilder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.LocationInventoryViewBuilder;

public class CraftDoubleChestInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractLocationInventoryViewBuilder<V> {
    public CraftDoubleChestInventoryViewBuilder(MenuType<?> handle) {
        super(handle);
    }

    @Override
    protected AbstractContainerMenu buildContainer(ServerPlayer player) {
        if (this.world == null) {
            return this.handle.create(player.nextContainerCounter(), player.getInventory());
        }
        ChestBlock chest = (ChestBlock)Blocks.CHEST;
        DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> result = chest.combine(this.world.getBlockState(this.position), this.world, this.position, false);
        if (result instanceof DoubleBlockCombiner.NeighborCombineResult.Single) {
            return this.handle.create(player.nextContainerCounter(), player.getInventory());
        }
        MenuProvider combined = result.apply(ChestBlock.MENU_PROVIDER_COMBINER).orElse(null);
        if (combined == null) {
            return this.handle.create(player.nextContainerCounter(), player.getInventory());
        }
        return combined.createMenu(player.nextContainerCounter(), player.getInventory(), player);
    }

    @Override
    public LocationInventoryViewBuilder<V> copy() {
        CraftDoubleChestInventoryViewBuilder<V> copy = new CraftDoubleChestInventoryViewBuilder<V>(this.handle);
        copy.world = this.world;
        copy.position = this.position;
        copy.checkReachable = this.checkReachable;
        copy.title = this.title;
        return copy;
    }
}

