/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.legacy.enums;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.legacy.enums.DummyEnum;
import org.bukkit.craftbukkit.v1_21_R7.legacy.enums.EnumEvil;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;

public class ImposterEnumSet
extends AbstractSet<Object> {
    private final Class<?> objectClass;
    private final Set set;

    private static Set createSet(Class<?> clazz) {
        if (clazz.isEnum()) {
            return EnumSet.noneOf(clazz);
        }
        return new TreeSet();
    }

    public static ImposterEnumSet noneOf(Class<?> clazz) {
        Set set = ImposterEnumSet.createSet(clazz);
        return new ImposterEnumSet(set, clazz);
    }

    public static ImposterEnumSet allOf(Class<?> clazz) {
        AbstractSet set;
        if (clazz.isEnum()) {
            set = EnumSet.allOf(clazz);
        } else {
            set = new HashSet();
            Registry<?> registry = EnumEvil.getRegistry(clazz);
            if (registry == null) {
                throw new IllegalArgumentException("Class " + String.valueOf(clazz) + " is not an Enum nor an OldEnum");
            }
            for (Object object : registry) {
                set.add(object);
            }
        }
        return new ImposterEnumSet(set, clazz);
    }

    public static ImposterEnumSet copyOf(Set set) {
        Class clazz;
        if (set instanceof ImposterEnumSet) {
            ImposterEnumSet imposter = (ImposterEnumSet)set;
            set = imposter.set;
            clazz = imposter.objectClass;
        } else {
            clazz = !set.isEmpty() ? set.stream().filter(val -> val != null).map(val -> val.getClass()).findAny().orElse(Object.class) : Object.class;
        }
        Set newSet = ImposterEnumSet.createSet(clazz);
        newSet.addAll(set);
        return new ImposterEnumSet(newSet, clazz);
    }

    public static ImposterEnumSet copyOf(Collection collection) {
        Class clazz;
        if (collection instanceof ImposterEnumSet) {
            ImposterEnumSet imposter = (ImposterEnumSet)collection;
            collection = imposter.set;
            clazz = imposter.objectClass;
        } else {
            clazz = !collection.isEmpty() ? collection.stream().filter(val -> val != null).map(val -> val.getClass()).findAny().orElse(Object.class) : Object.class;
        }
        Set newSet = ImposterEnumSet.createSet(clazz);
        newSet.addAll(collection);
        return new ImposterEnumSet(newSet, clazz);
    }

    public static ImposterEnumSet complementOf(Set set) {
        Class<Object> clazz = null;
        if (set instanceof ImposterEnumSet) {
            ImposterEnumSet imposter = (ImposterEnumSet)set;
            set = imposter.set;
            clazz = imposter.objectClass;
        }
        if (set instanceof EnumSet) {
            EnumSet enumSet = (EnumSet)set;
            enumSet = EnumSet.complementOf(enumSet);
            if (clazz != null) {
                return new ImposterEnumSet(enumSet, clazz);
            }
            clazz = !set.isEmpty() ? set.stream().filter(val -> val != null).map(val -> val.getClass()).findAny().orElse(Object.class) : enumSet.stream().filter(val -> val != null).map(val -> val.getClass()).map(val -> val).findAny().orElse(Object.class);
            return new ImposterEnumSet(enumSet, clazz);
        }
        if (set.isEmpty() && clazz == null) {
            throw new IllegalStateException("Class is null and set is empty, cannot get class!");
        }
        if (clazz == null) {
            clazz = set.stream().filter(val -> val != null).map(val -> val.getClass()).findAny().orElse(Object.class);
        }
        Registry<?> registry = EnumEvil.getRegistry(clazz);
        HashSet newSet = new HashSet();
        for (Object value : registry) {
            if (set.contains(value)) continue;
            newSet.add(value);
        }
        return new ImposterEnumSet(newSet, clazz);
    }

    public static ImposterEnumSet of(Object e) {
        Set set = ImposterEnumSet.createSet(e.getClass());
        set.add(e);
        return new ImposterEnumSet(set, e.getClass());
    }

    public static ImposterEnumSet of(Object e1, Object e2) {
        Set set = ImposterEnumSet.createSet(e1.getClass());
        set.add(e1);
        set.add(e2);
        return new ImposterEnumSet(set, e1.getClass());
    }

    public static ImposterEnumSet of(Object e1, Object e2, Object e3) {
        Set set = ImposterEnumSet.createSet(e1.getClass());
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return new ImposterEnumSet(set, e1.getClass());
    }

    public static ImposterEnumSet of(Object e1, Object e2, Object e3, Object e4) {
        Set set = ImposterEnumSet.createSet(e1.getClass());
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return new ImposterEnumSet(set, e1.getClass());
    }

    public static ImposterEnumSet of(Object e1, Object e2, Object e3, Object e4, Object e5) {
        Set set = ImposterEnumSet.createSet(e1.getClass());
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        return new ImposterEnumSet(set, e1.getClass());
    }

    public static ImposterEnumSet of(Object e, Object ... rest) {
        Set set = ImposterEnumSet.createSet(e.getClass());
        set.add(e);
        Collections.addAll(set, rest);
        return new ImposterEnumSet(set, e.getClass());
    }

    public static ImposterEnumSet range(Object from, Object to) {
        AbstractSet set;
        if (from.getClass().isEnum()) {
            set = EnumSet.range((Enum)from, (Enum)to);
        } else {
            set = new HashSet();
            Registry<?> registry = EnumEvil.getRegistry(from.getClass());
            for (Object o : registry) {
                if (((OldEnum)o).ordinal() < ((OldEnum)from).ordinal() || ((OldEnum)o).ordinal() > ((OldEnum)to).ordinal()) continue;
                set.add(o);
            }
        }
        return new ImposterEnumSet(set, from.getClass());
    }

    private ImposterEnumSet(Set set, Class<?> objectClass) {
        this.set = set;
        this.objectClass = objectClass;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.set.iterator();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean equals(Object o) {
        return this.set.equals(o);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(Object o) {
        this.typeCheck(o);
        return this.set.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<?> c) {
        if (this.set instanceof EnumSet) {
            this.set.addAll(c);
        }
        return super.addAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public String toString() {
        return this.set.toString();
    }

    public ImposterEnumSet clone() {
        Object newSet;
        Set set = this.set;
        if (set instanceof EnumSet) {
            EnumSet enumSet = (EnumSet)set;
            newSet = enumSet.clone();
        } else {
            newSet = new HashSet();
            newSet.addAll(this.set);
        }
        return new ImposterEnumSet((Set)newSet, this.objectClass);
    }

    private void typeCheck(Object object) {
        if (this.objectClass != DummyEnum.class && !this.objectClass.isAssignableFrom(object.getClass())) {
            throw new ClassCastException(String.valueOf(object.getClass()) + " != " + String.valueOf(this.objectClass));
        }
    }
}

