/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.packs;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import org.bukkit.Bukkit;
import org.bukkit.FeatureFlag;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.packs.CraftDataPackFormat;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.packs.DataPack;
import org.bukkit.packs.DataPackFormat;

public class CraftDataPack
implements DataPack {
    private final Pack handle;
    private final PackMetadataSection resourcePackInfo;

    public CraftDataPack(Pack handler) {
        this.handle = handler;
        try (PackResources iresourcepack = this.handle.resources.openPrimary(this.handle.location());){
            PackMetadataSection resourcepackinfo = iresourcepack.getMetadataSection(PackMetadataSection.SERVER_TYPE);
            if (resourcepackinfo == null) {
                resourcepackinfo = iresourcepack.getMetadataSection(PackMetadataSection.FALLBACK_TYPE);
            }
            this.resourcePackInfo = resourcepackinfo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Pack getHandle() {
        return this.handle;
    }

    public String getRawId() {
        return this.getHandle().getId();
    }

    public String getTitle() {
        return CraftChatMessage.fromComponent(this.getHandle().getTitle());
    }

    public String getDescription() {
        return CraftChatMessage.fromComponent(this.getHandle().getDescription());
    }

    public int getPackFormat() {
        return this.getMaxSupportedPackFormat();
    }

    public int getMinSupportedPackFormat() {
        return this.resourcePackInfo.supportedFormats().minInclusive().major();
    }

    public int getMaxSupportedPackFormat() {
        return this.resourcePackInfo.supportedFormats().maxInclusive().major();
    }

    public DataPackFormat getMinSupportedFormat() {
        return new CraftDataPackFormat(this.resourcePackInfo.supportedFormats().minInclusive());
    }

    public DataPackFormat getMaxSupportedFormat() {
        return new CraftDataPackFormat(this.resourcePackInfo.supportedFormats().maxInclusive());
    }

    public boolean isRequired() {
        return this.getHandle().isRequired();
    }

    public DataPack.Compatibility getCompatibility() {
        return switch (this.getHandle().getCompatibility()) {
            default -> throw new MatchException(null, null);
            case PackCompatibility.COMPATIBLE -> DataPack.Compatibility.COMPATIBLE;
            case PackCompatibility.TOO_NEW -> DataPack.Compatibility.NEW;
            case PackCompatibility.TOO_OLD -> DataPack.Compatibility.OLD;
            case PackCompatibility.UNKNOWN -> DataPack.Compatibility.UNKNOWN;
        };
    }

    public boolean isEnabled() {
        return ((CraftServer)Bukkit.getServer()).getServer().getPackRepository().getSelectedIds().contains(this.getRawId());
    }

    public DataPack.Source getSource() {
        if (this.getHandle().getPackSource() == PackSource.BUILT_IN) {
            return DataPack.Source.BUILT_IN;
        }
        if (this.getHandle().getPackSource() == PackSource.FEATURE) {
            return DataPack.Source.FEATURE;
        }
        if (this.getHandle().getPackSource() == PackSource.WORLD) {
            return DataPack.Source.WORLD;
        }
        if (this.getHandle().getPackSource() == PackSource.SERVER) {
            return DataPack.Source.SERVER;
        }
        return DataPack.Source.DEFAULT;
    }

    public Set<FeatureFlag> getRequestedFeatures() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().getRequestedFeatures()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public NamespacedKey getKey() {
        return NamespacedKey.fromString((String)this.getRawId());
    }

    public String toString() {
        String requestedFeatures = this.getRequestedFeatures().stream().map(featureFlag -> featureFlag.getKey().toString()).collect(Collectors.joining(","));
        return "CraftDataPack{rawId=" + this.getRawId() + ",id=" + String.valueOf(this.getKey()) + ",title=" + this.getTitle() + ",description=" + this.getDescription() + ",packformat=" + this.getPackFormat() + ",minSupportedPackFormat=" + this.getMinSupportedPackFormat() + ",maxSupportedPackFormat=" + this.getMaxSupportedPackFormat() + ",compatibility=" + String.valueOf(this.getCompatibility()) + ",source=" + String.valueOf(this.getSource()) + ",enabled=" + this.isEnabled() + ",requestedFeatures=[" + requestedFeatures + "]}";
    }
}

