/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.registry;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.core.Holder;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.util.HolderHandleable;
import org.bukkit.registry.RegistryAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CraftRegistryItem<M>
implements RegistryAware,
HolderHandleable<M> {
    private final NamespacedKey key;
    private final Holder<M> handle;

    protected CraftRegistryItem(NamespacedKey key, Holder<M> handle) {
        this.key = key;
        this.handle = handle;
    }

    @Override
    public Holder<M> getHandleHolder() {
        return this.handle;
    }

    @Override
    public M getHandle() {
        return this.getHandleHolder().value();
    }

    @NotNull
    public NamespacedKey getKeyOrThrow() {
        Preconditions.checkState((boolean)this.isRegistered(), (Object)"Cannot get key of this registry item, because it is not registered. Use #isRegistered() before calling this method.");
        return this.key;
    }

    @Nullable
    public NamespacedKey getKeyOrNull() {
        return this.key;
    }

    public boolean isRegistered() {
        return this.key != null;
    }

    public int hashCode() {
        if (this.isRegistered()) {
            return this.getKeyOrThrow().hashCode();
        }
        return this.getHandle().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CraftRegistryItem other = (CraftRegistryItem)obj;
        if (this.isRegistered() || other.isRegistered()) {
            return Objects.equals(this.key, other.key);
        }
        return Objects.equals(this.getHandle(), other.getHandle());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{key=" + String.valueOf(this.key) + ", handle=" + String.valueOf(this.handle) + "}";
    }
}

