/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.EnderDragonPart;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.entity.projectile.arrow.ThrownTrident;
import net.minecraft.world.entity.projectile.hurtingprojectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.bukkit.craftbukkit.v1_21_R7.SpigotTimings;
import org.spigotmc.SpigotWorldConfig;

public class ActivationRange {
    static AABB maxBB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public static ActivationType initializeEntityActivationType(Entity entity) {
        if (entity instanceof Raider) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof Monster || entity instanceof Slime) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof PathfinderMob || entity instanceof AmbientCreature) {
            return ActivationType.ANIMAL;
        }
        return ActivationType.MISC;
    }

    public static boolean initializeEntityActivationState(Entity entity, SpigotWorldConfig config) {
        if (config == null) {
            return false;
        }
        return entity.activationType == ActivationType.MISC && config.miscActivationRange == 0 || entity.activationType == ActivationType.RAIDER && config.raiderActivationRange == 0 || entity.activationType == ActivationType.ANIMAL && config.animalActivationRange == 0 || entity.activationType == ActivationType.MONSTER && config.monsterActivationRange == 0 || entity instanceof Player || entity instanceof ThrowableProjectile || entity instanceof EnderDragon || entity instanceof EnderDragonPart || entity instanceof WitherBoss || entity instanceof AbstractHurtingProjectile || entity instanceof LightningBolt || entity instanceof PrimedTnt || entity instanceof EndCrystal || entity instanceof FireworkRocketEntity || entity instanceof ThrownTrident;
    }

    public static void activateEntities(Level world) {
        SpigotTimings.entityActivationCheckTimer.startTiming();
        int miscActivationRange = world.spigotConfig.miscActivationRange;
        int raiderActivationRange = world.spigotConfig.raiderActivationRange;
        int animalActivationRange = world.spigotConfig.animalActivationRange;
        int monsterActivationRange = world.spigotConfig.monsterActivationRange;
        int maxRange = Math.max(monsterActivationRange, animalActivationRange);
        maxRange = Math.max(maxRange, raiderActivationRange);
        maxRange = Math.max(maxRange, miscActivationRange);
        maxRange = Math.min((world.spigotConfig.simulationDistance << 4) - 8, maxRange);
        for (Player player : world.players()) {
            player.activatedTick = MinecraftServer.currentTick;
            if (world.spigotConfig.ignoreSpectatorActivation && player.isSpectator()) continue;
            maxBB = player.getBoundingBox().inflate(maxRange, 256.0, maxRange);
            ActivationType.MISC.boundingBox = player.getBoundingBox().inflate(miscActivationRange, 256.0, miscActivationRange);
            ActivationType.RAIDER.boundingBox = player.getBoundingBox().inflate(raiderActivationRange, 256.0, raiderActivationRange);
            ActivationType.ANIMAL.boundingBox = player.getBoundingBox().inflate(animalActivationRange, 256.0, animalActivationRange);
            ActivationType.MONSTER.boundingBox = player.getBoundingBox().inflate(monsterActivationRange, 256.0, monsterActivationRange);
            world.getEntities().get(maxBB, ActivationRange::activateEntity);
        }
        SpigotTimings.entityActivationCheckTimer.stopTiming();
    }

    private static void activateEntity(Entity entity) {
        if ((long)MinecraftServer.currentTick > entity.activatedTick) {
            if (entity.defaultActivationState) {
                entity.activatedTick = MinecraftServer.currentTick;
                return;
            }
            if (entity.activationType.boundingBox.intersects(entity.getBoundingBox())) {
                entity.activatedTick = MinecraftServer.currentTick;
            }
        }
    }

    public static boolean checkEntityImmunities(Entity entity) {
        if (entity.wasTouchingWater || entity.getRemainingFireTicks() > 0) {
            return true;
        }
        if (!(entity instanceof AbstractArrow) ? !entity.onGround() || !entity.passengers.isEmpty() || entity.isPassenger() : !((AbstractArrow)entity).isInGround()) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.hurtTime > 0 || living.activeEffects.size() > 0) {
                return true;
            }
            if (entity instanceof PathfinderMob && ((PathfinderMob)entity).getTarget() != null) {
                return true;
            }
            if (entity instanceof Villager && ((Villager)entity).canBreed()) {
                return true;
            }
            if (entity instanceof Animal) {
                Animal animal = (Animal)entity;
                if (animal.isBaby() || animal.isInLove()) {
                    return true;
                }
                if (entity instanceof Sheep && ((Sheep)entity).isSheared()) {
                    return true;
                }
            }
            if (entity instanceof Creeper && ((Creeper)entity).isIgnited()) {
                return true;
            }
        }
        return entity instanceof ExperienceOrb;
    }

    public static boolean checkIfActive(Entity entity) {
        boolean isActive;
        SpigotTimings.checkIfActiveTimer.startTiming();
        if (entity instanceof FireworkRocketEntity || entity instanceof ItemEntity && (entity.tickCount + entity.getId() + 1) % 4 == 0) {
            SpigotTimings.checkIfActiveTimer.stopTiming();
            return true;
        }
        boolean bl = isActive = entity.activatedTick >= (long)MinecraftServer.currentTick || entity.defaultActivationState;
        if (!isActive) {
            if (((long)MinecraftServer.currentTick - entity.activatedTick - 1L) % 20L == 0L) {
                if (ActivationRange.checkEntityImmunities(entity)) {
                    entity.activatedTick = MinecraftServer.currentTick + 20;
                }
                isActive = true;
            }
        } else if (!entity.defaultActivationState && entity.tickCount % 4 == 0 && !ActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        SpigotTimings.checkIfActiveTimer.stopTiming();
        return isActive;
    }

    public static enum ActivationType {
        MONSTER,
        ANIMAL,
        RAIDER,
        MISC;

        AABB boundingBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

