/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionSet;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Main;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R7.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.PluginLoadOrder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.CustomTimingsHandler;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends cbv<anq>
implements anj,
ec,
erq {
    public static final Logger m = LogUtils.getLogger();
    public static final String b = "vanilla";
    private static final float n = 0.8f;
    private static final int o = 100;
    private static final long p = 30L * bhn.a / 20L;
    private static final int q = 20;
    private static final long r = 10L * bhn.a;
    private static final int s = 100;
    private static final long t = 5L * bhn.a;
    private static final long u = 10L * bhn.b;
    private static final int v = 12;
    public static final int c = 5;
    private static final int w = 30;
    private static final int x = 6000;
    private static final int y = 100;
    private static final int z = 3;
    public static final int d = 29999984;
    public static final dws e = new dws("Demo World", dwl.a, false, ccz.c, false, new eua(dhb.h), dxm.d);
    public static final bbx f = new bbx(bhs.e, "Anonymous Player");
    public fni.c g;
    public final fnl h;
    private final List<Runnable> A = Lists.newArrayList();
    private cbe B;
    private Consumer<bzk> C;
    private Consumer<Path> D;
    private boolean E;
    private @Nullable c F;
    private boolean G;
    private ayh H;
    public final axq I;
    private @Nullable alq J;
    private @Nullable alq.a K;
    private final bgr L;
    public final DataFixer M;
    private String N;
    private int O = -1;
    private final jk<anc> P;
    private Map<amt<dwo>, axf> Q;
    private bbz R;
    private volatile boolean S = true;
    private boolean T;
    private int U;
    private int V = 6000;
    protected final Proxy i;
    private boolean W;
    private boolean X;
    private @Nullable String Y;
    private int Z;
    private final long[] aa;
    private long ab = 0L;
    private @Nullable KeyPair ac;
    private @Nullable GameProfile ad;
    private boolean ae;
    private volatile boolean af;
    private long ag;
    protected final ano j;
    private final ayx ah;
    private final ayz ai;
    private long aj;
    public final Thread ak;
    private long al;
    private long am;
    private long an;
    private long ao;
    private boolean ap = false;
    private long aq;
    private boolean ar;
    private final bak as;
    private final anm at;
    private @Nullable cdn au;
    private @Nullable fmz av;
    private final anw aw;
    private final ani ax;
    private boolean ay;
    private boolean az;
    private float aA;
    public final Executor aB;
    private @Nullable String aC;
    public a aD;
    private final fjr aE;
    private final ann aF;
    private final bxj aG;
    protected fnt k;
    private fne.a aH;
    private final dnq aI;
    private emb aJ;
    private int aK;
    private volatile boolean aL;
    private static final AtomicReference<@Nullable RuntimeException> aM = new AtomicReference();
    private final anp aN;
    private final DiscontinuousFrame aO;
    private final xl aP;
    public final anr.a worldLoader;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public Terminal terminal;
    public static int currentTick = (int)(System.currentTimeMillis() / 50L);
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public ee vanillaCommandDispatcher;
    private boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 100;
    public final double[] recentTps = new double[3];
    private boolean hasStopped = false;
    private final Object stopLock = new Object();
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").build());

    public static <S extends MinecraftServer> S a(Function<Thread, S> function) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        Thread thread = new Thread(() -> ((MinecraftServer)atomicreference.get()).A(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> m.error("Uncaught exception in server thread", throwable));
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s0 = (MinecraftServer)function.apply(thread);
        atomicreference.set(s0);
        thread.start();
        return (S)s0;
    }

    public MinecraftServer(OptionSet options, anr.a worldLoader, Thread thread, fni.c convertable_conversionsession, bak resourcepackrepository, ans worldstem, Proxy proxy, DataFixer datafixer, ano services, axq levelloadlistener) {
        super("Server");
        this.B = cbd.a;
        this.C = methodprofilerresults -> this.aW();
        this.D = path -> {};
        this.L = bgr.a();
        this.Q = Maps.newLinkedHashMap();
        this.aa = new long[100];
        this.al = bhs.d();
        this.am = bhs.d();
        this.ao = bhs.d();
        this.at = new anm(this);
        this.aw = new anw();
        this.aG = new bxj(this);
        this.aH = fne.a.a;
        this.aN = new anp();
        this.P = worldstem.c();
        this.k = worldstem.d();
        this.i = proxy;
        this.as = resourcepackrepository;
        this.aD = new a(worldstem.a(), worldstem.b());
        this.j = services;
        this.aF = new ann(this);
        this.I = levelloadlistener;
        this.g = convertable_conversionsession;
        this.h = convertable_conversionsession.g();
        this.M = datafixer;
        this.ax = new ani(this, this.aD.b.a());
        jf.b holdergetter = this.P.a().f(mj.i).a(this.k.J());
        this.aE = new fjr(worldstem.a(), convertable_conversionsession, datafixer, holdergetter);
        this.ak = thread;
        this.aB = bhs.h();
        this.aI = dnq.a(this.k.J());
        this.aD.b.c().a(this.k.J());
        this.aJ = emb.a(this.P.a(), this.k.J());
        this.aO = TracyClient.createDiscontinuousFrame((String)"Server Tick");
        this.ah = new ayx();
        this.ai = new ayz(this.ah, 30);
        this.aP = new xl(thread);
        this.options = options;
        this.worldLoader = worldLoader;
        this.vanillaCommandDispatcher = worldstem.b().d;
        if (System.console() == null && System.getProperty("org.jline.terminal.provider") == null) {
            System.setProperty("org.jline.terminal.provider", "dumb");
            org.bukkit.craftbukkit.Main.useJline = false;
        }
        try {
            this.terminal = TerminalBuilder.builder().dumb(false).build();
        }
        catch (Throwable e2) {
            try {
                System.setProperty("org.jline.terminal.provider", "dumb");
                org.bukkit.craftbukkit.Main.useJline = false;
                this.terminal = TerminalBuilder.builder().build();
            }
            catch (IOException ex2) {
                m.warn((String)null, (Throwable)ex2);
            }
        }
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
    }

    protected abstract boolean e() throws IOException;

    public axp a(final int i2) {
        return new axp(){
            private @Nullable awj c;
            private int d;
            private int e;

            @Override
            public void a(amt<dwo> resourcekey, dvu chunkcoordintpair) {
                axf worldserver = MinecraftServer.this.a(resourcekey);
                this.c = worldserver != null ? worldserver.p().a : null;
                this.d = chunkcoordintpair.h;
                this.e = chunkcoordintpair.i;
            }

            @Override
            public @Nullable erj a(int j2, int k2) {
                return this.c == null ? null : this.c.c(dvu.d(j2 + this.d - i2, k2 + this.e - i2));
            }

            @Override
            public int a() {
                return i2;
            }
        };
    }

    protected void loadLevel(String s2) {
        boolean flag = !bzu.f.c() && w.au && bzu.f.a(bzs.a(this));
        bzx profiledduration = bzu.f.e();
        this.loadWorld0(s2);
        if (profiledduration != null) {
            profiledduration.finish(true);
        }
        if (flag) {
            try {
                bzu.f.b();
            }
            catch (Throwable throwable) {
                m.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    protected void t() {
    }

    private void loadWorld0(String s2) {
        fni.c worldSession = this.g;
        jr.b iregistrycustom_dimension = this.P.a();
        jq<esi> dimensions = iregistrycustom_dimension.f(mj.bF);
        for (esi worldDimension : dimensions) {
            axf world;
            fnm worlddata;
            Dynamic<?> dynamic;
            String name;
            amt<esi> dimensionKey = dimensions.d(worldDimension).get();
            int dimension = 0;
            if (dimensionKey == esi.c) {
                if (!this.server.getAllowNether()) continue;
                dimension = -1;
            } else if (dimensionKey == esi.d) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (dimensionKey != esi.b) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? dimensionKey.a().b() + "_" + dimensionKey.a().a() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase(Locale.ROOT);
            String string = name = dimensionKey == esi.b ? s2 : s2 + "_" + worldType;
            if (dimension != 0) {
                File newWorld = fni.getStorageFolder(new File(name).toPath(), dimensionKey).toFile();
                File oldWorld = fni.getStorageFolder(new File(s2).toPath(), dimensionKey).toFile();
                File oldLevelDat = new File(new File(s2), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    m.info("---- Migration of old " + worldType + " folder required ----");
                    m.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    m.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    m.info("Attempting to move " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "...");
                    if (newWorld.exists()) {
                        m.warn("A file or folder already exists at " + String.valueOf(newWorld) + "!");
                        m.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            m.info("Success! To restore " + worldType + " in the future, simply move " + String.valueOf(newWorld) + " to " + String.valueOf(oldWorld));
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                FileUtils.copyDirectory((File)new File(new File(s2), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                m.warn("Unable to migrate world data.");
                            }
                            m.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            m.warn("Could not move folder " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "!");
                            m.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        m.warn("Could not create path for " + String.valueOf(newWorld) + "!");
                        m.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    worldSession = fni.b(this.server.getWorldContainer().toPath()).validateAndCreateAccess(name, dimensionKey);
                }
                catch (ftb | IOException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            if (worldSession.m()) {
                fnj worldinfo;
                try {
                    dynamic = worldSession.h();
                    worldinfo = worldSession.a(dynamic);
                }
                catch (IOException | vk | vr ioexception) {
                    fni.b convertable_b = worldSession.e();
                    m.warn("Failed to load world data from {}", (Object)convertable_b.b(), (Object)ioexception);
                    m.info("Attempting to use fallback");
                    try {
                        dynamic = worldSession.i();
                        worldinfo = worldSession.a(dynamic);
                    }
                    catch (IOException | vk | vr ioexception1) {
                        m.error("Failed to load world data from {}", (Object)convertable_b.c(), (Object)ioexception1);
                        m.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.b(), (Object)convertable_b.c());
                        return;
                    }
                    worldSession.n();
                }
                if (worldinfo.d()) {
                    m.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.r()) {
                    m.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            ChunkGenerator gen = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            anr.a worldloader_a = this.worldLoader;
            jq<esi> iregistry = worldloader_a.d().f(mj.bF);
            if (dynamic != null) {
                fnf leveldataanddimensions = fni.a(dynamic, worldloader_a.b(), iregistry, worldloader_a.c());
                worlddata = (fnm)leveldataanddimensions.a();
            } else {
                evl worlddimensions;
                evo worldoptions;
                dws worldsettings;
                if (this.aa()) {
                    worldsettings = e;
                    worldoptions = evo.b;
                    worlddimensions = ffe.a(worldloader_a.c());
                } else {
                    arz dedicatedserverproperties = ((ary)this).a();
                    worldsettings = new dws(dedicatedserverproperties.o, dedicatedserverproperties.n.get(), dedicatedserverproperties.E, dedicatedserverproperties.m.get(), false, new eua(worldloader_a.b().b()), worldloader_a.b());
                    worldoptions = this.options.has("bonusChest") ? dedicatedserverproperties.aj.a(true) : dedicatedserverproperties.aj;
                    worlddimensions = dedicatedserverproperties.a(worldloader_a.c());
                }
                evl.b worlddimensions_b = worlddimensions.a(iregistry);
                Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().d());
                worlddata = new fnm(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle);
            }
            worlddata.checkName(name);
            if (this.options.has("forceUpgrade")) {
                Main.a(worldSession, worlddata, bia.a(), this.options.has("eraseCache"), () -> true, iregistrycustom_dimension, this.options.has("recreateRegionFiles"));
            }
            fnm iworlddataserver = worlddata;
            boolean flag = worlddata.z();
            evo worldoptions = worlddata.x();
            long i2 = worldoptions.c();
            long j2 = dxq.a(i2);
            ImmutableList list = ImmutableList.of((Object)new evc(), (Object)new evb(), (Object)new dcr(), (Object)new csv(), (Object)new ddf(iworlddataserver));
            esi worlddimension = dimensions.c(dimensionKey);
            CraftWorldInfo worldInfo = new CraftWorldInfo(iworlddataserver, worldSession, World.Environment.getEnvironment((int)dimension), worlddimension.a().a());
            if (biomeProvider == null && gen != null) {
                biomeProvider = gen.getDefaultBiomeProvider((WorldInfo)worldInfo);
            }
            amt<dwo> worldKey = amt.a(mj.bE, dimensionKey.a());
            if (dimensionKey == esi.b) {
                this.k = worlddata;
                this.k.a(((ary)this).a().n.get());
                world = new axf(this, this.aB, worldSession, iworlddataserver, worldKey, worlddimension, flag, j2, (List<dwb>)list, true, null, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
                fnc worldpersistentdata = world.A();
                this.at.a(worldpersistentdata.a(fus.a).b());
                this.server.scoreboardManager = new CraftScoreboardManager(this, world.i());
                this.av = new fmz(worldpersistentdata);
                this.au = worldpersistentdata.a(cdn.a);
            } else {
                world = new axf(this, this.aB, worldSession, iworlddataserver, worldKey, worlddimension, flag, j2, (List<dwb>)ImmutableList.of(), true, this.N().T(), World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
            }
            worlddata.a(this.getServerModName(), this.T().a());
            this.initWorld(world, worlddata, this.k, worldoptions);
            this.addLevel(world);
            this.aj().a(world);
            if (worlddata.D() == null) continue;
            this.aN().a(worlddata.D(), this.bc());
        }
        this.t();
        for (axf worldserver : this.P()) {
            this.prepareLevels(worldserver);
            worldserver.M.b();
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getWorld()));
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.H.acceptConnections();
    }

    public void initWorld(axf worldserver, fnn iworlddataserver, fnt saveData, evo worldoptions) {
        boolean flag = saveData.z();
        if (worldserver.generator != null) {
            worldserver.getWorld().getPopulators().addAll(worldserver.generator.getDefaultPopulators((World)worldserver.getWorld()));
        }
        this.initWorldBorder(worldserver, iworlddataserver);
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getWorld()));
        if (!iworlddataserver.m()) {
            try {
                MinecraftServer.a(worldserver, iworlddataserver, worldoptions.e(), flag, this.I);
                iworlddataserver.c(true);
                if (flag) {
                    this.a(this.k);
                }
            }
            catch (Throwable throwable) {
                m crashreport = m.a(throwable, "Exception initializing level");
                try {
                    worldserver.a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new v(crashreport);
            }
            iworlddataserver.c(true);
        }
        jc globalpos = new jc(worldserver.aq(), worldserver.C().b());
        this.I.a(globalpos.a(), new dvu(globalpos.b()));
    }

    private void initWorldBorder(axf worldserver1, fnn iworlddataserver) {
        boolean flag1 = false;
        Optional<eqa.c> optional = iworlddataserver.o();
        if (optional.isPresent()) {
            eqa.c worldborder_c = optional.get();
            fnc worldpersistentdata1 = worldserver1.A();
            if (worldpersistentdata1.b(eqa.d) == null) {
                double d0 = worldserver1.F_().g();
                eqa.c worldborder_c1 = new eqa.c(worldborder_c.a() / d0, worldborder_c.b() / d0, worldborder_c.c(), worldborder_c.d(), worldborder_c.e(), worldborder_c.f(), worldborder_c.g(), worldborder_c.h(), worldborder_c.i());
                eqa worldborder = new eqa(worldborder_c1);
                worldborder.a(worldserver1.au());
                worldpersistentdata1.a(eqa.d, worldborder);
            }
            flag1 = true;
        }
        worldserver1.w().a(this.au());
        this.aj().a(worldserver1);
        if (flag1) {
            iworlddataserver.a(Optional.empty());
        }
    }

    private static void a(axf worldserver, fnn iworlddataserver, boolean flag, boolean flag1, axq levelloadlistener) {
        if (w.ax && w.aN) {
            iworlddataserver.a(fne.a.a(worldserver.aq(), new is(0, 64, -100), 0.0f, 0.0f));
        } else if (flag1) {
            iworlddataserver.a(fne.a.a(worldserver.aq(), is.c.b(80), 0.0f, 0.0f));
        } else {
            axc chunkproviderserver = worldserver.p();
            dvu chunkcoordintpair = new dvu(chunkproviderserver.i().b().a());
            if (worldserver.generator != null) {
                Random rand = new Random(worldserver.J());
                Location spawn = worldserver.generator.getFixedSpawnLocation((World)worldserver.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != worldserver.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + iworlddataserver.d() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    iworlddataserver.a(fne.a.a(worldserver.aq(), new is(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw(), spawn.getPitch()));
                    return;
                }
            }
            levelloadlistener.a(axq.a.b, 0);
            levelloadlistener.a(worldserver.aq(), chunkcoordintpair);
            int i2 = chunkproviderserver.g().a(worldserver);
            if (i2 < worldserver.K_()) {
                is blockposition = chunkcoordintpair.m();
                i2 = worldserver.a(euq.a.b, blockposition.u() + 8, blockposition.w() + 8);
            }
            iworlddataserver.a(fne.a.a(worldserver.aq(), chunkcoordintpair.m().b(8, i2, 8), 0.0f, 0.0f));
            int j2 = 0;
            int k2 = 0;
            int l2 = 0;
            int i1 = -1;
            for (int j1 = 0; j1 < bgj.i(11); ++j1) {
                is blockposition1;
                if (j2 >= -5 && j2 <= 5 && k2 >= -5 && k2 <= 5 && (blockposition1 = awz.a(worldserver, new dvu(chunkcoordintpair.h + j2, chunkcoordintpair.i + k2))) != null) {
                    iworlddataserver.a(fne.a.a(worldserver.aq(), blockposition1, 0.0f, 0.0f));
                    break;
                }
                if (j2 == k2 || j2 < 0 && j2 == -k2 || j2 > 0 && j2 == 1 - k2) {
                    int k1 = l2;
                    l2 = -i1;
                    i1 = k1;
                }
                j2 += l2;
                k2 += i1;
            }
            if (flag) {
                worldserver.J_().a(mj.aY).flatMap(iregistry -> iregistry.a(rt.m)).ifPresent(holder_c -> ((exi)holder_c.a()).a(worldserver, chunkproviderserver.g(), worldserver.y, iworlddataserver.a().b()));
            }
            levelloadlistener.a(axq.a.b);
        }
    }

    private void a(fnt savedata) {
        savedata.a(ccz.a);
        savedata.d(true);
        fnn iworlddataserver = savedata.H();
        iworlddataserver.b(false);
        iworlddataserver.a(false);
        iworlddataserver.a(1000000000);
        iworlddataserver.b(6000L);
        iworlddataserver.a(dwl.d);
    }

    public void prepareLevels(axf worldserver) {
        this.forceTicks = true;
        awi chunkloadcounter = new awi();
        chunkloadcounter.a(worldserver, () -> {
            dxl ticketstorage = worldserver.A().b(dxl.b);
            if (ticketstorage != null) {
                ticketstorage.b();
            }
        });
        this.I.a(axq.a.c, chunkloadcounter.c());
        do {
            this.I.a(axq.a.c, chunkloadcounter.a(), chunkloadcounter.c());
            this.executeModerately();
        } while (chunkloadcounter.b() > 0);
        this.I.a(axq.a.c);
        this.forceTicks = false;
        this.bI();
    }

    protected jc v() {
        return this.k.H().a().c();
    }

    public dwl w() {
        return this.k.j();
    }

    public boolean v_() {
        return this.k.k();
    }

    public abstract bbh k();

    public abstract bbn l();

    public abstract boolean m();

    public boolean a(boolean flag, boolean flag1, boolean flag2) {
        this.at.a(this.N().A().a(fus.a));
        boolean flag3 = false;
        for (axf worldserver : this.P()) {
            if (!flag) {
                m.info("Saving chunks for level '{}'/{}", (Object)worldserver, (Object)worldserver.aq().a());
            }
            worldserver.a((bgq)null, flag1, w.X || worldserver.e && !flag2);
            flag3 = true;
        }
        if (flag1) {
            for (axf worldserver1 : this.P()) {
                m.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)worldserver1.p().a.l());
            }
            m.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean flag, boolean flag1, boolean flag2) {
        boolean flag3;
        try {
            this.aL = true;
            this.aj().h();
            flag3 = this.a(flag, flag1, flag2);
        }
        finally {
            this.aL = false;
        }
        return flag3;
    }

    @Override
    public void close() {
        this.x();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void x() {
        Iterator<axf> iterator = this.stopLock;
        synchronized (iterator) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        this.aP.close();
        if (this.B.e()) {
            this.aY();
        }
        m.info("Stopping server");
        if (this.server != null) {
            this.server.disablePlugins();
        }
        this.ak().b();
        this.aL = true;
        if (this.R != null) {
            m.info("Saving players");
            this.R.h();
            this.R.s();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        m.info("Saving worlds");
        for (axf worldserver : this.P()) {
            if (worldserver == null) continue;
            worldserver.e = false;
        }
        while (this.Q.values().stream().anyMatch(worldserver1 -> worldserver1.p().a.e())) {
            this.ao = bhs.d() + bhn.b;
            for (axf worldserver12 : this.P()) {
                worldserver12.p().q();
                worldserver12.p().a(() -> true, false);
            }
            this.w_();
        }
        this.a(false, true, false);
        for (axf worldserver2 : this.P()) {
            if (worldserver2 == null) continue;
            try {
                worldserver2.close();
            }
            catch (IOException ioexception) {
                m.error("Exception closing the level", (Throwable)ioexception);
            }
        }
        this.aL = false;
        this.aD.close();
        try {
            this.g.close();
        }
        catch (IOException ioexception1) {
            m.error("Failed to unlock level {}", (Object)this.g.f(), (Object)ioexception1);
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            m.info("Saving usercache.json");
            this.ar().f().a();
        }
    }

    public String y() {
        return this.N;
    }

    @Override
    public void a_(String s2) {
        this.N = s2;
    }

    public boolean z() {
        return this.S;
    }

    public void a(boolean flag) {
        this.S = false;
        if (flag) {
            try {
                this.ak.join();
            }
            catch (InterruptedException interruptedexception) {
                m.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    private static double calcTps(double avg2, double exp2, double tps) {
        return avg2 * exp2 + tps * (1.0 - exp2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void A() {
        try {
            if (!this.e()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.ao = bhs.d();
            this.K = this.bD().orElse(null);
            this.J = this.bG();
            Arrays.fill(this.recentTps, 20.0);
            long tickSection = bhs.c();
            long tickCount = 1L;
            while (this.S) {
                boolean flag;
                long i2;
                if (!this.I() && this.aF.a() && this.aF.d()) {
                    i2 = 0L;
                    this.ag = this.ao = bhs.d();
                } else {
                    i2 = this.aF.h();
                    long j2 = bhs.d() - this.ao;
                    if (j2 > p + 20L * i2 && this.ao - this.ag >= r + 100L * i2) {
                        long k2 = j2 / i2;
                        if (this.server.getWarnOnOverload()) {
                            m.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)(j2 / bhn.b), (Object)k2);
                        }
                        this.ao += k2 * i2;
                        this.ag = this.ao;
                    }
                }
                if (tickCount++ % 100L == 0L) {
                    long curTime = bhs.c();
                    double currentTps = 1000.0 / (double)(curTime - tickSection) * 100.0;
                    this.recentTps[0] = MinecraftServer.calcTps(this.recentTps[0], 0.92, currentTps);
                    this.recentTps[1] = MinecraftServer.calcTps(this.recentTps[1], 0.9835, currentTps);
                    this.recentTps[2] = MinecraftServer.calcTps(this.recentTps[2], 0.9945, currentTps);
                    tickSection = curTime;
                }
                boolean bl2 = flag = i2 == 0L;
                if (this.G) {
                    this.G = false;
                    this.F = new c(bhs.d(), this.U);
                }
                currentTick = (int)(System.currentTimeMillis() / 50L);
                this.ao += i2;
                try (bzl.a profiler_a = bzl.a(this.bQ());){
                    this.b(flag);
                    bzm gameprofilerfiller = bzl.a();
                    gameprofilerfiller.a("nextTickWait");
                    this.ar = true;
                    this.aq = Math.max(bhs.d() + i2, this.ao);
                    this.bz();
                    this.w_();
                    this.bA();
                    if (flag) {
                        this.aF.e();
                    }
                    gameprofilerfiller.c();
                    this.by();
                }
                finally {
                    this.aU();
                }
                this.af = true;
                bzu.f.a(this.aA);
            }
            return;
        }
        catch (Throwable throwable2) {
            m.error("Encountered an unexpected exception", throwable2);
            m crashreport = MinecraftServer.b(throwable2);
            this.b(crashreport.f());
            Path path = this.G().resolve("crash-reports").resolve("crash-" + bhs.f() + "-server.txt");
            if (crashreport.a(path, u.a)) {
                m.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                m.error("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
            return;
        }
        finally {
            try {
                this.T = true;
                this.x();
            }
            catch (Throwable throwable3) {
                m.error("Exception stopping the server", throwable3);
            }
            finally {
                WatchdogThread.doStop();
                try {
                    this.terminal.close();
                }
                catch (Exception tickSection) {}
                this.i();
            }
        }
    }

    private void by() {
        long i2 = bhs.d();
        if (this.g()) {
            this.f().a(i2 - this.al);
        }
        this.al = i2;
    }

    private void bz() {
        if (this.g()) {
            this.am = bhs.d();
            this.an = 0L;
        }
    }

    private void bA() {
        if (this.g()) {
            bxq samplelogger = this.f();
            samplelogger.a(bhs.d() - this.am - this.an, bxs.c.ordinal());
            samplelogger.a(this.an, bxs.d.ordinal());
        }
    }

    private static m b(Throwable throwable) {
        m crashreport;
        v reportedexception = null;
        for (Throwable throwable1 = throwable; throwable1 != null; throwable1 = throwable1.getCause()) {
            v reportedexception1;
            if (!(throwable1 instanceof v)) continue;
            reportedexception = reportedexception1 = (v)throwable1;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.a();
            if (reportedexception != throwable) {
                crashreport.a("Wrapped in").a("Wrapping exception", throwable);
            }
        } else {
            crashreport = new m("Exception in server tick loop", throwable);
        }
        return crashreport;
    }

    private boolean bB() {
        return this.forceTicks || this.bP() || bhs.d() < (this.ar ? this.aq : this.ao);
    }

    private void executeModerately() {
        this.bN();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean B() {
        RuntimeException runtimeexception = aM.get();
        if (runtimeexception != null) {
            throw runtimeexception;
        }
        return true;
    }

    public static void a(RuntimeException runtimeexception) {
        aM.compareAndSet(null, runtimeexception);
    }

    @Override
    public void b(BooleanSupplier booleansupplier) {
        super.b(() -> MinecraftServer.B() && booleansupplier.getAsBoolean());
    }

    public ayx C() {
        return this.ah;
    }

    protected void w_() {
        this.bN();
        this.ap = true;
        try {
            this.b(() -> !this.bB());
        }
        finally {
            this.ap = false;
        }
    }

    @Override
    public void D() {
        boolean flag = this.g();
        long i2 = flag ? bhs.d() : 0L;
        long j2 = this.ap ? this.ao - bhs.d() : 100000L;
        LockSupport.parkNanos("waiting for tasks", j2);
        if (flag) {
            this.an += bhs.d() - i2;
        }
    }

    public anq a(Runnable runnable) {
        return new anq(this.U, runnable);
    }

    protected boolean a(anq ticktask) {
        return ticktask.a() + 3 < this.U || this.bB();
    }

    @Override
    public boolean E() {
        boolean flag;
        this.ar = flag = this.bC();
        return flag;
    }

    private boolean bC() {
        if (super.E()) {
            return true;
        }
        if (this.aF.a() || this.bO() || this.bB()) {
            for (axf worldserver : this.P()) {
                if (!worldserver.p().c()) continue;
                return true;
            }
        }
        return false;
    }

    public void b(anq ticktask) {
        bzl.a().f("runTask");
        super.d(ticktask);
    }

    private Optional<alq.a> bD() {
        Optional<Path> optional = Optional.of(this.c("server-icon.png")).filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])).or(() -> this.g.j().filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                byte[] abyte = java.nio.file.Files.readAllBytes(path);
                bgo pnginfo = bgo.a(abyte);
                if (pnginfo.a() == 64 && pnginfo.b() == 64) {
                    return Optional.of(new alq.a(abyte));
                }
                int i2 = pnginfo.a();
                throw new IllegalArgumentException("Invalid world icon size [" + i2 + ", " + pnginfo.b() + "], but expected [64, 64]");
            }
            catch (Exception exception) {
                m.error("Couldn't load server icon", (Throwable)exception);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> F() {
        return this.g.j();
    }

    public Path G() {
        return Path.of("", new String[0]);
    }

    public ayz H() {
        return this.ai;
    }

    public void a(m crashreport) {
    }

    public void i() {
    }

    public boolean I() {
        return false;
    }

    public void a(BooleanSupplier booleansupplier) {
        WatchdogThread.tick();
        long i2 = bhs.d();
        int j2 = this.bu() * 20;
        if (j2 > 0) {
            this.aK = this.R.m() == 0 && !this.aF.a() ? ++this.aK : 0;
            if (this.aK >= j2) {
                if (this.aK == j2) {
                    m.info("Server empty for {} seconds, pausing", (Object)this.bu());
                    this.bE();
                }
                this.server.getScheduler().mainThreadHeartbeat();
                this.K();
                return;
            }
        }
        SpigotTimings.serverTickTimer.startTiming();
        ++this.U;
        this.aF.m();
        this.c(booleansupplier);
        if (i2 - this.aj >= t) {
            this.aj = i2;
            this.J = this.bG();
        }
        --this.V;
        if (this.autosavePeriod > 0 && this.V <= 0) {
            this.bE();
        }
        bzm gameprofilerfiller = bzl.a();
        gameprofilerfiller.a("tallying");
        long k2 = bhs.d() - i2;
        int l2 = this.U % 100;
        this.ab -= this.aa[l2];
        this.ab += k2;
        this.aa[l2] = k2;
        this.aA = this.aA * 0.8f + (float)k2 / (float)bhn.b * 0.19999999f;
        this.a(i2);
        gameprofilerfiller.c();
        SpigotTimings.serverTickTimer.stopTiming();
        CustomTimingsHandler.tick();
    }

    protected void b(boolean flag) {
        bzm gameprofilerfiller = bzl.a();
        gameprofilerfiller.a("tick");
        this.aO.start();
        gameprofilerfiller.a("scheduledPacketProcessing");
        this.aP.b();
        gameprofilerfiller.c();
        this.a(flag ? () -> false : this::bB);
        this.aO.end();
        gameprofilerfiller.c();
    }

    private void bE() {
        this.V = this.autosavePeriod;
        SpigotTimings.worldSaveTimer.startTiming();
        m.debug("Autosave started");
        bzm gameprofilerfiller = bzl.a();
        gameprofilerfiller.a("save");
        this.b(true, false, false);
        gameprofilerfiller.c();
        m.debug("Autosave finished");
        SpigotTimings.worldSaveTimer.stopTiming();
    }

    private void a(long i2) {
        if (this.g()) {
            this.f().a(bhs.d() - i2, bxs.b.ordinal());
        }
    }

    private int bF() {
        float f2;
        if (this.aF.a()) {
            long i2 = this.aS() + 1L;
            f2 = (float)bhn.a / (float)i2;
        } else {
            f2 = this.aF.f();
        }
        int j2 = 300;
        return Math.max(100, (int)(f2 * 300.0f));
    }

    public void J() {
        int i2 = this.bF();
        if (i2 < this.V) {
            this.V = i2;
        }
    }

    protected abstract bxq f();

    public abstract boolean g();

    private alq bG() {
        alq.b serverping_serverpingplayersample = this.bH();
        return new alq(yh.a(this.ah()), Optional.of(serverping_serverpingplayersample), Optional.of(alq.c.a()), Optional.ofNullable(this.K), this.ay());
    }

    private alq.b bH() {
        List<axg> list = this.R.t();
        int i2 = this.r();
        if (this.ao()) {
            return new alq.b(i2, list.size(), List.of());
        }
        int j2 = Math.min(list.size(), 12);
        ObjectArrayList objectarraylist = new ObjectArrayList(j2);
        int k2 = bgj.a(this.L, 0, list.size() - j2);
        for (int l2 = 0; l2 < j2; ++l2) {
            axg entityplayer = list.get(k2 + l2);
            objectarraylist.add((Object)(entityplayer.aa() ? entityplayer.gJ() : f));
        }
        bhs.c(objectarraylist, this.L);
        return new alq.b(i2, list.size(), (List<bbx>)objectarraylist);
    }

    protected void c(BooleanSupplier booleansupplier) {
        bzm gameprofilerfiller = bzl.a();
        this.aj().t().forEach(entityplayer -> entityplayer.g.f());
        SpigotTimings.schedulerTimer.startTiming();
        this.server.getScheduler().mainThreadHeartbeat();
        SpigotTimings.schedulerTimer.stopTiming();
        gameprofilerfiller.a("commandFunctions");
        SpigotTimings.commandFunctionsTimer.startTiming();
        this.aC().b();
        SpigotTimings.commandFunctionsTimer.stopTiming();
        gameprofilerfiller.b("levels");
        this.bI();
        SpigotTimings.processQueueTimer.startTiming();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        SpigotTimings.processQueueTimer.stopTiming();
        SpigotTimings.timeUpdateTimer.startTiming();
        if (this.U % 20 == 0) {
            for (int i2 = 0; i2 < this.aj().k.size(); ++i2) {
                axg entityplayer2 = this.aj().k.get(i2);
                entityplayer2.g.b(new ahd(entityplayer2.A().au(), entityplayer2.getPlayerTime(), entityplayer2.A().U().a(eua.a)));
            }
        }
        SpigotTimings.timeUpdateTimer.stopTiming();
        for (axf worldserver : this.P()) {
            gameprofilerfiller.a(() -> {
                String s2 = String.valueOf(worldserver);
                return s2 + " " + String.valueOf(worldserver.aq().a());
            });
            gameprofilerfiller.a("tick");
            try {
                worldserver.timings.doTick.startTiming();
                worldserver.a(booleansupplier);
                worldserver.timings.doTick.stopTiming();
            }
            catch (Throwable throwable) {
                m crashreport = m.a(throwable, "Exception ticking world");
                worldserver.a(crashreport);
                throw new v(crashreport);
            }
            gameprofilerfiller.c();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.b("connection");
        SpigotTimings.connectionTimer.startTiming();
        this.K();
        SpigotTimings.connectionTimer.stopTiming();
        gameprofilerfiller.b("players");
        SpigotTimings.playerListTimer.startTiming();
        this.R.d();
        SpigotTimings.playerListTimer.stopTiming();
        gameprofilerfiller.b("debugSubscribers");
        this.aG.a();
        if (this.aF.i()) {
            gameprofilerfiller.b("gameTests");
            ti.a.b();
        }
        gameprofilerfiller.b("server gui refresh");
        SpigotTimings.tickablesTimer.startTiming();
        for (Runnable runnable : this.A) {
            runnable.run();
        }
        SpigotTimings.tickablesTimer.stopTiming();
        gameprofilerfiller.b("send chunks");
        for (axg entityplayer2 : this.R.t()) {
            entityplayer2.g.h.a(entityplayer2);
            entityplayer2.g.g();
        }
        gameprofilerfiller.c();
        this.ai.a();
    }

    private void bI() {
        fne.a worlddata_a = this.k.H().a();
        axf worldserver = this.aH();
        this.aH = worldserver.b(worlddata_a);
    }

    public void K() {
        this.ak().c();
    }

    private void a(axf worldserver) {
        this.R.a(new ahd(worldserver.au(), worldserver.al(), worldserver.U().a(eua.a)), worldserver.aq());
    }

    public void L() {
        bzm gameprofilerfiller = bzl.a();
        gameprofilerfiller.a("timeSync");
        for (axf worldserver : this.P()) {
            this.a(worldserver);
        }
        gameprofilerfiller.c();
    }

    public void b(Runnable runnable) {
        this.A.add(runnable);
    }

    protected void b(String s2) {
        this.aC = s2;
    }

    public boolean M() {
        return !this.ak.isAlive();
    }

    public Path c(String s2) {
        return this.G().resolve(s2);
    }

    public final axf N() {
        return this.Q.get(dwo.h);
    }

    public @Nullable axf a(amt<dwo> resourcekey) {
        return this.Q.get(resourcekey);
    }

    public void addLevel(axf level) {
        Map<amt<dwo>, axf> oldLevels = this.Q;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.aq(), level);
        this.Q = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(axf level) {
        Map<amt<dwo>, axf> oldLevels = this.Q;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.aq());
        this.Q = Collections.unmodifiableMap(newLevels);
    }

    public Set<amt<dwo>> O() {
        return this.Q.keySet();
    }

    public Iterable<axf> P() {
        return this.Q.values();
    }

    @Override
    public String Q() {
        return w.b().c();
    }

    @Override
    public int R() {
        return this.R.m();
    }

    public String[] S() {
        return this.R.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return "Spigot";
    }

    public y b(y systemreport) {
        systemreport.a("Server Running", () -> Boolean.toString(this.S));
        if (this.R != null) {
            systemreport.a("Player Count", () -> {
                int i2 = this.R.m();
                return i2 + " / " + this.R.n() + "; " + String.valueOf(this.R.t());
            });
        }
        systemreport.a("Active Data Packs", () -> bak.a(this.as.g()));
        systemreport.a("Available Data Packs", () -> bak.a(this.as.d()));
        systemreport.a("Enabled Feature Flags", () -> dhb.e.b(this.k.J()).stream().map(amo::toString).collect(Collectors.joining(", ")));
        systemreport.a("World Generation", () -> this.k.A().toString());
        systemreport.a("World Seed", () -> String.valueOf(this.k.x().c()));
        anp suppressedexceptioncollector = this.aN;
        Objects.requireNonNull(this.aN);
        systemreport.a("Suppressed Exceptions", suppressedexceptioncollector::a);
        if (this.aC != null) {
            systemreport.a("Server Id", () -> this.aC);
        }
        return this.a(systemreport);
    }

    public abstract y a(y var1);

    public bgi T() {
        return bgi.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(yh ichatbasecomponent) {
        m.info(ichatbasecomponent.getString());
    }

    public KeyPair U() {
        return Objects.requireNonNull(this.ac);
    }

    public int V() {
        return this.O;
    }

    public void b(int i2) {
        this.O = i2;
    }

    public @Nullable GameProfile W() {
        return this.ad;
    }

    public void a(@Nullable GameProfile gameprofile) {
        this.ad = gameprofile;
    }

    public boolean X() {
        return this.ad != null;
    }

    protected void Y() {
        m.info("Generating keypair");
        try {
            this.ac = bfb.b();
        }
        catch (bfc cryptographyexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptographyexception);
        }
    }

    public void a(ccz enumdifficulty, boolean flag) {
        if (flag || !this.k.q()) {
            this.k.a(this.k.k() ? ccz.d : enumdifficulty);
            this.Z();
            this.aj().t().forEach(this::c);
        }
    }

    public int c(int i2) {
        return i2;
    }

    private void Z() {
        for (axf worldserver : this.P()) {
            worldserver.b(worldserver.O());
        }
    }

    public void c(boolean flag) {
        this.k.d(flag);
        this.aj().t().forEach(this::c);
    }

    private void c(axg entityplayer) {
        fne worlddata = entityplayer.A().D_();
        entityplayer.g.b(new adn(worlddata.p(), worlddata.q()));
    }

    public boolean aa() {
        return this.ae;
    }

    @Override
    public void d(boolean flag) {
        this.ae = flag;
    }

    public Map<String, String> ab() {
        return Map.of();
    }

    public Optional<b> ac() {
        return Optional.empty();
    }

    public boolean ad() {
        return this.ac().filter(b::d).isPresent();
    }

    public abstract boolean n();

    public abstract int o();

    public boolean ae() {
        return this.W;
    }

    public void e(boolean flag) {
        this.W = flag;
    }

    public boolean af() {
        return this.X;
    }

    public void f(boolean flag) {
        this.X = flag;
    }

    public abstract boolean p();

    public boolean ag() {
        return true;
    }

    @Override
    public String ah() {
        return this.Y;
    }

    @Override
    public void d(String s2) {
        this.Y = s2;
    }

    public boolean ai() {
        return this.T;
    }

    public bbz aj() {
        return this.R;
    }

    public void a(bbz playerlist) {
        this.R = playerlist;
    }

    public abstract boolean q();

    public void a(dwl enumgamemode) {
        this.k.a(enumgamemode);
    }

    public int b(@Nullable dwl enumgamemode) {
        if (enumgamemode == null) {
            return 0;
        }
        int i2 = 0;
        for (axg entityplayer : this.aj().t()) {
            if (!entityplayer.a(enumgamemode)) continue;
            ++i2;
        }
        return i2;
    }

    public ayh ak() {
        return this.H == null ? (this.H = new ayh(this)) : this.H;
    }

    public boolean al() {
        return this.af;
    }

    public boolean a(@Nullable dwl enumgamemode, boolean flag, int i2) {
        return false;
    }

    public int am() {
        return this.U;
    }

    public boolean a(axf worldserver, is blockposition, ddm entityhuman) {
        return false;
    }

    public boolean an() {
        return true;
    }

    public boolean ao() {
        return false;
    }

    public Proxy ap() {
        return this.i;
    }

    public int aq() {
        return this.Z;
    }

    @Override
    public void d(int i2) {
        this.Z = i2;
    }

    public ano ar() {
        return this.j;
    }

    public @Nullable alq as() {
        return this.J;
    }

    public void at() {
        this.aj = 0L;
    }

    public int au() {
        return 29999984;
    }

    @Override
    public boolean av() {
        return super.av() && !this.ai();
    }

    @Override
    public void c(Runnable runnable) {
        if (this.ai()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.c(runnable);
    }

    @Override
    public Thread aw() {
        return this.ak;
    }

    public int ax() {
        return 256;
    }

    public boolean ay() {
        return false;
    }

    public long az() {
        return this.ao;
    }

    public DataFixer aA() {
        return this.M;
    }

    public ang aB() {
        return this.aD.b.e();
    }

    public ani aC() {
        return this.ax;
    }

    @Override
    public CompletableFuture<Void> a(Collection<String> collection) {
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Stream stream = collection.stream();
            bak resourcepackrepository = this.as;
            Objects.requireNonNull(this.as);
            return (ImmutableList)stream.map(resourcepackrepository::c).filter(Objects::nonNull).map(bah::f).collect(ImmutableList.toImmutableList());
        }, this).thenCompose(immutablelist -> {
            bas ireloadableresourcemanager = new bas(azn.b, (List<azl>)immutablelist);
            List<jq.a<?>> list = beg.a((baz)ireloadableresourcemanager, this.P.a());
            return ((CompletableFuture)ane.a(ireloadableresourcemanager, this.P, list, this.k.J(), this.n() ? ee.a.b : ee.a.c, this.l(), this.aB, this).whenComplete((datapackresources, throwable) -> {
                if (throwable != null) {
                    ireloadableresourcemanager.close();
                }
            })).thenApply(datapackresources -> new a(ireloadableresourcemanager, (ane)datapackresources));
        })).thenAcceptAsync(minecraftserver_reloadableresources -> {
            this.aD.close();
            this.aD = minecraftserver_reloadableresources;
            this.server.syncCommands();
            this.as.b(collection);
            dxm worlddataconfiguration = new dxm(MinecraftServer.a(this.as, true), this.k.J());
            this.k.a(worlddataconfiguration);
            this.aD.b.g();
            this.aD.b.c().a(this.k.J());
            this.aj().h();
            this.aj().u();
            this.ax.a(this.aD.b.a());
            this.aE.a(this.aD.a);
            this.aJ = emb.a(this.P.a(), this.k.J());
        }, (Executor)this);
        if (this.bK()) {
            Objects.requireNonNull(completablefuture);
            this.b(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static dxm a(bak resourcepackrepository, dxm worlddataconfiguration, boolean flag, boolean flag1) {
        dwc datapackconfiguration = worlddataconfiguration.a();
        dgz featureflagset = flag ? dgz.a() : worlddataconfiguration.b();
        dgz featureflagset1 = flag ? dhb.e.a() : worlddataconfiguration.b();
        resourcepackrepository.a();
        if (flag1) {
            return MinecraftServer.a(resourcepackrepository, List.of(b), featureflagset, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s2 : datapackconfiguration.a()) {
            if (resourcepackrepository.d(s2)) {
                set.add(s2);
                continue;
            }
            m.warn("Missing data pack {}", (Object)s2);
        }
        for (bah resourcepackloader : resourcepackrepository.d()) {
            String s1 = resourcepackloader.g();
            if (datapackconfiguration.b().contains(s1)) continue;
            dgz featureflagset2 = resourcepackloader.e();
            boolean flag2 = set.contains(s1);
            if (!flag2 && resourcepackloader.l().a()) {
                if (featureflagset2.a(featureflagset1)) {
                    m.info("Found new data pack {}, loading it automatically", (Object)s1);
                    set.add(s1);
                } else {
                    m.info("Found new data pack {}, but can't load it due to missing features {}", (Object)s1, (Object)dhb.a(featureflagset1, featureflagset2));
                }
            }
            if (!flag2 || featureflagset2.a(featureflagset1)) continue;
            m.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)s1, (Object)dhb.a(featureflagset1, featureflagset2));
            set.remove(s1);
        }
        if (set.isEmpty()) {
            m.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        return MinecraftServer.a(resourcepackrepository, set, featureflagset, true);
    }

    private static dxm a(bak resourcepackrepository, Collection<String> collection, dgz featureflagset, boolean flag) {
        resourcepackrepository.b(collection);
        MinecraftServer.a(resourcepackrepository, featureflagset);
        dwc datapackconfiguration = MinecraftServer.a(resourcepackrepository, flag);
        dgz featureflagset1 = resourcepackrepository.f().c(featureflagset);
        return new dxm(datapackconfiguration, featureflagset1);
    }

    private static void a(bak resourcepackrepository, dgz featureflagset) {
        dgz featureflagset1 = resourcepackrepository.f();
        dgz featureflagset2 = featureflagset.d(featureflagset1);
        if (!featureflagset2.b()) {
            ObjectArraySet set = new ObjectArraySet(resourcepackrepository.e());
            for (bah resourcepackloader : resourcepackrepository.d()) {
                if (featureflagset2.b()) break;
                if (resourcepackloader.l() != bal.d) continue;
                String s2 = resourcepackloader.g();
                dgz featureflagset3 = resourcepackloader.e();
                if (featureflagset3.b() || !featureflagset3.b(featureflagset2) || !featureflagset3.a(featureflagset)) continue;
                if (!set.add(s2)) {
                    throw new IllegalStateException("Tried to force '" + s2 + "', but it was already enabled");
                }
                m.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)s2);
                featureflagset2 = featureflagset2.d(featureflagset3);
            }
            resourcepackrepository.b((Collection<String>)set);
        }
    }

    private static dwc a(bak resourcepackrepository, boolean flag) {
        Collection<String> collection = resourcepackrepository.e();
        ImmutableList list = ImmutableList.copyOf(collection);
        List<String> list1 = flag ? resourcepackrepository.c().stream().filter(s2 -> !collection.contains(s2)).toList() : List.of();
        return new dwc((List<String>)list, list1);
    }

    public void aD() {
        if (this.aO() && this.aP()) {
            bbz playerlist = this.aj();
            bcj whitelist = playerlist.i();
            for (axg entityplayer : Lists.newArrayList(playerlist.t())) {
                if (whitelist.a(entityplayer.gJ())) continue;
                entityplayer.g.a(yh.c("multiplayer.disconnect.not_whitelisted"));
            }
        }
    }

    public bak aE() {
        return this.as;
    }

    public ee aF() {
        return this.aD.b.d();
    }

    public ed aG() {
        axf worldserver = this.aH();
        return new ed(this, ftm.a(this.aI().b()), ftl.a, worldserver, bbh.e, "Server", yh.b("Server"), this, null);
    }

    public axf aH() {
        return this.findRespawnDimension(this.N());
    }

    public axf findRespawnDimension(axf world) {
        if (world == null) {
            return null;
        }
        fne.a worlddata_a = world.C();
        amt<dwo> resourcekey = worlddata_a.a();
        axf worldserver = this.a(resourcekey);
        return worldserver != null ? worldserver : this.N();
    }

    public void a(fne.a worlddata_a) {
        this.setRespawnData(worlddata_a, this.N());
    }

    public void setRespawnData(fne.a worlddata_a, axf world) {
        fnm iworlddataserver = world.I;
        fne.a worlddata_a1 = iworlddataserver.a();
        if (!worlddata_a1.equals(worlddata_a)) {
            iworlddataserver.a(worlddata_a);
            SpawnChangeEvent event = new SpawnChangeEvent((World)world.getWorld(), CraftLocation.toBukkit(worlddata_a1.b(), (World)world.getWorld(), worlddata_a1.d(), worlddata_a1.e()));
            this.server.getPluginManager().callEvent((Event)event);
            this.aj().a(new agn(worlddata_a));
            this.bI();
        }
    }

    public fne.a aI() {
        return this.aH;
    }

    @Override
    public boolean x_() {
        return true;
    }

    @Override
    public boolean y_() {
        return true;
    }

    @Override
    public abstract boolean c();

    public dqz aJ() {
        return this.aD.b.c();
    }

    public anm aK() {
        return this.at;
    }

    public fmz aL() {
        if (this.av == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.av;
    }

    public cdn aM() {
        if (this.au == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.au;
    }

    public anw aN() {
        return this.aw;
    }

    public boolean aO() {
        return this.ay;
    }

    public void g(boolean flag) {
        this.ay = flag;
    }

    public boolean aP() {
        return this.az;
    }

    public void h(boolean flag) {
        this.az = flag;
    }

    public float aQ() {
        return this.aA;
    }

    public ann aR() {
        return this.aF;
    }

    public long aS() {
        return this.ab / (long)Math.min(100, Math.max(this.U, 1));
    }

    public long[] aT() {
        return this.aa;
    }

    public bbh b(bbx nameandid) {
        if (this.aj().f(nameandid)) {
            bcc oplistentry = (bcc)this.aj().k().c(nameandid);
            return oplistentry != null ? oplistentry.a() : (this.a(nameandid) ? bbh.e : (this.X() ? (this.aj().v() ? bbh.e : bbh.a) : this.k()));
        }
        return bbh.a;
    }

    public abstract boolean a(bbx var1);

    public void a(Path path) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<amt<dwo>, axf> map_entry : this.Q.entrySet()) {
                amo minecraftkey = map_entry.getKey().a();
                Path path2 = path1.resolve(minecraftkey.b()).resolve(minecraftkey.a());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                map_entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            m.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.bL()));
            writer.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aQ())));
            writer.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.aa)));
            writer.write(String.format(Locale.ROOT, "queue: %s\n", bhs.h()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final eua gamerules = this.k.n();
            gamerules.a(new etz(){

                @Override
                public <T> void a(etv<T> gamerule) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", gamerule.b(), gamerules.b(gamerule)));
                }
            });
            for (String s2 : list) {
                writer.write(s2);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String s2 = System.getProperty("java.class.path");
            String s1 = File.pathSeparator;
            for (String s22 : Splitter.on((String)s1).split((CharSequence)s2)) {
                writer.write(s22);
                writer.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadinfo : athreadinfo) {
                writer.write(threadinfo.toString());
                ((Writer)writer).write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);
        try {
            ArrayList list;
            try {
                list = Lists.newArrayList(bgk.a());
            }
            catch (Throwable throwable) {
                m.warn("Failed to list native modules", throwable);
                if (writer != null) {
                    ((Writer)writer).close();
                }
                return;
            }
            list.sort(Comparator.comparing(nativemodulelister_a -> nativemodulelister_a.a));
            for (bgk.a nativemodulelister_a2 : list) {
                writer.write(nativemodulelister_a2.toString());
                ((Writer)writer).write(10);
            }
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public boolean isDebugging() {
        return false;
    }

    @Deprecated
    public static MinecraftServer getServer() {
        return Bukkit.getServer() instanceof CraftServer ? ((CraftServer)Bukkit.getServer()).getServer() : null;
    }

    @Deprecated
    public static jr getDefaultRegistryAccess() {
        return CraftRegistry.getMinecraftRegistry();
    }

    private bzm bQ() {
        if (this.E) {
            this.B = cbc.a(new cbg(bhs.c, this.n()), bhs.c, bhs.i(), new cbi("server"), this.C, path -> {
                this.h(() -> this.b(path.resolve("server")));
                this.D.accept((Path)path);
            });
            this.E = false;
        }
        this.B.c();
        return bzp.a(this.B.f(), bzp.a("Server"));
    }

    public void aU() {
        this.B.d();
    }

    public boolean aV() {
        return this.B.e();
    }

    public void a(Consumer<bzk> consumer, Consumer<Path> consumer1) {
        this.C = methodprofilerresults -> {
            this.aW();
            consumer.accept((bzk)methodprofilerresults);
        };
        this.D = consumer1;
        this.E = true;
    }

    public void aW() {
        this.B = cbd.a;
    }

    public void aX() {
        this.B.a();
    }

    public void aY() {
        this.B.b();
    }

    public Path a(fng savedfile) {
        return this.g.a(savedfile);
    }

    public boolean aZ() {
        return true;
    }

    public fjr ba() {
        return this.aE;
    }

    public fnt bb() {
        return this.k;
    }

    public jr.b bc() {
        return this.P.a();
    }

    public jk<anc> bd() {
        return this.P;
    }

    public and.a be() {
        return this.aD.b.b();
    }

    public ayo a(axg entityplayer) {
        return ayo.e;
    }

    public axh b(axg entityplayer) {
        return this.aa() ? new awr(entityplayer) : new axh(entityplayer);
    }

    public @Nullable dwl bf() {
        return null;
    }

    public baz bg() {
        return this.aD.a;
    }

    public boolean bh() {
        return this.aL;
    }

    public boolean bi() {
        return this.G || this.F != null;
    }

    public void bj() {
        this.G = true;
    }

    public bzk bk() {
        if (this.F == null) {
            return bzg.a;
        }
        bzk methodprofilerresults = this.F.a(bhs.d(), this.U);
        this.F = null;
        return methodprofilerresults;
    }

    public int bl() {
        return 1000000;
    }

    public void a(yh ichatbasecomponent, yd.a chatmessagetype_a, @Nullable String s2) {
        String s1 = chatmessagetype_a.a(ichatbasecomponent).getString();
        if (s2 != null) {
            m.info("[{}] {}", (Object)s2, (Object)s1);
        } else {
            m.info("{}", (Object)s1);
        }
    }

    public yc bm() {
        return yc.a;
    }

    public boolean bn() {
        return true;
    }

    public void handleCustomClickAction(amo minecraftkey, Optional<vz> optional, axg player) {
        m.debug("Received custom click action {} with payload {}", (Object)minecraftkey, optional.orElse(null));
        CraftEventFactory.callPlayerCustomClickEvent(minecraftkey, optional, player);
    }

    public axq bo() {
        return this.I;
    }

    public boolean i(boolean flag) {
        boolean flag1 = false;
        for (axf worldserver : this.P()) {
            if (worldserver == null || worldserver.e != flag) continue;
            worldserver.e = !flag;
            flag1 = true;
        }
        return flag1;
    }

    public boolean bp() {
        for (axf worldserver : this.P()) {
            if (worldserver == null || worldserver.e) continue;
            return true;
        }
        return false;
    }

    public static <T> void onGameRuleChanged(etv<T> gamerule, T t0, axf worldserver) {
        worldserver.s().C().a(gamerule, t0);
        if (gamerule == eua.P) {
            byte b0 = (byte)((Boolean)t0 != false ? 22 : 23);
            for (axg entityplayer : worldserver.E()) {
                entityplayer.g.b(new aei(entityplayer, b0));
            }
        } else if (gamerule != eua.u && gamerule != eua.r) {
            if (gamerule == eua.v) {
                bcv serverwaypointmanager = worldserver.j();
                if (((Boolean)t0).booleanValue()) {
                    List<axg> list = worldserver.E();
                    Objects.requireNonNull(serverwaypointmanager);
                    list.forEach(serverwaypointmanager::b);
                } else {
                    serverwaypointmanager.a();
                }
            } else if (gamerule == eua.W) {
                worldserver.b(worldserver.O());
            }
        } else {
            aem.a packetplayoutgamestatechange_a = gamerule == eua.u ? aem.n : aem.m;
            aem packetplayoutgamestatechange = new aem(packetplayoutgamestatechange_a, (Boolean)t0 != false ? 1.0f : 0.0f);
            worldserver.E().forEach(entityplayer1 -> entityplayer1.g.b(packetplayoutgamestatechange));
        }
    }

    public boolean bq() {
        return false;
    }

    private void a(m crashreport, dvu chunkcoordintpair, esa regionstorageinfo) {
        bhs.i().execute(() -> {
            try {
                Path path = this.c("debug");
                bfp.c(path);
                String s2 = bfp.a(regionstorageinfo.a());
                Path path1 = path.resolve("chunk-" + s2 + "-" + bhs.f() + "-server.txt");
                FileStore filestore = java.nio.file.Files.getFileStore(path);
                long i2 = filestore.getUsableSpace();
                if (i2 < 8192L) {
                    m.warn("Not storing chunk IO report due to low space on drive {}", (Object)filestore.name());
                    return;
                }
                n crashreportsystemdetails = crashreport.a("Chunk Info");
                Objects.requireNonNull(regionstorageinfo);
                crashreportsystemdetails.a("Level", regionstorageinfo::a);
                crashreportsystemdetails.a("Dimension", () -> regionstorageinfo.b().a().toString());
                Objects.requireNonNull(regionstorageinfo);
                crashreportsystemdetails.a("Storage", regionstorageinfo::c);
                Objects.requireNonNull(chunkcoordintpair);
                crashreportsystemdetails.a("Position", chunkcoordintpair::toString);
                crashreport.a(path1, u.e);
                m.info("Saved details to {}", (Object)crashreport.e());
            }
            catch (Exception exception) {
                m.warn("Failed to store chunk IO exception", (Throwable)exception);
            }
        });
    }

    @Override
    public void a(Throwable throwable, esa regionstorageinfo, dvu chunkcoordintpair) {
        m.error("Failed to load chunk {},{}", new Object[]{chunkcoordintpair.h, chunkcoordintpair.i, throwable});
        this.aN.a("chunk/load", throwable);
        this.a(m.a(throwable, "Chunk load failure"), chunkcoordintpair, regionstorageinfo);
    }

    @Override
    public void b(Throwable throwable, esa regionstorageinfo, dvu chunkcoordintpair) {
        m.error("Failed to save chunk {},{}", new Object[]{chunkcoordintpair.h, chunkcoordintpair.i, throwable});
        this.aN.a("chunk/save", throwable);
        this.a(m.a(throwable, "Chunk save failure"), chunkcoordintpair, regionstorageinfo);
    }

    public void a(Throwable throwable, aba<?> packettype) {
        this.aN.a("packet/" + String.valueOf(packettype), throwable);
    }

    public dnq br() {
        return this.aI;
    }

    public emb bs() {
        return this.aJ;
    }

    public anl bt() {
        return anl.a;
    }

    protected int bu() {
        return 0;
    }

    public xl bv() {
        return this.aP;
    }

    public bxj bw() {
        return this.aG;
    }

    public record a(bap a, ane b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    private static class c {
        final long a;
        final int b;

        c(long i2, int j2) {
            this.a = i2;
            this.b = j2;
        }

        bzk a(final long i2, final int j2) {
            return new bzk(){

                @Override
                public List<bzo> a(String s2) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return i2;
                }

                @Override
                public int d() {
                    return j2;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public record b(UUID a, String b, String c, boolean d, @Nullable yh e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

