/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.CraftChunkSnapshot;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class CraftChunk
implements Chunk {
    private final axf worldServer;
    private final int x;
    private final int z;
    private static final eqy<eoh> emptyBlockIDs = new eqy<eoh>(dzs.a.m(), erd.a(dzq.k));
    private static final byte[] FULL_LIGHT = new byte[2048];
    private static final byte[] EMPTY_LIGHT = new byte[2048];

    public CraftChunk(eqq chunk) {
        this.worldServer = chunk.q;
        this.x = chunk.f().h;
        this.z = chunk.f().i;
    }

    public CraftChunk(axf worldServer, int x2, int z2) {
        this.worldServer = worldServer;
        this.x = x2;
        this.z = z2;
    }

    public World getWorld() {
        return this.worldServer.getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public eqf getHandle(erj chunkStatus) {
        eqf chunkAccess = this.worldServer.a(this.x, this.z, chunkStatus);
        if (chunkAccess instanceof eqp) {
            eqp extension = (eqp)chunkAccess;
            return extension.H();
        }
        return chunkAccess;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "CraftChunk{x=" + this.getX() + "z=" + this.getZ() + "}";
    }

    public Block getBlock(int x2, int y2, int z2) {
        CraftChunk.validateChunkCoordinates(this.worldServer.K_(), this.worldServer.aw(), x2, y2, z2);
        return new CraftBlock(this.worldServer, new is(this.x << 4 | x2, y2, this.z << 4 | z2));
    }

    public boolean isEntitiesLoaded() {
        return this.getCraftWorld().getHandle().M.a(dvu.d(this.x, this.z));
    }

    public Entity[] getEntities() {
        long pair;
        eta<cgk> entityManager;
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        if ((entityManager = this.getCraftWorld().getHandle().M).a(pair = dvu.d(this.x, this.z))) {
            return (Entity[])entityManager.getEntities(new dvu(this.x, this.z)).stream().map(cgk::getBukkitEntity).filter(Objects::nonNull).toArray(Entity[]::new);
        }
        entityManager.b(pair);
        cbs mailbox = ((ers)entityManager.d).g;
        BooleanSupplier supplier = () -> {
            if (entityManager.a(pair)) {
                return true;
            }
            if (!entityManager.isPending(pair)) {
                entityManager.b(pair);
            }
            entityManager.b();
            return entityManager.a(pair);
        };
        while (!supplier.getAsBoolean()) {
            if (mailbox.b() != 0) {
                mailbox.run();
                continue;
            }
            Thread.yield();
            LockSupport.parkNanos("waiting for entity loading", 100000L);
        }
        return (Entity[])entityManager.getEntities(new dvu(this.x, this.z)).stream().map(cgk::getBukkitEntity).filter(Objects::nonNull).toArray(Entity[]::new);
    }

    public BlockState[] getTileEntities() {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        int index = 0;
        eqf chunk = this.getHandle(erj.n);
        BlockState[] entities = new BlockState[chunk.j.size()];
        for (is position : chunk.j.keySet()) {
            entities[index++] = this.worldServer.getWorld().getBlockAt(position.u(), position.v(), position.w()).getState();
        }
        return entities;
    }

    public boolean isGenerated() {
        eqf chunk = this.getHandle(erj.c);
        return chunk.n().a(erj.n);
    }

    public boolean isLoaded() {
        return this.getWorld().isChunkLoaded((Chunk)this);
    }

    public boolean load() {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), true);
    }

    public boolean load(boolean generate) {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), generate);
    }

    public boolean unload() {
        return this.getWorld().unloadChunk(this.getX(), this.getZ());
    }

    public boolean isSlimeChunk() {
        return evp.a(this.getX(), this.getZ(), this.getWorld().getSeed(), this.worldServer.spigotConfig.slimeSeed).a(10) == 0;
    }

    public boolean unload(boolean save) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save);
    }

    public boolean isForceLoaded() {
        return this.getWorld().isChunkForceLoaded(this.getX(), this.getZ());
    }

    public void setForceLoaded(boolean forced) {
        this.getWorld().setChunkForceLoaded(this.getX(), this.getZ(), forced);
    }

    public boolean addPluginChunkTicket(Plugin plugin) {
        return this.getWorld().addPluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public boolean removePluginChunkTicket(Plugin plugin) {
        return this.getWorld().removePluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public Collection<Plugin> getPluginChunkTickets() {
        return this.getWorld().getPluginChunkTickets(this.getX(), this.getZ());
    }

    public long getInhabitedTime() {
        return this.getHandle(erj.c).w();
    }

    public void setInhabitedTime(long ticks) {
        Preconditions.checkArgument((ticks >= 0L ? 1 : 0) != 0, (Object)"ticks cannot be negative");
        this.getHandle(erj.d).c(ticks);
    }

    public boolean contains(BlockData block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo((Object)((CraftBlockData)block).getState());
        for (eqr section : this.getHandle(erj.n).d()) {
            if (section == null || !section.h().a((Predicate<eoh>)nms)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Biome biome) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome cannot be null");
        eqf chunk = this.getHandle(erj.f);
        com.google.common.base.Predicate nms = Predicates.equalTo(CraftBiome.bukkitToMinecraftHolder(biome));
        for (eqr section : chunk.d()) {
            if (section == null || !section.i().a((Predicate<jd<dxo>>)nms)) continue;
            return true;
        }
        return false;
    }

    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain) {
        eqf chunk = this.getHandle(erj.n);
        eqr[] cs2 = chunk.d();
        eqy[] sectionBlockIDs = new eqy[cs2.length];
        byte[][] sectionSkyLights = new byte[cs2.length][];
        byte[][] sectionEmitLights = new byte[cs2.length][];
        boolean[] sectionEmpty = new boolean[cs2.length];
        eqy[] biome = includeBiome || includeBiomeTempRain ? new eqy[cs2.length] : null;
        eqz palettedcontainerfactory = this.worldServer.at();
        Codec<era<jd<dxo>>> biomeCodec = palettedcontainerfactory.h();
        for (int i2 = 0; i2 < cs2.length; ++i2) {
            uz data = new uz();
            data.a("block_states", (vz)palettedcontainerfactory.e().encodeStart((DynamicOps)vn.a, cs2[i2].h()).getOrThrow());
            sectionBlockIDs[i2] = (eqy)palettedcontainerfactory.e().parse((DynamicOps)vn.a, (Object)data.n("block_states")).getOrThrow(esc.a::new);
            sectionEmpty[i2] = cs2[i2].c();
            fkq lightengine = this.worldServer.C_();
            eql skyLightArray = lightengine.a(dww.a).a(jw.a(this.x, chunk.h(i2), this.z));
            if (skyLightArray == null) {
                sectionSkyLights[i2] = this.worldServer.F_().e() ? FULL_LIGHT : EMPTY_LIGHT;
            } else {
                sectionSkyLights[i2] = new byte[2048];
                System.arraycopy(skyLightArray.a(), 0, sectionSkyLights[i2], 0, 2048);
            }
            eql emitLightArray = lightengine.a(dww.b).a(jw.a(this.x, chunk.h(i2), this.z));
            if (emitLightArray == null) {
                sectionEmitLights[i2] = EMPTY_LIGHT;
            } else {
                sectionEmitLights[i2] = new byte[2048];
                System.arraycopy(emitLightArray.a(), 0, sectionEmitLights[i2], 0, 2048);
            }
            if (biome == null) continue;
            data.a("biomes", (vz)biomeCodec.encodeStart((DynamicOps)vn.a, cs2[i2].i()).getOrThrow());
            biome[i2] = (era)biomeCodec.parse((DynamicOps)vn.a, (Object)data.n("biomes")).getOrThrow(esc.a::new);
        }
        euq hmap = null;
        if (includeMaxBlockY) {
            hmap = new euq(chunk, euq.a.e);
            hmap.a(chunk, euq.a.e, chunk.g.get(euq.a.e).a());
        }
        World world = this.getWorld();
        return new CraftChunkSnapshot(this.getX(), this.getZ(), chunk.K_(), chunk.aw(), world.getSeaLevel(), world.getName(), world.getFullTime(), sectionBlockIDs, sectionSkyLights, sectionEmitLights, sectionEmpty, hmap, biome);
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.getHandle((erj)erj.d).persistentDataContainer;
    }

    public Chunk.LoadLevel getLoadLevel() {
        eqq chunk = this.worldServer.getChunkIfLoaded(this.getX(), this.getZ());
        if (chunk == null) {
            return Chunk.LoadLevel.UNLOADED;
        }
        return Chunk.LoadLevel.values()[chunk.G().ordinal()];
    }

    public Collection<GeneratedStructure> getStructures() {
        return this.getCraftWorld().getStructures(this.getX(), this.getZ());
    }

    public Collection<GeneratedStructure> getStructures(Structure structure) {
        return this.getCraftWorld().getStructures(this.getX(), this.getZ(), structure);
    }

    public Collection<Player> getPlayersSeeingChunk() {
        return this.getWorld().getPlayersSeeingChunk((Chunk)this);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        CraftChunk that = (CraftChunk)o2;
        if (this.x != that.x) {
            return false;
        }
        if (this.z != that.z) {
            return false;
        }
        return this.worldServer.equals(that.worldServer);
    }

    public int hashCode() {
        int result = this.worldServer.hashCode();
        result = 31 * result + this.x;
        result = 31 * result + this.z;
        return result;
    }

    public static ChunkSnapshot getEmptyChunkSnapshot(int x2, int z2, CraftWorld world, boolean includeBiome, boolean includeBiomeTempRain) {
        eqf actual = world.getHandle().a(x2, z2, includeBiome || includeBiomeTempRain ? erj.f : erj.c);
        int hSection = actual.ax();
        eqy[] blockIDs = new eqy[hSection];
        byte[][] skyLight = new byte[hSection][];
        byte[][] emitLight = new byte[hSection][];
        boolean[] empty = new boolean[hSection];
        eqy[] biome = includeBiome || includeBiomeTempRain ? new eqy[hSection] : null;
        Codec<era<jd<dxo>>> biomeCodec = world.getHandle().at().h();
        for (int i2 = 0; i2 < hSection; ++i2) {
            blockIDs[i2] = emptyBlockIDs;
            skyLight[i2] = world.getHandle().F_().e() ? FULL_LIGHT : EMPTY_LIGHT;
            emitLight[i2] = EMPTY_LIGHT;
            empty[i2] = true;
            if (biome == null) continue;
            biome[i2] = (eqy)biomeCodec.parse((DynamicOps)vn.a, (Object)((vz)biomeCodec.encodeStart((DynamicOps)vn.a, actual.b(i2).i()).getOrThrow())).getOrThrow(esc.a::new);
        }
        return new CraftChunkSnapshot(x2, z2, world.getMinHeight(), world.getMaxHeight(), world.getSeaLevel(), world.getName(), world.getFullTime(), blockIDs, skyLight, emitLight, empty, new euq(actual, euq.a.e), biome);
    }

    static void validateChunkCoordinates(int minY, int maxY, int x2, int y2, int z2) {
        Preconditions.checkArgument((0 <= x2 && x2 <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x2);
        Preconditions.checkArgument((minY <= y2 && y2 <= maxY ? 1 : 0) != 0, (String)"y out of range (expected %s-%s, got %s)", (Object)minY, (Object)maxY, (Object)y2);
        Preconditions.checkArgument((0 <= z2 && z2 <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z2);
    }

    static {
        Arrays.fill(FULL_LIGHT, (byte)-1);
    }
}

