/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_21_R7.CraftArt;
import org.bukkit.craftbukkit.v1_21_R7.CraftFluid;
import org.bukkit.craftbukkit.v1_21_R7.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R7.CraftGameRule;
import org.bukkit.craftbukkit.v1_21_R7.CraftJukeboxSong;
import org.bukkit.craftbukkit.v1_21_R7.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R7.CraftSound;
import org.bukkit.craftbukkit.v1_21_R7.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R7.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R7.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPig;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftZombieNautilus;
import org.bukkit.craftbukkit.v1_21_R7.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R7.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMenuType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R7.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_21_R7.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R7.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R7.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.util.Handleable;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.ZombieNautilus;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private static jr registry;
    private final Class<? super B> bukkitClass;
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final jq<M> minecraftRegistry;
    private final BiFunction<NamespacedKey, jd<M>, B> minecraftToBukkit;
    private final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater;
    private boolean init;

    public static void setMinecraftRegistry(jr registry) {
        Preconditions.checkState((CraftRegistry.registry == null ? 1 : 0) != 0, (Object)"Registry already set");
        CraftRegistry.registry = registry;
    }

    public static jr getMinecraftRegistry() {
        return registry;
    }

    public static <E> jq<E> getMinecraftRegistry(amt<jq<E>> key) {
        return CraftRegistry.getMinecraftRegistry().f(key);
    }

    public static <B extends Keyed, M> B minecraftToBukkit(M minecraft, amt<jq<M>> registryKey, Registry<B> bukkitRegistry) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        jq registry = CraftRegistry.getMinecraftRegistry(registryKey);
        Keyed bukkit = bukkitRegistry.get(CraftNamespacedKey.fromMinecraft(registry.d(minecraft).orElseThrow(() -> new IllegalStateException(String.format("Cannot convert '%s' to bukkit representation, since it is not registered.", minecraft))).a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (B)bukkit;
    }

    public static <B extends Keyed, M> M bukkitToMinecraft(B bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((Handleable)bukkit).getHandle();
    }

    public static <B extends Keyed, M> jd<M> bukkitToMinecraftHolder(B bukkit, amt<jq<M>> registryKey) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        jq registry = CraftRegistry.getMinecraftRegistry(registryKey);
        jd jd2 = registry.e(CraftRegistry.bukkitToMinecraft(bukkit));
        if (jd2 instanceof jd.c) {
            jd.c holder = (jd.c)jd2;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own registry entry with out properly registering it.");
    }

    private static <M, B> BiFunction<NamespacedKey, jd<M>, B> wrap(BiFunction<NamespacedKey, M, B> minecraftToBukkit) {
        return (namespacedKey, holder) -> minecraftToBukkit.apply((NamespacedKey)namespacedKey, (Object)holder.a());
    }

    public static <B extends Keyed> Registry<?> createRegistry(Class<? super B> bukkitClass, jr registryHolder) {
        if (bukkitClass == Art.class) {
            return new CraftRegistry<CraftArt, czh>(Art.class, registryHolder.f(mj.bn), CraftArt::new, FieldRename.NONE);
        }
        if (bukkitClass == Attribute.class) {
            return new CraftRegistry<CraftAttribute, cin>(Attribute.class, registryHolder.f(mj.c), CraftAttribute::new, FieldRename.ATTRIBUTE_RENAME);
        }
        if (bukkitClass == Biome.class) {
            return new CraftRegistry<CraftBiome, dxo>(Biome.class, registryHolder.f(mj.aS), CraftBiome::new, FieldRename.BIOME_RENAME);
        }
        if (bukkitClass == Enchantment.class) {
            return new CraftRegistry<CraftEnchantment, dso>(Enchantment.class, registryHolder.f(mj.bf), CraftRegistry.wrap(CraftEnchantment::new), FieldRename.ENCHANTMENT_RENAME);
        }
        if (bukkitClass == Fluid.class) {
            return new CraftRegistry<CraftFluid, fla>(Fluid.class, registryHolder.f(mj.L), CraftFluid::new, FieldRename.NONE);
        }
        if (bukkitClass == GameEvent.class) {
            return new CraftRegistry<CraftGameEvent, etk>(GameEvent.class, registryHolder.f(mj.N), CraftRegistry.wrap(CraftGameEvent::new), FieldRename.NONE);
        }
        if (bukkitClass == GameRule.class) {
            return new CraftRegistry<CraftGameRule, etv>(GameRule.class, registryHolder.f(mj.s), CraftRegistry.wrap(CraftGameRule::new), FieldRename.GAME_RULE_RENAME);
        }
        if (bukkitClass == MusicInstrument.class) {
            return new CraftRegistry<CraftMusicInstrument, dlm>(MusicInstrument.class, registryHolder.f(mj.bi), CraftMusicInstrument::new, FieldRename.NONE);
        }
        if (bukkitClass == MenuType.class) {
            return new CraftRegistry(MenuType.class, registryHolder.f(mj.ad), CraftMenuType::new, FieldRename.NONE);
        }
        if (bukkitClass == PotionEffectType.class) {
            return new CraftRegistry<CraftPotionEffectType, cfk>(PotionEffectType.class, registryHolder.f(mj.ae), CraftRegistry.wrap(CraftPotionEffectType::new), FieldRename.NONE);
        }
        if (bukkitClass == Sound.class) {
            return new CraftRegistry<CraftSound, bcz>(Sound.class, registryHolder.f(mj.aw), CraftSound::new, FieldRename.NONE);
        }
        if (bukkitClass == Structure.class) {
            return new CraftRegistry<CraftStructure, ffo>(Structure.class, registryHolder.f(mj.bs), CraftRegistry.wrap(CraftStructure::new), FieldRename.NONE);
        }
        if (bukkitClass == StructureType.class) {
            return new CraftRegistry<CraftStructureType, ffx>(StructureType.class, registryHolder.f(mj.aD), CraftRegistry.wrap(CraftStructureType::new), FieldRename.NONE);
        }
        if (bukkitClass == Villager.Type.class) {
            return new CraftRegistry<CraftVillager.CraftType, ddc>(Villager.Type.class, registryHolder.f(mj.aM), CraftVillager.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == Villager.Profession.class) {
            return new CraftRegistry<CraftVillager.CraftProfession, dda>(Villager.Profession.class, registryHolder.f(mj.aL), CraftVillager.CraftProfession::new, FieldRename.NONE);
        }
        if (bukkitClass == TrimMaterial.class) {
            return new CraftRegistry<CraftTrimMaterial, dur>(TrimMaterial.class, registryHolder.f(mj.bz), CraftTrimMaterial::new, FieldRename.NONE);
        }
        if (bukkitClass == TrimPattern.class) {
            return new CraftRegistry<CraftTrimPattern, dut>(TrimPattern.class, registryHolder.f(mj.bA), CraftTrimPattern::new, FieldRename.NONE);
        }
        if (bukkitClass == DamageType.class) {
            return new CraftRegistry<CraftDamageType, cez>(DamageType.class, registryHolder.f(mj.ba), CraftDamageType::new, FieldRename.NONE);
        }
        if (bukkitClass == JukeboxSong.class) {
            return new CraftRegistry<CraftJukeboxSong, dlz>(JukeboxSong.class, registryHolder.f(mj.bj), CraftJukeboxSong::new, FieldRename.NONE);
        }
        if (bukkitClass == Wolf.Variant.class) {
            return new CraftRegistry<CraftWolf.CraftVariant, cxx>(Wolf.Variant.class, registryHolder.f(mj.bB), CraftWolf.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == BlockType.class) {
            return new CraftRegistry<CraftBlockType, dzq>(BlockType.class, registryHolder.f(mj.i), CraftBlockType::new, FieldRename.BLOCK_TYPE_RENAME);
        }
        if (bukkitClass == ItemType.class) {
            return new CraftRegistry<CraftItemType, dlp>(ItemType.class, registryHolder.f(mj.R), CraftItemType::new, FieldRename.ITEM_TYPE_RENAME);
        }
        if (bukkitClass == Frog.Variant.class) {
            return new CraftRegistry<CraftFrog.CraftVariant, cvs>(Frog.Variant.class, registryHolder.f(mj.bh), CraftFrog.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Cat.Type.class) {
            return new CraftRegistry<CraftCat.CraftType, cvc>(Cat.Type.class, registryHolder.f(mj.aT), CraftCat.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == Pig.Variant.class) {
            return new CraftRegistry<CraftPig.CraftVariant, cxc>(Pig.Variant.class, registryHolder.f(mj.bo), CraftPig.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Cow.Variant.class) {
            return new CraftRegistry<CraftCow.CraftVariant, cui>(Cow.Variant.class, registryHolder.f(mj.aZ), CraftCow.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Chicken.Variant.class) {
            return new CraftRegistry<CraftChicken.CraftVariant, cud>(Chicken.Variant.class, registryHolder.f(mj.aV), CraftChicken.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == ZombieNautilus.Variant.class) {
            return new CraftRegistry<CraftZombieNautilus.CraftVariant, cws>(ZombieNautilus.Variant.class, registryHolder.f(mj.aW), CraftZombieNautilus.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == MapCursor.Type.class) {
            return new CraftRegistry<CraftMapCursor.CraftType, fmr>(MapCursor.Type.class, registryHolder.f(mj.Z), CraftMapCursor.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == PatternType.class) {
            return new CraftRegistry<CraftPatternType, ekq>(PatternType.class, registryHolder.f(mj.aR), CraftPatternType::new, FieldRename.NONE);
        }
        return null;
    }

    public static <B extends Keyed> B get(Registry<B> bukkit, NamespacedKey namespacedKey, ApiVersion apiVersion) {
        if (bukkit instanceof CraftRegistry) {
            CraftRegistry craft = (CraftRegistry)bukkit;
            return craft.get(namespacedKey, apiVersion);
        }
        if (bukkit instanceof Registry.SimpleRegistry) {
            Registry.SimpleRegistry simple = (Registry.SimpleRegistry)bukkit;
            Class bClass = simple.getType();
            if (bClass == EntityType.class) {
                return (B)bukkit.get(FieldRename.ENTITY_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == Particle.class) {
                return (B)bukkit.get(FieldRename.PARTICLE_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
        }
        return (B)bukkit.get(namespacedKey);
    }

    public CraftRegistry(Class<? super B> bukkitClass, jq<M> minecraftRegistry, BiFunction<NamespacedKey, jd<M>, B> minecraftToBukkit, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater) {
        this.bukkitClass = bukkitClass;
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
        this.updater = updater;
    }

    public B get(NamespacedKey namespacedKey, ApiVersion apiVersion) {
        return this.get(this.updater.apply(namespacedKey, apiVersion));
    }

    public B get(NamespacedKey namespacedKey) {
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        if (!this.init) {
            this.init = true;
            try {
                Class.forName(this.bukkitClass.getName());
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException("Could not load registry class " + String.valueOf(this.bukkitClass), e2);
            }
            return this.get(namespacedKey);
        }
        B bukkit = this.createBukkit(namespacedKey, this.minecraftRegistry.c(CraftNamespacedKey.toMinecraft(namespacedKey)).orElse(null));
        if (bukkit == null) {
            return null;
        }
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    @NotNull
    public B getOrThrow(@NotNull NamespacedKey namespacedKey) {
        B object = this.get(namespacedKey);
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (String)"No %s registry entry found for key %s.", this.minecraftRegistry.g(), (Object)namespacedKey);
        return object;
    }

    @NotNull
    public Stream<B> stream() {
        return this.minecraftRegistry.i().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }

    public Iterator<B> iterator() {
        return this.stream().iterator();
    }

    public B createBukkit(NamespacedKey namespacedKey, jd<M> minecraft) {
        if (minecraft == null) {
            return null;
        }
        return (B)((Keyed)this.minecraftToBukkit.apply(namespacedKey, minecraft));
    }
}

