/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import java.util.Set;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftBlockEntityState<T extends elb>
extends CraftBlockState
implements TileState {
    private final T tileEntity;
    private final T snapshot;

    public CraftBlockEntityState(World world, T tileEntity) {
        super(world, ((elb)tileEntity).aD_(), ((elb)tileEntity).o());
        this.tileEntity = tileEntity;
        this.snapshot = this.createSnapshot(tileEntity);
        this.load(this.snapshot);
    }

    protected CraftBlockEntityState(CraftBlockEntityState<T> state, Location location) {
        super(state, location);
        this.tileEntity = this.createSnapshot(state.snapshot);
        this.snapshot = this.tileEntity;
        this.loadData(state.getSnapshotNBT());
    }

    public void refreshSnapshot() {
        this.load(this.tileEntity);
    }

    protected jr getRegistryAccess() {
        dwp worldHandle = this.getWorldHandle();
        return worldHandle != null ? worldHandle.J_() : MinecraftServer.getDefaultRegistryAccess();
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        uz nbtTagCompound = ((elb)tileEntity).b(this.getRegistryAccess());
        elb snapshot = elb.a(this.getPosition(), this.getHandle(), nbtTagCompound, this.getRegistryAccess());
        return (T)snapshot;
    }

    public Set<kh<?>> applyComponents(kf datacomponentmap, kg datacomponentpatch) {
        Set<kh<?>> result = ((elb)this.snapshot).applyComponentsSet(datacomponentmap, datacomponentpatch);
        this.load(this.snapshot);
        return result;
    }

    public kf collectComponents() {
        return ((elb)this.snapshot).t();
    }

    private fnq createInput(uz nbtTagCompound) {
        return fno.a(bgp.a, (jf.a)this.getRegistryAccess(), nbtTagCompound);
    }

    private fnp createOutput() {
        return fnp.a(bgp.a, this.getRegistryAccess());
    }

    public void loadData(uz nbtTagCompound) {
        this.loadData(this.createInput(nbtTagCompound));
    }

    public void loadData(fnq input) {
        ((elb)this.snapshot).b(input);
        this.load(this.snapshot);
    }

    private void copyData(T from, T to2) {
        uz nbtTagCompound = ((elb)from).b(this.getRegistryAccess());
        ((elb)to2).b(this.createInput(nbtTagCompound));
    }

    protected T getTileEntity() {
        return this.tileEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected elb getTileEntityFromWorld() {
        this.requirePlaced();
        return this.getWorldHandle().c_(this.getPosition());
    }

    public uz getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return ((elb)this.snapshot).b(this.getRegistryAccess());
    }

    public fnq getSnapshotInput() {
        return this.createInput(this.getSnapshotNBT());
    }

    public fnp getItemNBT() {
        this.applyTo(this.snapshot);
        fnp output = this.createOutput();
        ((elb)this.snapshot).f(output);
        ((elb)this.snapshot).b(output);
        return output;
    }

    public eld<?> getEntityType() {
        return ((elb)this.snapshot).s();
    }

    public uz getUpdateNBT() {
        this.applyTo(this.snapshot);
        return ((elb)this.snapshot).a(this.getRegistryAccess());
    }

    protected void load(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(tileEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    protected boolean isApplicable(elb tileEntity) {
        return tileEntity != null && this.tileEntity.getClass() == tileEntity.getClass();
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        elb tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo(tile);
            tile.e();
        }
        return result;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return ((elb)this.getSnapshot()).persistentDataContainer;
    }

    @Nullable
    public aay<adb> getUpdatePacket(@NotNull Location location) {
        return new adh(CraftLocation.toBlockPosition(location), ((elb)this.snapshot).s(), this.getUpdateNBT());
    }

    @Override
    public CraftBlockEntityState<T> copy() {
        return new CraftBlockEntityState<T>(this, null);
    }

    @Override
    public CraftBlockEntityState<T> copy(Location location) {
        return new CraftBlockEntityState<T>(this, location);
    }
}

