/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R7.registry.CraftRegistryItem;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

public class CraftBlockType<B extends BlockData>
extends CraftRegistryItem<dzq>
implements BlockType.Typed<B> {
    private final Class<B> blockDataClass = CraftBlockData.fromData(((dzq)this.getHandle()).m()).getClass().getInterfaces()[0];
    private final boolean interactable = CraftBlockType.isInteractable((dzq)this.getHandle());
    private static final Class<?>[] USE_WITHOUT_ITEM_ARGS = new Class[]{eoh.class, dwo.class, is.class, ddm.class, fti.class};
    private static final Class<?>[] USE_ITEM_ON_ARGS = new Class[]{dlt.class, eoh.class, dwo.class, is.class, ddm.class, cdb.class, fti.class};

    public static Material minecraftToBukkit(dzq block) {
        return CraftMagicNumbers.getMaterial(block);
    }

    public static dzq bukkitToMinecraft(Material material) {
        return CraftMagicNumbers.getBlock(material);
    }

    public static BlockType minecraftToBukkitNew(dzq minecraft) {
        return (BlockType)CraftRegistry.minecraftToBukkit(minecraft, mj.i, Registry.BLOCK);
    }

    public static dzq bukkitToMinecraftNew(BlockType bukkit) {
        return (dzq)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    private static boolean hasMethod(Class<?> clazz, Class<?> ... params) {
        boolean hasMethod = false;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Arrays.equals(method.getParameterTypes(), params)) continue;
            Preconditions.checkArgument((!hasMethod ? 1 : 0) != 0, (String)"More than one matching method for %s, args %s", clazz, (Object)Arrays.toString(params));
            hasMethod = true;
        }
        return hasMethod;
    }

    private static boolean isInteractable(dzq block) {
        boolean hasMethod;
        Class<?> clazz = block.getClass();
        boolean bl2 = hasMethod = CraftBlockType.hasMethod(clazz, USE_WITHOUT_ITEM_ARGS) || CraftBlockType.hasMethod(clazz, USE_ITEM_ON_ARGS);
        if (!hasMethod && clazz.getSuperclass() != eog.class) {
            hasMethod = CraftBlockType.hasMethod(clazz = clazz.getSuperclass(), USE_WITHOUT_ITEM_ARGS) || CraftBlockType.hasMethod(clazz, USE_ITEM_ON_ARGS);
        }
        return hasMethod;
    }

    public CraftBlockType(NamespacedKey key, jd<dzq> handle) {
        super(key, handle);
    }

    @NotNull
    public BlockType.Typed<BlockData> typed() {
        return this.typed(BlockData.class);
    }

    @NotNull
    public <Other extends BlockData> BlockType.Typed<Other> typed(@NotNull Class<Other> blockDataType) {
        if (blockDataType.isAssignableFrom(this.blockDataClass)) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type block type " + String.valueOf(this.isRegistered() ? this.getKeyOrThrow() : this.toString()) + " to blockdata type " + blockDataType.getSimpleName());
    }

    public boolean hasItemType() {
        if (this == AIR) {
            return true;
        }
        return ((dzq)this.getHandle()).h() != dlx.a;
    }

    @NotNull
    public ItemType getItemType() {
        if (this == AIR) {
            return ItemType.AIR;
        }
        dlp item = ((dzq)this.getHandle()).h();
        Preconditions.checkArgument((item != dlx.a ? 1 : 0) != 0, (String)"The block type %s has no corresponding item type", (Object)(this.isRegistered() ? this.getKeyOrThrow() : this.toString()));
        return CraftItemType.minecraftToBukkitNew(item);
    }

    public Class<B> getBlockDataClass() {
        return this.blockDataClass;
    }

    public B createBlockData() {
        return this.createBlockData((String)null);
    }

    public B createBlockData(Consumer<? super B> consumer) {
        B data = this.createBlockData();
        if (consumer != null) {
            consumer.accept(data);
        }
        return data;
    }

    public B createBlockData(String data) {
        return (B)CraftBlockData.newData((BlockType)this, data);
    }

    public boolean isSolid() {
        return ((dzq)this.getHandle()).m().d();
    }

    public boolean isAir() {
        return ((dzq)this.getHandle()).m().l();
    }

    public boolean isEnabledByFeature(@NotNull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        return ((dzq)this.getHandle()).a(((CraftWorld)world).getHandle().Q());
    }

    public boolean isFlammable() {
        return ((dzq)this.getHandle()).m().m();
    }

    public boolean isBurnable() {
        return ((ecv)dzs.cN).aa.getOrDefault(this.getHandle(), 0) > 0;
    }

    public boolean isOccluding() {
        return ((dzq)this.getHandle()).m().d(dwf.a, is.c);
    }

    public boolean hasGravity() {
        return this.getHandle() instanceof ecq;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public float getHardness() {
        return ((dzq)this.getHandle()).m().p;
    }

    public float getBlastResistance() {
        return ((dzq)this.getHandle()).e();
    }

    public float getSlipperiness() {
        return ((dzq)this.getHandle()).g();
    }

    @NotNull
    public String getTranslationKey() {
        return ((dzq)this.getHandle()).z();
    }

    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public Material asMaterial() {
        return (Material)Registry.MATERIAL.get(this.getKeyOrThrow());
    }
}

