/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.DecoratedPot;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryDecoratedPot;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.inventory.DecoratedPotInventory;

public class CraftDecoratedPot
extends CraftBlockEntityState<elu>
implements DecoratedPot {
    public CraftDecoratedPot(World world, elu tileEntity) {
        super(world, tileEntity);
    }

    protected CraftDecoratedPot(CraftDecoratedPot state, Location location) {
        super(state, location);
    }

    public DecoratedPotInventory getSnapshotInventory() {
        return new CraftInventoryDecoratedPot((ccv)this.getSnapshot());
    }

    public DecoratedPotInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryDecoratedPot((ccv)this.getTileEntity());
    }

    public void setSherd(DecoratedPot.Side face, Material sherd) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((sherd == null || sherd == Material.BRICK || Tag.ITEMS_DECORATED_POT_SHERDS.isTagged((Keyed)sherd) ? 1 : 0) != 0, (String)"sherd is not a valid sherd material: %s", (Object)sherd);
        Optional<dlp> sherdItem = sherd != null ? Optional.of(CraftItemType.bukkitToMinecraft(sherd)) : Optional.of(dlx.sx);
        eml decorations = ((elu)this.getSnapshot()).m();
        switch (face) {
            case BACK: {
                ((elu)this.getSnapshot()).k = new eml(sherdItem, decorations.c(), decorations.d(), decorations.e());
                break;
            }
            case LEFT: {
                ((elu)this.getSnapshot()).k = new eml(decorations.b(), sherdItem, decorations.d(), decorations.e());
                break;
            }
            case RIGHT: {
                ((elu)this.getSnapshot()).k = new eml(decorations.b(), decorations.c(), sherdItem, decorations.e());
                break;
            }
            case FRONT: {
                ((elu)this.getSnapshot()).k = new eml(decorations.b(), decorations.c(), decorations.d(), sherdItem);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(face));
            }
        }
    }

    public Material getSherd(DecoratedPot.Side face) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        eml decorations = ((elu)this.getSnapshot()).m();
        Optional<dlp> sherdItem = switch (face) {
            case DecoratedPot.Side.BACK -> decorations.b();
            case DecoratedPot.Side.LEFT -> decorations.c();
            case DecoratedPot.Side.RIGHT -> decorations.d();
            case DecoratedPot.Side.FRONT -> decorations.e();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(face));
        };
        return CraftItemType.minecraftToBukkit(sherdItem.orElse(dlx.sx));
    }

    public Map<DecoratedPot.Side, Material> getSherds() {
        eml decorations = ((elu)this.getSnapshot()).m();
        EnumMap<DecoratedPot.Side, Material> sherds = new EnumMap<DecoratedPot.Side, Material>(DecoratedPot.Side.class);
        sherds.put(DecoratedPot.Side.BACK, CraftItemType.minecraftToBukkit(decorations.b().orElse(dlx.sx)));
        sherds.put(DecoratedPot.Side.LEFT, CraftItemType.minecraftToBukkit(decorations.c().orElse(dlx.sx)));
        sherds.put(DecoratedPot.Side.RIGHT, CraftItemType.minecraftToBukkit(decorations.d().orElse(dlx.sx)));
        sherds.put(DecoratedPot.Side.FRONT, CraftItemType.minecraftToBukkit(decorations.e().orElse(dlx.sx)));
        return sherds;
    }

    public List<Material> getShards() {
        return ((elu)this.getSnapshot()).m().a().stream().map(CraftItemType::minecraftToBukkit).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public CraftDecoratedPot copy() {
        return new CraftDecoratedPot(this, null);
    }

    @Override
    public CraftDecoratedPot copy(Location location) {
        return new CraftDecoratedPot(this, location);
    }
}

