/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Structure;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.block.structure.UsageMode;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftBlockVector;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BlockVector;

public class CraftStructureBlock
extends CraftBlockEntityState<emx>
implements Structure {
    private static final int MAX_SIZE = 48;

    public CraftStructureBlock(World world, emx tileEntity) {
        super(world, tileEntity);
    }

    protected CraftStructureBlock(CraftStructureBlock state, Location location) {
        super(state, location);
    }

    public String getStructureName() {
        return ((emx)this.getSnapshot()).d();
    }

    public void setStructureName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Structure name cannot be null");
        ((emx)this.getSnapshot()).a(name);
    }

    public String getAuthor() {
        return ((emx)this.getSnapshot()).v;
    }

    public void setAuthor(String author) {
        Preconditions.checkArgument((author != null ? 1 : 0) != 0, (Object)"Author name cannot be null");
        Preconditions.checkArgument((!author.isEmpty() ? 1 : 0) != 0, (Object)"Author name cannot be empty");
        ((emx)this.getSnapshot()).v = author;
    }

    public void setAuthor(LivingEntity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Structure Block author entity cannot be null");
        ((emx)this.getSnapshot()).a(((CraftLivingEntity)entity).getHandle());
    }

    public BlockVector getRelativePosition() {
        return CraftBlockVector.toBukkit(((emx)this.getSnapshot()).x);
    }

    public void setRelativePosition(BlockVector vector) {
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), -48, 48), (String)"Structure Size (X) must be between -%s and %s but got %s", (Object)48, (Object)48, (Object)vector.getBlockX());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), -48, 48), (String)"Structure Size (Y) must be between -%s and %s but got %s", (Object)48, (Object)48, (Object)vector.getBlockY());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), -48, 48), (String)"Structure Size (Z) must be between -%s and %s but got %s", (Object)48, (Object)48, (Object)vector.getBlockZ());
        ((emx)this.getSnapshot()).x = CraftBlockVector.toBlockPosition(vector);
    }

    public BlockVector getStructureSize() {
        return CraftBlockVector.toBukkit(((emx)this.getSnapshot()).y);
    }

    public void setStructureSize(BlockVector vector) {
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), 0, 48), (String)"Structure Size (X) must be between %s and %s but got %s", (Object)0, (Object)48, (Object)vector.getBlockX());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), 0, 48), (String)"Structure Size (Y) must be between %s and %s but got %s", (Object)0, (Object)48, (Object)vector.getBlockY());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), 0, 48), (String)"Structure Size (Z) must be between %s and %s but got %s", (Object)0, (Object)48, (Object)vector.getBlockZ());
        ((emx)this.getSnapshot()).y = CraftBlockVector.toBlockPosition(vector);
    }

    public void setMirror(Mirror mirror) {
        Preconditions.checkArgument((mirror != null ? 1 : 0) != 0, (Object)"Mirror cannot be null");
        ((emx)this.getSnapshot()).z = eev.valueOf(mirror.name());
    }

    public Mirror getMirror() {
        return Mirror.valueOf((String)((emx)this.getSnapshot()).z.name());
    }

    public void setRotation(StructureRotation rotation) {
        Preconditions.checkArgument((rotation != null ? 1 : 0) != 0, (Object)"StructureRotation cannot be null");
        ((emx)this.getSnapshot()).A = egm.valueOf(rotation.name());
    }

    public StructureRotation getRotation() {
        return StructureRotation.valueOf((String)((emx)this.getSnapshot()).A.name());
    }

    public void setUsageMode(UsageMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"UsageMode cannot be null");
        ((emx)this.getSnapshot()).B = eps.valueOf(mode.name());
    }

    public UsageMode getUsageMode() {
        return UsageMode.valueOf((String)((emx)this.getSnapshot()).x().name());
    }

    public void setIgnoreEntities(boolean flag) {
        ((emx)this.getSnapshot()).C = flag;
    }

    public boolean isIgnoreEntities() {
        return ((emx)this.getSnapshot()).C;
    }

    public void setShowAir(boolean showAir) {
        ((emx)this.getSnapshot()).F = showAir;
    }

    public boolean isShowAir() {
        return ((emx)this.getSnapshot()).F;
    }

    public void setBoundingBoxVisible(boolean showBoundingBox) {
        ((emx)this.getSnapshot()).G = showBoundingBox;
    }

    public boolean isBoundingBoxVisible() {
        return ((emx)this.getSnapshot()).G;
    }

    public void setIntegrity(float integrity) {
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(integrity, 0.0f, 1.0f), (String)"Integrity must be between 0.0f and 1.0f but got %s", (Object)Float.valueOf(integrity));
        ((emx)this.getSnapshot()).H = integrity;
    }

    public float getIntegrity() {
        return ((emx)this.getSnapshot()).H;
    }

    public void setSeed(long seed) {
        ((emx)this.getSnapshot()).I = seed;
    }

    public long getSeed() {
        return ((emx)this.getSnapshot()).I;
    }

    public void setMetadata(String metadata) {
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"Structure metadata cannot be null");
        if (this.getUsageMode() == UsageMode.DATA) {
            ((emx)this.getSnapshot()).w = metadata;
        }
    }

    public String getMetadata() {
        return ((emx)this.getSnapshot()).w;
    }

    @Override
    protected void applyTo(emx tileEntity) {
        eoh data;
        super.applyTo(tileEntity);
        dwp access = this.getWorldHandle();
        if (access instanceof dwo) {
            tileEntity.a(tileEntity.x());
        } else if (access != null && (data = access.a_(this.getPosition())).a(dzs.pY)) {
            access.a(this.getPosition(), (eoh)data.b(eid.b, tileEntity.x()), 2);
        }
    }

    @Override
    public CraftStructureBlock copy() {
        return new CraftStructureBlock(this, null);
    }

    @Override
    public CraftStructureBlock copy(Location location) {
        return new CraftStructureBlock(this, location);
    }

    private static boolean isBetween(int num, int min, int max) {
        return num >= min && num <= max;
    }

    private static boolean isBetween(float num, float min, float max) {
        return num >= min && num <= max;
    }
}

