/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TrialSpawner;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftTrialSpawnerConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.spawner.TrialSpawnerConfiguration;

public class CraftTrialSpawner
extends CraftBlockEntityState<ene>
implements TrialSpawner {
    private CraftTrialSpawnerConfiguration normalConfig;
    private CraftTrialSpawnerConfiguration ominousConfig;

    public CraftTrialSpawner(World world, ene tileEntity) {
        super(world, tileEntity);
    }

    protected CraftTrialSpawner(CraftTrialSpawner state, Location location) {
        super(state, location);
    }

    public int getCooldownLength() {
        return ((ene)this.getSnapshot()).a.e();
    }

    public void setCooldownLength(int ticks) {
        enh.b oldConfig = ((ene)this.getSnapshot()).a.i;
        ((ene)this.getSnapshot()).a.i = new enh.b(oldConfig.a(), oldConfig.b(), ticks, oldConfig.d());
    }

    public int getRequiredPlayerRange() {
        return ((ene)this.getSnapshot()).a.f();
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        enh.b oldConfig = ((ene)this.getSnapshot()).a.i;
        ((ene)this.getSnapshot()).a.i = new enh.b(oldConfig.a(), oldConfig.b(), oldConfig.c(), requiredPlayerRange);
    }

    public Collection<Player> getTrackedPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (UUID uuid : this.getTrialData().a) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            players.add((Object)player);
        }
        return players.build();
    }

    public boolean isTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        return this.getTrialData().a.contains(player.getUniqueId());
    }

    public void startTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.getTrialData().a.add(player.getUniqueId());
    }

    public void stopTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.getTrialData().a.remove(player.getUniqueId());
    }

    public Collection<Entity> getTrackedEntities() {
        ImmutableSet.Builder entities = ImmutableSet.builder();
        for (UUID uuid : this.getTrialData().b) {
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (entity == null) continue;
            entities.add((Object)entity);
        }
        return entities.build();
    }

    public boolean isTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.getTrialData().b.contains(entity.getUniqueId());
    }

    public void startTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getTrialData().b.add(entity.getUniqueId());
    }

    public void stopTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getTrialData().b.remove(entity.getUniqueId());
    }

    public boolean isOminous() {
        return this.getHandle().c(eiy.c);
    }

    public void setOminous(boolean ominous) {
        ((ene)this.getSnapshot()).a.n = ominous;
        if (ominous) {
            this.setData((eoh)this.getHandle().b(eiy.c, true));
            return;
        }
        this.setData((eoh)this.getHandle().b(eiy.c, false));
    }

    public TrialSpawnerConfiguration getNormalConfiguration() {
        return this.normalConfig;
    }

    public TrialSpawnerConfiguration getOminousConfiguration() {
        return this.ominousConfig;
    }

    @Override
    protected void load(ene tileEntity) {
        super.load(tileEntity);
        if (this.normalConfig == null) {
            this.normalConfig = new CraftTrialSpawnerConfiguration((ene)this.getSnapshot(), this.getRegistryAccess());
        }
        if (this.ominousConfig == null) {
            this.ominousConfig = new CraftTrialSpawnerConfiguration((ene)this.getSnapshot(), this.getRegistryAccess());
        }
        if (tileEntity != null) {
            this.normalConfig.loadFromConfig(tileEntity.c().b());
            this.ominousConfig.loadFromConfig(tileEntity.c().c());
        }
    }

    @Override
    protected void applyTo(ene tileEntity) {
        super.applyTo(tileEntity);
        tileEntity.a.i = new enh.b(jd.a(this.normalConfig.toMinecraft()), jd.a(this.ominousConfig.toMinecraft()), this.getCooldownLength(), this.getRequiredPlayerRange());
    }

    private enl getTrialData() {
        return ((ene)this.getSnapshot()).c().h();
    }

    @Override
    public CraftTrialSpawner copy() {
        return new CraftTrialSpawner(this, null);
    }

    @Override
    public CraftTrialSpawner copy(Location location) {
        return new CraftTrialSpawner(this, location);
    }
}

