/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R7.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.loot.LootTable;
import org.bukkit.spawner.TrialSpawnerConfiguration;

public class CraftTrialSpawnerConfiguration
implements TrialSpawnerConfiguration {
    private final ene snapshot;
    private final jr registry;
    private int spawnRange;
    private float totalMobs;
    private float simultaneousMobs;
    private float totalMobsAddedPerPlayer;
    private float simultaneousMobsAddedPerPlayer;
    private int ticksBetweenSpawn;
    private cbn<dxi> spawnPotentialsDefinition;
    private cbn<amt<fof>> lootTablesToEject;
    private amt<fof> itemsToDropWhenOminous;

    public CraftTrialSpawnerConfiguration(ene snapshot, jr registry) {
        this.snapshot = snapshot;
        this.registry = registry;
    }

    void loadFromConfig(eni minecraft) {
        this.spawnRange = minecraft.c();
        this.totalMobs = minecraft.d();
        this.simultaneousMobs = minecraft.e();
        this.totalMobsAddedPerPlayer = minecraft.f();
        this.simultaneousMobsAddedPerPlayer = minecraft.g();
        this.ticksBetweenSpawn = minecraft.h();
        this.spawnPotentialsDefinition = minecraft.i();
        this.lootTablesToEject = minecraft.j();
        this.itemsToDropWhenOminous = minecraft.k();
    }

    public EntityType getSpawnedType() {
        if (this.spawnPotentialsDefinition.c()) {
            return null;
        }
        Optional<cgu<?>> type = this.spawnPotentialsDefinition.d().get(0).a().a().a("id", cgu.a);
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            this.getTrialData().f = Optional.empty();
            this.spawnPotentialsDefinition = cbn.a();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        dxi data = new dxi();
        data.a().a("id", mi.g.b(CraftEntityType.bukkitToMinecraft(entityType)).toString());
        this.getTrialData().f = Optional.of(data);
        this.spawnPotentialsDefinition = cbn.a(data);
    }

    public float getBaseSpawnsBeforeCooldown() {
        return this.totalMobs;
    }

    public void setBaseSpawnsBeforeCooldown(float amount) {
        this.totalMobs = amount;
    }

    public float getBaseSimultaneousEntities() {
        return this.simultaneousMobs;
    }

    public void setBaseSimultaneousEntities(float amount) {
        this.simultaneousMobs = amount;
    }

    public float getAdditionalSpawnsBeforeCooldown() {
        return this.totalMobsAddedPerPlayer;
    }

    public void setAdditionalSpawnsBeforeCooldown(float amount) {
        this.totalMobsAddedPerPlayer = amount;
    }

    public float getAdditionalSimultaneousEntities() {
        return this.simultaneousMobsAddedPerPlayer;
    }

    public void setAdditionalSimultaneousEntities(float amount) {
        this.simultaneousMobsAddedPerPlayer = amount;
    }

    public int getDelay() {
        return this.ticksBetweenSpawn;
    }

    public void setDelay(int delay) {
        Preconditions.checkArgument((delay >= 0 ? 1 : 0) != 0, (Object)"Delay cannot be less than 0");
        this.ticksBetweenSpawn = delay;
    }

    public int getSpawnRange() {
        return this.spawnRange;
    }

    public void setSpawnRange(int spawnRange) {
        this.spawnRange = spawnRange;
    }

    public EntitySnapshot getSpawnedEntity() {
        cbn<dxi> potentials = this.spawnPotentialsDefinition;
        if (potentials.c()) {
            return null;
        }
        return CraftEntitySnapshot.create(potentials.d().get(0).a().a());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        this.setSpawnedEntity(snapshot, null, null);
    }

    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.setSpawnedEntity(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    private void setSpawnedEntity(EntitySnapshot snapshot, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        if (snapshot == null) {
            this.getTrialData().f = Optional.empty();
            this.spawnPotentialsDefinition = cbn.a();
            return;
        }
        uz compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        dxi data = new dxi(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment));
        this.getTrialData().f = Optional.of(data);
        this.spawnPotentialsDefinition = cbn.a(data);
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        this.addPotentialSpawn(snapshot, weight, spawnRule, null);
    }

    private void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        uz compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        cbn.a<dxi> builder = cbn.b();
        this.spawnPotentialsDefinition.d().forEach(entry -> builder.a((dxi)entry.a(), entry.b()));
        builder.a(new dxi(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment)), weight);
        this.spawnPotentialsDefinition = builder.a();
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        cbn.a<dxi> builder = cbn.b();
        for (SpawnerEntry spawnerEntry : entries) {
            uz compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.a(new dxi(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        this.spawnPotentialsDefinition = builder.a();
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (cbm<dxi> entry : this.spawnPotentialsDefinition.d()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(entry.a().a());
            if (snapshot == null) continue;
            SpawnRule rule = entry.a().e().map(CraftCreatureSpawner::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry((EntitySnapshot)snapshot, entry.b(), rule));
        }
        return entries;
    }

    public Map<LootTable, Integer> getPossibleRewards() {
        HashMap<LootTable, Integer> tables = new HashMap<LootTable, Integer>();
        for (cbm<amt<fof>> entry : this.lootTablesToEject.d()) {
            LootTable table = CraftLootTable.minecraftToBukkit(entry.a());
            if (table == null) continue;
            tables.put(table, entry.b());
        }
        return tables;
    }

    public void addPossibleReward(LootTable table, int weight) {
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Table cannot be null");
        Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)"Weight must be at least 1");
        cbn.a<amt<fof>> builder = cbn.b();
        this.lootTablesToEject.d().forEach(entry -> builder.a((amt)entry.a(), entry.b()));
        builder.a(CraftLootTable.bukkitToMinecraft(table), weight);
        this.lootTablesToEject = builder.a();
    }

    public void removePossibleReward(LootTable table) {
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        amt<fof> minecraftKey = CraftLootTable.bukkitToMinecraft(table);
        cbn.a<amt<fof>> builder = cbn.b();
        for (cbm<amt<fof>> entry : this.lootTablesToEject.d()) {
            if (entry.a().equals(minecraftKey)) continue;
            builder.a(entry.a(), entry.b());
        }
        this.lootTablesToEject = builder.a();
    }

    public void setPossibleRewards(Map<LootTable, Integer> rewards) {
        if (rewards == null || rewards.isEmpty()) {
            this.lootTablesToEject = cbn.a();
            return;
        }
        cbn.a builder = cbn.b();
        rewards.forEach((table, weight) -> {
            Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Table cannot be null");
            Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)"Weight must be at least 1");
            builder.a(CraftLootTable.bukkitToMinecraft(table), (int)weight);
        });
        this.lootTablesToEject = builder.a();
    }

    public int getRequiredPlayerRange() {
        return this.snapshot.a.f();
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        enh.b oldConfig = this.snapshot.a.i;
        this.snapshot.a.i = new enh.b(oldConfig.a(), oldConfig.b(), oldConfig.c(), requiredPlayerRange);
    }

    private enl getTrialData() {
        return this.snapshot.c().h();
    }

    protected eni toMinecraft() {
        return new eni(this.spawnRange, this.totalMobs, this.simultaneousMobs, this.totalMobsAddedPerPlayer, this.simultaneousMobsAddedPerPlayer, this.ticksBetweenSpawn, this.spawnPotentialsDefinition, this.lootTablesToEject, this.itemsToDropWhenOminous);
    }
}

