/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Vault;
import org.bukkit.craftbukkit.v1_21_R7.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;

public class CraftVault
extends CraftBlockEntityState<enn>
implements Vault {
    private CraftVaultConfiguration config;

    public CraftVault(World world, enn tileEntity) {
        super(world, tileEntity);
    }

    protected CraftVault(CraftVault state, Location location) {
        super(state, location);
    }

    @Override
    public CraftVault copy() {
        return new CraftVault(this, null);
    }

    @Override
    public CraftVault copy(Location location) {
        return new CraftVault(this, location);
    }

    public double getActivationRange() {
        return this.config.activationRange;
    }

    public void setActivationRange(double range) {
        this.config.activationRange = range;
    }

    public double getDeactivationRange() {
        return this.config.deactivationRange;
    }

    public void setDeactivationRange(double range) {
        this.config.deactivationRange = range;
    }

    public LootTable getLootTable() {
        return CraftLootTable.minecraftToBukkit(this.config.lootTable);
    }

    public void setLootTable(LootTable lootTable) {
        Preconditions.checkArgument((lootTable != null ? 1 : 0) != 0, (Object)"LootTable cannot be null");
        this.config.lootTable = CraftLootTable.bukkitToMinecraft(lootTable);
    }

    public LootTable getDisplayLootTable() {
        return this.config.overrideLootTableToDisplay.map(CraftLootTable::minecraftToBukkit).orElse(null);
    }

    public void setDisplayLootTable(LootTable lootTable) {
        this.config.overrideLootTableToDisplay = Optional.ofNullable(CraftLootTable.bukkitToMinecraft(lootTable));
    }

    public ItemStack getKeyItem() {
        return CraftItemStack.asBukkitCopy(this.config.keyItem);
    }

    public void setKeyItem(ItemStack keyItem) {
        Preconditions.checkArgument((keyItem != null ? 1 : 0) != 0, (Object)"Key item cannot be null");
        this.config.keyItem = CraftItemStack.asNMSCopy(keyItem);
    }

    @Override
    protected void load(enn tileEntity) {
        super.load(tileEntity);
        if (this.config == null) {
            this.config = new CraftVaultConfiguration();
        }
        if (tileEntity != null) {
            this.config.loadFromConfig(tileEntity.f());
        }
    }

    @Override
    protected void applyTo(enn tileEntity) {
        super.applyTo(tileEntity);
        tileEntity.a(this.config.toMinecraft());
    }

    public Set<UUID> getRewardedPlayers() {
        this.requirePlaced();
        enq serverData = ((enn)this.getTileEntity()).a();
        Objects.requireNonNull(serverData, "serverData should not be null for placed Vault");
        return Collections.unmodifiableSet(serverData.b());
    }

    static class CraftVaultConfiguration {
        private amt<fof> lootTable;
        private double activationRange;
        private double deactivationRange;
        private dlt keyItem;
        private Optional<amt<fof>> overrideLootTableToDisplay;
        private eng playerDetector;
        private eng.a entitySelector;

        CraftVaultConfiguration() {
        }

        private void loadFromConfig(enp minecraft) {
            this.lootTable = minecraft.b();
            this.activationRange = minecraft.c();
            this.deactivationRange = minecraft.d();
            this.keyItem = minecraft.e();
            this.overrideLootTableToDisplay = minecraft.f();
            this.playerDetector = minecraft.a();
            this.entitySelector = minecraft.g();
        }

        private enp toMinecraft() {
            return new enp(this.lootTable, this.activationRange, this.deactivationRange, this.keyItem, this.overrideLootTableToDisplay, this.playerDetector, this.entitySelector);
        }
    }
}

