/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.command;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R7.command.CraftRemoteConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R7.command.ProxiedNativeCommandSender;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.entity.minecart.CommandMinecart;

public final class VanillaCommandWrapper
extends BukkitCommand {
    private final ee dispatcher;
    public final CommandNode<ed> vanillaCommand;

    public VanillaCommandWrapper(ee dispatcher, CommandNode<ed> vanillaCommand) {
        super(vanillaCommand.getName(), "A Mojang provided command.", vanillaCommand.getUsageText(), Collections.EMPTY_LIST);
        this.dispatcher = dispatcher;
        this.vanillaCommand = vanillaCommand;
        this.setPermission(VanillaCommandWrapper.getPermission(vanillaCommand));
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        ed icommandlistener = VanillaCommandWrapper.getListener(sender);
        this.dispatcher.performPrefixedCommand(icommandlistener, this.toDispatcher(args, this.getName()), this.toDispatcher(args, commandLabel));
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"Sender cannot be null");
        Preconditions.checkArgument((args != null ? 1 : 0) != 0, (Object)"Arguments cannot be null");
        Preconditions.checkArgument((alias != null ? 1 : 0) != 0, (Object)"Alias cannot be null");
        ed icommandlistener = VanillaCommandWrapper.getListener(sender);
        ParseResults<ed> parsed = this.dispatcher.a().parse(this.toDispatcher(args, this.getName()), icommandlistener);
        ArrayList<String> results = new ArrayList<String>();
        this.dispatcher.a().getCompletionSuggestions(parsed).thenAccept(suggestions -> suggestions.getList().forEach(s2 -> results.add(s2.getText())));
        return results;
    }

    public static ed getListener(CommandSender sender) {
        if (sender instanceof CraftEntity) {
            CraftEntity entity = (CraftEntity)sender;
            axf world = (axf)entity.getHandle().ao();
            if (sender instanceof CommandMinecart) {
                dvo commandBlock = ((CraftMinecartCommand)sender).getHandle().e();
                return commandBlock.a(world, commandBlock.c(world));
            }
            if (sender instanceof CraftPlayer) {
                CraftPlayer player = (CraftPlayer)sender;
                return player.getHandle().C();
            }
            return entity.getHandle().d(world);
        }
        if (sender instanceof BlockCommandSender) {
            return ((CraftBlockCommandSender)sender).getWrapper();
        }
        if (sender instanceof RemoteConsoleCommandSender) {
            return ((CraftRemoteConsoleCommandSender)sender).getListener().g();
        }
        if (sender instanceof ConsoleCommandSender) {
            return ((CraftServer)sender.getServer()).getServer().aG();
        }
        if (sender instanceof ProxiedCommandSender) {
            return ((ProxiedNativeCommandSender)sender).getHandle();
        }
        throw new IllegalArgumentException("Cannot make " + String.valueOf(sender) + " a vanilla command listener");
    }

    public static String getPermission(CommandNode<ed> vanillaCommand) {
        return "minecraft.command." + (vanillaCommand.getRedirect() == null ? vanillaCommand.getName() : vanillaCommand.getRedirect().getName());
    }

    private String toDispatcher(String[] args, String name) {
        return name + (String)(args.length > 0 ? " " + Joiner.on((char)' ').join((Object[])args) : "");
    }
}

