/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.stream.Collectors;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVehicle;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;

public abstract class CraftBoat
extends CraftVehicle
implements Boat {
    public CraftBoat(CraftServer server, dgb entity) {
        super(server, entity);
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().ay());
    }

    public void setWoodType(TreeSpecies species) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().ay());
    }

    public void setBoatType(Boat.Type type) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Boat.Status getStatus() {
        return CraftBoat.boatStatusFromNms(this.getHandle().aZ);
    }

    public boolean isLeashed() {
        return this.getHandle().C() != null;
    }

    public Entity getLeashHolder() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isLeashed(), (Object)"Entity not leashed");
        return this.getHandle().C().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        this.getHandle().r();
        return true;
    }

    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle().generation) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        this.getHandle().a_(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    @Override
    public dgb getHandle() {
        return (dgb)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat{boatType=" + String.valueOf(this.getBoatType()) + ",status=" + String.valueOf(this.getStatus()) + ",passengers=" + this.getPassengers().stream().map(Entity::toString).collect(Collectors.joining("-", "{", "}")) + "}";
    }

    public static Boat.Type boatTypeFromNms(cgu<?> boatType) {
        if (boatType == cgu.aN || boatType == cgu.aO) {
            return Boat.Type.OAK;
        }
        if (boatType == cgu.o || boatType == cgu.p) {
            return Boat.Type.BIRCH;
        }
        if (boatType == cgu.c || boatType == cgu.d) {
            return Boat.Type.ACACIA;
        }
        if (boatType == cgu.z || boatType == cgu.A) {
            return Boat.Type.CHERRY;
        }
        if (boatType == cgu.ay || boatType == cgu.az) {
            return Boat.Type.JUNGLE;
        }
        if (boatType == cgu.bx || boatType == cgu.by) {
            return Boat.Type.SPRUCE;
        }
        if (boatType == cgu.J || boatType == cgu.K) {
            return Boat.Type.DARK_OAK;
        }
        if (boatType == cgu.aF || boatType == cgu.aG) {
            return Boat.Type.MANGROVE;
        }
        if (boatType == cgu.l || boatType == cgu.k) {
            return Boat.Type.BAMBOO;
        }
        throw new EnumConstantNotPresentException(Boat.Type.class, boatType.toString());
    }

    public static Boat.Status boatStatusFromNms(dgb.a enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case dgb.a.e -> Boat.Status.IN_AIR;
            case dgb.a.d -> Boat.Status.ON_LAND;
            case dgb.a.b -> Boat.Status.UNDER_WATER;
            case dgb.a.c -> Boat.Status.UNDER_FLOWING_WATER;
            case dgb.a.a -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(cgu<?> boatType) {
        if (boatType == cgu.bx || boatType == cgu.by) {
            return TreeSpecies.REDWOOD;
        }
        if (boatType == cgu.o || boatType == cgu.p) {
            return TreeSpecies.BIRCH;
        }
        if (boatType == cgu.ay || boatType == cgu.az) {
            return TreeSpecies.JUNGLE;
        }
        if (boatType == cgu.c || boatType == cgu.d) {
            return TreeSpecies.ACACIA;
        }
        if (boatType == cgu.J || boatType == cgu.K) {
            return TreeSpecies.DARK_OAK;
        }
        return TreeSpecies.GENERIC;
    }
}

