/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftSound;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftComplexPart;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityTypes;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R7.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.spigotmc.AsyncCatcher;

public abstract class CraftEntity
implements Entity {
    private static PermissibleBase perm;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    protected final CraftServer server;
    protected cgk entity;
    private final EntityType entityType;
    private EntityDamageEvent lastDamageEvent;
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private final Entity.Spigot spigot = new Entity.Spigot(this){

        public void sendMessage(BaseComponent component) {
        }

        public void sendMessage(BaseComponent ... components) {
        }

        public void sendMessage(UUID sender, BaseComponent ... components) {
        }

        public void sendMessage(UUID sender, BaseComponent component) {
        }
    };

    public CraftEntity(CraftServer server, cgk entity) {
        this.server = server;
        this.entity = entity;
        this.entityType = CraftEntityType.minecraftToBukkit(entity.ay());
    }

    public static <T extends cgk> CraftEntity getEntity(CraftServer server, T entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Unknown entity");
        if (entity instanceof ddm && !(entity instanceof axg)) {
            return new CraftHumanEntity(server, (ddm)entity);
        }
        if (entity instanceof cyd) {
            cyd complexPart = (cyd)entity;
            if (complexPart.a instanceof cyc) {
                return new CraftEnderDragonPart(server, complexPart);
            }
            return new CraftComplexPart(server, complexPart);
        }
        CraftEntityTypes.EntityTypeData entityTypeData = CraftEntityTypes.getEntityTypeData(CraftEntityType.minecraftToBukkit(entity.ay()));
        if (entityTypeData != null) {
            return (CraftEntity)entityTypeData.convertFunction().apply(server, entity);
        }
        throw new AssertionError((Object)("Unknown entity " + String.valueOf(entity == null ? null : entity.getClass())));
    }

    public Location getLocation() {
        return CraftLocation.toBukkit(this.entity.dI(), this.getWorld(), this.entity.getBukkitYaw(), this.entity.ee());
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.dP());
            loc.setY(this.entity.dR());
            loc.setZ(this.entity.dV());
            loc.setYaw(this.entity.getBukkitYaw());
            loc.setPitch(this.entity.ee());
        }
        return loc;
    }

    public Vector getVelocity() {
        return CraftVector.toBukkit(this.entity.dN());
    }

    public void setVelocity(Vector velocity) {
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"velocity");
        velocity.checkFinite();
        this.entity.k(CraftVector.toNMS(velocity));
        this.entity.ah = true;
    }

    public double getHeight() {
        return this.getHandle().dG();
    }

    public double getWidth() {
        return this.getHandle().dF();
    }

    public BoundingBox getBoundingBox() {
        fth bb2 = this.getHandle().dj();
        return new BoundingBox(bb2.a, bb2.b, bb2.c, bb2.d, bb2.e, bb2.f);
    }

    public boolean isOnGround() {
        if (this.entity instanceof deh) {
            return ((deh)this.entity).f();
        }
        return this.entity.aV();
    }

    public boolean isInWater() {
        return this.entity.by();
    }

    public World getWorld() {
        return this.entity.ao().getWorld();
    }

    public void setRotation(float yaw, float pitch) {
        NumberConversions.checkFinite((float)pitch, (String)"pitch not finite");
        NumberConversions.checkFinite((float)yaw, (String)"yaw not finite");
        yaw = Location.normalizeYaw((float)yaw);
        pitch = Location.normalizePitch((float)pitch);
        this.entity.v(yaw);
        this.entity.w(pitch);
        this.entity.ab = yaw;
        this.entity.ac = pitch;
        this.entity.r(yaw);
    }

    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        location.checkFinite();
        if (this.entity.cr() || this.entity.eh()) {
            return false;
        }
        this.entity.cf();
        if (location.getWorld() != null && !location.getWorld().equals((Object)this.getWorld())) {
            Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot teleport entity to an other world during world generation");
            this.entity.b(new fmb(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), ftm.c, location.getPitch(), location.getYaw(), Set.of(), fmb.a, PlayerTeleportEvent.TeleportCause.PLUGIN));
            return true;
        }
        this.entity.a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.entity.r(location.getYaw());
        return true;
    }

    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    public List<Entity> getNearbyEntities(double x2, double y2, double z2) {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get nearby entities during world generation");
        AsyncCatcher.catchOp("getNearbyEntities");
        List<cgk> notchEntityList = this.entity.ao().a(this.entity, this.entity.dj().c(x2, y2, z2), (Predicate<? super cgk>)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(notchEntityList.size());
        for (cgk e2 : notchEntityList) {
            bukkitEntityList.add(e2.getBukkitEntity());
        }
        return bukkitEntityList;
    }

    public int getEntityId() {
        return this.entity.aA();
    }

    public int getFireTicks() {
        return this.entity.aS();
    }

    public int getMaxFireTicks() {
        return this.entity.dC();
    }

    public void setFireTicks(int ticks) {
        this.entity.h(ticks);
    }

    public void setVisualFire(boolean fire) {
        this.getHandle().bE = fire;
    }

    public boolean isVisualFire() {
        return this.getHandle().bE;
    }

    public int getFreezeTicks() {
        return this.getHandle().cM();
    }

    public int getMaxFreezeTicks() {
        return this.getHandle().cP();
    }

    public void setFreezeTicks(int ticks) {
        Preconditions.checkArgument((0 <= ticks ? 1 : 0) != 0, (String)"Ticks (%s) cannot be less than 0", (int)ticks);
        this.getHandle().k(ticks);
    }

    public boolean isFrozen() {
        return this.getHandle().cO();
    }

    public void remove() {
        this.entity.pluginRemoved = true;
        this.entity.discard(this.getHandle().generation ? null : EntityRemoveEvent.Cause.PLUGIN);
    }

    public boolean isDead() {
        return !this.entity.cb();
    }

    public boolean isValid() {
        return this.entity.cb() && this.entity.valid && this.entity.isChunkLoaded() && this.isInWorld();
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isPersistent() {
        return this.entity.persist;
    }

    public void setPersistent(boolean persistent) {
        this.entity.persist = persistent;
    }

    public Vector getMomentum() {
        return this.getVelocity();
    }

    public void setMomentum(Vector value) {
        this.setVelocity(value);
    }

    public Entity getPassenger() {
        return this.isEmpty() ? null : ((cgk)this.getHandle().aS.get(0)).getBukkitEntity();
    }

    public boolean setPassenger(Entity passenger) {
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        if (passenger instanceof CraftEntity) {
            this.eject();
            return ((CraftEntity)passenger).getHandle().o(this.getHandle());
        }
        return false;
    }

    public List<Entity> getPassengers() {
        return Lists.newArrayList((Iterable)Lists.transform(this.getHandle().aS, input -> input.getBukkitEntity()));
    }

    public boolean addPassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        return ((CraftEntity)passenger).getHandle().a(this.getHandle(), true, true);
    }

    public boolean removePassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        ((CraftEntity)passenger).getHandle().cf();
        return true;
    }

    public boolean isEmpty() {
        return !this.getHandle().cr();
    }

    public boolean eject() {
        if (this.isEmpty()) {
            return false;
        }
        this.getHandle().ce();
        return true;
    }

    public float getFallDistance() {
        return (float)this.getHandle().an;
    }

    public void setFallDistance(float distance) {
        this.getHandle().an = distance;
    }

    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    public UUID getUniqueId() {
        return this.getHandle().cY();
    }

    public int getTicksLived() {
        return this.getHandle().at;
    }

    public void setTicksLived(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Age value (%s) must be greater than 0", (int)value);
        this.getHandle().at = value;
    }

    public cgk getHandle() {
        return this.entity;
    }

    public final EntityType getType() {
        return this.entityType;
    }

    public void playEffect(EntityEffect type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot play effect during world generation");
        if (type.getApplicable().isInstance(this)) {
            this.getHandle().ao().a(this.getHandle(), type.getData());
        }
    }

    public Sound getSwimSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSound0());
    }

    public Sound getSwimSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSplashSound0());
    }

    public Sound getSwimHighSpeedSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimHighSpeedSplashSound0());
    }

    public void setHandle(cgk entity) {
        this.entity = entity;
    }

    public String toString() {
        return "CraftEntity{id=" + this.getEntityId() + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.getEntityId() == other.getEntityId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.getEntityId();
        return hash;
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public boolean isInsideVehicle() {
        return this.getHandle().cq();
    }

    public boolean leaveVehicle() {
        if (!this.isInsideVehicle()) {
            return false;
        }
        this.getHandle().cf();
        return true;
    }

    public Entity getVehicle() {
        if (!this.isInsideVehicle()) {
            return null;
        }
        return this.getHandle().dz().getBukkitEntity();
    }

    public void setCustomName(String name) {
        if (name != null && name.length() > 256) {
            name = name.substring(0, 256);
        }
        this.getHandle().b(CraftChatMessage.fromStringOrNull(name));
    }

    public String getCustomName() {
        yh name = this.getHandle().as();
        if (name == null) {
            return null;
        }
        return CraftChatMessage.fromComponent(name);
    }

    public void setCustomNameVisible(boolean flag) {
        this.getHandle().p(flag);
    }

    public boolean isCustomNameVisible() {
        return this.getHandle().dd();
    }

    public void setVisibleByDefault(boolean visible) {
        if (this.getHandle().visibleByDefault != visible) {
            if (visible) {
                for (Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndShowEntity(this);
                }
            } else {
                for (Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndHideEntity(this);
                }
            }
            this.getHandle().visibleByDefault = visible;
        }
    }

    public boolean isVisibleByDefault() {
        return this.getHandle().visibleByDefault;
    }

    public Set<Player> getTrackedBy() {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get tracking players during world generation");
        ImmutableSet.Builder players = ImmutableSet.builder();
        axf world = ((CraftWorld)this.getWorld()).getHandle();
        awj.b entityTracker = (awj.b)world.p().a.G.get(this.getEntityId());
        if (entityTracker != null) {
            for (ayl connection : entityTracker.f) {
                players.add((Object)connection.p().getBukkitEntity());
            }
        }
        return players.build();
    }

    public void sendMessage(String message) {
    }

    public void sendMessage(String ... messages) {
    }

    public void sendMessage(UUID sender, String message) {
        this.sendMessage(message);
    }

    public void sendMessage(UUID sender, String ... messages) {
        this.sendMessage(messages);
    }

    public String getName() {
        return CraftChatMessage.fromComponent(this.getHandle().ap());
    }

    public boolean isPermissionSet(String name) {
        return CraftEntity.getPermissibleBase().isPermissionSet(name);
    }

    public boolean isPermissionSet(Permission perm) {
        return CraftEntity.getPermissibleBase().isPermissionSet(perm);
    }

    public boolean hasPermission(String name) {
        return CraftEntity.getPermissibleBase().hasPermission(name);
    }

    public boolean hasPermission(Permission perm) {
        return CraftEntity.getPermissibleBase().hasPermission(perm);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value, ticks);
    }

    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, ticks);
    }

    public void removeAttachment(PermissionAttachment attachment) {
        CraftEntity.getPermissibleBase().removeAttachment(attachment);
    }

    public void recalculatePermissions() {
        CraftEntity.getPermissibleBase().recalculatePermissions();
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return CraftEntity.getPermissibleBase().getEffectivePermissions();
    }

    public boolean isOp() {
        return CraftEntity.getPermissibleBase().isOp();
    }

    public void setOp(boolean value) {
        CraftEntity.getPermissibleBase().setOp(value);
    }

    public void setGlowing(boolean flag) {
        this.getHandle().k(flag);
    }

    public boolean isGlowing() {
        return this.getHandle().cF();
    }

    public void setInvulnerable(boolean flag) {
        this.getHandle().n(flag);
    }

    public boolean isInvulnerable() {
        return this.getHandle().d(this.getHandle().en().p());
    }

    public boolean isSilent() {
        return this.getHandle().bq();
    }

    public void setSilent(boolean flag) {
        this.getHandle().f(flag);
    }

    public boolean hasGravity() {
        return !this.getHandle().br();
    }

    public void setGravity(boolean gravity) {
        this.getHandle().g(!gravity);
    }

    public int getPortalCooldown() {
        return this.getHandle().bt;
    }

    public void setPortalCooldown(int cooldown) {
        this.getHandle().bt = cooldown;
    }

    public Set<String> getScoreboardTags() {
        return this.getHandle().aB();
    }

    public boolean addScoreboardTag(String tag) {
        return this.getHandle().a(tag);
    }

    public boolean removeScoreboardTag(String tag) {
        return this.getHandle().b(tag);
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.getHandle().n_().ordinal());
    }

    public BlockFace getFacing() {
        return CraftBlock.notchToBlockFace(this.getHandle().dh());
    }

    public CraftPersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public Pose getPose() {
        return Pose.values()[this.getHandle().aF().ordinal()];
    }

    public SpawnCategory getSpawnCategory() {
        return CraftSpawnCategory.toBukkit(this.getHandle().ay().f());
    }

    public boolean isInWorld() {
        return this.getHandle().inWorld;
    }

    public String getAsString() {
        fnp tag = fnp.a(bgp.a, this.getHandle().eo());
        if (!this.getHandle().saveAsPassenger(tag, false)) {
            return null;
        }
        return tag.b().toString();
    }

    public EntitySnapshot createSnapshot() {
        return CraftEntitySnapshot.create(this);
    }

    public Entity copy() {
        cgk copy = this.copy(this.getHandle().ao());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        return copy.getBukkitEntity();
    }

    public Entity copy(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        cgk copy = this.copy(((CraftWorld)location.getWorld()).getHandle());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        copy.a_(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)copy.getBukkitEntity());
    }

    private cgk copy(dwo level) {
        fnp compoundTag = fnp.a(bgp.a, this.getHandle().eo());
        this.getHandle().saveAsPassenger(compoundTag, false);
        return cgu.a(compoundTag.b(), level, cgt.r, cgq.a);
    }

    public void storeBukkitValues(fns output) {
        if (!this.persistentDataContainer.isEmpty()) {
            this.persistentDataContainer.store(output.a("BukkitValues"));
        }
    }

    public void readBukkitValues(fnq input) {
        input.a("BukkitValues").ifPresent(base -> this.persistentDataContainer.putAll((fnq)base));
    }

    protected uz save() {
        fnp nbttagcompound = fnp.a(bgp.a, this.getHandle().eo());
        nbttagcompound.a("id", this.getHandle().ca());
        this.getHandle().d(nbttagcompound);
        return nbttagcompound.b();
    }

    protected void update() {
        if (!this.getHandle().cb()) {
            return;
        }
        axf world = ((CraftWorld)this.getWorld()).getHandle();
        awj.b entityTracker = (awj.b)world.p().a.G.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        entityTracker.a(this.getHandle().a(entityTracker.b));
    }

    public void update(axg player) {
        if (!this.getHandle().cb()) {
            return;
        }
        axf world = ((CraftWorld)this.getWorld()).getHandle();
        awj.b entityTracker = (awj.b)world.p().a.G.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        player.g.b(this.getHandle().a(entityTracker.b));
    }

    private static PermissibleBase getPermissibleBase() {
        if (perm == null) {
            perm = new PermissibleBase(new ServerOperator(){

                public boolean isOp() {
                    return false;
                }

                public void setOp(boolean value) {
                }
            });
        }
        return perm;
    }

    public Entity.Spigot spigot() {
        return this.spigot;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    }
}

