/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.registry.CraftOldEnumRegistryItem;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Frog;

public class CraftFrog
extends CraftAnimals
implements Frog {
    public CraftFrog(CraftServer server, cvq entity) {
        super(server, entity);
    }

    @Override
    public cvq getHandle() {
        return (cvq)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFrog";
    }

    public Entity getTongueTarget() {
        return this.getHandle().gP().map(cgk::getBukkitEntity).orElse(null);
    }

    public void setTongueTarget(Entity target) {
        if (target == null) {
            this.getHandle().p();
        } else {
            this.getHandle().H(((CraftEntity)target).getHandle());
        }
    }

    public Frog.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().gQ());
    }

    public void setVariant(Frog.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().b(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant
    extends CraftOldEnumRegistryItem<Frog.Variant, cvs>
    implements Frog.Variant {
        private static int count = 0;

        public static Frog.Variant minecraftToBukkit(cvs minecraft) {
            return (Frog.Variant)CraftRegistry.minecraftToBukkit(minecraft, mj.bh, Registry.FROG_VARIANT);
        }

        public static Frog.Variant minecraftHolderToBukkit(jd<cvs> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.a());
        }

        public static cvs bukkitToMinecraft(Frog.Variant bukkit) {
            return (cvs)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static jd<cvs> bukkitToMinecraftHolder(Frog.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, mj.bh);
        }

        public CraftVariant(NamespacedKey key, jd<cvs> handle) {
            super(key, handle, count++);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }
}

