/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftSound;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.damage.CraftDamageSource;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.memory.CraftMemoryKey;
import org.bukkit.craftbukkit.v1_21_R7.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftEntityEquipment;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractWindCharge;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class CraftLivingEntity
extends CraftEntity
implements LivingEntity {
    private CraftEntityEquipment equipment;

    public CraftLivingEntity(CraftServer server, chl entity) {
        super(server, entity);
        if (entity instanceof chn || entity instanceof cyy || entity instanceof cze) {
            this.equipment = new CraftEntityEquipment(this);
        }
    }

    public double getHealth() {
        return Math.min((double)Math.max(0.0f, this.getHandle().eZ()), this.getMaxHealth());
    }

    public void setHealth(double health) {
        Preconditions.checkArgument(((health = (double)((float)health)) >= 0.0 && health <= this.getMaxHealth() ? 1 : 0) != 0, (String)"Health value (%s) must be between 0 and %s", (Object)health, (Object)this.getMaxHealth());
        if (this.getHandle().generation && health == 0.0) {
            this.getHandle().discard(null);
            return;
        }
        this.getHandle().x((float)health);
        if (health == 0.0) {
            this.getHandle().a(this.getHandle().en().p());
        }
    }

    public double getAbsorptionAmount() {
        return this.getHandle().fX();
    }

    public void setAbsorptionAmount(double amount) {
        Preconditions.checkArgument((amount >= 0.0 && Double.isFinite(amount) ? 1 : 0) != 0, (Object)"amount < 0 or non-finite");
        this.getHandle().F((float)amount);
    }

    public double getMaxHealth() {
        return this.getHandle().fq();
    }

    public void setMaxHealth(double amount) {
        Preconditions.checkArgument((amount > 0.0 ? 1 : 0) != 0, (String)"Max health amount (%s) must be greater than 0", (Object)amount);
        this.getHandle().h(cis.u).a(amount);
        if (this.getHealth() > amount) {
            this.setHealth(amount);
        }
    }

    public void resetMaxHealth() {
        this.setMaxHealth(this.getHandle().h(cis.u).a().a().a());
    }

    public double getEyeHeight() {
        return this.getHandle().dk();
    }

    public double getEyeHeight(boolean ignorePose) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(Set<Material> transparent, int maxDistance, int maxLength) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot get line of sight during world generation");
        if (transparent == null) {
            transparent = Sets.newHashSet((Object[])new Material[]{Material.AIR, Material.CAVE_AIR, Material.VOID_AIR});
        }
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator((LivingEntity)this, maxDistance);
        while (itr.hasNext()) {
            Material material;
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            if (transparent.contains(material = block.getType())) continue;
            break;
        }
        return blocks;
    }

    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    public Block getTargetBlockExact(int maxDistance) {
        return this.getTargetBlockExact(maxDistance, FluidCollisionMode.NEVER);
    }

    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        RayTraceResult hitResult = this.rayTraceBlocks(maxDistance, fluidCollisionMode);
        return hitResult != null ? hitResult.getHitBlock() : null;
    }

    public RayTraceResult rayTraceBlocks(double maxDistance) {
        return this.rayTraceBlocks(maxDistance, FluidCollisionMode.NEVER);
    }

    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot ray tray blocks during world generation");
        Location eyeLocation = this.getEyeLocation();
        Vector direction = eyeLocation.getDirection();
        return this.getWorld().rayTraceBlocks(eyeLocation, direction, maxDistance, fluidCollisionMode, false);
    }

    public int getRemainingAir() {
        return this.getHandle().cK();
    }

    public void setRemainingAir(int ticks) {
        this.getHandle().j(ticks);
    }

    public int getMaximumAir() {
        return this.getHandle().maxAirTicks;
    }

    public void setMaximumAir(int ticks) {
        this.getHandle().maxAirTicks = ticks;
    }

    public ItemStack getItemInUse() {
        dlt item = this.getHandle().gb();
        return item.f() ? null : CraftItemStack.asCraftMirror(item);
    }

    public int getItemInUseTicks() {
        return this.getHandle().gc();
    }

    public void setItemInUseTicks(int ticks) {
        this.getHandle().bU = ticks;
    }

    public int getArrowCooldown() {
        return this.getHandle().bs;
    }

    public void setArrowCooldown(int ticks) {
        this.getHandle().bs = ticks;
    }

    public int getArrowsInBody() {
        return this.getHandle().fs();
    }

    public void setArrowsInBody(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New arrow amount must be >= 0");
        this.getHandle().aD().a(chl.cg, count);
    }

    @Override
    public boolean isInvulnerable() {
        return this.getHandle().a((axf)this.getHandle().ao(), this.getHandle().en().p());
    }

    public void damage(double amount) {
        this.damage(amount, this.getHandle().en().p());
    }

    public void damage(double amount, Entity source) {
        cex reason = this.getHandle().en().p();
        if (source instanceof HumanEntity) {
            reason = this.getHandle().en().a(((CraftHumanEntity)source).getHandle());
        } else if (source instanceof LivingEntity) {
            reason = this.getHandle().en().b(((CraftLivingEntity)source).getHandle());
        }
        this.damage(amount, reason);
    }

    public void damage(double amount, DamageSource damageSource) {
        Preconditions.checkArgument((damageSource != null ? 1 : 0) != 0, (Object)"damageSource cannot be null");
        this.damage(amount, ((CraftDamageSource)damageSource).getHandle());
    }

    private void damage(double amount, cex damageSource) {
        Preconditions.checkArgument((damageSource != null ? 1 : 0) != 0, (Object)"damageSource cannot be null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot damage entity during world generation");
        this.entity.a(damageSource, (float)amount);
    }

    public Location getEyeLocation() {
        Location loc = this.getLocation();
        loc.setY(loc.getY() + this.getEyeHeight());
        return loc;
    }

    public int getMaximumNoDamageTicks() {
        return this.getHandle().invulnerableDuration;
    }

    public void setMaximumNoDamageTicks(int ticks) {
        this.getHandle().invulnerableDuration = ticks;
    }

    public double getLastDamage() {
        return this.getHandle().bL;
    }

    public void setLastDamage(double damage) {
        this.getHandle().bL = (float)damage;
    }

    public int getNoDamageTicks() {
        return this.getHandle().ax;
    }

    public void setNoDamageTicks(int ticks) {
        this.getHandle().ax = ticks;
    }

    public int getNoActionTicks() {
        return this.getHandle().eP();
    }

    public void setNoActionTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().n(ticks);
    }

    @Override
    public chl getHandle() {
        return (chl)this.entity;
    }

    public void setHandle(chl entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftLivingEntity{id=" + this.getEntityId() + "}";
    }

    public Player getKiller() {
        ddm lastHurtByPlayer = this.getHandle().eL();
        return lastHurtByPlayer == null ? null : (Player)lastHurtByPlayer.getBukkitEntity();
    }

    public boolean addPotionEffect(PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        this.getHandle().addEffect(new cfm(CraftPotionEffectType.bukkitToMinecraftHolder(effect.getType()), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles()), EntityPotionEffectEvent.Cause.PLUGIN);
        return true;
    }

    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean success = true;
        for (PotionEffect effect : effects) {
            success &= this.addPotionEffect(effect);
        }
        return success;
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getHandle().d(CraftPotionEffectType.bukkitToMinecraftHolder(type));
    }

    public PotionEffect getPotionEffect(PotionEffectType type) {
        cfm handle = this.getHandle().e(CraftPotionEffectType.bukkitToMinecraftHolder(type));
        return handle == null ? null : new PotionEffect(CraftPotionEffectType.minecraftHolderToBukkit(handle.c()), handle.d(), handle.e(), handle.f(), handle.g());
    }

    public void removePotionEffect(PotionEffectType type) {
        this.getHandle().removeEffect(CraftPotionEffectType.bukkitToMinecraftHolder(type), EntityPotionEffectEvent.Cause.PLUGIN);
    }

    public Collection<PotionEffect> getActivePotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (cfm handle : this.getHandle().co.values()) {
            effects.add(new PotionEffect(CraftPotionEffectType.minecraftHolderToBukkit(handle.c()), handle.d(), handle.e(), handle.f(), handle.g()));
        }
        return effects;
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot launch projectile during world generation");
        axf world = ((CraftWorld)this.getWorld()).getHandle();
        dec launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new dez(world, this.getHandle(), new dlt(dlx.so));
            ((deg)launch).a(this.getHandle(), this.getHandle().ee(), this.getHandle().ec(), 0.0f, 1.5f, 1.0f);
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new dfb(world, this.getHandle(), new dlt(dlx.sD));
            ((deg)launch).a(this.getHandle(), this.getHandle().ee(), this.getHandle().ec(), 0.0f, 1.5f, 1.0f);
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new dfc(world, this.getHandle(), new dlt(dlx.uj));
            ((deg)launch).a(this.getHandle(), this.getHandle().ee(), this.getHandle().ec(), 0.0f, 1.5f, 1.0f);
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new dei(world, this.getHandle(), new dlt(dlx.pX), null);
                ((Arrow)launch.getBukkitEntity()).setBasePotionType(PotionType.WATER);
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new dej(world, this.getHandle(), new dlt(dlx.xE), null) : (Trident.class.isAssignableFrom(projectile) ? new dek(world, this.getHandle(), new dlt(dlx.yr)) : new dei(world, this.getHandle(), new dlt(dlx.pX), null));
            }
            ((deh)launch).a(this.getHandle(), this.getHandle().ee(), this.getHandle().ec(), 0.0f, 3.0f, 1.0f);
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            launch = LingeringPotion.class.isAssignableFrom(projectile) ? new dfe(world, this.getHandle(), new dlt(dlx.xG)) : new dff(world, this.getHandle(), new dlt(dlx.xD));
            ((deg)launch).a(this.getHandle(), this.getHandle().ee(), this.getHandle().ec(), -20.0f, 0.5f, 1.0f);
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new dfd(world, this.getHandle(), new dlt(dlx.wh));
            ((deg)launch).a(this.getHandle(), this.getHandle().ee(), this.getHandle().ec(), -20.0f, 0.7f, 1.0f);
        } else if (FishHook.class.isAssignableFrom(projectile) && this.getHandle() instanceof ddm) {
            launch = new ddz((ddm)this.getHandle(), (dwo)world, 0, 0);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection().multiply(10);
            ftm vec = new ftm(direction.getX(), direction.getY(), direction.getZ());
            if (SmallFireball.class.isAssignableFrom(projectile)) {
                launch = new deq(world, this.getHandle(), vec);
            } else if (WitherSkull.class.isAssignableFrom(projectile)) {
                launch = new der(world, this.getHandle(), vec);
            } else if (DragonFireball.class.isAssignableFrom(projectile)) {
                launch = new den(world, this.getHandle(), vec);
            } else if (AbstractWindCharge.class.isAssignableFrom(projectile)) {
                launch = BreezeWindCharge.class.isAssignableFrom(projectile) ? cgu.u.a(world, cgt.k) : cgu.bP.a(world, cgt.k);
                ((det)launch).d(this.getHandle());
                ((det)launch).a(this.getHandle(), this.getHandle().ee(), this.getHandle().ec(), 0.0f, 1.5f, 1.0f);
            } else {
                launch = new dep(world, this.getHandle(), vec, 1);
            }
            ((dem)launch).projectileSource = this;
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (LlamaSpit.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection();
            launch = cgu.aD.a(world, cgt.k);
            ((deb)launch).d(this.getHandle());
            ((deb)launch).d(direction.getX(), direction.getY(), direction.getZ(), 1.5f, 10.0f);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (ShulkerBullet.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new def(world, this.getHandle(), null, null);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (Firework.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new ddy(world, dlt.l, this.getHandle());
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
        Preconditions.checkArgument((launch != null ? 1 : 0) != 0, (String)"Projectile (%s) not supported", (Object)projectile.getName());
        if (velocity != null) {
            ((Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }

    public boolean hasLineOfSight(Entity other) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check line of sight during world generation");
        return this.getHandle().G(((CraftEntity)other).getHandle());
    }

    public boolean getRemoveWhenFarAway() {
        return this.getHandle() instanceof chn && !((chn)this.getHandle()).gA();
    }

    public void setRemoveWhenFarAway(boolean remove) {
        if (this.getHandle() instanceof chn) {
            ((chn)this.getHandle()).setPersistenceRequired(!remove);
        }
    }

    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    public void setCanPickupItems(boolean pickup) {
        if (this.getHandle() instanceof chn) {
            ((chn)this.getHandle()).b_(pickup);
        } else {
            this.getHandle().bukkitPickUpLoot = pickup;
        }
    }

    public boolean getCanPickupItems() {
        if (this.getHandle() instanceof chn) {
            return ((chn)this.getHandle()).gn();
        }
        return this.getHandle().bukkitPickUpLoot;
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.getHealth() == 0.0) {
            return false;
        }
        return super.teleport(location, cause);
    }

    public boolean isLeashed() {
        if (!(this.getHandle() instanceof chj)) {
            return false;
        }
        return ((chj)((Object)this.getHandle())).C() != null;
    }

    public Entity getLeashHolder() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isLeashed(), (Object)"Entity not leashed");
        return ((chj)((Object)this.getHandle())).C().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        ((chj)((Object)this.getHandle())).r();
        return true;
    }

    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle().generation || !(this.getHandle() instanceof chj)) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        ((chj)((Object)this.getHandle())).a_(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    public boolean isGliding() {
        return this.getHandle().i(7);
    }

    public void setGliding(boolean gliding) {
        this.getHandle().b(7, gliding);
    }

    public boolean isSwimming() {
        return this.getHandle().cB();
    }

    public void setSwimming(boolean swimming) {
        this.getHandle().j(swimming);
    }

    public boolean isRiptiding() {
        return this.getHandle().fW();
    }

    public void setRiptiding(boolean riptiding) {
        this.getHandle().c(4, riptiding);
    }

    public boolean isSleeping() {
        return this.getHandle().gr();
    }

    public boolean isClimbing() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check if climbing during world generation");
        return this.getHandle().fl();
    }

    public AttributeInstance getAttribute(Attribute attribute) {
        return this.getHandle().craftAttributes.getAttribute(attribute);
    }

    public void setAI(boolean ai2) {
        if (this.getHandle() instanceof chn) {
            ((chn)this.getHandle()).u(!ai2);
        }
    }

    public boolean hasAI() {
        return this.getHandle() instanceof chn ? !((chn)this.getHandle()).gG() : false;
    }

    public void attack(Entity target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target == null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot attack during world generation");
        if (this.getHandle() instanceof ddm) {
            ((ddm)this.getHandle()).e(((CraftEntity)target).getHandle());
        } else {
            this.getHandle().c((axf)((CraftEntity)target).getHandle().ao(), ((CraftEntity)target).getHandle());
        }
    }

    public void swingMainHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(cdb.a, true);
    }

    public void swingOffHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(cdb.b, true);
    }

    public void playHurtAnimation(float yaw) {
        dwo dwo2 = this.getHandle().ao();
        if (dwo2 instanceof axf) {
            axf world = (axf)dwo2;
            float actualYaw = yaw + 90.0f;
            aeo packet = new aeo(this.getEntityId(), actualYaw);
            world.p().a(this.getHandle(), packet);
        }
    }

    public void setCollidable(boolean collidable) {
        this.getHandle().collides = collidable;
    }

    public boolean isCollidable() {
        return this.getHandle().collides;
    }

    public Set<UUID> getCollidableExemptions() {
        return this.getHandle().collidableExemptions;
    }

    public <T> T getMemory(MemoryKey<T> memoryKey) {
        return this.getHandle().ev().c(CraftMemoryKey.bukkitToMinecraft(memoryKey)).map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public <T> void setMemory(MemoryKey<T> memoryKey, T t2) {
        this.getHandle().ev().a(CraftMemoryKey.bukkitToMinecraft(memoryKey), CraftMemoryMapper.toNms(t2));
    }

    public Sound getHurtSound() {
        bcz sound = this.getHandle().getHurtSound0(this.getHandle().en().p());
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    public Sound getDeathSound() {
        bcz sound = this.getHandle().getDeathSound0();
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    public Sound getFallDamageSound(int fallHeight) {
        return CraftSound.minecraftToBukkit(this.getHandle().getFallDamageSound0(fallHeight));
    }

    public Sound getFallDamageSoundSmall() {
        return CraftSound.minecraftToBukkit(this.getHandle().fj().a());
    }

    public Sound getFallDamageSoundBig() {
        return CraftSound.minecraftToBukkit(this.getHandle().fj().b());
    }

    public Sound getDrinkingSound(ItemStack itemStack) {
        return this.getEatingSound(itemStack);
    }

    public Sound getEatingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        dlt nms = CraftItemStack.asNMSCopy(itemStack);
        dob consumable = nms.a(ki.z);
        bcz soundeffect = bda.lQ.a();
        if (consumable != null) {
            chl chl2 = this.getHandle();
            if (chl2 instanceof dob.b) {
                dob.b consumable_b = (dob.b)((Object)chl2);
                soundeffect = consumable_b.j(nms);
            } else {
                soundeffect = consumable.e().a();
            }
        }
        return CraftSound.minecraftToBukkit(soundeffect);
    }

    public boolean canBreatheUnderwater() {
        return this.getHandle().ey();
    }

    public EntityCategory getCategory() {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    public boolean isInvisible() {
        return this.getHandle().cG();
    }

    public void setInvisible(boolean invisible) {
        this.getHandle().persistentInvisibility = invisible;
        this.getHandle().b(5, invisible);
    }

    public Color getWaypointColor() {
        return this.getHandle().gy().e.map(Color::fromRGB).orElse(null);
    }

    public void setWaypointColor(Color color) {
        this.mutateIcon(icon -> {
            icon.e = Optional.ofNullable(color).map(Color::asRGB);
        });
    }

    public NamespacedKey getWaypointStyle() {
        return CraftNamespacedKey.fromMinecraft(this.getHandle().gy().d.a());
    }

    public void setWaypointStyle(NamespacedKey key) {
        this.mutateIcon(icon -> {
            icon.d = Optional.ofNullable(key).map(k2 -> amt.a(fvw.a, CraftNamespacedKey.toMinecraft(k2))).orElse(fvw.b);
        });
    }

    private void mutateIcon(Consumer<fvt.a> consumer) {
        chl handle = this.getHandle();
        axf worldserver = (axf)handle.ao();
        worldserver.j().c(handle);
        consumer.accept(handle.gy());
        worldserver.j().a(handle);
    }
}

