/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractCow;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionUtil;
import org.bukkit.entity.MushroomCow;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftMushroomCow
extends CraftAbstractCow
implements MushroomCow {
    public CraftMushroomCow(CraftServer server, cuk entity) {
        super(server, entity);
    }

    public boolean hasEffectsForNextStew() {
        dpa stewEffects = this.getHandle().cz;
        return stewEffects != null && !stewEffects.a().isEmpty();
    }

    public List<PotionEffect> getEffectsForNextStew() {
        dpa stewEffects = this.getHandle().cz;
        if (stewEffects != null) {
            return stewEffects.a().stream().map(recordSuspiciousEffect -> CraftPotionUtil.toBukkit(recordSuspiciousEffect.a())).toList();
        }
        return ImmutableList.of();
    }

    public boolean addEffectToNextStew(PotionEffect potionEffect, boolean overwrite) {
        Preconditions.checkArgument((potionEffect != null ? 1 : 0) != 0, (Object)"PotionEffect cannot be null");
        cfm minecraftPotionEffect = CraftPotionUtil.fromBukkit(potionEffect);
        if (!overwrite && this.hasEffectForNextStew(potionEffect.getType())) {
            return false;
        }
        dpa stewEffects = this.getHandle().cz;
        if (stewEffects == null) {
            stewEffects = dpa.a;
        }
        dpa.a recordSuspiciousEffect = new dpa.a(minecraftPotionEffect.c(), minecraftPotionEffect.d());
        this.removeEffectFromNextStew(potionEffect.getType());
        this.getHandle().cz = stewEffects.a(recordSuspiciousEffect);
        return true;
    }

    public boolean removeEffectFromNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        if (!this.hasEffectForNextStew(potionEffectType)) {
            return false;
        }
        dpa stewEffects = this.getHandle().cz;
        if (stewEffects == null) {
            return false;
        }
        jd<cfk> minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraftHolder(potionEffectType);
        this.getHandle().cz = new dpa(stewEffects.a().stream().filter(effect -> !effect.b().equals(minecraftPotionEffectType)).toList());
        return true;
    }

    public boolean hasEffectForNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        dpa stewEffects = this.getHandle().cz;
        if (stewEffects == null) {
            return false;
        }
        jd<cfk> minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraftHolder(potionEffectType);
        return stewEffects.a().stream().anyMatch(recordSuspiciousEffect -> recordSuspiciousEffect.b().equals(minecraftPotionEffectType));
    }

    public void clearEffectsForNextStew() {
        this.getHandle().cz = null;
    }

    @Override
    public cuk getHandle() {
        return (cuk)this.entity;
    }

    public MushroomCow.Variant getVariant() {
        return MushroomCow.Variant.values()[this.getHandle().gP().ordinal()];
    }

    public void setVariant(MushroomCow.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"Variant cannot be null");
        this.getHandle().a(cuk.a.values()[variant.ordinal()]);
    }

    @Override
    public String toString() {
        return "CraftMushroomCow";
    }
}

