/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R7.registry.CraftOldEnumRegistryItem;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.Handleable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, dcx entity) {
        super(server, entity);
    }

    @Override
    public dcx getHandle() {
        return (dcx)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public void remove() {
        this.getHandle().hm();
        super.remove();
    }

    public Villager.Profession getProfession() {
        return CraftProfession.minecraftHolderToBukkit(this.getHandle().gZ().b());
    }

    public void setProfession(Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"Profession cannot be null");
        this.getHandle().a(this.getHandle().gZ().b(CraftProfession.bukkitToMinecraftHolder(profession)));
    }

    public Villager.Type getVillagerType() {
        return CraftType.minecraftHolderToBukkit(this.getHandle().gZ().a());
    }

    public void setVillagerType(Villager.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        this.getHandle().a(this.getHandle().gZ().a(CraftType.bukkitToMinecraftHolder(type)));
    }

    public int getVillagerLevel() {
        return this.getHandle().gZ().c();
    }

    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (String)"level (%s) must be between [1, 5]", (int)level);
        this.getHandle().a(this.getHandle().gZ().a(level));
    }

    public int getVillagerExperience() {
        return this.getHandle().d();
    }

    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (String)"Experience (%s) must be positive", (int)experience);
        this.getHandle().s(experience);
    }

    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot sleep during world generation");
        is position = CraftLocation.toBlockPosition(location);
        eoh iblockdata = this.getHandle().ao().a_(position);
        if (!(iblockdata.b() instanceof dzj)) {
            return false;
        }
        this.getHandle().b(position);
        return true;
    }

    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot wakeup during world generation");
        this.getHandle().gs();
    }

    public void shakeHead() {
        this.getHandle().hf();
    }

    public ZombieVillager zombify() {
        dco entityzombievillager = dcn.convertVillagerToZombieVillager(this.getHandle().ao().getMinecraftWorld(), this.getHandle(), this.getHandle().dK(), this.isSilent(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entityzombievillager != null ? (ZombieVillager)entityzombievillager.getBukkitEntity() : null;
    }

    public int getReputation(UUID uuid, Villager.ReputationType reputationType) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        return this.getHandle().he().getReputation(uuid, Predicate.isEqual(CraftReputationType.bukkitToMinecraft(reputationType)), false);
    }

    public int getWeightedReputation(UUID uuid, Villager.ReputationType reputationType) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        return this.getHandle().he().getReputation(uuid, Predicate.isEqual(CraftReputationType.bukkitToMinecraft(reputationType)), true);
    }

    public int getReputation(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        return this.getHandle().he().a(uuid, reputationType -> true);
    }

    public void addReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.addReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void addReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().he().add(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void removeReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.removeReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void removeReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().he().remove(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void setReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.setReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void setReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().he().set(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void setGossipDecayTime(long ticks) {
        this.getHandle().gossipDecayInterval = ticks;
    }

    public long getGossipDecayTime() {
        return this.getHandle().gossipDecayInterval;
    }

    public static class CraftProfession
    extends CraftOldEnumRegistryItem<Villager.Profession, dda>
    implements Villager.Profession {
        private static int count = 0;

        public static Villager.Profession minecraftToBukkit(dda minecraft) {
            return (Villager.Profession)CraftRegistry.minecraftToBukkit(minecraft, mj.aL, Registry.VILLAGER_PROFESSION);
        }

        public static Villager.Profession minecraftHolderToBukkit(jd<dda> minecraft) {
            return CraftProfession.minecraftToBukkit(minecraft.a());
        }

        public static dda bukkitToMinecraft(Villager.Profession bukkit) {
            return (dda)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static jd<dda> bukkitToMinecraftHolder(Villager.Profession bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            jq registry = CraftRegistry.getMinecraftRegistry(mj.aL);
            jd<dda> jd2 = registry.e(CraftProfession.bukkitToMinecraft(bukkit));
            if (jd2 instanceof jd.c) {
                jd.c holder = (jd.c)jd2;
                return holder;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own villager profession without properly registering it.");
        }

        public CraftProfession(NamespacedKey key, jd<dda> handle) {
            super(key, handle, count++);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }

    public static class CraftType
    extends CraftOldEnumRegistryItem<Villager.Type, ddc>
    implements Villager.Type {
        private static int count = 0;

        public static Villager.Type minecraftToBukkit(ddc minecraft) {
            return (Villager.Type)CraftRegistry.minecraftToBukkit(minecraft, mj.aM, Registry.VILLAGER_TYPE);
        }

        public static Villager.Type minecraftHolderToBukkit(jd<ddc> minecraft) {
            return CraftType.minecraftToBukkit(minecraft.a());
        }

        public static ddc bukkitToMinecraft(Villager.Type bukkit) {
            return (ddc)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static jd<ddc> bukkitToMinecraftHolder(Villager.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            jq registry = CraftRegistry.getMinecraftRegistry(mj.aM);
            jd<ddc> jd2 = registry.e(CraftType.bukkitToMinecraft(bukkit));
            if (jd2 instanceof jd.c) {
                jd.c holder = (jd.c)jd2;
                return holder;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own villager type without properly registering it.");
        }

        public CraftType(NamespacedKey key, jd<ddc> handle) {
            super(key, handle, count++);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }

    public static class CraftReputationType
    implements Villager.ReputationType,
    Handleable<cqt> {
        public static final Map<String, CraftReputationType> BY_ID = Stream.of(cqt.values()).collect(Collectors.toMap(reputationType -> reputationType.i, CraftReputationType::new));
        private final cqt handle;

        public CraftReputationType(cqt handle) {
            this.handle = handle;
        }

        @Override
        public cqt getHandle() {
            return this.handle;
        }

        public int getMaxValue() {
            return this.handle.k;
        }

        public int getWeight() {
            return this.handle.j;
        }

        public static cqt bukkitToMinecraft(Villager.ReputationType bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return ((CraftReputationType)bukkit).getHandle();
        }

        public static Villager.ReputationType minecraftToBukkit(cqt minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            return switch (minecraft) {
                default -> throw new MatchException(null, null);
                case cqt.a -> Villager.ReputationType.MAJOR_NEGATIVE;
                case cqt.b -> Villager.ReputationType.MINOR_NEGATIVE;
                case cqt.c -> Villager.ReputationType.MINOR_POSITIVE;
                case cqt.d -> Villager.ReputationType.MAJOR_POSITIVE;
                case cqt.e -> Villager.ReputationType.TRADING;
            };
        }
    }

    public static class CraftReputationEvent
    implements Villager.ReputationEvent,
    Handleable<csu> {
        private static final Map<String, Villager.ReputationEvent> ALL = Maps.newHashMap();
        private final csu handle;

        public CraftReputationEvent(csu handle) {
            this.handle = handle;
            ALL.put(handle.toString(), this);
        }

        @Override
        public csu getHandle() {
            return this.handle;
        }

        public static csu bukkitToMinecraft(Villager.ReputationEvent bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return ((CraftReputationEvent)bukkit).getHandle();
        }

        public static Villager.ReputationEvent minecraftToBukkit(csu minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            Villager.ReputationEvent bukkit = ALL.get(minecraft.toString());
            return bukkit == null ? new CraftReputationEvent(minecraft) : bukkit;
        }
    }
}

