/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Preconditions;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class CraftEntityEquipment
implements EntityEquipment {
    private final CraftLivingEntity entity;

    public CraftEntityEquipment(CraftLivingEntity entity) {
        this.entity = entity;
    }

    public void setItem(EquipmentSlot slot, ItemStack item) {
        this.setItem(slot, item, false);
    }

    public void setItem(EquipmentSlot slot, ItemStack item, boolean silent) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        cgv nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.setEquipment(nmsSlot, item, silent);
    }

    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        cgv nmsSlot = CraftEquipmentSlot.getNMS(slot);
        return this.getEquipment(nmsSlot);
    }

    public ItemStack getItemInMainHand() {
        return this.getEquipment(cgv.a);
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItemInMainHand(item, false);
    }

    public void setItemInMainHand(ItemStack item, boolean silent) {
        this.setEquipment(cgv.a, item, silent);
    }

    public ItemStack getItemInOffHand() {
        return this.getEquipment(cgv.b);
    }

    public void setItemInOffHand(ItemStack item) {
        this.setItemInOffHand(item, false);
    }

    public void setItemInOffHand(ItemStack item, boolean silent) {
        this.setEquipment(cgv.b, item, silent);
    }

    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    public ItemStack getHelmet() {
        return this.getEquipment(cgv.f);
    }

    public void setHelmet(ItemStack helmet) {
        this.setHelmet(helmet, false);
    }

    public void setHelmet(ItemStack helmet, boolean silent) {
        this.setEquipment(cgv.f, helmet, silent);
    }

    public ItemStack getChestplate() {
        return this.getEquipment(cgv.e);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setChestplate(chestplate, false);
    }

    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.setEquipment(cgv.e, chestplate, silent);
    }

    public ItemStack getLeggings() {
        return this.getEquipment(cgv.d);
    }

    public void setLeggings(ItemStack leggings) {
        this.setLeggings(leggings, false);
    }

    public void setLeggings(ItemStack leggings, boolean silent) {
        this.setEquipment(cgv.d, leggings, silent);
    }

    public ItemStack getBoots() {
        return this.getEquipment(cgv.c);
    }

    public void setBoots(ItemStack boots) {
        this.setBoots(boots, false);
    }

    public void setBoots(ItemStack boots, boolean silent) {
        this.setEquipment(cgv.c, boots, silent);
    }

    public ItemStack[] getArmorContents() {
        ItemStack[] armor = new ItemStack[]{this.getEquipment(cgv.c), this.getEquipment(cgv.d), this.getEquipment(cgv.e), this.getEquipment(cgv.f)};
        return armor;
    }

    public void setArmorContents(ItemStack[] items) {
        this.setEquipment(cgv.c, items.length >= 1 ? items[0] : null, false);
        this.setEquipment(cgv.d, items.length >= 2 ? items[1] : null, false);
        this.setEquipment(cgv.e, items.length >= 3 ? items[2] : null, false);
        this.setEquipment(cgv.f, items.length >= 4 ? items[3] : null, false);
    }

    private ItemStack getEquipment(cgv slot) {
        return CraftItemStack.asBukkitCopy(this.entity.getHandle().a(slot));
    }

    private void setEquipment(cgv slot, ItemStack stack, boolean silent) {
        this.entity.getHandle().setItemSlot(slot, CraftItemStack.asNMSCopy(stack), silent);
    }

    public void clear() {
        for (cgv slot : cgv.values()) {
            this.setEquipment(slot, null, false);
        }
    }

    public Entity getHolder() {
        return this.entity;
    }

    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    public float getItemInMainHandDropChance() {
        return this.getDropChance(cgv.a);
    }

    public void setItemInMainHandDropChance(float chance) {
        this.setDropChance(cgv.a, chance);
    }

    public float getItemInOffHandDropChance() {
        return this.getDropChance(cgv.b);
    }

    public void setItemInOffHandDropChance(float chance) {
        this.setDropChance(cgv.b, chance);
    }

    public float getHelmetDropChance() {
        return this.getDropChance(cgv.f);
    }

    public void setHelmetDropChance(float chance) {
        this.setDropChance(cgv.f, chance);
    }

    public float getChestplateDropChance() {
        return this.getDropChance(cgv.e);
    }

    public void setChestplateDropChance(float chance) {
        this.setDropChance(cgv.e, chance);
    }

    public float getLeggingsDropChance() {
        return this.getDropChance(cgv.d);
    }

    public void setLeggingsDropChance(float chance) {
        this.setDropChance(cgv.d, chance);
    }

    public float getBootsDropChance() {
        return this.getDropChance(cgv.c);
    }

    public void setBootsDropChance(float chance) {
        this.setDropChance(cgv.c, chance);
    }

    private void setDropChance(cgv slot, float chance) {
        Preconditions.checkArgument((boolean)(this.entity.getHandle() instanceof chn), (Object)"Cannot set drop chance for non-Mob entity");
        ((chn)this.entity.getHandle()).a(slot, chance);
    }

    private float getDropChance(cgv slot) {
        if (!(this.entity.getHandle() instanceof chn)) {
            return 1.0f;
        }
        return ((chn)this.entity.getHandle()).an().b(slot);
    }
}

