/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R7.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemFlag;

public class CraftItemFlag {
    private static final BiMap<ItemFlag, kh<?>> BUKKIT_TO_NMS = HashBiMap.create();
    private static final Collection<kh<?>> HIDE_ADDITIONAL_TOOLTIP = Arrays.asList(ki.Y, ki.ab, ki.ac, ki.aq, ki.ap, ki.S, ki.U, ki.T, ki.V, ki.at, ki.Q);

    public static Collection<kh<?>> bukkitToNMS(ItemFlag bukkit) {
        if (bukkit == ItemFlag.HIDE_ADDITIONAL_TOOLTIP) {
            return HIDE_ADDITIONAL_TOOLTIP;
        }
        kh<?> type = (kh<?>)BUKKIT_TO_NMS.get((Object)bukkit);
        if (type == null) {
            NamespacedKey key = bukkit.getComponent();
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"Unknown flag %s must have component key", (Object)bukkit);
            type = mi.am.a(CraftNamespacedKey.toMinecraft(key));
        }
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown flag %s", (Object)bukkit);
        return Arrays.asList(type);
    }

    public static ItemFlag nmsToBukkit(kh<?> nms) {
        ItemFlag inverse = (ItemFlag)BUKKIT_TO_NMS.inverse().get(nms);
        if (inverse == null) {
            amo key = mi.am.b(nms);
            if (key == null) {
                throw new IllegalArgumentException("Unregistered component " + String.valueOf(nms));
            }
            inverse = ItemFlag.valueOf((String)("HIDE_" + key.a().toUpperCase(Locale.ROOT).replace('/', '_')));
        }
        return inverse;
    }

    public static String bukkitToString(ItemFlag bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.name();
    }

    public static ItemFlag stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertItemFlagName(ApiVersion.CURRENT, string);
        return ItemFlag.valueOf((String)string);
    }

    static {
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_ARMOR_TRIM, ki.ad);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_ATTRIBUTES, ki.r);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_DESTROYS, ki.q);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_DYE, ki.R);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_ENCHANTS, ki.o);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_PLACED_ON, ki.p);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_UNBREAKABLE, ki.f);
    }
}

