/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R7.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemMetas;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R7.registry.CraftRegistryItem;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftItemType<M extends ItemMeta>
extends CraftRegistryItem<dlp>
implements ItemType.Typed<M> {
    private final Supplier<CraftItemMetas.ItemMetaData<M>> itemMetaData = Suppliers.memoize(() -> CraftItemMetas.getItemMetaData(this));

    public static Material minecraftToBukkit(dlp item) {
        return CraftMagicNumbers.getMaterial(item);
    }

    public static dlp bukkitToMinecraft(Material material) {
        return CraftMagicNumbers.getItem(material);
    }

    public static ItemType minecraftToBukkitNew(dlp minecraft) {
        return (ItemType)CraftRegistry.minecraftToBukkit(minecraft, mj.R, Registry.ITEM);
    }

    public static dlp bukkitToMinecraftNew(ItemType bukkit) {
        return (dlp)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public CraftItemType(NamespacedKey key, jd<dlp> handle) {
        super(key, handle);
    }

    @NotNull
    public ItemType.Typed<ItemMeta> typed() {
        return this.typed(ItemMeta.class);
    }

    @NotNull
    public <Other extends ItemMeta> ItemType.Typed<Other> typed(@NotNull Class<Other> itemMetaType) {
        if (itemMetaType.isAssignableFrom(this.itemMetaData.get().metaClass())) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type item type " + String.valueOf(this.isRegistered() ? this.getKeyOrThrow() : this.toString()) + " to meta type " + itemMetaType.getSimpleName());
    }

    @NotNull
    public ItemStack createItemStack() {
        return this.createItemStack(1, null);
    }

    @NotNull
    public ItemStack createItemStack(int amount) {
        return this.createItemStack(amount, null);
    }

    @NotNull
    public ItemStack createItemStack(Consumer<? super M> metaConfigurator) {
        return this.createItemStack(1, metaConfigurator);
    }

    @NotNull
    public ItemStack createItemStack(int amount, @Nullable Consumer<? super M> metaConfigurator) {
        ItemStack itemStack = new ItemStack(this.asMaterial(), amount);
        if (metaConfigurator != null) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            metaConfigurator.accept(itemMeta);
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    public M getItemMeta(dlt itemStack) {
        return (M)((ItemMeta)this.itemMetaData.get().fromItemStack().apply(itemStack));
    }

    public M getItemMeta(ItemMeta itemMeta) {
        return (M)((ItemMeta)this.itemMetaData.get().fromItemMeta().apply(this, (CraftMetaItem)itemMeta));
    }

    public boolean hasBlockType() {
        return this.getHandle() instanceof dkb;
    }

    @NotNull
    public BlockType getBlockType() {
        Object m2 = this.getHandle();
        if (!(m2 instanceof dkb)) {
            throw new IllegalStateException("The item type " + String.valueOf(this.isRegistered() ? this.getKeyOrThrow() : this.toString()) + " has no corresponding block type");
        }
        dkb block = (dkb)m2;
        return CraftBlockType.minecraftToBukkitNew(block.c());
    }

    public Class<M> getItemMetaClass() {
        if (this == ItemType.AIR) {
            throw new UnsupportedOperationException("Air does not have ItemMeta");
        }
        return this.itemMetaData.get().metaClass();
    }

    public int getMaxStackSize() {
        if (this == AIR) {
            return 0;
        }
        return ((dlp)this.getHandle()).f().a(ki.c, 64);
    }

    public short getMaxDurability() {
        return ((dlp)this.getHandle()).f().a(ki.d, 0).shortValue();
    }

    public boolean isEdible() {
        return ((dlp)this.getHandle()).f().c(ki.y);
    }

    public boolean isRecord() {
        return ((dlp)this.getHandle()).f().c(ki.al);
    }

    public boolean isFuel() {
        return MinecraftServer.getServer().bs().a(new dlt((dwn)this.getHandle()));
    }

    public boolean isCompostable() {
        return ebc.f.containsKey(this.getHandle());
    }

    public float getCompostChance() {
        Preconditions.checkArgument((boolean)this.isCompostable(), (Object)("The item type " + String.valueOf(this.isRegistered() ? this.getKeyOrThrow() : this.toString()) + " is not compostable"));
        return ebc.f.getFloat(this.getHandle());
    }

    public ItemType getCraftingRemainingItem() {
        dlt expectedItem = ((dlp)this.getHandle()).i();
        return expectedItem.f() ? null : CraftItemType.minecraftToBukkitNew(expectedItem.h());
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(EquipmentSlot slot) {
        ImmutableMultimap.Builder defaultAttributes = ImmutableMultimap.builder();
        don nmsDefaultAttributes = ((dlp)this.getHandle()).f().a(ki.r, don.a);
        nmsDefaultAttributes.a(CraftEquipmentSlot.getNMS(slot), (key, value) -> {
            Attribute attribute = CraftAttribute.minecraftToBukkit((cin)key.a());
            defaultAttributes.put((Object)attribute, (Object)CraftAttributeInstance.convert(value, slot));
        });
        return defaultAttributes.build();
    }

    public CreativeCategory getCreativeCategory() {
        return CreativeCategory.BUILDING_BLOCKS;
    }

    public boolean isEnabledByFeature(@NotNull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        return ((dlp)this.getHandle()).a(((CraftWorld)world).getHandle().Q());
    }

    @NotNull
    public String getTranslationKey() {
        return ((dlp)this.getHandle()).j();
    }

    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public Material asMaterial() {
        return (Material)Registry.MATERIAL.get(this.getKeyOrThrow());
    }
}

