/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.CraftSound;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftHolderUtil;
import org.bukkit.craftbukkit.v1_21_R7.tag.CraftEntityTag;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.components.EquippableComponent;

@SerializableAs(value="Equippable")
public final class CraftEquippableComponent
implements EquippableComponent {
    private dun handle;

    public CraftEquippableComponent(dun handle) {
        this.handle = handle;
    }

    public CraftEquippableComponent(CraftEquippableComponent craft) {
        this.handle = craft.handle;
    }

    public CraftEquippableComponent(Map<String, Object> map) {
        cgv slot = CraftEquipmentSlot.getNMS(EquipmentSlot.valueOf((String)SerializableMeta.getString(map, "slot", false)));
        Sound equipSound = null;
        String snd = SerializableMeta.getString(map, "equip-sound", true);
        if (snd != null) {
            equipSound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)snd));
        }
        String model = SerializableMeta.getString(map, "model", true);
        String cameraOverlay = SerializableMeta.getString(map, "camera-overlay", true);
        jh<cgu<?>> allowedEntities = null;
        Object allowed = SerializableMeta.getObject(Object.class, map, "allowed-entities", true);
        if (allowed != null) {
            allowedEntities = CraftHolderUtil.parse(allowed, mj.F, mi.g);
        }
        Boolean dispensable = SerializableMeta.getObject(Boolean.class, map, "dispensable", true);
        Boolean swappable = SerializableMeta.getObject(Boolean.class, map, "swappable", true);
        Boolean damageOnHurt = SerializableMeta.getObject(Boolean.class, map, "damage-on-hurt", true);
        Boolean equipOnInteract = SerializableMeta.getObject(Boolean.class, map, "equip-on-interact", true);
        Boolean canBeSheared = SerializableMeta.getObject(Boolean.class, map, "can-be-sheared", true);
        Sound shearSound = null;
        String shearSnd = SerializableMeta.getString(map, "equip-sound", true);
        if (shearSnd != null) {
            shearSound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)shearSnd));
        }
        this.handle = new dun(slot, equipSound != null ? CraftSound.bukkitToMinecraftHolder(equipSound) : bda.as, Optional.ofNullable(model).map(amo::a).map(k2 -> amt.a(dum.a, k2)), Optional.ofNullable(cameraOverlay).map(amo::a), Optional.ofNullable(allowedEntities), dispensable != null ? dispensable : true, swappable != null ? swappable : true, damageOnHurt != null ? damageOnHurt : true, equipOnInteract != null ? equipOnInteract : true, canBeSheared, shearSound != null ? CraftSound.bukkitToMinecraftHolder(shearSound) : mi.b.e(bda.zy));
    }

    public Map<String, Object> serialize() {
        Optional<jh<cgu<?>>> allowed;
        NamespacedKey cameraOverlay;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("slot", this.getSlot().name());
        result.put("equip-sound", this.getEquipSound().getKey().toString());
        NamespacedKey model = this.getModel();
        if (model != null) {
            result.put("model", model.toString());
        }
        if ((cameraOverlay = this.getCameraOverlay()) != null) {
            result.put("camera-overlay", cameraOverlay.toString());
        }
        if ((allowed = this.handle.f()).isPresent()) {
            CraftHolderUtil.serialize(result, "allowed-entities", allowed.get());
        }
        result.put("dispensable", this.isDispensable());
        result.put("swappable", this.isSwappable());
        result.put("damage-on-hurt", this.isDamageOnHurt());
        result.put("equip-on-interact", this.isEquipOnInteract());
        result.put("can-be-sheared", this.isCanBeSheared());
        result.put("shearing-sound", this.getShearingSound().getKey().toString());
        return result;
    }

    public dun getHandle() {
        return this.handle;
    }

    public EquipmentSlot getSlot() {
        return CraftEquipmentSlot.getSlot(this.handle.b());
    }

    public void setSlot(EquipmentSlot slot) {
        this.handle = new dun(CraftEquipmentSlot.getNMS(slot), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public Sound getEquipSound() {
        return CraftSound.minecraftToBukkit(this.handle.c().a());
    }

    public void setEquipSound(Sound sound) {
        this.handle = new dun(this.handle.b(), sound != null ? CraftSound.bukkitToMinecraftHolder(sound) : bda.as, this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public NamespacedKey getModel() {
        return this.handle.d().map(a2 -> CraftNamespacedKey.fromMinecraft(a2.a())).orElse(null);
    }

    public void setModel(NamespacedKey key) {
        this.handle = new dun(this.handle.b(), this.handle.c(), Optional.ofNullable(key).map(CraftNamespacedKey::toMinecraft).map(k2 -> amt.a(dum.a, k2)), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public NamespacedKey getCameraOverlay() {
        return this.handle.e().map(CraftNamespacedKey::fromMinecraft).orElse(null);
    }

    public void setCameraOverlay(NamespacedKey key) {
        this.handle = new dun(this.handle.b(), this.handle.c(), this.handle.d(), Optional.ofNullable(key).map(CraftNamespacedKey::toMinecraft), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public Collection<EntityType> getAllowedEntities() {
        return this.handle.f().map(jh::a).map(stream -> stream.map(jd::a).map(CraftEntityType::minecraftToBukkit).collect(Collectors.toList())).orElse(null);
    }

    public void setAllowedEntities(EntityType entities) {
        this.handle = new dun(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), entities != null ? Optional.of(jh.a(CraftEntityType.bukkitToMinecraftHolder(entities))) : Optional.empty(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public void setAllowedEntities(Collection<EntityType> entities) {
        this.handle = new dun(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), entities != null ? Optional.of(jh.a(entities.stream().map(CraftEntityType::bukkitToMinecraftHolder).collect(Collectors.toList()))) : Optional.empty(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public void setAllowedEntities(Tag<EntityType> tag) {
        Preconditions.checkArgument((boolean)(tag instanceof CraftEntityTag), (Object)"tag must be an entity tag");
        this.handle = new dun(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), tag != null ? Optional.of(((CraftEntityTag)tag).getHandle()) : Optional.empty(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public boolean isDispensable() {
        return this.handle.g();
    }

    public void setDispensable(boolean dispensable) {
        this.handle = new dun(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), dispensable, this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public boolean isSwappable() {
        return this.handle.h();
    }

    public void setSwappable(boolean swappable) {
        this.handle = new dun(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), swappable, this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public boolean isDamageOnHurt() {
        return this.handle.i();
    }

    public void setDamageOnHurt(boolean damage) {
        this.handle = new dun(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), damage, this.handle.j(), this.handle.k(), this.handle.l());
    }

    public boolean isEquipOnInteract() {
        return this.handle.j();
    }

    public void setEquipOnInteract(boolean equip) {
        this.handle = new dun(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), equip, this.handle.k(), this.handle.l());
    }

    public boolean isCanBeSheared() {
        return this.handle.k();
    }

    public void setCanBeSheared(boolean sheared) {
        this.handle = new dun(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), sheared, this.handle.l());
    }

    public Sound getShearingSound() {
        return CraftSound.minecraftToBukkit(this.handle.l().a());
    }

    public void setShearingSound(Sound sound) {
        this.handle = new dun(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), sound != null ? CraftSound.bukkitToMinecraftHolder(sound) : mi.b.e(bda.zy));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEquippableComponent other = (CraftEquippableComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public String toString() {
        return "CraftEquippableComponent{handle=" + String.valueOf(this.handle) + "}";
    }
}

