/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.JukeboxSong;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.CraftJukeboxSong;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;

@SerializableAs(value="JukeboxPlayable")
public final class CraftJukeboxComponent
implements JukeboxPlayableComponent {
    private dly handle;

    public CraftJukeboxComponent(dly jukebox) {
        this.handle = jukebox;
    }

    public CraftJukeboxComponent(CraftJukeboxComponent jukebox) {
        this.handle = jukebox.handle;
    }

    public CraftJukeboxComponent(Map<String, Object> map) {
        String song = SerializableMeta.getObject(String.class, map, "song", false);
        this.handle = new dly(new dku<dlz>(amt.a(mj.bj, amo.a(song))));
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("song", this.getSongKey().toString());
        return result;
    }

    public dly getHandle() {
        return this.handle;
    }

    public JukeboxSong getSong() {
        Optional<jd<dlz>> song = this.handle.a().a(CraftRegistry.getMinecraftRegistry());
        return song.isPresent() ? CraftJukeboxSong.minecraftHolderToBukkit(song.get()) : null;
    }

    public NamespacedKey getSongKey() {
        return this.handle.a().a().map(amt::a).map(CraftNamespacedKey::fromMinecraft).orElse(null);
    }

    public void setSong(JukeboxSong song) {
        Preconditions.checkArgument((song != null ? 1 : 0) != 0, (Object)"song cannot be null");
        this.handle = new dly(new dku<dlz>(CraftJukeboxSong.bukkitToMinecraftHolder(song)));
    }

    public void setSongKey(NamespacedKey song) {
        Preconditions.checkArgument((song != null ? 1 : 0) != 0, (Object)"song cannot be null");
        this.handle = new dly(new dku<dlz>(amt.a(mj.bj, CraftNamespacedKey.toMinecraft(song))));
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftJukeboxComponent other = (CraftJukeboxComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftJukeboxComponent{handle=" + String.valueOf(this.handle) + "}";
    }
}

