/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.CraftSound;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.inventory.meta.components.PiercingWeaponComponent;

@SerializableAs(value="PiercingWeapon")
public final class CraftPiercingWeaponComponent
implements PiercingWeaponComponent {
    private dow handle;

    public CraftPiercingWeaponComponent(dow handle) {
        this.handle = handle;
    }

    public CraftPiercingWeaponComponent(CraftPiercingWeaponComponent craft) {
        this.handle = craft.handle;
    }

    public CraftPiercingWeaponComponent(Map<String, Object> map) {
        Boolean dealsKnockback = SerializableMeta.getObject(Boolean.class, map, "deals-knockback", true);
        Boolean dismounts = SerializableMeta.getObject(Boolean.class, map, "dismounts", true);
        Sound sound = null;
        String snd = SerializableMeta.getString(map, "sound", true);
        if (snd != null) {
            sound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)snd));
        }
        Sound hitSound = null;
        String hitSnd = SerializableMeta.getString(map, "hit-sound", true);
        if (hitSnd != null) {
            hitSound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)hitSnd));
        }
        this.handle = new dow(dealsKnockback != null ? dealsKnockback : true, dismounts != null ? dismounts : false, Optional.ofNullable(sound).map(CraftSound::bukkitToMinecraftHolder), Optional.ofNullable(hitSound).map(CraftSound::bukkitToMinecraftHolder));
    }

    public Map<String, Object> serialize() {
        Sound hitSound;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("deals-knockback", this.isDealsKnockback());
        result.put("dismounts", this.isDismounts());
        Sound sound = this.getSound();
        if (sound != null) {
            result.put("sound", sound.getKey().toString());
        }
        if ((hitSound = this.getHitSound()) != null) {
            result.put("hit-sound", hitSound.getKey().toString());
        }
        return result;
    }

    public dow getHandle() {
        return this.handle;
    }

    public boolean isDealsKnockback() {
        return this.handle.a();
    }

    public void setDealsKnockback(boolean knockback) {
        this.handle = new dow(knockback, this.handle.b(), this.handle.c(), this.handle.d());
    }

    public boolean isDismounts() {
        return this.handle.b();
    }

    public void setDismounts(boolean dismounts) {
        this.handle = new dow(this.handle.a(), dismounts, this.handle.c(), this.handle.d());
    }

    public Sound getSound() {
        return this.handle.c().map(CraftSound::minecraftHolderToBukkit).orElse(null);
    }

    public void setSound(Sound sound) {
        this.handle = new dow(this.handle.a(), this.handle.b(), Optional.ofNullable(sound).map(CraftSound::bukkitToMinecraftHolder), this.handle.d());
    }

    public Sound getHitSound() {
        return this.handle.d().map(CraftSound::minecraftHolderToBukkit).orElse(null);
    }

    public void setHitSound(Sound sound) {
        this.handle = new dow(this.handle.a(), this.handle.b(), this.handle.c(), Optional.ofNullable(sound).map(CraftSound::bukkitToMinecraftHolder));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftPiercingWeaponComponent other = (CraftPiercingWeaponComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public String toString() {
        return "CraftPiercingWeaponComponent{handle=" + String.valueOf(this.handle) + "}";
    }
}

