/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.inventory.meta.components.SwingAnimationComponent;

@SerializableAs(value="SwingAnimation")
public class CraftSwingAnimationComponent
implements SwingAnimationComponent {
    private dpb handle;

    public CraftSwingAnimationComponent(dpb handle) {
        this.handle = handle;
    }

    public CraftSwingAnimationComponent(CraftSwingAnimationComponent component) {
        this.handle = component.handle;
    }

    public CraftSwingAnimationComponent(Map<String, Object> map) {
        SwingAnimationComponent.Type type = SwingAnimationComponent.Type.valueOf((String)SerializableMeta.getString(map, "type", false));
        Integer duration = SerializableMeta.getObject(Integer.class, map, "duration", false);
        this.handle = new dpb(CraftSwingAnimationType.bukkitToMinecraft(type), duration);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("type", this.getType().name());
        result.put("duration", this.getDuration());
        return result;
    }

    public dpb getHandle() {
        return this.handle;
    }

    public SwingAnimationComponent.Type getType() {
        return CraftSwingAnimationType.minecraftToBukkit(this.handle.a());
    }

    public void setType(SwingAnimationComponent.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        this.handle = new dpb(CraftSwingAnimationType.bukkitToMinecraft(type), this.handle.b());
    }

    public int getDuration() {
        return this.handle.b();
    }

    public void setDuration(int ticks) {
        this.handle = new dpb(this.handle.a(), ticks);
    }

    public static class CraftSwingAnimationType {
        public static SwingAnimationComponent.Type minecraftToBukkit(dnf minecraft) {
            return SwingAnimationComponent.Type.valueOf((String)minecraft.name());
        }

        public static dnf bukkitToMinecraft(SwingAnimationComponent.Type bukkit) {
            return dnf.valueOf(bukkit.name());
        }
    }
}

