/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.potion;

import com.google.common.base.Preconditions;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionEffectTypeCategory;
import org.bukkit.craftbukkit.v1_21_R7.util.Handleable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionEffectTypeCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftPotionEffectType
extends PotionEffectType
implements Handleable<cfk> {
    private final NamespacedKey key;
    private final cfk handle;
    private final int id;

    public static PotionEffectType minecraftHolderToBukkit(jd<cfk> minecraft) {
        return CraftPotionEffectType.minecraftToBukkit(minecraft.a());
    }

    public static PotionEffectType minecraftToBukkit(cfk minecraft) {
        return (PotionEffectType)CraftRegistry.minecraftToBukkit(minecraft, mj.ae, Registry.EFFECT);
    }

    public static cfk bukkitToMinecraft(PotionEffectType bukkit) {
        return (cfk)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static jd<cfk> bukkitToMinecraftHolder(PotionEffectType bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit, mj.ae);
    }

    public CraftPotionEffectType(NamespacedKey key, cfk handle) {
        this.key = key;
        this.handle = handle;
        this.id = CraftRegistry.getMinecraftRegistry(mj.ae).a(handle) + 1;
    }

    @Override
    public cfk getHandle() {
        return this.handle;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public double getDurationModifier() {
        return 1.0;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return switch (this.getId()) {
            case 1 -> "SPEED";
            case 2 -> "SLOW";
            case 3 -> "FAST_DIGGING";
            case 4 -> "SLOW_DIGGING";
            case 5 -> "INCREASE_DAMAGE";
            case 6 -> "HEAL";
            case 7 -> "HARM";
            case 8 -> "JUMP";
            case 9 -> "CONFUSION";
            case 10 -> "REGENERATION";
            case 11 -> "DAMAGE_RESISTANCE";
            case 12 -> "FIRE_RESISTANCE";
            case 13 -> "WATER_BREATHING";
            case 14 -> "INVISIBILITY";
            case 15 -> "BLINDNESS";
            case 16 -> "NIGHT_VISION";
            case 17 -> "HUNGER";
            case 18 -> "WEAKNESS";
            case 19 -> "POISON";
            case 20 -> "WITHER";
            case 21 -> "HEALTH_BOOST";
            case 22 -> "ABSORPTION";
            case 23 -> "SATURATION";
            case 24 -> "GLOWING";
            case 25 -> "LEVITATION";
            case 26 -> "LUCK";
            case 27 -> "UNLUCK";
            case 28 -> "SLOW_FALLING";
            case 29 -> "CONDUIT_POWER";
            case 30 -> "DOLPHINS_GRACE";
            case 31 -> "BAD_OMEN";
            case 32 -> "HERO_OF_THE_VILLAGE";
            case 33 -> "DARKNESS";
            default -> this.getKey().toString();
        };
    }

    @NotNull
    public PotionEffect createEffect(int duration, int amplifier) {
        return new PotionEffect((PotionEffectType)this, this.isInstant() ? 1 : (int)((double)duration * this.getDurationModifier()), amplifier);
    }

    public boolean isInstant() {
        return this.handle.a();
    }

    public PotionEffectTypeCategory getCategory() {
        return CraftPotionEffectTypeCategory.minecraftToBukkit(this.handle.h());
    }

    public Color getColor() {
        return Color.fromRGB((int)this.handle.i());
    }

    @NotNull
    public String getTranslationKey() {
        return this.handle.f();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PotionEffectType)) {
            return false;
        }
        return this.getKey().equals((Object)((PotionEffectType)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "CraftPotionEffectType[" + String.valueOf(this.getKey()) + "]";
    }

    @NotNull
    public NamespacedKey getKeyOrThrow() {
        Preconditions.checkState((boolean)this.isRegistered(), (Object)"Cannot get key of this registry item, because it is not registered. Use #isRegistered() before calling this method.");
        return this.key;
    }

    @Nullable
    public NamespacedKey getKeyOrNull() {
        return this.key;
    }

    public boolean isRegistered() {
        return this.key != null;
    }
}

