/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.scoreboard;

import com.google.common.base.Preconditions;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R7.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_21_R7.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_21_R7.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_21_R7.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_21_R7.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;

final class CraftObjective
extends CraftScoreboardComponent
implements Objective {
    private final fuj objective;
    private final CraftCriteria criteria;

    CraftObjective(CraftScoreboard scoreboard, fuj objective) {
        super(scoreboard);
        this.objective = objective;
        this.criteria = CraftCriteria.getFromNMS(objective);
    }

    fuj getHandle() {
        return this.objective;
    }

    public String getName() {
        this.checkState();
        return this.objective.c();
    }

    public String getDisplayName() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.objective.e());
    }

    public void setDisplayName(String displayName) {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"Display name cannot be null");
        this.checkState();
        this.objective.a(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getCriteria() {
        this.checkState();
        return this.criteria.bukkitName;
    }

    public Criteria getTrackedCriteria() {
        this.checkState();
        return this.criteria;
    }

    public boolean isModifiable() {
        this.checkState();
        return !this.criteria.criteria.e();
    }

    public void setDisplaySlot(DisplaySlot slot) {
        CraftScoreboard scoreboard = this.checkState();
        fur board = scoreboard.board;
        fuj objective = this.objective;
        for (fui i2 : fui.values()) {
            if (board.a(i2) != objective) continue;
            board.a(i2, null);
        }
        if (slot != null) {
            fui slotNumber = CraftScoreboardTranslations.fromBukkitSlot(slot);
            board.a(slotNumber, this.getHandle());
        }
    }

    public DisplaySlot getDisplaySlot() {
        CraftScoreboard scoreboard = this.checkState();
        fur board = scoreboard.board;
        fuj objective = this.objective;
        for (fui i2 : fui.values()) {
            if (board.a(i2) != objective) continue;
            return CraftScoreboardTranslations.toBukkitSlot(i2);
        }
        return null;
    }

    public void setRenderType(RenderType renderType) {
        Preconditions.checkArgument((renderType != null ? 1 : 0) != 0, (Object)"RenderType cannot be null");
        this.checkState();
        this.objective.a(CraftScoreboardTranslations.fromBukkitRender(renderType));
    }

    public RenderType getRenderType() {
        this.checkState();
        return CraftScoreboardTranslations.toBukkitRender(this.objective.i());
    }

    public Score getScore(OfflinePlayer player) {
        this.checkState();
        return new CraftScore(this, CraftScoreboard.getScoreHolder(player));
    }

    public Score getScore(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        Preconditions.checkArgument((entry.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (Object)("Score '" + entry + "' is longer than the limit of 32767 characters"));
        this.checkState();
        return new CraftScore(this, CraftScoreboard.getScoreHolder(entry));
    }

    @Override
    public void unregister() {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.j(this.objective);
    }

    @Override
    CraftScoreboard checkState() {
        Preconditions.checkState((this.getScoreboard().board.a(this.objective.c()) != null ? 1 : 0) != 0, (Object)"Unregistered scoreboard component");
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.objective != null ? this.objective.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftObjective other = (CraftObjective)obj;
        return this.objective == other.objective || this.objective != null && this.objective.equals(other.objective);
    }
}

