/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CraftNBTTagConfigSerializer {
    private static final Pattern ARRAY = Pattern.compile("^\\[.*]");
    private static final Pattern INTEGER = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)?i", 2);
    private static final Pattern DOUBLE = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final wa<vz> MOJANGSON_PARSER = wa.a(vn.a);

    public static String serialize(@NotNull vz base) {
        vv snbtVisitor = new vv();
        return snbtVisitor.a(base);
    }

    public static vz deserialize(Object object) {
        if (object instanceof String) {
            String snbtString = (String)object;
            try {
                return wa.a(snbtString);
            }
            catch (CommandSyntaxException e2) {
                throw new RuntimeException("Failed to deserialise nbt", e2);
            }
        }
        return CraftNBTTagConfigSerializer.internalLegacyDeserialization(object);
    }

    private static vz internalLegacyDeserialization(@NotNull Object object) {
        if (object instanceof Map) {
            uz compound = new uz();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                compound.a((String)entry.getKey(), CraftNBTTagConfigSerializer.internalLegacyDeserialization(entry.getValue()));
            }
            return compound;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return new vf();
            }
            vf tagList = new vf();
            for (Object tag : list) {
                tagList.add(CraftNBTTagConfigSerializer.internalLegacyDeserialization(tag));
            }
            return tagList;
        }
        if (object instanceof String) {
            vz nbtBase;
            String string = (String)object;
            if (ARRAY.matcher(string).matches()) {
                try {
                    return MOJANGSON_PARSER.b(new StringReader(string));
                }
                catch (CommandSyntaxException e2) {
                    throw new RuntimeException("Could not deserialize found list ", e2);
                }
            }
            if (INTEGER.matcher(string).matches()) {
                return ve.a(Integer.parseInt(string.substring(0, string.length() - 1)));
            }
            if (DOUBLE.matcher(string).matches()) {
                return va.a(Double.parseDouble(string.substring(0, string.length() - 1)));
            }
            try {
                nbtBase = MOJANGSON_PARSER.b(new StringReader(string));
            }
            catch (CommandSyntaxException e3) {
                throw new RuntimeException("Could not deserialize found value ", e3);
            }
            if (nbtBase instanceof ve) {
                return vx.a(String.valueOf(((ve)nbtBase).h()));
            }
            if (nbtBase instanceof va) {
                return vx.a(String.valueOf(((va)nbtBase).k()));
            }
            if (nbtBase instanceof vx) {
                return vx.a(string);
            }
            return nbtBase;
        }
        throw new RuntimeException("Could not deserialize NBTBase");
    }
}

