/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.MinecraftServer;
import org.bukkit.craftbukkit.v1_21_R7.SpigotTimings;
import org.spigotmc.SpigotWorldConfig;

public class ActivationRange {
    static fth maxBB = new fth(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public static ActivationType initializeEntityActivationType(cgk entity) {
        if (entity instanceof dfi) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof czz || entity instanceof dag) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof cht || entity instanceof ctd) {
            return ActivationType.ANIMAL;
        }
        return ActivationType.MISC;
    }

    public static boolean initializeEntityActivationState(cgk entity, SpigotWorldConfig config) {
        if (config == null) {
            return false;
        }
        return entity.activationType == ActivationType.MISC && config.miscActivationRange == 0 || entity.activationType == ActivationType.RAIDER && config.raiderActivationRange == 0 || entity.activationType == ActivationType.ANIMAL && config.animalActivationRange == 0 || entity.activationType == ActivationType.MONSTER && config.monsterActivationRange == 0 || entity instanceof ddm || entity instanceof deg || entity instanceof cyc || entity instanceof cyd || entity instanceof cyw || entity instanceof dem || entity instanceof chk || entity instanceof czm || entity instanceof cyb || entity instanceof ddy || entity instanceof dek;
    }

    public static void activateEntities(dwo world) {
        SpigotTimings.entityActivationCheckTimer.startTiming();
        int miscActivationRange = world.spigotConfig.miscActivationRange;
        int raiderActivationRange = world.spigotConfig.raiderActivationRange;
        int animalActivationRange = world.spigotConfig.animalActivationRange;
        int monsterActivationRange = world.spigotConfig.monsterActivationRange;
        int maxRange = Math.max(monsterActivationRange, animalActivationRange);
        maxRange = Math.max(maxRange, raiderActivationRange);
        maxRange = Math.max(maxRange, miscActivationRange);
        maxRange = Math.min((world.spigotConfig.simulationDistance << 4) - 8, maxRange);
        for (ddm ddm2 : world.E()) {
            ddm2.activatedTick = MinecraftServer.currentTick;
            if (world.spigotConfig.ignoreSpectatorActivation && ddm2.au()) continue;
            maxBB = ddm2.dj().c(maxRange, 256.0, maxRange);
            ActivationType.MISC.boundingBox = ddm2.dj().c(miscActivationRange, 256.0, miscActivationRange);
            ActivationType.RAIDER.boundingBox = ddm2.dj().c(raiderActivationRange, 256.0, raiderActivationRange);
            ActivationType.ANIMAL.boundingBox = ddm2.dj().c(animalActivationRange, 256.0, animalActivationRange);
            ActivationType.MONSTER.boundingBox = ddm2.dj().c(monsterActivationRange, 256.0, monsterActivationRange);
            world.M().a(maxBB, ActivationRange::activateEntity);
        }
        SpigotTimings.entityActivationCheckTimer.stopTiming();
    }

    private static void activateEntity(cgk entity) {
        if ((long)MinecraftServer.currentTick > entity.activatedTick) {
            if (entity.defaultActivationState) {
                entity.activatedTick = MinecraftServer.currentTick;
                return;
            }
            if (entity.activationType.boundingBox.c(entity.dj())) {
                entity.activatedTick = MinecraftServer.currentTick;
            }
        }
    }

    public static boolean checkEntityImmunities(cgk entity) {
        if (entity.au || entity.aS() > 0) {
            return true;
        }
        if (!(entity instanceof deh) ? !entity.aV() || !entity.aS.isEmpty() || entity.cq() : !((deh)entity).f()) {
            return true;
        }
        if (entity instanceof chl) {
            chl living = (chl)entity;
            if (living.bu > 0 || living.co.size() > 0) {
                return true;
            }
            if (entity instanceof cht && ((cht)entity).ag_() != null) {
                return true;
            }
            if (entity instanceof dcx && ((dcx)entity).Y_()) {
                return true;
            }
            if (entity instanceof cth) {
                cth animal = (cth)entity;
                if (animal.e_() || animal.hb()) {
                    return true;
                }
                if (entity instanceof cxj && ((cxj)entity).gQ()) {
                    return true;
                }
            }
            if (entity instanceof czp && ((czp)entity).gQ()) {
                return true;
            }
        }
        return entity instanceof cgz;
    }

    public static boolean checkIfActive(cgk entity) {
        boolean isActive;
        SpigotTimings.checkIfActiveTimer.startTiming();
        if (entity instanceof ddy || entity instanceof czl && (entity.at + entity.aA() + 1) % 4 == 0) {
            SpigotTimings.checkIfActiveTimer.stopTiming();
            return true;
        }
        boolean bl2 = isActive = entity.activatedTick >= (long)MinecraftServer.currentTick || entity.defaultActivationState;
        if (!isActive) {
            if (((long)MinecraftServer.currentTick - entity.activatedTick - 1L) % 20L == 0L) {
                if (ActivationRange.checkEntityImmunities(entity)) {
                    entity.activatedTick = MinecraftServer.currentTick + 20;
                }
                isActive = true;
            }
        } else if (!entity.defaultActivationState && entity.at % 4 == 0 && !ActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        SpigotTimings.checkIfActiveTimer.stopTiming();
        return isActive;
    }

    public static enum ActivationType {
        MONSTER,
        ANIMAL,
        RAIDER,
        MISC;

        fth boundingBox = new fth(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

