/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import org.apache.commons.io.FilenameUtils;

public class ResourceSelectorArgument<T>
implements ArgumentType<Collection<Holder.c<T>>> {
    private static final Collection<String> b = List.of("minecraft:*", "*:asset", "*");
    public static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.b("argument.resource_selector.not_found", var0, var1));
    final ResourceKey<? extends IRegistry<T>> c;
    private final HolderLookup<T> d;

    ResourceSelectorArgument(CommandBuildContext var0, ResourceKey<? extends IRegistry<T>> var1) {
        this.c = var1;
        this.d = var0.e(var1);
    }

    public Collection<Holder.c<T>> a(StringReader var0) throws CommandSyntaxException {
        String var12 = ResourceSelectorArgument.a(ResourceSelectorArgument.b(var0));
        List<Holder.c<T>> var2 = this.d.c().filter(var1 -> ResourceSelectorArgument.a(var12, var1.h().a())).toList();
        if (var2.isEmpty()) {
            throw a.createWithContext((ImmutableStringReader)var0, (Object)var12, (Object)this.c.a());
        }
        return var2;
    }

    public static <T> Collection<Holder.c<T>> a(StringReader var0, HolderLookup<T> var12) {
        String var2 = ResourceSelectorArgument.a(ResourceSelectorArgument.b(var0));
        return var12.c().filter(var1 -> ResourceSelectorArgument.a(var2, var1.h().a())).toList();
    }

    private static String b(StringReader var0) {
        int var1 = var0.getCursor();
        while (var0.canRead() && ResourceSelectorArgument.a(var0.peek())) {
            var0.skip();
        }
        return var0.getString().substring(var1, var0.getCursor());
    }

    private static boolean a(char var0) {
        return MinecraftKey.a(var0) || var0 == '*' || var0 == '?';
    }

    private static String a(String var0) {
        if (!var0.contains(":")) {
            return "minecraft:" + var0;
        }
        return var0;
    }

    private static boolean a(String var0, MinecraftKey var1) {
        return FilenameUtils.wildcardMatch((String)var1.toString(), (String)var0);
    }

    public static <T> ResourceSelectorArgument<T> a(CommandBuildContext var0, ResourceKey<? extends IRegistry<T>> var1) {
        return new ResourceSelectorArgument<T>(var0, var1);
    }

    public static <T> Collection<Holder.c<T>> a(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (Collection)var0.getArgument(var1, Collection.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.a(var0, var1, this.c, ICompletionProvider.a.b);
    }

    public Collection<String> getExamples() {
        return b;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    public static class net.minecraft.commands.arguments.ResourceSelectorArgument$a<T>
    implements ArgumentTypeInfo<ResourceSelectorArgument<T>, a> {
        @Override
        public void a(a var0, PacketDataSerializer var1) {
            var1.b(var0.b);
        }

        @Override
        public a a(PacketDataSerializer var0) {
            return new a(var0.r());
        }

        @Override
        public void a(a var0, JsonObject var1) {
            var1.addProperty("registry", var0.b.a().toString());
        }

        @Override
        public a a(ResourceSelectorArgument<T> var0) {
            return new a(var0.c);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a b(PacketDataSerializer packetDataSerializer) {
            return this.a(packetDataSerializer);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceSelectorArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> b;

            a(ResourceKey var1) {
                this.b = var1;
            }

            public ResourceSelectorArgument<T> a(CommandBuildContext var0) {
                return new ResourceSelectorArgument(var0, this.b);
            }

            @Override
            public ArgumentTypeInfo<ResourceSelectorArgument<T>, ?> a() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType b(CommandBuildContext commandBuildContext) {
                return this.a(commandBuildContext);
            }
        }
    }
}

