/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.jspecify.annotations.Nullable;

public class ArgumentBlock {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("argument.block.id.invalid", object));
    public static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.b("argument.block.property.unknown", object, object1));
    public static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.b("argument.block.property.duplicate", object1, object));
    public static final Dynamic3CommandExceptionType e = new Dynamic3CommandExceptionType((object, object1, object2) -> IChatBaseComponent.b("argument.block.property.invalid", object, object2, object1));
    public static final Dynamic2CommandExceptionType f = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.b("argument.block.property.novalue", object1, object));
    public static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.block.property.unclosed"));
    public static final DynamicCommandExceptionType h = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("arguments.block.tag.unknown", object));
    private static final char i = '[';
    private static final char j = '{';
    private static final char k = ']';
    private static final char l = '=';
    private static final char m = ',';
    private static final char n = '#';
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> o = SuggestionsBuilder::buildFuture;
    private final HolderLookup<Block> p;
    private final StringReader q;
    private final boolean r;
    private final boolean s;
    private final Map<IBlockState<?>, Comparable<?>> t = Maps.newLinkedHashMap();
    private final Map<String, String> u = Maps.newHashMap();
    private MinecraftKey v = MinecraftKey.b("");
    private @Nullable BlockStateList<Block, IBlockData> w;
    private @Nullable IBlockData x;
    private @Nullable NBTTagCompound y;
    private @Nullable HolderSet<Block> z;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> A = o;

    private ArgumentBlock(HolderLookup<Block> holderlookup, StringReader stringreader, boolean flag, boolean flag1) {
        this.p = holderlookup;
        this.q = stringreader;
        this.r = flag;
        this.s = flag1;
    }

    public static a a(HolderLookup<Block> holderlookup, String s2, boolean flag) throws CommandSyntaxException {
        return ArgumentBlock.a(holderlookup, new StringReader(s2), flag);
    }

    public static a a(HolderLookup<Block> holderlookup, StringReader stringreader, boolean flag) throws CommandSyntaxException {
        int i2 = stringreader.getCursor();
        try {
            ArgumentBlock argumentblock = new ArgumentBlock(holderlookup, stringreader, false, flag);
            argumentblock.a();
            return new a(argumentblock.x, argumentblock.t, argumentblock.y);
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            stringreader.setCursor(i2);
            throw commandsyntaxexception;
        }
    }

    public static Either<a, b> b(HolderLookup<Block> holderlookup, String s2, boolean flag) throws CommandSyntaxException {
        return ArgumentBlock.b(holderlookup, new StringReader(s2), flag);
    }

    public static Either<a, b> b(HolderLookup<Block> holderlookup, StringReader stringreader, boolean flag) throws CommandSyntaxException {
        int i2 = stringreader.getCursor();
        try {
            ArgumentBlock argumentblock = new ArgumentBlock(holderlookup, stringreader, true, flag);
            argumentblock.a();
            return argumentblock.z != null ? Either.right((Object)new b(argumentblock.z, argumentblock.u, argumentblock.y)) : Either.left((Object)new a(argumentblock.x, argumentblock.t, argumentblock.y));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            stringreader.setCursor(i2);
            throw commandsyntaxexception;
        }
    }

    public static CompletableFuture<Suggestions> a(HolderLookup<Block> holderlookup, SuggestionsBuilder suggestionsbuilder, boolean flag, boolean flag1) {
        StringReader stringreader = new StringReader(suggestionsbuilder.getInput());
        stringreader.setCursor(suggestionsbuilder.getStart());
        ArgumentBlock argumentblock = new ArgumentBlock(holderlookup, stringreader, flag, flag1);
        try {
            argumentblock.a();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return argumentblock.A.apply(suggestionsbuilder.createOffset(stringreader.getCursor()));
    }

    private void a() throws CommandSyntaxException {
        this.A = this.r ? this::l : this::k;
        if (this.q.canRead() && this.q.peek() == '#') {
            this.d();
            this.A = this::h;
            if (this.q.canRead() && this.q.peek() == '[') {
                this.f();
                this.A = this::e;
            }
        } else {
            this.c();
            this.A = this::i;
            if (this.q.canRead() && this.q.peek() == '[') {
                this.e();
                this.A = this::e;
            }
        }
        if (this.s && this.q.canRead() && this.q.peek() == '{') {
            this.A = o;
            this.g();
        }
    }

    private CompletableFuture<Suggestions> a(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty()) {
            suggestionsbuilder.suggest(String.valueOf(']'));
        }
        return this.c(suggestionsbuilder);
    }

    private CompletableFuture<Suggestions> b(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty()) {
            suggestionsbuilder.suggest(String.valueOf(']'));
        }
        return this.d(suggestionsbuilder);
    }

    private CompletableFuture<Suggestions> c(SuggestionsBuilder suggestionsbuilder) {
        String s2 = suggestionsbuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (IBlockState<?> iblockstate : this.x.F()) {
            if (this.t.containsKey(iblockstate) || !iblockstate.f().startsWith(s2)) continue;
            suggestionsbuilder.suggest(iblockstate.f() + "=");
        }
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> d(SuggestionsBuilder suggestionsbuilder) {
        String s2 = suggestionsbuilder.getRemaining().toLowerCase(Locale.ROOT);
        if (this.z != null) {
            for (Holder holder : this.z) {
                for (IBlockState<?> iblockstate : ((Block)holder.a()).l().d()) {
                    if (this.u.containsKey(iblockstate.f()) || !iblockstate.f().startsWith(s2)) continue;
                    suggestionsbuilder.suggest(iblockstate.f() + "=");
                }
            }
        }
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> e(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty() && this.b()) {
            suggestionsbuilder.suggest(String.valueOf('{'));
        }
        return suggestionsbuilder.buildFuture();
    }

    private boolean b() {
        if (this.x != null) {
            return this.x.x();
        }
        if (this.z != null) {
            for (Holder holder : this.z) {
                if (!((Block)holder.a()).m().x()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> f(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty()) {
            suggestionsbuilder.suggest(String.valueOf('='));
        }
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> g(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty()) {
            suggestionsbuilder.suggest(String.valueOf(']'));
        }
        if (suggestionsbuilder.getRemaining().isEmpty() && this.t.size() < this.x.F().size()) {
            suggestionsbuilder.suggest(String.valueOf(','));
        }
        return suggestionsbuilder.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder a(SuggestionsBuilder suggestionsbuilder, IBlockState<T> iblockstate) {
        for (Comparable t0 : iblockstate.a()) {
            if (t0 instanceof Integer) {
                Integer integer = (Integer)t0;
                suggestionsbuilder.suggest(integer.intValue());
                continue;
            }
            suggestionsbuilder.suggest(iblockstate.b(t0));
        }
        return suggestionsbuilder;
    }

    private CompletableFuture<Suggestions> a(SuggestionsBuilder suggestionsbuilder, String s2) {
        boolean flag = false;
        if (this.z != null) {
            block0: for (Holder holder : this.z) {
                Block block = (Block)holder.a();
                IBlockState<?> iblockstate = block.l().a(s2);
                if (iblockstate != null) {
                    ArgumentBlock.a(suggestionsbuilder, iblockstate);
                }
                if (flag) continue;
                for (IBlockState<?> iblockstate1 : block.l().d()) {
                    if (this.u.containsKey(iblockstate1.f())) continue;
                    flag = true;
                    continue block0;
                }
            }
        }
        if (flag) {
            suggestionsbuilder.suggest(String.valueOf(','));
        }
        suggestionsbuilder.suggest(String.valueOf(']'));
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> h(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty() && this.z != null) {
            Holder holder;
            Block block;
            boolean flag = false;
            boolean flag1 = false;
            Iterator iterator = this.z.iterator();
            while (!(!iterator.hasNext() || (flag |= !(block = (Block)(holder = (Holder)iterator.next()).a()).l().d().isEmpty()) && (flag1 |= block.m().x()))) {
            }
            if (flag) {
                suggestionsbuilder.suggest(String.valueOf('['));
            }
            if (flag1) {
                suggestionsbuilder.suggest(String.valueOf('{'));
            }
        }
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> i(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty()) {
            if (!this.w.d().isEmpty()) {
                suggestionsbuilder.suggest(String.valueOf('['));
            }
            if (this.x.x()) {
                suggestionsbuilder.suggest(String.valueOf('{'));
            }
        }
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> j(SuggestionsBuilder suggestionsbuilder) {
        return ICompletionProvider.a(this.p.f().map(TagKey::b), suggestionsbuilder, String.valueOf('#'));
    }

    private CompletableFuture<Suggestions> k(SuggestionsBuilder suggestionsbuilder) {
        return ICompletionProvider.a(this.p.c_().map(ResourceKey::a), suggestionsbuilder);
    }

    private CompletableFuture<Suggestions> l(SuggestionsBuilder suggestionsbuilder) {
        this.j(suggestionsbuilder);
        this.k(suggestionsbuilder);
        return suggestionsbuilder.buildFuture();
    }

    private void c() throws CommandSyntaxException {
        int i2 = this.q.getCursor();
        this.v = MinecraftKey.a(this.q);
        Block block = this.p.a(ResourceKey.a(Registries.i, this.v)).orElseThrow(() -> {
            this.q.setCursor(i2);
            return b.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString());
        }).a();
        this.w = block.l();
        this.x = block.m();
    }

    private void d() throws CommandSyntaxException {
        if (!this.r) {
            throw a.createWithContext((ImmutableStringReader)this.q);
        }
        int i2 = this.q.getCursor();
        this.q.expect('#');
        this.A = this::j;
        MinecraftKey minecraftkey = MinecraftKey.a(this.q);
        this.z = this.p.a(TagKey.a(Registries.i, minecraftkey)).orElseThrow(() -> {
            this.q.setCursor(i2);
            return h.createWithContext((ImmutableStringReader)this.q, (Object)minecraftkey.toString());
        });
    }

    private void e() throws CommandSyntaxException {
        this.q.skip();
        this.A = this::a;
        this.q.skipWhitespace();
        while (this.q.canRead() && this.q.peek() != ']') {
            this.q.skipWhitespace();
            int i2 = this.q.getCursor();
            String s2 = this.q.readString();
            IBlockState<?> iblockstate = this.w.a(s2);
            if (iblockstate == null) {
                this.q.setCursor(i2);
                throw c.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)s2);
            }
            if (this.t.containsKey(iblockstate)) {
                this.q.setCursor(i2);
                throw d.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)s2);
            }
            this.q.skipWhitespace();
            this.A = this::f;
            if (!this.q.canRead() || this.q.peek() != '=') {
                throw f.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)s2);
            }
            this.q.skip();
            this.q.skipWhitespace();
            this.A = suggestionsbuilder -> ArgumentBlock.a(suggestionsbuilder, iblockstate).buildFuture();
            int j2 = this.q.getCursor();
            this.a(iblockstate, this.q.readString(), j2);
            this.A = this::g;
            this.q.skipWhitespace();
            if (!this.q.canRead()) continue;
            if (this.q.peek() == ',') {
                this.q.skip();
                this.A = this::c;
                continue;
            }
            if (this.q.peek() == ']') break;
            throw g.createWithContext((ImmutableStringReader)this.q);
        }
        if (this.q.canRead()) {
            this.q.skip();
            return;
        }
        throw g.createWithContext((ImmutableStringReader)this.q);
    }

    private void f() throws CommandSyntaxException {
        this.q.skip();
        this.A = this::b;
        int i2 = -1;
        this.q.skipWhitespace();
        while (this.q.canRead() && this.q.peek() != ']') {
            this.q.skipWhitespace();
            int j2 = this.q.getCursor();
            String s2 = this.q.readString();
            if (this.u.containsKey(s2)) {
                this.q.setCursor(j2);
                throw d.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)s2);
            }
            this.q.skipWhitespace();
            if (!this.q.canRead() || this.q.peek() != '=') {
                this.q.setCursor(j2);
                throw f.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)s2);
            }
            this.q.skip();
            this.q.skipWhitespace();
            this.A = suggestionsbuilder -> this.a((SuggestionsBuilder)suggestionsbuilder, s2);
            i2 = this.q.getCursor();
            String s1 = this.q.readString();
            this.u.put(s2, s1);
            this.q.skipWhitespace();
            if (!this.q.canRead()) continue;
            i2 = -1;
            if (this.q.peek() == ',') {
                this.q.skip();
                this.A = this::d;
                continue;
            }
            if (this.q.peek() == ']') break;
            throw g.createWithContext((ImmutableStringReader)this.q);
        }
        if (this.q.canRead()) {
            this.q.skip();
            return;
        }
        if (i2 >= 0) {
            this.q.setCursor(i2);
        }
        throw g.createWithContext((ImmutableStringReader)this.q);
    }

    private void g() throws CommandSyntaxException {
        this.y = MojangsonParser.c(this.q);
    }

    private <T extends Comparable<T>> void a(IBlockState<T> iblockstate, String s2, int i2) throws CommandSyntaxException {
        Optional<T> optional = iblockstate.b(s2);
        if (!optional.isPresent()) {
            this.q.setCursor(i2);
            throw e.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)iblockstate.f(), (Object)s2);
        }
        this.x = (IBlockData)this.x.b(iblockstate, (Comparable)optional.get());
        this.t.put(iblockstate, (Comparable)optional.get());
    }

    public static String a(IBlockData iblockdata) {
        StringBuilder stringbuilder = new StringBuilder(iblockdata.c().e().map(resourcekey -> resourcekey.a().toString()).orElse("air"));
        if (!iblockdata.F().isEmpty()) {
            stringbuilder.append('[');
            boolean flag = false;
            for (Map.Entry<IBlockState<?>, Comparable<?>> map_entry : iblockdata.G().entrySet()) {
                if (flag) {
                    stringbuilder.append(',');
                }
                ArgumentBlock.a(stringbuilder, map_entry.getKey(), map_entry.getValue());
                flag = true;
            }
            stringbuilder.append(']');
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> void a(StringBuilder stringbuilder, IBlockState<T> iblockstate, Comparable<?> comparable) {
        stringbuilder.append(iblockstate.f());
        stringbuilder.append('=');
        stringbuilder.append(iblockstate.b(comparable));
    }

    public record a(IBlockData a, Map<IBlockState<?>, Comparable<?>> b, @Nullable NBTTagCompound c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockState;properties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockState;properties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockState;properties;nbt", "a", "b", "c"}, this, o2);
        }
    }

    public record b(HolderSet<Block> a, Map<String, String> b, @Nullable NBTTagCompound c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "tag;vagueProperties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "tag;vagueProperties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "tag;vagueProperties;nbt", "a", "b", "c"}, this, o2);
        }
    }
}

