/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ARGB;
import net.minecraft.util.LenientJsonParser;
import net.minecraft.util.MathHelper;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public interface ByteBufCodecs {
    public static final int a = 65536;
    public static final StreamCodec<ByteBuf, Boolean> b = new StreamCodec<ByteBuf, Boolean>(){

        public Boolean a(ByteBuf var0) {
            return var0.readBoolean();
        }

        public void a(ByteBuf var0, Boolean var1) {
            var0.writeBoolean(var1.booleanValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Boolean)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Byte> c = new StreamCodec<ByteBuf, Byte>(){

        public Byte a(ByteBuf var0) {
            return var0.readByte();
        }

        public void a(ByteBuf var0, Byte var1) {
            var0.writeByte((int)var1.byteValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Byte)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Float> d = c.a(MathHelper::a, MathHelper::e);
    public static final StreamCodec<ByteBuf, Short> e = new StreamCodec<ByteBuf, Short>(){

        public Short a(ByteBuf var0) {
            return var0.readShort();
        }

        public void a(ByteBuf var0, Short var1) {
            var0.writeShort((int)var1.shortValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Short)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> f = new StreamCodec<ByteBuf, Integer>(){

        public Integer a(ByteBuf var0) {
            return var0.readUnsignedShort();
        }

        public void a(ByteBuf var0, Integer var1) {
            var0.writeShort(var1.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> g = new StreamCodec<ByteBuf, Integer>(){

        public Integer a(ByteBuf var0) {
            return var0.readInt();
        }

        public void a(ByteBuf var0, Integer var1) {
            var0.writeInt(var1.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> h = new StreamCodec<ByteBuf, Integer>(){

        public Integer a(ByteBuf var0) {
            return VarInt.a(var0);
        }

        public void a(ByteBuf var0, Integer var1) {
            VarInt.a(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, OptionalInt> i = h.a(var0 -> var0 == 0 ? OptionalInt.empty() : OptionalInt.of(var0 - 1), var0 -> var0.isPresent() ? var0.getAsInt() + 1 : 0);
    public static final StreamCodec<ByteBuf, Long> j = new StreamCodec<ByteBuf, Long>(){

        public Long a(ByteBuf var0) {
            return var0.readLong();
        }

        public void a(ByteBuf var0, Long var1) {
            var0.writeLong(var1.longValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Long)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Long> k = new StreamCodec<ByteBuf, Long>(){

        public Long a(ByteBuf var0) {
            return VarLong.a(var0);
        }

        public void a(ByteBuf var0, Long var1) {
            VarLong.a(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Long)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Float> l = new StreamCodec<ByteBuf, Float>(){

        public Float a(ByteBuf var0) {
            return Float.valueOf(var0.readFloat());
        }

        public void a(ByteBuf var0, Float var1) {
            var0.writeFloat(var1.floatValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Float)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Double> m = new StreamCodec<ByteBuf, Double>(){

        public Double a(ByteBuf var0) {
            return var0.readDouble();
        }

        public void a(ByteBuf var0, Double var1) {
            var0.writeDouble(var1.doubleValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Double)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, byte[]> n = new StreamCodec<ByteBuf, byte[]>(){

        public byte[] a(ByteBuf var0) {
            return PacketDataSerializer.a(var0);
        }

        public void a(ByteBuf var0, byte[] var1) {
            PacketDataSerializer.a(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (byte[])object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, long[]> o = new StreamCodec<ByteBuf, long[]>(){

        public long[] a(ByteBuf var0) {
            return PacketDataSerializer.b(var0);
        }

        public void a(ByteBuf var0, long[] var1) {
            PacketDataSerializer.a(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (long[])object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, String> p = ByteBufCodecs.b(Short.MAX_VALUE);
    public static final StreamCodec<ByteBuf, NBTBase> q = ByteBufCodecs.b(NBTReadLimiter::a);
    public static final StreamCodec<ByteBuf, NBTBase> r = ByteBufCodecs.b(NBTReadLimiter::c);
    public static final StreamCodec<ByteBuf, NBTTagCompound> s = ByteBufCodecs.c(NBTReadLimiter::a);
    public static final StreamCodec<ByteBuf, NBTTagCompound> t = ByteBufCodecs.c(NBTReadLimiter::c);
    public static final StreamCodec<ByteBuf, Optional<NBTTagCompound>> u = new StreamCodec<ByteBuf, Optional<NBTTagCompound>>(){

        public Optional<NBTTagCompound> a(ByteBuf var0) {
            return Optional.ofNullable(PacketDataSerializer.i(var0));
        }

        public void a(ByteBuf var0, Optional<NBTTagCompound> var1) {
            PacketDataSerializer.a(var0, var1.orElse(null));
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Optional)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Vector3fc> v = new StreamCodec<ByteBuf, Vector3fc>(){

        public Vector3fc a(ByteBuf var0) {
            return PacketDataSerializer.e(var0);
        }

        public void a(ByteBuf var0, Vector3fc var1) {
            PacketDataSerializer.a(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Vector3fc)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Quaternionfc> w = new StreamCodec<ByteBuf, Quaternionfc>(){

        public Quaternionfc a(ByteBuf var0) {
            return PacketDataSerializer.f(var0);
        }

        public void a(ByteBuf var0, Quaternionfc var1) {
            PacketDataSerializer.a(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Quaternionfc)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> x = new StreamCodec<ByteBuf, Integer>(){

        public Integer a(ByteBuf var0) {
            return PacketDataSerializer.j(var0);
        }

        public void a(ByteBuf var0, Integer var1) {
            PacketDataSerializer.b(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, PropertyMap> y = new StreamCodec<ByteBuf, PropertyMap>(){

        public PropertyMap a(ByteBuf var02) {
            int var1 = ByteBufCodecs.a(var02, 16);
            ImmutableMultimap.Builder var2 = ImmutableMultimap.builder();
            for (int var3 = 0; var3 < var1; ++var3) {
                String var4 = Utf8String.a(var02, 64);
                String var5 = Utf8String.a(var02, Short.MAX_VALUE);
                String var6 = PacketDataSerializer.a(var02, (? super B var0) -> Utf8String.a(var0, 1024));
                Property var7 = new Property(var4, var5, var6);
                var2.put((Object)var7.name(), (Object)var7);
            }
            return new PropertyMap((Multimap)var2.build());
        }

        public void a(ByteBuf var02, PropertyMap var12) {
            ByteBufCodecs.a(var02, var12.size(), 16);
            for (Property var3 : var12.values()) {
                Utf8String.a(var02, var3.name(), 64);
                Utf8String.a(var02, var3.value(), Short.MAX_VALUE);
                PacketDataSerializer.a(var02, var3.signature(), (? super B var0, T var1) -> Utf8String.a(var0, var1, 1024));
            }
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (PropertyMap)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, String> z = ByteBufCodecs.b(16);
    public static final StreamCodec<ByteBuf, GameProfile> A = StreamCodec.a(UUIDUtil.g, GameProfile::id, z, GameProfile::name, y, GameProfile::properties, GameProfile::new);
    public static final StreamCodec<ByteBuf, Integer> B = new StreamCodec<ByteBuf, Integer>(){

        public Integer a(ByteBuf var0) {
            return ARGB.a(var0.readByte() & 0xFF, var0.readByte() & 0xFF, var0.readByte() & 0xFF);
        }

        public void a(ByteBuf var0, Integer var1) {
            var0.writeByte(ARGB.c(var1));
            var0.writeByte(ARGB.d(var1));
            var0.writeByte(ARGB.e(var1));
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };

    public static StreamCodec<ByteBuf, byte[]> a(final int var0) {
        return new StreamCodec<ByteBuf, byte[]>(){

            public byte[] a(ByteBuf var02) {
                return PacketDataSerializer.a(var02, var0);
            }

            public void a(ByteBuf var02, byte[] var1) {
                if (var1.length > var0) {
                    throw new EncoderException("ByteArray with size " + var1.length + " is bigger than allowed " + var0);
                }
                PacketDataSerializer.a(var02, var1);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, (byte[])object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, String> b(final int var0) {
        return new StreamCodec<ByteBuf, String>(){

            public String a(ByteBuf var02) {
                return Utf8String.a(var02, var0);
            }

            public void a(ByteBuf var02, String var1) {
                Utf8String.a(var02, var1, var0);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, (String)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, Optional<NBTBase>> a(final Supplier<NBTReadLimiter> var0) {
        return new StreamCodec<ByteBuf, Optional<NBTBase>>(){

            public Optional<NBTBase> a(ByteBuf var02) {
                return Optional.ofNullable(PacketDataSerializer.a(var02, (NBTReadLimiter)var0.get()));
            }

            public void a(ByteBuf var02, Optional<NBTBase> var1) {
                PacketDataSerializer.a(var02, var1.orElse(null));
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, (Optional)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, NBTBase> b(final Supplier<NBTReadLimiter> var0) {
        return new StreamCodec<ByteBuf, NBTBase>(){

            public NBTBase a(ByteBuf var02) {
                NBTBase var1 = PacketDataSerializer.a(var02, (NBTReadLimiter)var0.get());
                if (var1 == null) {
                    throw new DecoderException("Expected non-null compound tag");
                }
                return var1;
            }

            public void a(ByteBuf var02, NBTBase var1) {
                if (var1 == NBTTagEnd.b) {
                    throw new EncoderException("Expected non-null compound tag");
                }
                PacketDataSerializer.a(var02, var1);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, (NBTBase)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, NBTTagCompound> c(Supplier<NBTReadLimiter> var02) {
        return ByteBufCodecs.b(var02).a(var0 -> {
            if (var0 instanceof NBTTagCompound) {
                NBTTagCompound var1 = (NBTTagCompound)var0;
                return var1;
            }
            throw new DecoderException("Not a compound tag: " + String.valueOf(var0));
        }, var0 -> var0);
    }

    public static <T> StreamCodec<ByteBuf, T> a(Codec<T> var0) {
        return ByteBufCodecs.a(var0, NBTReadLimiter::c);
    }

    public static <T> StreamCodec<ByteBuf, T> b(Codec<T> var0) {
        return ByteBufCodecs.a(var0, NBTReadLimiter::a);
    }

    public static <T, B extends ByteBuf, V> StreamCodec.a<B, T, V> a(final DynamicOps<T> var0, final Codec<V> var1) {
        return var2 -> new StreamCodec<B, V>(){

            public V a(B var02) {
                Object var12 = var2.decode(var02);
                return var1.parse(var0, var12).getOrThrow(var1 -> new DecoderException("Failed to decode: " + var1 + " " + String.valueOf(var12)));
            }

            public void a(B var02, V var12) {
                Object var22 = var1.encodeStart(var0, var12).getOrThrow(var1 -> new EncoderException("Failed to encode: " + var1 + " " + String.valueOf(var12)));
                var2.encode(var02, var22);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> a(Codec<T> var0, Supplier<NBTReadLimiter> var1) {
        return ByteBufCodecs.b(var1).a(ByteBufCodecs.a(DynamicOpsNBT.a, var0));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> c(Codec<T> var0) {
        return ByteBufCodecs.b(var0, NBTReadLimiter::c);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> d(Codec<T> var0) {
        return ByteBufCodecs.b(var0, NBTReadLimiter::a);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> b(final Codec<T> var0, Supplier<NBTReadLimiter> var1) {
        final StreamCodec<ByteBuf, NBTBase> var2 = ByteBufCodecs.b(var1);
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            public T a(RegistryFriendlyByteBuf var02) {
                NBTBase var12 = (NBTBase)var2.decode(var02);
                RegistryOps<NBTBase> var22 = var02.G().a(DynamicOpsNBT.a);
                return var0.parse(var22, (Object)var12).getOrThrow(var1 -> new DecoderException("Failed to decode: " + var1 + " " + String.valueOf(var12)));
            }

            public void a(RegistryFriendlyByteBuf var02, T var12) {
                RegistryOps<NBTBase> var22 = var02.G().a(DynamicOpsNBT.a);
                NBTBase var3 = (NBTBase)var0.encodeStart(var22, var12).getOrThrow(var1 -> new EncoderException("Failed to encode: " + var1 + " " + String.valueOf(var12)));
                var2.encode(var02, var3);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((RegistryFriendlyByteBuf)((Object)object), object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, Optional<V>> a(final StreamCodec<? super B, V> var0) {
        return new StreamCodec<B, Optional<V>>(){

            public Optional<V> a(B var02) {
                if (var02.readBoolean()) {
                    return Optional.of(var0.decode(var02));
                }
                return Optional.empty();
            }

            public void a(B var02, Optional<V> var1) {
                if (var1.isPresent()) {
                    var02.writeBoolean(true);
                    var0.encode(var02, var1.get());
                } else {
                    var02.writeBoolean(false);
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, (Optional)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }

    public static int a(ByteBuf var0, int var1) {
        int var2 = VarInt.a(var0);
        if (var2 > var1) {
            throw new DecoderException(var2 + " elements exceeded max size of: " + var1);
        }
        return var2;
    }

    public static void a(ByteBuf var0, int var1, int var2) {
        if (var1 > var2) {
            throw new EncoderException(var1 + " elements exceeded max size of: " + var2);
        }
        VarInt.a(var0, var1);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> a(IntFunction<C> var0, StreamCodec<? super B, V> var1) {
        return ByteBufCodecs.a(var0, var1, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> a(final IntFunction<C> var0, final StreamCodec<? super B, V> var1, final int var2) {
        return new StreamCodec<B, C>(){

            public C a(B var02) {
                int var12 = ByteBufCodecs.a(var02, var2);
                Collection var22 = (Collection)var0.apply(Math.min(var12, 65536));
                for (int var3 = 0; var3 < var12; ++var3) {
                    var22.add(var1.decode(var02));
                }
                return var22;
            }

            public void a(B var02, C var12) {
                ByteBufCodecs.a(var02, var12.size(), var2);
                for (Object var3 : var12) {
                    var1.encode(var02, var3);
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, (Collection)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec.a<B, V, C> a(IntFunction<C> var0) {
        return var1 -> ByteBufCodecs.a(var0, var1);
    }

    public static <B extends ByteBuf, V> StreamCodec.a<B, V, List<V>> a() {
        return var0 -> ByteBufCodecs.a(ArrayList::new, var0);
    }

    public static <B extends ByteBuf, V> StreamCodec.a<B, V, List<V>> c(int var0) {
        return var1 -> ByteBufCodecs.a(ArrayList::new, var1, var0);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> a(IntFunction<? extends M> var0, StreamCodec<? super B, K> var1, StreamCodec<? super B, V> var2) {
        return ByteBufCodecs.a(var0, var1, var2, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> a(final IntFunction<? extends M> var0, final StreamCodec<? super B, K> var1, final StreamCodec<? super B, V> var2, final int var3) {
        return new StreamCodec<B, M>(){

            public void a(B var02, M var12) {
                ByteBufCodecs.a(var02, var12.size(), var3);
                var12.forEach((var3, var4) -> {
                    var1.encode(var02, var3);
                    var2.encode(var02, var4);
                });
            }

            public M a(B var02) {
                int var12 = ByteBufCodecs.a(var02, var3);
                Map var22 = (Map)var0.apply(Math.min(var12, 65536));
                for (int var32 = 0; var32 < var12; ++var32) {
                    Object var4 = var1.decode(var02);
                    Object var5 = var2.decode(var02);
                    var22.put(var4, var5);
                }
                return var22;
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, (Map)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Either<L, R>> a(final StreamCodec<? super B, L> var0, final StreamCodec<? super B, R> var1) {
        return new StreamCodec<B, Either<L, R>>(){

            @Override
            public Either<L, R> a(B var02) {
                if (var02.readBoolean()) {
                    return Either.left(var0.decode(var02));
                }
                return Either.right(var1.decode(var02));
            }

            public void a(B var02, Either<L, R> var12) {
                var12.ifLeft(var2 -> {
                    var02.writeBoolean(true);
                    var0.encode(var02, var2);
                }).ifRight(var2 -> {
                    var02.writeBoolean(false);
                    var1.encode(var02, var2);
                });
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, (Either)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec.a<B, V, V> a(final int var0, final BiFunction<B, ByteBuf, B> var1) {
        return var2 -> new StreamCodec<B, V>(){

            public V a(B var02) {
                int var12 = VarInt.a(var02);
                if (var12 > var0) {
                    throw new DecoderException("Buffer size " + var12 + " is larger than allowed limit of " + var0);
                }
                int var22 = var02.readerIndex();
                ByteBuf var3 = (ByteBuf)var1.apply(var02, var02.slice(var22, var12));
                var02.readerIndex(var22 + var12);
                return var2.decode(var3);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void a(B var02, V var12) {
                ByteBuf var22 = (ByteBuf)var1.apply(var02, var02.alloc().buffer());
                try {
                    var2.encode(var22, var12);
                    int var3 = var22.readableBytes();
                    if (var3 > var0) {
                        throw new EncoderException("Buffer size " + var3 + " is  larger than allowed limit of " + var0);
                    }
                    VarInt.a(var02, var3);
                    var02.writeBytes(var22);
                }
                finally {
                    var22.release();
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }

    public static <V> StreamCodec.a<ByteBuf, V, V> d(int var02) {
        return ByteBufCodecs.a(var02, (B var0, ByteBuf var1) -> var1);
    }

    public static <V> StreamCodec.a<RegistryFriendlyByteBuf, V, V> e(int var02) {
        return ByteBufCodecs.a(var02, (B var0, ByteBuf var1) -> new RegistryFriendlyByteBuf((ByteBuf)var1, var0.G()));
    }

    public static <T> StreamCodec<ByteBuf, T> a(final IntFunction<T> var0, final ToIntFunction<T> var1) {
        return new StreamCodec<ByteBuf, T>(){

            public T a(ByteBuf var02) {
                int var12 = VarInt.a(var02);
                return var0.apply(var12);
            }

            public void a(ByteBuf var02, T var12) {
                int var2 = var1.applyAsInt(var12);
                VarInt.a(var02, var2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> a(Registry<T> var0) {
        return ByteBufCodecs.a(var0::b, var0::c);
    }

    private static <T, R> StreamCodec<RegistryFriendlyByteBuf, R> a(final ResourceKey<? extends IRegistry<T>> var0, final Function<IRegistry<T>, Registry<R>> var1) {
        return new StreamCodec<RegistryFriendlyByteBuf, R>(){

            private Registry<R> b(RegistryFriendlyByteBuf var02) {
                return (Registry)var1.apply(var02.G().f(var0));
            }

            public R a(RegistryFriendlyByteBuf var02) {
                int var12 = VarInt.a(var02);
                return this.b(var02).b(var12);
            }

            public void a(RegistryFriendlyByteBuf var02, R var12) {
                int var2 = this.b(var02).c(var12);
                VarInt.a(var02, var2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((RegistryFriendlyByteBuf)((Object)object), object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> a(ResourceKey<? extends IRegistry<T>> var02) {
        return ByteBufCodecs.a(var02, (IRegistry<T> var0) -> var0);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> b(ResourceKey<? extends IRegistry<T>> var0) {
        return ByteBufCodecs.a(var0, IRegistry::t);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> a(final ResourceKey<? extends IRegistry<T>> var0, final StreamCodec<? super RegistryFriendlyByteBuf, T> var1) {
        return new StreamCodec<RegistryFriendlyByteBuf, Holder<T>>(){
            private static final int c = 0;

            private Registry<Holder<T>> b(RegistryFriendlyByteBuf var02) {
                return var02.G().f(var0).t();
            }

            public Holder<T> a(RegistryFriendlyByteBuf var02) {
                int var12 = VarInt.a(var02);
                if (var12 == 0) {
                    return Holder.a(var1.decode(var02));
                }
                return this.b(var02).b(var12 - 1);
            }

            public void a(RegistryFriendlyByteBuf var02, Holder<T> var12) {
                switch (var12.f()) {
                    case a: {
                        int var2 = this.b(var02).c(var12);
                        VarInt.a(var02, var2 + 1);
                        break;
                    }
                    case b: {
                        VarInt.a(var02, 0);
                        var1.encode(var02, var12.a());
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((RegistryFriendlyByteBuf)((Object)object), (Holder)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> c(final ResourceKey<? extends IRegistry<T>> var0) {
        return new StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>>(){
            private static final int b = -1;
            private final StreamCodec<RegistryFriendlyByteBuf, Holder<T>> c;
            {
                this.c = ByteBufCodecs.b(var0);
            }

            public HolderSet<T> a(RegistryFriendlyByteBuf var02) {
                int var1 = VarInt.a(var02) - 1;
                if (var1 == -1) {
                    IRegistry var2 = var02.G().f(var0);
                    return (HolderSet)var2.a(TagKey.a(var0, (MinecraftKey)MinecraftKey.b.decode(var02))).orElseThrow();
                }
                ArrayList<Holder> var2 = new ArrayList<Holder>(Math.min(var1, 65536));
                for (int var3 = 0; var3 < var1; ++var3) {
                    var2.add((Holder)this.c.decode(var02));
                }
                return HolderSet.a(var2);
            }

            public void a(RegistryFriendlyByteBuf var02, HolderSet<T> var1) {
                Optional var2 = var1.e();
                if (var2.isPresent()) {
                    VarInt.a(var02, 0);
                    MinecraftKey.b.encode(var02, var2.get().b());
                } else {
                    VarInt.a(var02, var1.b() + 1);
                    for (Holder holder : var1) {
                        this.c.encode(var02, holder);
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((RegistryFriendlyByteBuf)((Object)object), (HolderSet)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static StreamCodec<ByteBuf, JsonElement> f(final int var0) {
        return new StreamCodec<ByteBuf, JsonElement>(){
            private static final Gson b = new GsonBuilder().disableHtmlEscaping().create();

            public JsonElement a(ByteBuf var02) {
                String var1 = Utf8String.a(var02, var0);
                try {
                    return LenientJsonParser.a(var1);
                }
                catch (JsonSyntaxException var2) {
                    throw new DecoderException("Failed to parse JSON", (Throwable)var2);
                }
            }

            public void a(ByteBuf var02, JsonElement var1) {
                String var2 = b.toJson(var1);
                Utf8String.a(var02, var2, var0);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.a((ByteBuf)object, (JsonElement)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.a((ByteBuf)object);
            }
        };
    }
}

