/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionSet;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.PacketProcessor;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.Main;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.SuppressedExceptionCollector;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.DemoPlayerInteractManager;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.ChunkLoadStatusView;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerConnection;
import net.minecraft.server.notifications.NotificationManager;
import net.minecraft.server.notifications.ServerActivityMonitor;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteList;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.tags.TagDataPack;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.ModCheck;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.PngInfo;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.TimeRange;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.debug.ServerDebugSubscribers;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.GameProfilerTick;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.IAsyncTaskHandlerReentrant;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Stopwatches;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.wanderingtrader.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleTypeVisitor;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.PersistentCommandStorage;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.PersistentScoreboard;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R7.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.PluginLoadOrder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.CustomTimingsHandler;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends IAsyncTaskHandlerReentrant<TickTask>
implements ServerInfo,
ICommandListener,
ChunkIOErrorReporter {
    public static final Logger m = LogUtils.getLogger();
    public static final String b = "vanilla";
    private static final float n = 0.8f;
    private static final int o = 100;
    private static final long p = 30L * TimeRange.a / 20L;
    private static final int q = 20;
    private static final long r = 10L * TimeRange.a;
    private static final int s = 100;
    private static final long t = 5L * TimeRange.a;
    private static final long u = 10L * TimeRange.b;
    private static final int v = 12;
    public static final int c = 5;
    private static final int w = 30;
    private static final int x = 6000;
    private static final int y = 100;
    private static final int z = 3;
    public static final int d = 29999984;
    public static final WorldSettings e = new WorldSettings("Demo World", EnumGamemode.a, false, EnumDifficulty.c, false, new GameRules(FeatureFlags.h), WorldDataConfiguration.d);
    public static final NameAndId f = new NameAndId(SystemUtils.e, "Anonymous Player");
    public Convertable.ConversionSession g;
    public final WorldNBTStorage h;
    private final List<Runnable> A = Lists.newArrayList();
    private MetricsRecorder B;
    private Consumer<MethodProfilerResults> C;
    private Consumer<Path> D;
    private boolean E;
    private @Nullable TimeProfiler F;
    private boolean G;
    private ServerConnection H;
    public final LevelLoadListener I;
    private @Nullable ServerPing J;
    private @Nullable ServerPing.a K;
    private final RandomSource L;
    public final DataFixer M;
    private String N;
    private int O = -1;
    private final LayeredRegistryAccess<RegistryLayer> P;
    private Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> Q;
    private PlayerList R;
    private volatile boolean S = true;
    private boolean T;
    private int U;
    private int V = 6000;
    protected final Proxy i;
    private boolean W;
    private boolean X;
    private @Nullable String Y;
    private int Z;
    private final long[] aa;
    private long ab = 0L;
    private @Nullable KeyPair ac;
    private @Nullable GameProfile ad;
    private boolean ae;
    private volatile boolean af;
    private long ag;
    protected final Services j;
    private final NotificationManager ah;
    private final ServerActivityMonitor ai;
    private long aj;
    public final Thread ak;
    private long al;
    private long am;
    private long an;
    private long ao;
    private boolean ap = false;
    private long aq;
    private boolean ar;
    private final ResourcePackRepository as;
    private final ScoreboardServer at;
    private @Nullable Stopwatches au;
    private @Nullable PersistentCommandStorage av;
    private final BossBattleCustomData aw;
    private final CustomFunctionData ax;
    private boolean ay;
    private boolean az;
    private float aA;
    public final Executor aB;
    private @Nullable String aC;
    public ReloadableResources aD;
    private final StructureTemplateManager aE;
    private final ServerTickRateManager aF;
    private final ServerDebugSubscribers aG;
    protected SaveData k;
    private WorldData.a aH;
    private final PotionBrewer aI;
    private FuelValues aJ;
    private int aK;
    private volatile boolean aL;
    private static final AtomicReference<@Nullable RuntimeException> aM = new AtomicReference();
    private final SuppressedExceptionCollector aN;
    private final DiscontinuousFrame aO;
    private final PacketProcessor aP;
    public final WorldLoader.a worldLoader;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public Terminal terminal;
    public static int currentTick = (int)(System.currentTimeMillis() / 50L);
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public CommandDispatcher vanillaCommandDispatcher;
    private boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 100;
    public final double[] recentTps = new double[3];
    private boolean hasStopped = false;
    private final Object stopLock = new Object();
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").build());

    public static <S extends MinecraftServer> S a(Function<Thread, S> function) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        Thread thread = new Thread(() -> ((MinecraftServer)atomicreference.get()).A(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> m.error("Uncaught exception in server thread", throwable));
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s0 = (MinecraftServer)function.apply(thread);
        atomicreference.set(s0);
        thread.start();
        return (S)s0;
    }

    public MinecraftServer(OptionSet options, WorldLoader.a worldLoader, Thread thread, Convertable.ConversionSession convertable_conversionsession, ResourcePackRepository resourcepackrepository, WorldStem worldstem, Proxy proxy, DataFixer datafixer, Services services, LevelLoadListener levelloadlistener) {
        super("Server");
        this.B = InactiveMetricsRecorder.a;
        this.C = methodprofilerresults -> this.aW();
        this.D = path -> {};
        this.L = RandomSource.a();
        this.Q = Maps.newLinkedHashMap();
        this.aa = new long[100];
        this.al = SystemUtils.d();
        this.am = SystemUtils.d();
        this.ao = SystemUtils.d();
        this.at = new ScoreboardServer(this);
        this.aw = new BossBattleCustomData();
        this.aG = new ServerDebugSubscribers(this);
        this.aH = WorldData.a.a;
        this.aN = new SuppressedExceptionCollector();
        this.P = worldstem.c();
        this.k = worldstem.d();
        this.i = proxy;
        this.as = resourcepackrepository;
        this.aD = new ReloadableResources(worldstem.a(), worldstem.b());
        this.j = services;
        this.aF = new ServerTickRateManager(this);
        this.I = levelloadlistener;
        this.g = convertable_conversionsession;
        this.h = convertable_conversionsession.g();
        this.M = datafixer;
        this.ax = new CustomFunctionData(this, this.aD.b.a());
        HolderLookup.b holdergetter = this.P.a().f(Registries.i).a(this.k.J());
        this.aE = new StructureTemplateManager(worldstem.a(), convertable_conversionsession, datafixer, holdergetter);
        this.ak = thread;
        this.aB = SystemUtils.h();
        this.aI = PotionBrewer.a(this.k.J());
        this.aD.b.c().a(this.k.J());
        this.aJ = FuelValues.a(this.P.a(), this.k.J());
        this.aO = TracyClient.createDiscontinuousFrame((String)"Server Tick");
        this.ah = new NotificationManager();
        this.ai = new ServerActivityMonitor(this.ah, 30);
        this.aP = new PacketProcessor(thread);
        this.options = options;
        this.worldLoader = worldLoader;
        this.vanillaCommandDispatcher = worldstem.b().d;
        if (System.console() == null && System.getProperty("org.jline.terminal.provider") == null) {
            System.setProperty("org.jline.terminal.provider", "dumb");
            org.bukkit.craftbukkit.Main.useJline = false;
        }
        try {
            this.terminal = TerminalBuilder.builder().dumb(false).build();
        }
        catch (Throwable e2) {
            try {
                System.setProperty("org.jline.terminal.provider", "dumb");
                org.bukkit.craftbukkit.Main.useJline = false;
                this.terminal = TerminalBuilder.builder().build();
            }
            catch (IOException ex) {
                m.warn((String)null, (Throwable)ex);
            }
        }
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
    }

    protected abstract boolean e() throws IOException;

    public ChunkLoadStatusView a(final int i2) {
        return new ChunkLoadStatusView(){
            private @Nullable PlayerChunkMap c;
            private int d;
            private int e;

            @Override
            public void a(ResourceKey<net.minecraft.world.level.World> resourcekey, ChunkCoordIntPair chunkcoordintpair) {
                WorldServer worldserver = MinecraftServer.this.a(resourcekey);
                this.c = worldserver != null ? worldserver.p().a : null;
                this.d = chunkcoordintpair.h;
                this.e = chunkcoordintpair.i;
            }

            @Override
            public @Nullable ChunkStatus a(int j2, int k2) {
                return this.c == null ? null : this.c.c(ChunkCoordIntPair.d(j2 + this.d - i2, k2 + this.e - i2));
            }

            @Override
            public int a() {
                return i2;
            }
        };
    }

    protected void loadLevel(String s2) {
        boolean flag = !JvmProfiler.f.c() && SharedConstants.au && JvmProfiler.f.a(Environment.a(this));
        ProfiledDuration profiledduration = JvmProfiler.f.e();
        this.loadWorld0(s2);
        if (profiledduration != null) {
            profiledduration.finish(true);
        }
        if (flag) {
            try {
                JvmProfiler.f.b();
            }
            catch (Throwable throwable) {
                m.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    protected void t() {
    }

    private void loadWorld0(String s2) {
        Convertable.ConversionSession worldSession = this.g;
        IRegistryCustom.Dimension iregistrycustom_dimension = this.P.a();
        IRegistry<WorldDimension> dimensions = iregistrycustom_dimension.f(Registries.bF);
        for (WorldDimension worldDimension : dimensions) {
            WorldServer world;
            WorldDataServer worlddata;
            Dynamic<?> dynamic;
            String name;
            ResourceKey<WorldDimension> dimensionKey = dimensions.d(worldDimension).get();
            int dimension = 0;
            if (dimensionKey == WorldDimension.c) {
                if (!this.server.getAllowNether()) continue;
                dimension = -1;
            } else if (dimensionKey == WorldDimension.d) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (dimensionKey != WorldDimension.b) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? dimensionKey.a().b() + "_" + dimensionKey.a().a() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase(Locale.ROOT);
            String string = name = dimensionKey == WorldDimension.b ? s2 : s2 + "_" + worldType;
            if (dimension != 0) {
                File newWorld = Convertable.getStorageFolder(new File(name).toPath(), dimensionKey).toFile();
                File oldWorld = Convertable.getStorageFolder(new File(s2).toPath(), dimensionKey).toFile();
                File oldLevelDat = new File(new File(s2), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    m.info("---- Migration of old " + worldType + " folder required ----");
                    m.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    m.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    m.info("Attempting to move " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "...");
                    if (newWorld.exists()) {
                        m.warn("A file or folder already exists at " + String.valueOf(newWorld) + "!");
                        m.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            m.info("Success! To restore " + worldType + " in the future, simply move " + String.valueOf(newWorld) + " to " + String.valueOf(oldWorld));
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                FileUtils.copyDirectory((File)new File(new File(s2), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                m.warn("Unable to migrate world data.");
                            }
                            m.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            m.warn("Could not move folder " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "!");
                            m.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        m.warn("Could not create path for " + String.valueOf(newWorld) + "!");
                        m.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    worldSession = Convertable.b(this.server.getWorldContainer().toPath()).validateAndCreateAccess(name, dimensionKey);
                }
                catch (IOException | ContentValidationException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (worldSession.m()) {
                WorldInfo worldinfo;
                try {
                    dynamic = worldSession.h();
                    worldinfo = worldSession.a(dynamic);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception) {
                    Convertable.b convertable_b = worldSession.e();
                    m.warn("Failed to load world data from {}", (Object)convertable_b.b(), (Object)ioexception);
                    m.info("Attempting to use fallback");
                    try {
                        dynamic = worldSession.i();
                        worldinfo = worldSession.a(dynamic);
                    }
                    catch (IOException | NbtException | ReportedNbtException ioexception1) {
                        m.error("Failed to load world data from {}", (Object)convertable_b.c(), (Object)ioexception1);
                        m.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.b(), (Object)convertable_b.c());
                        return;
                    }
                    worldSession.n();
                }
                if (worldinfo.d()) {
                    m.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.r()) {
                    m.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            ChunkGenerator gen = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            WorldLoader.a worldloader_a = this.worldLoader;
            IRegistry<WorldDimension> iregistry = worldloader_a.d().f(Registries.bF);
            if (dynamic != null) {
                LevelDataAndDimensions leveldataanddimensions = Convertable.a(dynamic, worldloader_a.b(), iregistry, worldloader_a.c());
                worlddata = (WorldDataServer)leveldataanddimensions.a();
            } else {
                WorldDimensions worlddimensions;
                WorldOptions worldoptions;
                WorldSettings worldsettings;
                if (this.aa()) {
                    worldsettings = e;
                    worldoptions = WorldOptions.b;
                    worlddimensions = WorldPresets.a(worldloader_a.c());
                } else {
                    DedicatedServerProperties dedicatedserverproperties = ((DedicatedServer)this).a();
                    worldsettings = new WorldSettings(dedicatedserverproperties.o, dedicatedserverproperties.n.get(), dedicatedserverproperties.E, dedicatedserverproperties.m.get(), false, new GameRules(worldloader_a.b().b()), worldloader_a.b());
                    worldoptions = this.options.has("bonusChest") ? dedicatedserverproperties.aj.a(true) : dedicatedserverproperties.aj;
                    worlddimensions = dedicatedserverproperties.a(worldloader_a.c());
                }
                WorldDimensions.b worlddimensions_b = worlddimensions.a(iregistry);
                Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().d());
                worlddata = new WorldDataServer(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle);
            }
            worlddata.checkName(name);
            if (this.options.has("forceUpgrade")) {
                Main.a(worldSession, worlddata, DataConverterRegistry.a(), this.options.has("eraseCache"), () -> true, iregistrycustom_dimension, this.options.has("recreateRegionFiles"));
            }
            WorldDataServer iworlddataserver = worlddata;
            boolean flag = worlddata.z();
            WorldOptions worldoptions = worlddata.x();
            long i2 = worldoptions.c();
            long j2 = BiomeManager.a(i2);
            ImmutableList list = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(iworlddataserver));
            WorldDimension worlddimension = dimensions.c(dimensionKey);
            CraftWorldInfo worldInfo = new CraftWorldInfo(iworlddataserver, worldSession, World.Environment.getEnvironment((int)dimension), worlddimension.a().a());
            if (biomeProvider == null && gen != null) {
                biomeProvider = gen.getDefaultBiomeProvider((org.bukkit.generator.WorldInfo)worldInfo);
            }
            ResourceKey<net.minecraft.world.level.World> worldKey = ResourceKey.a(Registries.bE, dimensionKey.a());
            if (dimensionKey == WorldDimension.b) {
                this.k = worlddata;
                this.k.a(((DedicatedServer)this).a().n.get());
                world = new WorldServer(this, this.aB, worldSession, iworlddataserver, worldKey, worlddimension, flag, j2, (List<MobSpawner>)list, true, null, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
                WorldPersistentData worldpersistentdata = world.A();
                this.at.a(worldpersistentdata.a(PersistentScoreboard.a).b());
                this.server.scoreboardManager = new CraftScoreboardManager(this, world.i());
                this.av = new PersistentCommandStorage(worldpersistentdata);
                this.au = worldpersistentdata.a(Stopwatches.a);
            } else {
                world = new WorldServer(this, this.aB, worldSession, iworlddataserver, worldKey, worlddimension, flag, j2, (List<MobSpawner>)ImmutableList.of(), true, this.N().T(), World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
            }
            worlddata.a(this.getServerModName(), this.T().a());
            this.initWorld(world, worlddata, this.k, worldoptions);
            this.addLevel(world);
            this.aj().a(world);
            if (worlddata.D() == null) continue;
            this.aN().a(worlddata.D(), this.bc());
        }
        this.t();
        for (WorldServer worldserver : this.P()) {
            this.prepareLevels(worldserver);
            worldserver.M.b();
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getWorld()));
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.H.acceptConnections();
    }

    public void initWorld(WorldServer worldserver, IWorldDataServer iworlddataserver, SaveData saveData, WorldOptions worldoptions) {
        boolean flag = saveData.z();
        if (worldserver.generator != null) {
            worldserver.getWorld().getPopulators().addAll(worldserver.generator.getDefaultPopulators((World)worldserver.getWorld()));
        }
        this.initWorldBorder(worldserver, iworlddataserver);
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getWorld()));
        if (!iworlddataserver.m()) {
            try {
                MinecraftServer.a(worldserver, iworlddataserver, worldoptions.e(), flag, this.I);
                iworlddataserver.c(true);
                if (flag) {
                    this.a(this.k);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a(throwable, "Exception initializing level");
                try {
                    worldserver.a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            iworlddataserver.c(true);
        }
        GlobalPos globalpos = new GlobalPos(worldserver.aq(), worldserver.C().b());
        this.I.a(globalpos.a(), new ChunkCoordIntPair(globalpos.b()));
    }

    private void initWorldBorder(WorldServer worldserver1, IWorldDataServer iworlddataserver) {
        boolean flag1 = false;
        Optional<WorldBorder.c> optional = iworlddataserver.o();
        if (optional.isPresent()) {
            WorldBorder.c worldborder_c = optional.get();
            WorldPersistentData worldpersistentdata1 = worldserver1.A();
            if (worldpersistentdata1.b(WorldBorder.d) == null) {
                double d0 = worldserver1.F_().g();
                WorldBorder.c worldborder_c1 = new WorldBorder.c(worldborder_c.a() / d0, worldborder_c.b() / d0, worldborder_c.c(), worldborder_c.d(), worldborder_c.e(), worldborder_c.f(), worldborder_c.g(), worldborder_c.h(), worldborder_c.i());
                WorldBorder worldborder = new WorldBorder(worldborder_c1);
                worldborder.a(worldserver1.au());
                worldpersistentdata1.a(WorldBorder.d, worldborder);
            }
            flag1 = true;
        }
        worldserver1.w().a(this.au());
        this.aj().a(worldserver1);
        if (flag1) {
            iworlddataserver.a(Optional.empty());
        }
    }

    private static void a(WorldServer worldserver, IWorldDataServer iworlddataserver, boolean flag, boolean flag1, LevelLoadListener levelloadlistener) {
        if (SharedConstants.ax && SharedConstants.aN) {
            iworlddataserver.a(WorldData.a.a(worldserver.aq(), new BlockPosition(0, 64, -100), 0.0f, 0.0f));
        } else if (flag1) {
            iworlddataserver.a(WorldData.a.a(worldserver.aq(), BlockPosition.c.b(80), 0.0f, 0.0f));
        } else {
            ChunkProviderServer chunkproviderserver = worldserver.p();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(chunkproviderserver.i().b().a());
            if (worldserver.generator != null) {
                Random rand = new Random(worldserver.J());
                Location spawn = worldserver.generator.getFixedSpawnLocation((World)worldserver.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != worldserver.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + iworlddataserver.d() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    iworlddataserver.a(WorldData.a.a(worldserver.aq(), new BlockPosition(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw(), spawn.getPitch()));
                    return;
                }
            }
            levelloadlistener.a(LevelLoadListener.a.b, 0);
            levelloadlistener.a(worldserver.aq(), chunkcoordintpair);
            int i2 = chunkproviderserver.g().a(worldserver);
            if (i2 < worldserver.K_()) {
                BlockPosition blockposition = chunkcoordintpair.m();
                i2 = worldserver.a(HeightMap.Type.b, blockposition.u() + 8, blockposition.w() + 8);
            }
            iworlddataserver.a(WorldData.a.a(worldserver.aq(), chunkcoordintpair.m().b(8, i2, 8), 0.0f, 0.0f));
            int j2 = 0;
            int k2 = 0;
            int l2 = 0;
            int i1 = -1;
            for (int j1 = 0; j1 < MathHelper.i(11); ++j1) {
                BlockPosition blockposition1;
                if (j2 >= -5 && j2 <= 5 && k2 >= -5 && k2 <= 5 && (blockposition1 = PlayerSpawnFinder.a(worldserver, new ChunkCoordIntPair(chunkcoordintpair.h + j2, chunkcoordintpair.i + k2))) != null) {
                    iworlddataserver.a(WorldData.a.a(worldserver.aq(), blockposition1, 0.0f, 0.0f));
                    break;
                }
                if (j2 == k2 || j2 < 0 && j2 == -k2 || j2 > 0 && j2 == 1 - k2) {
                    int k1 = l2;
                    l2 = -i1;
                    i1 = k1;
                }
                j2 += l2;
                k2 += i1;
            }
            if (flag) {
                worldserver.J_().a(Registries.aY).flatMap(iregistry -> iregistry.a(MiscOverworldFeatures.m)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.a()).a(worldserver, chunkproviderserver.g(), worldserver.y, iworlddataserver.a().b()));
            }
            levelloadlistener.a(LevelLoadListener.a.b);
        }
    }

    private void a(SaveData savedata) {
        savedata.a(EnumDifficulty.a);
        savedata.d(true);
        IWorldDataServer iworlddataserver = savedata.H();
        iworlddataserver.b(false);
        iworlddataserver.a(false);
        iworlddataserver.a(1000000000);
        iworlddataserver.b(6000L);
        iworlddataserver.a(EnumGamemode.d);
    }

    public void prepareLevels(WorldServer worldserver) {
        this.forceTicks = true;
        ChunkLoadCounter chunkloadcounter = new ChunkLoadCounter();
        chunkloadcounter.a(worldserver, () -> {
            TicketStorage ticketstorage = worldserver.A().b(TicketStorage.b);
            if (ticketstorage != null) {
                ticketstorage.b();
            }
        });
        this.I.a(LevelLoadListener.a.c, chunkloadcounter.c());
        do {
            this.I.a(LevelLoadListener.a.c, chunkloadcounter.a(), chunkloadcounter.c());
            this.executeModerately();
        } while (chunkloadcounter.b() > 0);
        this.I.a(LevelLoadListener.a.c);
        this.forceTicks = false;
        this.bI();
    }

    protected GlobalPos v() {
        return this.k.H().a().c();
    }

    public EnumGamemode w() {
        return this.k.j();
    }

    public boolean v_() {
        return this.k.k();
    }

    public abstract LevelBasedPermissionSet k();

    public abstract PermissionSet l();

    public abstract boolean m();

    public boolean a(boolean flag, boolean flag1, boolean flag2) {
        this.at.a(this.N().A().a(PersistentScoreboard.a));
        boolean flag3 = false;
        for (WorldServer worldserver : this.P()) {
            if (!flag) {
                m.info("Saving chunks for level '{}'/{}", (Object)worldserver, (Object)worldserver.aq().a());
            }
            worldserver.a((IProgressUpdate)null, flag1, SharedConstants.X || worldserver.e && !flag2);
            flag3 = true;
        }
        if (flag1) {
            for (WorldServer worldserver1 : this.P()) {
                m.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)worldserver1.p().a.l());
            }
            m.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean flag, boolean flag1, boolean flag2) {
        boolean flag3;
        try {
            this.aL = true;
            this.aj().h();
            flag3 = this.a(flag, flag1, flag2);
        }
        finally {
            this.aL = false;
        }
        return flag3;
    }

    @Override
    public void close() {
        this.x();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void x() {
        Iterator<WorldServer> iterator = this.stopLock;
        synchronized (iterator) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        this.aP.close();
        if (this.B.e()) {
            this.aY();
        }
        m.info("Stopping server");
        if (this.server != null) {
            this.server.disablePlugins();
        }
        this.ak().b();
        this.aL = true;
        if (this.R != null) {
            m.info("Saving players");
            this.R.h();
            this.R.s();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        m.info("Saving worlds");
        for (WorldServer worldserver : this.P()) {
            if (worldserver == null) continue;
            worldserver.e = false;
        }
        while (this.Q.values().stream().anyMatch(worldserver1 -> worldserver1.p().a.e())) {
            this.ao = SystemUtils.d() + TimeRange.b;
            for (WorldServer worldserver12 : this.P()) {
                worldserver12.p().q();
                worldserver12.p().a(() -> true, false);
            }
            this.w_();
        }
        this.a(false, true, false);
        for (WorldServer worldserver2 : this.P()) {
            if (worldserver2 == null) continue;
            try {
                worldserver2.close();
            }
            catch (IOException ioexception) {
                m.error("Exception closing the level", (Throwable)ioexception);
            }
        }
        this.aL = false;
        this.aD.close();
        try {
            this.g.close();
        }
        catch (IOException ioexception1) {
            m.error("Failed to unlock level {}", (Object)this.g.f(), (Object)ioexception1);
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            m.info("Saving usercache.json");
            this.ar().f().a();
        }
    }

    public String y() {
        return this.N;
    }

    @Override
    public void a_(String s2) {
        this.N = s2;
    }

    public boolean z() {
        return this.S;
    }

    public void a(boolean flag) {
        this.S = false;
        if (flag) {
            try {
                this.ak.join();
            }
            catch (InterruptedException interruptedexception) {
                m.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    private static double calcTps(double avg, double exp, double tps) {
        return avg * exp + tps * (1.0 - exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void A() {
        try {
            if (!this.e()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.ao = SystemUtils.d();
            this.K = this.bD().orElse(null);
            this.J = this.bG();
            Arrays.fill(this.recentTps, 20.0);
            long tickSection = SystemUtils.c();
            long tickCount = 1L;
            while (this.S) {
                boolean flag;
                long i2;
                if (!this.I() && this.aF.a() && this.aF.d()) {
                    i2 = 0L;
                    this.ag = this.ao = SystemUtils.d();
                } else {
                    i2 = this.aF.h();
                    long j2 = SystemUtils.d() - this.ao;
                    if (j2 > p + 20L * i2 && this.ao - this.ag >= r + 100L * i2) {
                        long k2 = j2 / i2;
                        if (this.server.getWarnOnOverload()) {
                            m.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)(j2 / TimeRange.b), (Object)k2);
                        }
                        this.ao += k2 * i2;
                        this.ag = this.ao;
                    }
                }
                if (tickCount++ % 100L == 0L) {
                    long curTime = SystemUtils.c();
                    double currentTps = 1000.0 / (double)(curTime - tickSection) * 100.0;
                    this.recentTps[0] = MinecraftServer.calcTps(this.recentTps[0], 0.92, currentTps);
                    this.recentTps[1] = MinecraftServer.calcTps(this.recentTps[1], 0.9835, currentTps);
                    this.recentTps[2] = MinecraftServer.calcTps(this.recentTps[2], 0.9945, currentTps);
                    tickSection = curTime;
                }
                boolean bl = flag = i2 == 0L;
                if (this.G) {
                    this.G = false;
                    this.F = new TimeProfiler(SystemUtils.d(), this.U);
                }
                currentTick = (int)(System.currentTimeMillis() / 50L);
                this.ao += i2;
                try (Profiler.a profiler_a = Profiler.a(this.bQ());){
                    this.b(flag);
                    GameProfilerFiller gameprofilerfiller = Profiler.a();
                    gameprofilerfiller.a("nextTickWait");
                    this.ar = true;
                    this.aq = Math.max(SystemUtils.d() + i2, this.ao);
                    this.bz();
                    this.w_();
                    this.bA();
                    if (flag) {
                        this.aF.e();
                    }
                    gameprofilerfiller.c();
                    this.by();
                }
                finally {
                    this.aU();
                }
                this.af = true;
                JvmProfiler.f.a(this.aA);
            }
            return;
        }
        catch (Throwable throwable2) {
            m.error("Encountered an unexpected exception", throwable2);
            CrashReport crashreport = MinecraftServer.b(throwable2);
            this.b(crashreport.f());
            Path path = this.G().resolve("crash-reports").resolve("crash-" + SystemUtils.f() + "-server.txt");
            if (crashreport.a(path, ReportType.a)) {
                m.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                m.error("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
            return;
        }
        finally {
            try {
                this.T = true;
                this.x();
            }
            catch (Throwable throwable3) {
                m.error("Exception stopping the server", throwable3);
            }
            finally {
                WatchdogThread.doStop();
                try {
                    this.terminal.close();
                }
                catch (Exception tickSection) {}
                this.i();
            }
        }
    }

    private void by() {
        long i2 = SystemUtils.d();
        if (this.g()) {
            this.f().a(i2 - this.al);
        }
        this.al = i2;
    }

    private void bz() {
        if (this.g()) {
            this.am = SystemUtils.d();
            this.an = 0L;
        }
    }

    private void bA() {
        if (this.g()) {
            SampleLogger samplelogger = this.f();
            samplelogger.a(SystemUtils.d() - this.am - this.an, TpsDebugDimensions.c.ordinal());
            samplelogger.a(this.an, TpsDebugDimensions.d.ordinal());
        }
    }

    private static CrashReport b(Throwable throwable) {
        CrashReport crashreport;
        ReportedException reportedexception = null;
        for (Throwable throwable1 = throwable; throwable1 != null; throwable1 = throwable1.getCause()) {
            ReportedException reportedexception1;
            if (!(throwable1 instanceof ReportedException)) continue;
            reportedexception = reportedexception1 = (ReportedException)throwable1;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.a();
            if (reportedexception != throwable) {
                crashreport.a("Wrapped in").a("Wrapping exception", throwable);
            }
        } else {
            crashreport = new CrashReport("Exception in server tick loop", throwable);
        }
        return crashreport;
    }

    private boolean bB() {
        return this.forceTicks || this.bP() || SystemUtils.d() < (this.ar ? this.aq : this.ao);
    }

    private void executeModerately() {
        this.bN();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean B() {
        RuntimeException runtimeexception = aM.get();
        if (runtimeexception != null) {
            throw runtimeexception;
        }
        return true;
    }

    public static void a(RuntimeException runtimeexception) {
        aM.compareAndSet(null, runtimeexception);
    }

    @Override
    public void b(BooleanSupplier booleansupplier) {
        super.b(() -> MinecraftServer.B() && booleansupplier.getAsBoolean());
    }

    public NotificationManager C() {
        return this.ah;
    }

    protected void w_() {
        this.bN();
        this.ap = true;
        try {
            this.b(() -> !this.bB());
        }
        finally {
            this.ap = false;
        }
    }

    @Override
    public void D() {
        boolean flag = this.g();
        long i2 = flag ? SystemUtils.d() : 0L;
        long j2 = this.ap ? this.ao - SystemUtils.d() : 100000L;
        LockSupport.parkNanos("waiting for tasks", j2);
        if (flag) {
            this.an += SystemUtils.d() - i2;
        }
    }

    public TickTask a(Runnable runnable) {
        return new TickTask(this.U, runnable);
    }

    protected boolean a(TickTask ticktask) {
        return ticktask.a() + 3 < this.U || this.bB();
    }

    @Override
    public boolean E() {
        boolean flag;
        this.ar = flag = this.bC();
        return flag;
    }

    private boolean bC() {
        if (super.E()) {
            return true;
        }
        if (this.aF.a() || this.bO() || this.bB()) {
            for (WorldServer worldserver : this.P()) {
                if (!worldserver.p().c()) continue;
                return true;
            }
        }
        return false;
    }

    public void b(TickTask ticktask) {
        Profiler.a().f("runTask");
        super.d(ticktask);
    }

    private Optional<ServerPing.a> bD() {
        Optional<Path> optional = Optional.of(this.c("server-icon.png")).filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])).or(() -> this.g.j().filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                byte[] abyte = java.nio.file.Files.readAllBytes(path);
                PngInfo pnginfo = PngInfo.a(abyte);
                if (pnginfo.a() == 64 && pnginfo.b() == 64) {
                    return Optional.of(new ServerPing.a(abyte));
                }
                int i2 = pnginfo.a();
                throw new IllegalArgumentException("Invalid world icon size [" + i2 + ", " + pnginfo.b() + "], but expected [64, 64]");
            }
            catch (Exception exception) {
                m.error("Couldn't load server icon", (Throwable)exception);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> F() {
        return this.g.j();
    }

    public Path G() {
        return Path.of("", new String[0]);
    }

    public ServerActivityMonitor H() {
        return this.ai;
    }

    public void a(CrashReport crashreport) {
    }

    public void i() {
    }

    public boolean I() {
        return false;
    }

    public void a(BooleanSupplier booleansupplier) {
        WatchdogThread.tick();
        long i2 = SystemUtils.d();
        int j2 = this.bu() * 20;
        if (j2 > 0) {
            this.aK = this.R.m() == 0 && !this.aF.a() ? ++this.aK : 0;
            if (this.aK >= j2) {
                if (this.aK == j2) {
                    m.info("Server empty for {} seconds, pausing", (Object)this.bu());
                    this.bE();
                }
                this.server.getScheduler().mainThreadHeartbeat();
                this.K();
                return;
            }
        }
        SpigotTimings.serverTickTimer.startTiming();
        ++this.U;
        this.aF.m();
        this.c(booleansupplier);
        if (i2 - this.aj >= t) {
            this.aj = i2;
            this.J = this.bG();
        }
        --this.V;
        if (this.autosavePeriod > 0 && this.V <= 0) {
            this.bE();
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("tallying");
        long k2 = SystemUtils.d() - i2;
        int l2 = this.U % 100;
        this.ab -= this.aa[l2];
        this.ab += k2;
        this.aa[l2] = k2;
        this.aA = this.aA * 0.8f + (float)k2 / (float)TimeRange.b * 0.19999999f;
        this.a(i2);
        gameprofilerfiller.c();
        SpigotTimings.serverTickTimer.stopTiming();
        CustomTimingsHandler.tick();
    }

    protected void b(boolean flag) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("tick");
        this.aO.start();
        gameprofilerfiller.a("scheduledPacketProcessing");
        this.aP.b();
        gameprofilerfiller.c();
        this.a(flag ? () -> false : this::bB);
        this.aO.end();
        gameprofilerfiller.c();
    }

    private void bE() {
        this.V = this.autosavePeriod;
        SpigotTimings.worldSaveTimer.startTiming();
        m.debug("Autosave started");
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("save");
        this.b(true, false, false);
        gameprofilerfiller.c();
        m.debug("Autosave finished");
        SpigotTimings.worldSaveTimer.stopTiming();
    }

    private void a(long i2) {
        if (this.g()) {
            this.f().a(SystemUtils.d() - i2, TpsDebugDimensions.b.ordinal());
        }
    }

    private int bF() {
        float f2;
        if (this.aF.a()) {
            long i2 = this.aS() + 1L;
            f2 = (float)TimeRange.a / (float)i2;
        } else {
            f2 = this.aF.f();
        }
        int j2 = 300;
        return Math.max(100, (int)(f2 * 300.0f));
    }

    public void J() {
        int i2 = this.bF();
        if (i2 < this.V) {
            this.V = i2;
        }
    }

    protected abstract SampleLogger f();

    public abstract boolean g();

    private ServerPing bG() {
        ServerPing.ServerPingPlayerSample serverping_serverpingplayersample = this.bH();
        return new ServerPing(IChatBaseComponent.a(this.ah()), Optional.of(serverping_serverpingplayersample), Optional.of(ServerPing.ServerData.a()), Optional.ofNullable(this.K), this.ay());
    }

    private ServerPing.ServerPingPlayerSample bH() {
        List<EntityPlayer> list = this.R.t();
        int i2 = this.r();
        if (this.ao()) {
            return new ServerPing.ServerPingPlayerSample(i2, list.size(), List.of());
        }
        int j2 = Math.min(list.size(), 12);
        ObjectArrayList objectarraylist = new ObjectArrayList(j2);
        int k2 = MathHelper.a(this.L, 0, list.size() - j2);
        for (int l2 = 0; l2 < j2; ++l2) {
            EntityPlayer entityplayer = list.get(k2 + l2);
            objectarraylist.add((Object)(entityplayer.aa() ? entityplayer.gJ() : f));
        }
        SystemUtils.c(objectarraylist, this.L);
        return new ServerPing.ServerPingPlayerSample(i2, list.size(), (List<NameAndId>)objectarraylist);
    }

    protected void c(BooleanSupplier booleansupplier) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        this.aj().t().forEach(entityplayer -> entityplayer.g.f());
        SpigotTimings.schedulerTimer.startTiming();
        this.server.getScheduler().mainThreadHeartbeat();
        SpigotTimings.schedulerTimer.stopTiming();
        gameprofilerfiller.a("commandFunctions");
        SpigotTimings.commandFunctionsTimer.startTiming();
        this.aC().b();
        SpigotTimings.commandFunctionsTimer.stopTiming();
        gameprofilerfiller.b("levels");
        this.bI();
        SpigotTimings.processQueueTimer.startTiming();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        SpigotTimings.processQueueTimer.stopTiming();
        SpigotTimings.timeUpdateTimer.startTiming();
        if (this.U % 20 == 0) {
            for (int i2 = 0; i2 < this.aj().k.size(); ++i2) {
                EntityPlayer entityplayer2 = this.aj().k.get(i2);
                entityplayer2.g.b(new PacketPlayOutUpdateTime(entityplayer2.A().au(), entityplayer2.getPlayerTime(), entityplayer2.A().U().a(GameRules.a)));
            }
        }
        SpigotTimings.timeUpdateTimer.stopTiming();
        for (WorldServer worldserver : this.P()) {
            gameprofilerfiller.a(() -> {
                String s2 = String.valueOf(worldserver);
                return s2 + " " + String.valueOf(worldserver.aq().a());
            });
            gameprofilerfiller.a("tick");
            try {
                worldserver.timings.doTick.startTiming();
                worldserver.a(booleansupplier);
                worldserver.timings.doTick.stopTiming();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a(throwable, "Exception ticking world");
                worldserver.a(crashreport);
                throw new ReportedException(crashreport);
            }
            gameprofilerfiller.c();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.b("connection");
        SpigotTimings.connectionTimer.startTiming();
        this.K();
        SpigotTimings.connectionTimer.stopTiming();
        gameprofilerfiller.b("players");
        SpigotTimings.playerListTimer.startTiming();
        this.R.d();
        SpigotTimings.playerListTimer.stopTiming();
        gameprofilerfiller.b("debugSubscribers");
        this.aG.a();
        if (this.aF.i()) {
            gameprofilerfiller.b("gameTests");
            GameTestHarnessTicker.a.b();
        }
        gameprofilerfiller.b("server gui refresh");
        SpigotTimings.tickablesTimer.startTiming();
        for (Runnable runnable : this.A) {
            runnable.run();
        }
        SpigotTimings.tickablesTimer.stopTiming();
        gameprofilerfiller.b("send chunks");
        for (EntityPlayer entityplayer2 : this.R.t()) {
            entityplayer2.g.h.a(entityplayer2);
            entityplayer2.g.g();
        }
        gameprofilerfiller.c();
        this.ai.a();
    }

    private void bI() {
        WorldData.a worlddata_a = this.k.H().a();
        WorldServer worldserver = this.aH();
        this.aH = worldserver.b(worlddata_a);
    }

    public void K() {
        this.ak().c();
    }

    private void a(WorldServer worldserver) {
        this.R.a(new PacketPlayOutUpdateTime(worldserver.au(), worldserver.al(), worldserver.U().a(GameRules.a)), worldserver.aq());
    }

    public void L() {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("timeSync");
        for (WorldServer worldserver : this.P()) {
            this.a(worldserver);
        }
        gameprofilerfiller.c();
    }

    public void b(Runnable runnable) {
        this.A.add(runnable);
    }

    protected void b(String s2) {
        this.aC = s2;
    }

    public boolean M() {
        return !this.ak.isAlive();
    }

    public Path c(String s2) {
        return this.G().resolve(s2);
    }

    public final WorldServer N() {
        return this.Q.get(net.minecraft.world.level.World.h);
    }

    public @Nullable WorldServer a(ResourceKey<net.minecraft.world.level.World> resourcekey) {
        return this.Q.get(resourcekey);
    }

    public void addLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.Q;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.aq(), level);
        this.Q = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.Q;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.aq());
        this.Q = Collections.unmodifiableMap(newLevels);
    }

    public Set<ResourceKey<net.minecraft.world.level.World>> O() {
        return this.Q.keySet();
    }

    public Iterable<WorldServer> P() {
        return this.Q.values();
    }

    @Override
    public String Q() {
        return SharedConstants.b().c();
    }

    @Override
    public int R() {
        return this.R.m();
    }

    public String[] S() {
        return this.R.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return "Spigot";
    }

    public SystemReport b(SystemReport systemreport) {
        systemreport.a("Server Running", () -> Boolean.toString(this.S));
        if (this.R != null) {
            systemreport.a("Player Count", () -> {
                int i2 = this.R.m();
                return i2 + " / " + this.R.n() + "; " + String.valueOf(this.R.t());
            });
        }
        systemreport.a("Active Data Packs", () -> ResourcePackRepository.a(this.as.g()));
        systemreport.a("Available Data Packs", () -> ResourcePackRepository.a(this.as.d()));
        systemreport.a("Enabled Feature Flags", () -> FeatureFlags.e.b(this.k.J()).stream().map(MinecraftKey::toString).collect(Collectors.joining(", ")));
        systemreport.a("World Generation", () -> this.k.A().toString());
        systemreport.a("World Seed", () -> String.valueOf(this.k.x().c()));
        SuppressedExceptionCollector suppressedexceptioncollector = this.aN;
        Objects.requireNonNull(this.aN);
        systemreport.a("Suppressed Exceptions", suppressedexceptioncollector::a);
        if (this.aC != null) {
            systemreport.a("Server Id", () -> this.aC);
        }
        return this.a(systemreport);
    }

    public abstract SystemReport a(SystemReport var1);

    public ModCheck T() {
        return ModCheck.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent) {
        m.info(ichatbasecomponent.getString());
    }

    public KeyPair U() {
        return Objects.requireNonNull(this.ac);
    }

    public int V() {
        return this.O;
    }

    public void b(int i2) {
        this.O = i2;
    }

    public @Nullable GameProfile W() {
        return this.ad;
    }

    public void a(@Nullable GameProfile gameprofile) {
        this.ad = gameprofile;
    }

    public boolean X() {
        return this.ad != null;
    }

    protected void Y() {
        m.info("Generating keypair");
        try {
            this.ac = MinecraftEncryption.b();
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptographyexception);
        }
    }

    public void a(EnumDifficulty enumdifficulty, boolean flag) {
        if (flag || !this.k.q()) {
            this.k.a(this.k.k() ? EnumDifficulty.d : enumdifficulty);
            this.Z();
            this.aj().t().forEach(this::c);
        }
    }

    public int c(int i2) {
        return i2;
    }

    private void Z() {
        for (WorldServer worldserver : this.P()) {
            worldserver.b(worldserver.O());
        }
    }

    public void c(boolean flag) {
        this.k.d(flag);
        this.aj().t().forEach(this::c);
    }

    private void c(EntityPlayer entityplayer) {
        WorldData worlddata = entityplayer.A().D_();
        entityplayer.g.b(new PacketPlayOutServerDifficulty(worlddata.p(), worlddata.q()));
    }

    public boolean aa() {
        return this.ae;
    }

    @Override
    public void d(boolean flag) {
        this.ae = flag;
    }

    public Map<String, String> ab() {
        return Map.of();
    }

    public Optional<ServerResourcePackInfo> ac() {
        return Optional.empty();
    }

    public boolean ad() {
        return this.ac().filter(ServerResourcePackInfo::d).isPresent();
    }

    public abstract boolean n();

    public abstract int o();

    public boolean ae() {
        return this.W;
    }

    public void e(boolean flag) {
        this.W = flag;
    }

    public boolean af() {
        return this.X;
    }

    public void f(boolean flag) {
        this.X = flag;
    }

    public abstract boolean p();

    public boolean ag() {
        return true;
    }

    @Override
    public String ah() {
        return this.Y;
    }

    @Override
    public void d(String s2) {
        this.Y = s2;
    }

    public boolean ai() {
        return this.T;
    }

    public PlayerList aj() {
        return this.R;
    }

    public void a(PlayerList playerlist) {
        this.R = playerlist;
    }

    public abstract boolean q();

    public void a(EnumGamemode enumgamemode) {
        this.k.a(enumgamemode);
    }

    public int b(@Nullable EnumGamemode enumgamemode) {
        if (enumgamemode == null) {
            return 0;
        }
        int i2 = 0;
        for (EntityPlayer entityplayer : this.aj().t()) {
            if (!entityplayer.a(enumgamemode)) continue;
            ++i2;
        }
        return i2;
    }

    public ServerConnection ak() {
        return this.H == null ? (this.H = new ServerConnection(this)) : this.H;
    }

    public boolean al() {
        return this.af;
    }

    public boolean a(@Nullable EnumGamemode enumgamemode, boolean flag, int i2) {
        return false;
    }

    public int am() {
        return this.U;
    }

    public boolean a(WorldServer worldserver, BlockPosition blockposition, EntityHuman entityhuman) {
        return false;
    }

    public boolean an() {
        return true;
    }

    public boolean ao() {
        return false;
    }

    public Proxy ap() {
        return this.i;
    }

    public int aq() {
        return this.Z;
    }

    @Override
    public void d(int i2) {
        this.Z = i2;
    }

    public Services ar() {
        return this.j;
    }

    public @Nullable ServerPing as() {
        return this.J;
    }

    public void at() {
        this.aj = 0L;
    }

    public int au() {
        return 29999984;
    }

    @Override
    public boolean av() {
        return super.av() && !this.ai();
    }

    @Override
    public void c(Runnable runnable) {
        if (this.ai()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.c(runnable);
    }

    @Override
    public Thread aw() {
        return this.ak;
    }

    public int ax() {
        return 256;
    }

    public boolean ay() {
        return false;
    }

    public long az() {
        return this.ao;
    }

    public DataFixer aA() {
        return this.M;
    }

    public AdvancementDataWorld aB() {
        return this.aD.b.e();
    }

    public CustomFunctionData aC() {
        return this.ax;
    }

    @Override
    public CompletableFuture<Void> a(Collection<String> collection) {
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Stream stream = collection.stream();
            ResourcePackRepository resourcepackrepository = this.as;
            Objects.requireNonNull(this.as);
            return (ImmutableList)stream.map(resourcepackrepository::c).filter(Objects::nonNull).map(ResourcePackLoader::f).collect(ImmutableList.toImmutableList());
        }, this).thenCompose(immutablelist -> {
            ResourceManager ireloadableresourcemanager = new ResourceManager(EnumResourcePackType.b, (List<IResourcePack>)immutablelist);
            List<IRegistry.a<?>> list = TagDataPack.a((IResourceManager)ireloadableresourcemanager, this.P.a());
            return ((CompletableFuture)DataPackResources.a(ireloadableresourcemanager, this.P, list, this.k.J(), this.n() ? CommandDispatcher.ServerType.b : CommandDispatcher.ServerType.c, this.l(), this.aB, this).whenComplete((datapackresources, throwable) -> {
                if (throwable != null) {
                    ireloadableresourcemanager.close();
                }
            })).thenApply(datapackresources -> new ReloadableResources(ireloadableresourcemanager, (DataPackResources)datapackresources));
        })).thenAcceptAsync(minecraftserver_reloadableresources -> {
            this.aD.close();
            this.aD = minecraftserver_reloadableresources;
            this.server.syncCommands();
            this.as.b(collection);
            WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(MinecraftServer.a(this.as, true), this.k.J());
            this.k.a(worlddataconfiguration);
            this.aD.b.g();
            this.aD.b.c().a(this.k.J());
            this.aj().h();
            this.aj().u();
            this.ax.a(this.aD.b.a());
            this.aE.a(this.aD.a);
            this.aJ = FuelValues.a(this.P.a(), this.k.J());
        }, (Executor)this);
        if (this.bK()) {
            Objects.requireNonNull(completablefuture);
            this.b(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static WorldDataConfiguration a(ResourcePackRepository resourcepackrepository, WorldDataConfiguration worlddataconfiguration, boolean flag, boolean flag1) {
        DataPackConfiguration datapackconfiguration = worlddataconfiguration.a();
        FeatureFlagSet featureflagset = flag ? FeatureFlagSet.a() : worlddataconfiguration.b();
        FeatureFlagSet featureflagset1 = flag ? FeatureFlags.e.a() : worlddataconfiguration.b();
        resourcepackrepository.a();
        if (flag1) {
            return MinecraftServer.a(resourcepackrepository, List.of(b), featureflagset, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s2 : datapackconfiguration.a()) {
            if (resourcepackrepository.d(s2)) {
                set.add(s2);
                continue;
            }
            m.warn("Missing data pack {}", (Object)s2);
        }
        for (ResourcePackLoader resourcepackloader : resourcepackrepository.d()) {
            String s1 = resourcepackloader.g();
            if (datapackconfiguration.b().contains(s1)) continue;
            FeatureFlagSet featureflagset2 = resourcepackloader.e();
            boolean flag2 = set.contains(s1);
            if (!flag2 && resourcepackloader.l().a()) {
                if (featureflagset2.a(featureflagset1)) {
                    m.info("Found new data pack {}, loading it automatically", (Object)s1);
                    set.add(s1);
                } else {
                    m.info("Found new data pack {}, but can't load it due to missing features {}", (Object)s1, (Object)FeatureFlags.a(featureflagset1, featureflagset2));
                }
            }
            if (!flag2 || featureflagset2.a(featureflagset1)) continue;
            m.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)s1, (Object)FeatureFlags.a(featureflagset1, featureflagset2));
            set.remove(s1);
        }
        if (set.isEmpty()) {
            m.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        return MinecraftServer.a(resourcepackrepository, set, featureflagset, true);
    }

    private static WorldDataConfiguration a(ResourcePackRepository resourcepackrepository, Collection<String> collection, FeatureFlagSet featureflagset, boolean flag) {
        resourcepackrepository.b(collection);
        MinecraftServer.a(resourcepackrepository, featureflagset);
        DataPackConfiguration datapackconfiguration = MinecraftServer.a(resourcepackrepository, flag);
        FeatureFlagSet featureflagset1 = resourcepackrepository.f().c(featureflagset);
        return new WorldDataConfiguration(datapackconfiguration, featureflagset1);
    }

    private static void a(ResourcePackRepository resourcepackrepository, FeatureFlagSet featureflagset) {
        FeatureFlagSet featureflagset1 = resourcepackrepository.f();
        FeatureFlagSet featureflagset2 = featureflagset.d(featureflagset1);
        if (!featureflagset2.b()) {
            ObjectArraySet set = new ObjectArraySet(resourcepackrepository.e());
            for (ResourcePackLoader resourcepackloader : resourcepackrepository.d()) {
                if (featureflagset2.b()) break;
                if (resourcepackloader.l() != PackSource.d) continue;
                String s2 = resourcepackloader.g();
                FeatureFlagSet featureflagset3 = resourcepackloader.e();
                if (featureflagset3.b() || !featureflagset3.b(featureflagset2) || !featureflagset3.a(featureflagset)) continue;
                if (!set.add(s2)) {
                    throw new IllegalStateException("Tried to force '" + s2 + "', but it was already enabled");
                }
                m.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)s2);
                featureflagset2 = featureflagset2.d(featureflagset3);
            }
            resourcepackrepository.b((Collection<String>)set);
        }
    }

    private static DataPackConfiguration a(ResourcePackRepository resourcepackrepository, boolean flag) {
        Collection<String> collection = resourcepackrepository.e();
        ImmutableList list = ImmutableList.copyOf(collection);
        List<String> list1 = flag ? resourcepackrepository.c().stream().filter(s2 -> !collection.contains(s2)).toList() : List.of();
        return new DataPackConfiguration((List<String>)list, list1);
    }

    public void aD() {
        if (this.aO() && this.aP()) {
            PlayerList playerlist = this.aj();
            WhiteList whitelist = playerlist.i();
            for (EntityPlayer entityplayer : Lists.newArrayList(playerlist.t())) {
                if (whitelist.a(entityplayer.gJ())) continue;
                entityplayer.g.a(IChatBaseComponent.c("multiplayer.disconnect.not_whitelisted"));
            }
        }
    }

    public ResourcePackRepository aE() {
        return this.as;
    }

    public CommandDispatcher aF() {
        return this.aD.b.d();
    }

    public CommandListenerWrapper aG() {
        WorldServer worldserver = this.aH();
        return new CommandListenerWrapper(this, Vec3D.a(this.aI().b()), Vec2F.a, worldserver, LevelBasedPermissionSet.e, "Server", IChatBaseComponent.b("Server"), this, null);
    }

    public WorldServer aH() {
        return this.findRespawnDimension(this.N());
    }

    public WorldServer findRespawnDimension(WorldServer world) {
        if (world == null) {
            return null;
        }
        WorldData.a worlddata_a = world.C();
        ResourceKey<net.minecraft.world.level.World> resourcekey = worlddata_a.a();
        WorldServer worldserver = this.a(resourcekey);
        return worldserver != null ? worldserver : this.N();
    }

    public void a(WorldData.a worlddata_a) {
        this.setRespawnData(worlddata_a, this.N());
    }

    public void setRespawnData(WorldData.a worlddata_a, WorldServer world) {
        WorldDataServer iworlddataserver = world.I;
        WorldData.a worlddata_a1 = iworlddataserver.a();
        if (!worlddata_a1.equals(worlddata_a)) {
            iworlddataserver.a(worlddata_a);
            SpawnChangeEvent event = new SpawnChangeEvent((World)world.getWorld(), CraftLocation.toBukkit(worlddata_a1.b(), (World)world.getWorld(), worlddata_a1.d(), worlddata_a1.e()));
            this.server.getPluginManager().callEvent((Event)event);
            this.aj().a(new PacketPlayOutSpawnPosition(worlddata_a));
            this.bI();
        }
    }

    public WorldData.a aI() {
        return this.aH;
    }

    @Override
    public boolean x_() {
        return true;
    }

    @Override
    public boolean y_() {
        return true;
    }

    @Override
    public abstract boolean c();

    public CraftingManager aJ() {
        return this.aD.b.c();
    }

    public ScoreboardServer aK() {
        return this.at;
    }

    public PersistentCommandStorage aL() {
        if (this.av == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.av;
    }

    public Stopwatches aM() {
        if (this.au == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.au;
    }

    public BossBattleCustomData aN() {
        return this.aw;
    }

    public boolean aO() {
        return this.ay;
    }

    public void g(boolean flag) {
        this.ay = flag;
    }

    public boolean aP() {
        return this.az;
    }

    public void h(boolean flag) {
        this.az = flag;
    }

    public float aQ() {
        return this.aA;
    }

    public ServerTickRateManager aR() {
        return this.aF;
    }

    public long aS() {
        return this.ab / (long)Math.min(100, Math.max(this.U, 1));
    }

    public long[] aT() {
        return this.aa;
    }

    public LevelBasedPermissionSet b(NameAndId nameandid) {
        if (this.aj().f(nameandid)) {
            OpListEntry oplistentry = (OpListEntry)this.aj().k().c(nameandid);
            return oplistentry != null ? oplistentry.a() : (this.a(nameandid) ? LevelBasedPermissionSet.e : (this.X() ? (this.aj().v() ? LevelBasedPermissionSet.e : LevelBasedPermissionSet.a) : this.k()));
        }
        return LevelBasedPermissionSet.a;
    }

    public abstract boolean a(NameAndId var1);

    public void a(Path path) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<net.minecraft.world.level.World>, WorldServer> map_entry : this.Q.entrySet()) {
                MinecraftKey minecraftkey = map_entry.getKey().a();
                Path path2 = path1.resolve(minecraftkey.b()).resolve(minecraftkey.a());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                map_entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            m.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.bL()));
            writer.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aQ())));
            writer.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.aa)));
            writer.write(String.format(Locale.ROOT, "queue: %s\n", SystemUtils.h()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gamerules = this.k.n();
            gamerules.a(new GameRuleTypeVisitor(){

                @Override
                public <T> void a(GameRule<T> gamerule) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", gamerule.b(), gamerules.b(gamerule)));
                }
            });
            for (String s2 : list) {
                writer.write(s2);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String s2 = System.getProperty("java.class.path");
            String s1 = File.pathSeparator;
            for (String s22 : Splitter.on((String)s1).split((CharSequence)s2)) {
                writer.write(s22);
                writer.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadinfo : athreadinfo) {
                writer.write(threadinfo.toString());
                ((Writer)writer).write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);
        try {
            ArrayList list;
            try {
                list = Lists.newArrayList(NativeModuleLister.a());
            }
            catch (Throwable throwable) {
                m.warn("Failed to list native modules", throwable);
                if (writer != null) {
                    ((Writer)writer).close();
                }
                return;
            }
            list.sort(Comparator.comparing(nativemodulelister_a -> nativemodulelister_a.a));
            for (NativeModuleLister.a nativemodulelister_a2 : list) {
                writer.write(nativemodulelister_a2.toString());
                ((Writer)writer).write(10);
            }
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public boolean isDebugging() {
        return false;
    }

    @Deprecated
    public static MinecraftServer getServer() {
        return Bukkit.getServer() instanceof CraftServer ? ((CraftServer)Bukkit.getServer()).getServer() : null;
    }

    @Deprecated
    public static IRegistryCustom getDefaultRegistryAccess() {
        return CraftRegistry.getMinecraftRegistry();
    }

    private GameProfilerFiller bQ() {
        if (this.E) {
            this.B = ActiveMetricsRecorder.a(new ServerMetricsSamplersProvider(SystemUtils.c, this.n()), SystemUtils.c, SystemUtils.i(), new MetricsPersister("server"), this.C, path -> {
                this.h(() -> this.b(path.resolve("server")));
                this.D.accept((Path)path);
            });
            this.E = false;
        }
        this.B.c();
        return GameProfilerTick.a(this.B.f(), GameProfilerTick.a("Server"));
    }

    public void aU() {
        this.B.d();
    }

    public boolean aV() {
        return this.B.e();
    }

    public void a(Consumer<MethodProfilerResults> consumer, Consumer<Path> consumer1) {
        this.C = methodprofilerresults -> {
            this.aW();
            consumer.accept((MethodProfilerResults)methodprofilerresults);
        };
        this.D = consumer1;
        this.E = true;
    }

    public void aW() {
        this.B = InactiveMetricsRecorder.a;
    }

    public void aX() {
        this.B.a();
    }

    public void aY() {
        this.B.b();
    }

    public Path a(SavedFile savedfile) {
        return this.g.a(savedfile);
    }

    public boolean aZ() {
        return true;
    }

    public StructureTemplateManager ba() {
        return this.aE;
    }

    public SaveData bb() {
        return this.k;
    }

    public IRegistryCustom.Dimension bc() {
        return this.P.a();
    }

    public LayeredRegistryAccess<RegistryLayer> bd() {
        return this.P;
    }

    public ReloadableServerRegistries.a be() {
        return this.aD.b.b();
    }

    public ITextFilter a(EntityPlayer entityplayer) {
        return ITextFilter.e;
    }

    public PlayerInteractManager b(EntityPlayer entityplayer) {
        return this.aa() ? new DemoPlayerInteractManager(entityplayer) : new PlayerInteractManager(entityplayer);
    }

    public @Nullable EnumGamemode bf() {
        return null;
    }

    public IResourceManager bg() {
        return this.aD.a;
    }

    public boolean bh() {
        return this.aL;
    }

    public boolean bi() {
        return this.G || this.F != null;
    }

    public void bj() {
        this.G = true;
    }

    public MethodProfilerResults bk() {
        if (this.F == null) {
            return MethodProfilerResultsEmpty.a;
        }
        MethodProfilerResults methodprofilerresults = this.F.a(SystemUtils.d(), this.U);
        this.F = null;
        return methodprofilerresults;
    }

    public int bl() {
        return 1000000;
    }

    public void a(IChatBaseComponent ichatbasecomponent, ChatMessageType.a chatmessagetype_a, @Nullable String s2) {
        String s1 = chatmessagetype_a.a(ichatbasecomponent).getString();
        if (s2 != null) {
            m.info("[{}] {}", (Object)s2, (Object)s1);
        } else {
            m.info("{}", (Object)s1);
        }
    }

    public ChatDecorator bm() {
        return ChatDecorator.a;
    }

    public boolean bn() {
        return true;
    }

    public void handleCustomClickAction(MinecraftKey minecraftkey, Optional<NBTBase> optional, EntityPlayer player) {
        m.debug("Received custom click action {} with payload {}", (Object)minecraftkey, optional.orElse(null));
        CraftEventFactory.callPlayerCustomClickEvent(minecraftkey, optional, player);
    }

    public LevelLoadListener bo() {
        return this.I;
    }

    public boolean i(boolean flag) {
        boolean flag1 = false;
        for (WorldServer worldserver : this.P()) {
            if (worldserver == null || worldserver.e != flag) continue;
            worldserver.e = !flag;
            flag1 = true;
        }
        return flag1;
    }

    public boolean bp() {
        for (WorldServer worldserver : this.P()) {
            if (worldserver == null || worldserver.e) continue;
            return true;
        }
        return false;
    }

    public static <T> void onGameRuleChanged(GameRule<T> gamerule, T t0, WorldServer worldserver) {
        worldserver.s().C().a(gamerule, t0);
        if (gamerule == GameRules.P) {
            byte b0 = (byte)((Boolean)t0 != false ? 22 : 23);
            for (EntityPlayer entityplayer : worldserver.E()) {
                entityplayer.g.b(new PacketPlayOutEntityStatus(entityplayer, b0));
            }
        } else if (gamerule != GameRules.u && gamerule != GameRules.r) {
            if (gamerule == GameRules.v) {
                ServerWaypointManager serverwaypointmanager = worldserver.j();
                if (((Boolean)t0).booleanValue()) {
                    List<EntityPlayer> list = worldserver.E();
                    Objects.requireNonNull(serverwaypointmanager);
                    list.forEach(serverwaypointmanager::b);
                } else {
                    serverwaypointmanager.a();
                }
            } else if (gamerule == GameRules.W) {
                worldserver.b(worldserver.O());
            }
        } else {
            PacketPlayOutGameStateChange.a packetplayoutgamestatechange_a = gamerule == GameRules.u ? PacketPlayOutGameStateChange.n : PacketPlayOutGameStateChange.m;
            PacketPlayOutGameStateChange packetplayoutgamestatechange = new PacketPlayOutGameStateChange(packetplayoutgamestatechange_a, (Boolean)t0 != false ? 1.0f : 0.0f);
            worldserver.E().forEach(entityplayer1 -> entityplayer1.g.b(packetplayoutgamestatechange));
        }
    }

    public boolean bq() {
        return false;
    }

    private void a(CrashReport crashreport, ChunkCoordIntPair chunkcoordintpair, RegionStorageInfo regionstorageinfo) {
        SystemUtils.i().execute(() -> {
            try {
                Path path = this.c("debug");
                net.minecraft.util.FileUtils.c(path);
                String s2 = net.minecraft.util.FileUtils.a(regionstorageinfo.a());
                Path path1 = path.resolve("chunk-" + s2 + "-" + SystemUtils.f() + "-server.txt");
                FileStore filestore = java.nio.file.Files.getFileStore(path);
                long i2 = filestore.getUsableSpace();
                if (i2 < 8192L) {
                    m.warn("Not storing chunk IO report due to low space on drive {}", (Object)filestore.name());
                    return;
                }
                CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk Info");
                Objects.requireNonNull(regionstorageinfo);
                crashreportsystemdetails.a("Level", regionstorageinfo::a);
                crashreportsystemdetails.a("Dimension", () -> regionstorageinfo.b().a().toString());
                Objects.requireNonNull(regionstorageinfo);
                crashreportsystemdetails.a("Storage", regionstorageinfo::c);
                Objects.requireNonNull(chunkcoordintpair);
                crashreportsystemdetails.a("Position", chunkcoordintpair::toString);
                crashreport.a(path1, ReportType.e);
                m.info("Saved details to {}", (Object)crashreport.e());
            }
            catch (Exception exception) {
                m.warn("Failed to store chunk IO exception", (Throwable)exception);
            }
        });
    }

    @Override
    public void a(Throwable throwable, RegionStorageInfo regionstorageinfo, ChunkCoordIntPair chunkcoordintpair) {
        m.error("Failed to load chunk {},{}", new Object[]{chunkcoordintpair.h, chunkcoordintpair.i, throwable});
        this.aN.a("chunk/load", throwable);
        this.a(CrashReport.a(throwable, "Chunk load failure"), chunkcoordintpair, regionstorageinfo);
    }

    @Override
    public void b(Throwable throwable, RegionStorageInfo regionstorageinfo, ChunkCoordIntPair chunkcoordintpair) {
        m.error("Failed to save chunk {},{}", new Object[]{chunkcoordintpair.h, chunkcoordintpair.i, throwable});
        this.aN.a("chunk/save", throwable);
        this.a(CrashReport.a(throwable, "Chunk save failure"), chunkcoordintpair, regionstorageinfo);
    }

    public void a(Throwable throwable, PacketType<?> packettype) {
        this.aN.a("packet/" + String.valueOf(packettype), throwable);
    }

    public PotionBrewer br() {
        return this.aI;
    }

    public FuelValues bs() {
        return this.aJ;
    }

    public ServerLinks bt() {
        return ServerLinks.a;
    }

    protected int bu() {
        return 0;
    }

    public PacketProcessor bv() {
        return this.aP;
    }

    public ServerDebugSubscribers bw() {
        return this.aG;
    }

    public record ReloadableResources(IReloadableResourceManager a, DataPackResources b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    private static class TimeProfiler {
        final long a;
        final int b;

        TimeProfiler(long i2, int j2) {
            this.a = i2;
            this.b = j2;
        }

        MethodProfilerResults a(final long i2, final int j2) {
            return new MethodProfilerResults(){

                @Override
                public List<MethodProfilerResultsField> a(String s2) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return i2;
                }

                @Override
                public int d() {
                    return j2;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public record ServerResourcePackInfo(UUID a, String b, String c, boolean d, @Nullable IChatBaseComponent e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

