/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.PersistentScoreboard;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.jspecify.annotations.Nullable;

public class ScoreboardServer
extends Scoreboard {
    private final MinecraftServer b;
    private final Set<ScoreboardObjective> c = Sets.newHashSet();
    private boolean d;

    public ScoreboardServer(MinecraftServer minecraftserver) {
        this.b = minecraftserver;
    }

    public void a(PersistentScoreboard.a persistentscoreboard_a) {
        persistentscoreboard_a.a().forEach(scoreboardobjective_a -> this.a((ScoreboardObjective.a)scoreboardobjective_a));
        persistentscoreboard_a.b().forEach(scoreboard_a -> this.a((Scoreboard.a)scoreboard_a));
        persistentscoreboard_a.c().forEach((displayslot, s2) -> {
            ScoreboardObjective scoreboardobjective = this.a((String)s2);
            this.a((DisplaySlot)displayslot, scoreboardobjective);
        });
        persistentscoreboard_a.d().forEach(scoreboardteam_a -> this.a((ScoreboardTeam.a)scoreboardteam_a));
    }

    private PersistentScoreboard.a k() {
        return new PersistentScoreboard.a(this.i(), this.g(), this.j(), this.h());
    }

    @Override
    protected void a(ScoreHolder scoreholder, ScoreboardObjective scoreboardobjective, ScoreboardScore scoreboardscore) {
        super.a(scoreholder, scoreboardobjective, scoreboardscore);
        if (this.c.contains(scoreboardobjective)) {
            this.broadcastAll(new PacketPlayOutScoreboardScore(scoreholder.da(), scoreboardobjective.c(), scoreboardscore.a(), Optional.ofNullable(scoreboardscore.e()), Optional.ofNullable(scoreboardscore.c())));
        }
        this.a();
    }

    @Override
    protected void a(ScoreHolder scoreholder, ScoreboardObjective scoreboardobjective) {
        super.a(scoreholder, scoreboardobjective);
        this.a();
    }

    @Override
    public void a(ScoreHolder scoreholder) {
        super.a(scoreholder);
        this.broadcastAll(new ClientboundResetScorePacket(scoreholder.da(), null));
        this.a();
    }

    @Override
    public void b(ScoreHolder scoreholder, ScoreboardObjective scoreboardobjective) {
        super.b(scoreholder, scoreboardobjective);
        if (this.c.contains(scoreboardobjective)) {
            this.broadcastAll(new ClientboundResetScorePacket(scoreholder.da(), scoreboardobjective.c()));
        }
        this.a();
    }

    @Override
    public void a(DisplaySlot displayslot, @Nullable ScoreboardObjective scoreboardobjective) {
        ScoreboardObjective scoreboardobjective1 = this.a(displayslot);
        super.a(displayslot, scoreboardobjective);
        if (scoreboardobjective1 != scoreboardobjective && scoreboardobjective1 != null) {
            if (this.h(scoreboardobjective1) > 0) {
                this.broadcastAll(new PacketPlayOutScoreboardDisplayObjective(displayslot, scoreboardobjective));
            } else {
                this.g(scoreboardobjective1);
            }
        }
        if (scoreboardobjective != null) {
            if (this.c.contains(scoreboardobjective)) {
                this.broadcastAll(new PacketPlayOutScoreboardDisplayObjective(displayslot, scoreboardobjective));
            } else {
                this.e(scoreboardobjective);
            }
        }
        this.a();
    }

    @Override
    public boolean a(String s2, ScoreboardTeam scoreboardteam) {
        if (super.a(s2, scoreboardteam)) {
            this.broadcastAll(PacketPlayOutScoreboardTeam.a(scoreboardteam, s2, PacketPlayOutScoreboardTeam.a.a));
            this.f(s2);
            this.a();
            return true;
        }
        return false;
    }

    @Override
    public void b(String s2, ScoreboardTeam scoreboardteam) {
        super.b(s2, scoreboardteam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(scoreboardteam, s2, PacketPlayOutScoreboardTeam.a.b));
        this.f(s2);
        this.a();
    }

    @Override
    public void a(ScoreboardObjective scoreboardobjective) {
        super.a(scoreboardobjective);
        this.a();
    }

    @Override
    public void b(ScoreboardObjective scoreboardobjective) {
        super.b(scoreboardobjective);
        if (this.c.contains(scoreboardobjective)) {
            this.broadcastAll(new PacketPlayOutScoreboardObjective(scoreboardobjective, 2));
        }
        this.a();
    }

    @Override
    public void c(ScoreboardObjective scoreboardobjective) {
        super.c(scoreboardobjective);
        if (this.c.contains(scoreboardobjective)) {
            this.g(scoreboardobjective);
        }
        this.a();
    }

    @Override
    public void a(ScoreboardTeam scoreboardteam) {
        super.a(scoreboardteam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(scoreboardteam, true));
        this.a();
    }

    @Override
    public void b(ScoreboardTeam scoreboardteam) {
        super.b(scoreboardteam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(scoreboardteam, false));
        this.e(scoreboardteam);
        this.a();
    }

    @Override
    public void c(ScoreboardTeam scoreboardteam) {
        super.c(scoreboardteam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(scoreboardteam));
        this.e(scoreboardteam);
        this.a();
    }

    protected void a() {
        this.d = true;
    }

    public void a(PersistentScoreboard persistentscoreboard) {
        if (this.d) {
            this.d = false;
            persistentscoreboard.a(this.k());
        }
    }

    public List<Packet<?>> d(ScoreboardObjective scoreboardobjective) {
        ArrayList list = Lists.newArrayList();
        list.add(new PacketPlayOutScoreboardObjective(scoreboardobjective, 0));
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.a(displayslot) != scoreboardobjective) continue;
            list.add(new PacketPlayOutScoreboardDisplayObjective(displayslot, scoreboardobjective));
        }
        for (PlayerScoreEntry playerscoreentry : this.i(scoreboardobjective)) {
            list.add(new PacketPlayOutScoreboardScore(playerscoreentry.c(), scoreboardobjective.c(), playerscoreentry.d(), Optional.ofNullable(playerscoreentry.e()), Optional.ofNullable(playerscoreentry.f())));
        }
        return list;
    }

    public void e(ScoreboardObjective scoreboardobjective) {
        List<Packet<?>> list = this.d(scoreboardobjective);
        for (EntityPlayer entityplayer : this.b.aj().t()) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : list) {
                entityplayer.g.b(packet);
            }
        }
        this.c.add(scoreboardobjective);
    }

    public List<Packet<?>> f(ScoreboardObjective scoreboardobjective) {
        ArrayList list = Lists.newArrayList();
        list.add(new PacketPlayOutScoreboardObjective(scoreboardobjective, 1));
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.a(displayslot) != scoreboardobjective) continue;
            list.add(new PacketPlayOutScoreboardDisplayObjective(displayslot, scoreboardobjective));
        }
        return list;
    }

    public void g(ScoreboardObjective scoreboardobjective) {
        List<Packet<?>> list = this.f(scoreboardobjective);
        for (EntityPlayer entityplayer : this.b.aj().t()) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : list) {
                entityplayer.g.b(packet);
            }
        }
        this.c.remove(scoreboardobjective);
    }

    public int h(ScoreboardObjective scoreboardobjective) {
        int i2 = 0;
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.a(displayslot) != scoreboardobjective) continue;
            ++i2;
        }
        return i2;
    }

    private void f(String s2) {
        EntityPlayer entityplayer = this.b.aj().a(s2);
        if (entityplayer != null) {
            entityplayer.A().j().d(entityplayer);
        }
    }

    private void e(ScoreboardTeam scoreboardteam) {
        for (WorldServer worldserver : this.b.P()) {
            scoreboardteam.h().stream().map(s2 -> this.b.aj().a((String)s2)).filter(Objects::nonNull).forEach(entityplayer -> worldserver.j().d((WaypointTransmitter)entityplayer));
        }
    }

    private void broadcastAll(Packet packet) {
        for (EntityPlayer entityplayer : this.b.aj().k) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            entityplayer.g.b(packet);
        }
    }
}

