/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.FileUtils;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.storage.SavedFile;
import org.slf4j.Logger;

public class CommandDatapack {
    private static final Logger a = LogUtils.getLogger();
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("commands.datapack.unknown", var0));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("commands.datapack.enable.failed", var0));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("commands.datapack.disable.failed", var0));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("commands.datapack.disable.failed.feature", var0));
    private static final Dynamic2CommandExceptionType f = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.b("commands.datapack.enable.failed.no_flags", var0, var1));
    private static final DynamicCommandExceptionType g = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("commands.datapack.create.invalid_name", var0));
    private static final DynamicCommandExceptionType h = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("commands.datapack.create.invalid_full_name", var0));
    private static final DynamicCommandExceptionType i = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("commands.datapack.create.already_exists", var0));
    private static final Dynamic2CommandExceptionType j = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.b("commands.datapack.create.metadata_encode_failure", var0, var1));
    private static final DynamicCommandExceptionType k = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("commands.datapack.create.io_failure", var0));
    private static final SuggestionProvider<CommandListenerWrapper> l = (var0, var1) -> ICompletionProvider.b(((CommandListenerWrapper)var0.getSource()).m().aE().e().stream().map(StringArgumentType::escapeIfRequired), var1);
    private static final SuggestionProvider<CommandListenerWrapper> m = (var0, var12) -> {
        ResourcePackRepository var2 = ((CommandListenerWrapper)var0.getSource()).m().aE();
        Collection<String> var3 = var2.e();
        FeatureFlagSet var4 = ((CommandListenerWrapper)var0.getSource()).w();
        return ICompletionProvider.b(var2.d().stream().filter(var1 -> var1.e().a(var4)).map(ResourcePackLoader::g).filter(var1 -> !var3.contains(var1)).map(StringArgumentType::escapeIfRequired), var12);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> var03, CommandBuildContext var1) {
        var03.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("datapack").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(net.minecraft.commands.CommandDispatcher.b("enable").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.string()).suggests(m).executes(var02 -> CommandDatapack.a((CommandListenerWrapper)var02.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)var02, "name", true), (List<ResourcePackLoader> var0, ResourcePackLoader var1) -> var1.k().a(var0, var1, ResourcePackLoader::h, false)))).then(net.minecraft.commands.CommandDispatcher.b("after").then(net.minecraft.commands.CommandDispatcher.a("existing", StringArgumentType.string()).suggests(l).executes(var0 -> CommandDatapack.a((CommandListenerWrapper)var0.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)var0, "name", true), (List<ResourcePackLoader> var1, ResourcePackLoader var2) -> var1.add(var1.indexOf(CommandDatapack.a((CommandContext<CommandListenerWrapper>)var0, "existing", false)) + 1, var2)))))).then(net.minecraft.commands.CommandDispatcher.b("before").then(net.minecraft.commands.CommandDispatcher.a("existing", StringArgumentType.string()).suggests(l).executes(var0 -> CommandDatapack.a((CommandListenerWrapper)var0.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)var0, "name", true), (List<ResourcePackLoader> var1, ResourcePackLoader var2) -> var1.add(var1.indexOf(CommandDatapack.a((CommandContext<CommandListenerWrapper>)var0, "existing", false)), var2)))))).then(net.minecraft.commands.CommandDispatcher.b("last").executes(var0 -> CommandDatapack.a((CommandListenerWrapper)var0.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)var0, "name", true), List::add)))).then(net.minecraft.commands.CommandDispatcher.b("first").executes(var02 -> CommandDatapack.a((CommandListenerWrapper)var02.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)var02, "name", true), (List<ResourcePackLoader> var0, ResourcePackLoader var1) -> var0.add(0, var1))))))).then(net.minecraft.commands.CommandDispatcher.b("disable").then(net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.string()).suggests(l).executes(var0 -> CommandDatapack.a((CommandListenerWrapper)var0.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)var0, "name", false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("list").executes(var0 -> CommandDatapack.a((CommandListenerWrapper)var0.getSource()))).then(net.minecraft.commands.CommandDispatcher.b("available").executes(var0 -> CommandDatapack.b((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("enabled").executes(var0 -> CommandDatapack.c((CommandListenerWrapper)var0.getSource()))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("create").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.f))).then(net.minecraft.commands.CommandDispatcher.a("id", StringArgumentType.string()).then(net.minecraft.commands.CommandDispatcher.a("description", ArgumentChatComponent.a(var1)).executes(var0 -> CommandDatapack.a((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"id"), ArgumentChatComponent.b((CommandContext<CommandListenerWrapper>)var0, "description"))))))));
    }

    private static int a(CommandListenerWrapper var0, String var1, IChatBaseComponent var2) throws CommandSyntaxException {
        Path var3 = var0.m().a(SavedFile.j);
        if (!FileUtils.f(var1)) {
            throw g.create((Object)var1);
        }
        if (!FileUtils.b(var1)) {
            throw h.create((Object)var1);
        }
        Path var4 = var3.resolve(var1);
        if (Files.exists(var4, new LinkOption[0])) {
            throw i.create((Object)var1);
        }
        ResourcePackInfo var5 = new ResourcePackInfo(var2, SharedConstants.b().a(EnumResourcePackType.b).a());
        DataResult var6 = ResourcePackInfo.b.b().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)var5);
        Optional var7 = var6.error();
        if (var7.isPresent()) {
            throw j.create((Object)var1, (Object)((DataResult.Error)var7.get()).message());
        }
        JsonObject var8 = new JsonObject();
        var8.add(ResourcePackInfo.b.a(), (JsonElement)var6.getOrThrow());
        try {
            Files.createDirectory(var4, new FileAttribute[0]);
            Files.createDirectory(var4.resolve(EnumResourcePackType.b.a()), new FileAttribute[0]);
            try (BufferedWriter var9 = Files.newBufferedWriter(var4.resolve("pack.mcmeta"), StandardCharsets.UTF_8, new OpenOption[0]);
                 JsonWriter var10 = new JsonWriter((Writer)var9);){
                var10.setSerializeNulls(false);
                var10.setIndent("  ");
                ChatDeserializer.a(var10, (JsonElement)var8, null);
            }
        }
        catch (IOException var9) {
            a.warn("Failed to create pack at {}", (Object)var3.toAbsolutePath(), (Object)var9);
            throw k.create((Object)var1);
        }
        var0.a(() -> IChatBaseComponent.a("commands.datapack.create.success", new Object[]{var1}), true);
        return 1;
    }

    private static int a(CommandListenerWrapper var0, ResourcePackLoader var1, a var2) throws CommandSyntaxException {
        ResourcePackRepository var3 = var0.m().aE();
        ArrayList var4 = Lists.newArrayList(var3.g());
        var2.apply(var4, var1);
        var0.a(() -> IChatBaseComponent.a("commands.datapack.modify.enable", var1.a(true)), true);
        CommandReload.a(var4.stream().map(ResourcePackLoader::g).collect(Collectors.toList()), var0);
        return var4.size();
    }

    private static int a(CommandListenerWrapper var0, ResourcePackLoader var1) {
        ResourcePackRepository var2 = var0.m().aE();
        ArrayList var3 = Lists.newArrayList(var2.g());
        var3.remove(var1);
        var0.a(() -> IChatBaseComponent.a("commands.datapack.modify.disable", var1.a(true)), true);
        CommandReload.a(var3.stream().map(ResourcePackLoader::g).collect(Collectors.toList()), var0);
        return var3.size();
    }

    private static int a(CommandListenerWrapper var0) {
        return CommandDatapack.c(var0) + CommandDatapack.b(var0);
    }

    private static int b(CommandListenerWrapper var0) {
        ResourcePackRepository var1 = var0.m().aE();
        var1.a();
        Collection<ResourcePackLoader> var22 = var1.g();
        Collection<ResourcePackLoader> var3 = var1.d();
        FeatureFlagSet var4 = var0.w();
        List<ResourcePackLoader> var5 = var3.stream().filter(var2 -> !var22.contains(var2) && var2.e().a(var4)).toList();
        if (var5.isEmpty()) {
            var0.a(() -> IChatBaseComponent.c("commands.datapack.list.available.none"), false);
        } else {
            var0.a(() -> IChatBaseComponent.a("commands.datapack.list.available.success", var5.size(), ChatComponentUtils.b(var5, (T var0) -> var0.a(false))), false);
        }
        return var5.size();
    }

    private static int c(CommandListenerWrapper var0) {
        ResourcePackRepository var1 = var0.m().aE();
        var1.a();
        Collection<ResourcePackLoader> var2 = var1.g();
        if (var2.isEmpty()) {
            var0.a(() -> IChatBaseComponent.c("commands.datapack.list.enabled.none"), false);
        } else {
            var0.a(() -> IChatBaseComponent.a("commands.datapack.list.enabled.success", var2.size(), ChatComponentUtils.b(var2, (T var0) -> var0.a(true))), false);
        }
        return var2.size();
    }

    private static ResourcePackLoader a(CommandContext<CommandListenerWrapper> var0, String var1, boolean var2) throws CommandSyntaxException {
        String var3 = StringArgumentType.getString(var0, (String)var1);
        ResourcePackRepository var4 = ((CommandListenerWrapper)var0.getSource()).m().aE();
        ResourcePackLoader var5 = var4.c(var3);
        if (var5 == null) {
            throw b.create((Object)var3);
        }
        boolean var6 = var4.g().contains(var5);
        if (var2 && var6) {
            throw c.create((Object)var3);
        }
        if (!var2 && !var6) {
            throw d.create((Object)var3);
        }
        FeatureFlagSet var7 = ((CommandListenerWrapper)var0.getSource()).w();
        FeatureFlagSet var8 = var5.e();
        if (!var2 && !var8.b() && var5.l() == PackSource.d) {
            throw e.create((Object)var3);
        }
        if (!var8.a(var7)) {
            throw f.create((Object)var3, (Object)FeatureFlags.a(var7, var8));
        }
        return var5;
    }

    static interface a {
        public void apply(List<ResourcePackLoader> var1, ResourcePackLoader var2) throws CommandSyntaxException;
    }
}

