/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.FileUtils;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.entity.SpawnCategory;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ChunkProviderServer
extends IChunkProvider {
    private static final Logger b = LogUtils.getLogger();
    private final ChunkMapDistance c;
    private final WorldServer d;
    final Thread e;
    final LightEngineThreaded f;
    private final a g;
    public final PlayerChunkMap a;
    private final WorldPersistentData h;
    public final TicketStorage i;
    private long j;
    public boolean k = true;
    private static final int l = 4;
    private final long[] m = new long[4];
    private final @Nullable ChunkStatus[] n = new ChunkStatus[4];
    private final @Nullable IChunkAccess[] o = new IChunkAccess[4];
    private final List<Chunk> p = new ObjectArrayList();
    private final Set<PlayerChunk> q = new ReferenceOpenHashSet();
    @VisibleForDebug
    private @Nullable SpawnerCreature.d r;

    public ChunkProviderServer(WorldServer worldserver, Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, StructureTemplateManager structuretemplatemanager, Executor executor, ChunkGenerator chunkgenerator, int i2, int j2, boolean flag, ChunkStatusUpdateListener chunkstatusupdatelistener, Supplier<WorldPersistentData> supplier) {
        this.d = worldserver;
        this.g = new a(worldserver);
        this.e = Thread.currentThread();
        Path path = convertable_conversionsession.a(worldserver.aq()).resolve("data");
        try {
            FileUtils.c(path);
        }
        catch (IOException ioexception) {
            b.error("Failed to create dimension data storage directory", (Throwable)ioexception);
        }
        this.h = new WorldPersistentData(path, datafixer, worldserver.J_());
        this.i = this.h.a(TicketStorage.b);
        this.a = new PlayerChunkMap(worldserver, convertable_conversionsession, datafixer, structuretemplatemanager, executor, this.g, this, chunkgenerator, chunkstatusupdatelistener, supplier, this.i, i2, flag);
        this.f = this.a.d();
        this.c = this.a.i();
        this.c.b(j2);
        this.t();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        PlayerChunk chunk = this.a.a(ChunkCoordIntPair.d(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    public LightEngineThreaded a() {
        return this.f;
    }

    private @Nullable PlayerChunk b(long i2) {
        return this.a.b(i2);
    }

    private void a(long i2, @Nullable IChunkAccess ichunkaccess, ChunkStatus chunkstatus) {
        for (int j2 = 3; j2 > 0; --j2) {
            this.m[j2] = this.m[j2 - 1];
            this.n[j2] = this.n[j2 - 1];
            this.o[j2] = this.o[j2 - 1];
        }
        this.m[0] = i2;
        this.n[0] = chunkstatus;
        this.o[0] = ichunkaccess;
    }

    @Override
    public @Nullable IChunkAccess a(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        if (Thread.currentThread() != this.e) {
            return CompletableFuture.supplyAsync(() -> this.a(i2, j2, chunkstatus, flag), this.g).join();
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.f("getChunk");
        long k2 = ChunkCoordIntPair.d(i2, j2);
        for (int l2 = 0; l2 < 4; ++l2) {
            IChunkAccess ichunkaccess;
            if (k2 != this.m[l2] || chunkstatus != this.n[l2] || (ichunkaccess = this.o[l2]) == null) continue;
            return ichunkaccess;
        }
        gameprofilerfiller.f("getChunkCacheMiss");
        this.d.timings.syncChunkLoadTimer.startTiming();
        CompletableFuture<ChunkResult<IChunkAccess>> completablefuture = this.c(i2, j2, chunkstatus, flag);
        a chunkproviderserver_a = this.g;
        Objects.requireNonNull(completablefuture);
        chunkproviderserver_a.b(completablefuture::isDone);
        this.d.timings.syncChunkLoadTimer.stopTiming();
        ChunkResult<IChunkAccess> chunkresult = completablefuture.join();
        IChunkAccess ichunkaccess1 = chunkresult.b((IChunkAccess)null);
        if (ichunkaccess1 == null && flag) {
            throw SystemUtils.b(new IllegalStateException("Chunk not there when requested: " + chunkresult.b()));
        }
        this.a(k2, ichunkaccess1, chunkstatus);
        return ichunkaccess1;
    }

    @Override
    public @Nullable Chunk a(int i2, int j2) {
        if (Thread.currentThread() != this.e) {
            return null;
        }
        Profiler.a().f("getChunkNow");
        long k2 = ChunkCoordIntPair.d(i2, j2);
        for (int l2 = 0; l2 < 4; ++l2) {
            if (k2 != this.m[l2] || this.n[l2] != ChunkStatus.n) continue;
            IChunkAccess ichunkaccess = this.o[l2];
            return ichunkaccess instanceof Chunk ? (Chunk)ichunkaccess : null;
        }
        PlayerChunk playerchunk = this.b(k2);
        if (playerchunk == null) {
            return null;
        }
        IChunkAccess ichunkaccess1 = playerchunk.b(ChunkStatus.n);
        if (ichunkaccess1 != null) {
            this.a(k2, ichunkaccess1, ChunkStatus.n);
            if (ichunkaccess1 instanceof Chunk) {
                return (Chunk)ichunkaccess1;
            }
        }
        return null;
    }

    private void t() {
        Arrays.fill(this.m, ChunkCoordIntPair.c);
        Arrays.fill(this.n, null);
        Arrays.fill(this.o, null);
    }

    public CompletableFuture<ChunkResult<IChunkAccess>> b(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        CompletionStage<ChunkResult<IChunkAccess>> completablefuture;
        boolean flag1;
        boolean bl = flag1 = Thread.currentThread() == this.e;
        if (flag1) {
            completablefuture = this.c(i2, j2, chunkstatus, flag);
            a chunkproviderserver_a = this.g;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_a.b(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.c(i2, j2, chunkstatus, flag), this.g).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<ChunkResult<IChunkAccess>> c(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2, j2);
        long k2 = chunkcoordintpair.b();
        int l2 = ChunkLevel.a(chunkstatus);
        PlayerChunk playerchunk = this.b(k2);
        boolean currentlyUnloading = false;
        if (playerchunk != null) {
            FullChunkStatus oldChunkState = ChunkLevel.c(playerchunk.j);
            FullChunkStatus currentChunkState = ChunkLevel.c(playerchunk.j());
            boolean bl = currentlyUnloading = oldChunkState.a(FullChunkStatus.b) && !currentChunkState.a(FullChunkStatus.b);
        }
        if (flag && !currentlyUnloading) {
            this.a(new Ticket(TicketType.o, l2), chunkcoordintpair);
            if (this.a(playerchunk, l2)) {
                GameProfilerFiller gameprofilerfiller = Profiler.a();
                gameprofilerfiller.a("chunkLoad");
                this.d();
                playerchunk = this.b(k2);
                gameprofilerfiller.c();
                if (this.a(playerchunk, l2)) {
                    throw SystemUtils.b(new IllegalStateException("No chunk holder after ticket has been added"));
                }
            }
        }
        return this.a(playerchunk, l2) ? GenerationChunkHolder.c : playerchunk.a(chunkstatus, this.a);
    }

    private boolean a(@Nullable PlayerChunk playerchunk, int i2) {
        return playerchunk == null || playerchunk.j > i2;
    }

    @Override
    public boolean b(int i2, int j2) {
        int k2;
        PlayerChunk playerchunk = this.b(new ChunkCoordIntPair(i2, j2).b());
        return !this.a(playerchunk, k2 = ChunkLevel.a(ChunkStatus.n));
    }

    @Override
    public @Nullable LightChunk c(int i2, int j2) {
        long k2 = ChunkCoordIntPair.d(i2, j2);
        PlayerChunk playerchunk = this.b(k2);
        return playerchunk == null ? null : playerchunk.a(ChunkStatus.k.c());
    }

    public World b() {
        return this.d;
    }

    public boolean c() {
        return this.g.E();
    }

    boolean d() {
        boolean flag = this.c.a(this.a);
        boolean flag1 = this.a.f();
        this.a.g();
        if (!flag && !flag1) {
            return false;
        }
        this.t();
        return true;
    }

    public boolean a(long i2) {
        if (!this.d.a(i2)) {
            return false;
        }
        PlayerChunk playerchunk = this.b(i2);
        return playerchunk == null ? false : playerchunk.a().getNow(PlayerChunk.a).a();
    }

    public void a(boolean flag) {
        this.d();
        this.a.a(flag);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.a(true);
        }
        this.h.close();
        this.f.close();
        this.a.close();
    }

    public void purgeUnload() {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("purge");
        this.i.a(this.a);
        this.d();
        gameprofilerfiller.b("unload");
        this.a.a(() -> true);
        gameprofilerfiller.c();
        this.t();
    }

    @Override
    public void a(BooleanSupplier booleansupplier, boolean flag) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("purge");
        this.d.timings.doChunkMap.startTiming();
        if (this.d.y().i() || !flag || this.d.spigotConfig.unloadFrozenChunks) {
            this.i.a(this.a);
        }
        this.d();
        this.d.timings.doChunkMap.stopTiming();
        gameprofilerfiller.b("chunks");
        if (flag) {
            this.u();
            this.d.timings.tracker.startTiming();
            this.a.j();
            this.d.timings.tracker.stopTiming();
        }
        this.d.timings.doChunkUnload.startTiming();
        gameprofilerfiller.b("unload");
        this.a.a(booleansupplier);
        this.d.timings.doChunkUnload.stopTiming();
        gameprofilerfiller.c();
        this.t();
    }

    private void u() {
        long i2 = this.d.au();
        long j2 = i2 - this.j;
        this.j = i2;
        if (!this.d.ar()) {
            GameProfilerFiller gameprofilerfiller = Profiler.a();
            gameprofilerfiller.a("pollingChunks");
            if (this.d.y().i()) {
                gameprofilerfiller.a("tickingChunks");
                this.a(gameprofilerfiller, j2);
                gameprofilerfiller.c();
            }
            this.a(gameprofilerfiller);
            gameprofilerfiller.c();
        }
    }

    private void a(GameProfilerFiller gameprofilerfiller) {
        gameprofilerfiller.a("broadcast");
        for (PlayerChunk playerchunk : this.q) {
            Chunk chunk = playerchunk.d();
            if (chunk == null) continue;
            playerchunk.a(chunk);
        }
        this.q.clear();
        gameprofilerfiller.c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(GameProfilerFiller gameprofilerfiller, long i2) {
        List<EnumCreatureType> list;
        SpawnerCreature.d spawnercreature_d;
        gameprofilerfiller.a("naturalSpawnCount");
        int j2 = this.c.a();
        this.r = spawnercreature_d = SpawnerCreature.a(j2, this.d.H(), this::a, new LocalMobCapCalculator(this.a));
        boolean flag = this.d.U().a(GameRules.V) != false && !this.d.E().isEmpty();
        int k2 = this.d.U().a(GameRules.O);
        if (flag) {
            boolean flag1 = this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && this.d.D_().b() % this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
            list = SpawnerCreature.getFilteredSpawningCategories(spawnercreature_d, true, this.k, flag1, this.d);
        } else {
            list = List.of();
        }
        List<Chunk> list1 = this.p;
        try {
            gameprofilerfiller.b("filteringSpawningChunks");
            this.a.a(list1);
            gameprofilerfiller.b("shuffleSpawningChunks");
            SystemUtils.c(list1, this.d.y);
            gameprofilerfiller.b("tickSpawningChunks");
            for (Chunk chunk : list1) {
                this.a(chunk, i2, list, spawnercreature_d);
            }
        }
        finally {
            list1.clear();
        }
        gameprofilerfiller.b("tickTickingChunks");
        this.a.a((Chunk chunk1) -> {
            this.d.timings.doTickTiles.startTiming();
            this.d.a((Chunk)chunk1, k2);
            this.d.timings.doTickTiles.stopTiming();
        });
        if (flag) {
            gameprofilerfiller.b("customSpawners");
            this.d.a(this.k);
        }
        gameprofilerfiller.c();
    }

    private void a(Chunk chunk, long i2, List<EnumCreatureType> list, SpawnerCreature.d spawnercreature_d) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        chunk.b(i2);
        if (this.c.c(chunkcoordintpair.b())) {
            this.d.a(chunk);
        }
        if (!list.isEmpty() && this.d.c(chunkcoordintpair) && this.a.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, true)) {
            SpawnerCreature.a(this.d, chunk, spawnercreature_d, list);
        }
    }

    private void a(long i2, Consumer<Chunk> consumer) {
        PlayerChunk playerchunk = this.b(i2);
        if (playerchunk != null) {
            playerchunk.c().getNow(PlayerChunk.a).a(consumer);
        }
    }

    @Override
    public String e() {
        return Integer.toString(this.j());
    }

    @VisibleForTesting
    public int f() {
        return this.g.bL();
    }

    public ChunkGenerator g() {
        return this.a.a();
    }

    public ChunkGeneratorStructureState h() {
        return this.a.b();
    }

    public RandomState i() {
        return this.a.c();
    }

    @Override
    public int j() {
        return this.a.h();
    }

    public void a(BlockPosition blockposition) {
        int j2;
        int i2 = SectionPosition.a(blockposition.u());
        PlayerChunk playerchunk = this.b(ChunkCoordIntPair.d(i2, j2 = SectionPosition.a(blockposition.w())));
        if (playerchunk != null && playerchunk.a(blockposition)) {
            this.q.add(playerchunk);
        }
    }

    @Override
    public void a(EnumSkyBlock enumskyblock, SectionPosition sectionposition) {
        this.g.execute(() -> {
            PlayerChunk playerchunk = this.b(sectionposition.r().b());
            if (playerchunk != null && playerchunk.a(enumskyblock, sectionposition.b())) {
                this.q.add(playerchunk);
            }
        });
    }

    public boolean k() {
        return this.i.d();
    }

    public void a(Ticket ticket, ChunkCoordIntPair chunkcoordintpair) {
        this.i.a(ticket, chunkcoordintpair);
    }

    public CompletableFuture<?> a(TicketType tickettype, ChunkCoordIntPair chunkcoordintpair, int i2) {
        if (!tickettype.b()) {
            throw new IllegalStateException("Ticket type " + String.valueOf(tickettype) + " does not trigger chunk loading");
        }
        if (tickettype.e()) {
            throw new IllegalStateException("Ticket type " + String.valueOf(tickettype) + " can expire before it loads, cannot fetch asynchronously");
        }
        this.b(tickettype, chunkcoordintpair, i2);
        this.d();
        PlayerChunk playerchunk = this.b(chunkcoordintpair.b());
        Objects.requireNonNull(playerchunk, "No chunk was scheduled for loading");
        return this.a.a(playerchunk, i2, (int j2) -> ChunkStatus.n);
    }

    public void b(TicketType tickettype, ChunkCoordIntPair chunkcoordintpair, int i2) {
        this.i.a(tickettype, chunkcoordintpair, i2);
    }

    public void c(TicketType tickettype, ChunkCoordIntPair chunkcoordintpair, int i2) {
        this.i.b(tickettype, chunkcoordintpair, i2);
    }

    @Override
    public boolean a(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        return this.i.a(chunkcoordintpair, flag);
    }

    @Override
    public LongSet l() {
        return this.i.f();
    }

    public void a(EntityPlayer entityplayer) {
        if (!entityplayer.eh()) {
            this.a.a(entityplayer);
            if (entityplayer.o()) {
                this.d.j().b(entityplayer);
            }
        }
    }

    public void a(Entity entity) {
        this.a.b(entity);
    }

    public void b(Entity entity) {
        this.a.a(entity);
    }

    public void a(Entity entity, Packet<? super PacketListenerPlayOut> packet) {
        this.a.b(entity, packet);
    }

    public void b(Entity entity, Packet<? super PacketListenerPlayOut> packet) {
        this.a.a(entity, packet);
    }

    public void a(int i2) {
        this.a.a(i2);
    }

    public void b(int i2) {
        this.c.b(i2);
    }

    @Override
    public void b(boolean flag) {
        this.k = flag;
    }

    public String a(ChunkCoordIntPair chunkcoordintpair) {
        return this.a.a(chunkcoordintpair);
    }

    public WorldPersistentData m() {
        return this.h;
    }

    public VillagePlace n() {
        return this.a.k();
    }

    public ChunkScanAccess o() {
        return this.a.m();
    }

    @VisibleForDebug
    public @Nullable SpawnerCreature.d p() {
        return this.r;
    }

    public void q() {
        this.i.e();
    }

    public void a(PlayerChunk playerchunk) {
        if (playerchunk.i()) {
            this.q.add(playerchunk);
        }
    }

    private final class a
    extends IAsyncTaskHandler<Runnable> {
        a(World world) {
            super("Chunk source main thread executor for " + String.valueOf(world.aq().a()));
        }

        @Override
        public void b(BooleanSupplier booleansupplier) {
            super.b(() -> MinecraftServer.B() && booleansupplier.getAsBoolean());
        }

        @Override
        public Runnable f(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean e(Runnable runnable) {
            return true;
        }

        @Override
        protected boolean av() {
            return true;
        }

        @Override
        protected Thread aw() {
            return ChunkProviderServer.this.e;
        }

        @Override
        protected void d(Runnable runnable) {
            Profiler.a().f("runTask");
            super.d(runnable);
        }

        @Override
        public boolean E() {
            try {
                if (ChunkProviderServer.this.d()) {
                    boolean bl = true;
                    return bl;
                }
                ChunkProviderServer.this.f.b();
                boolean bl = super.E();
                return bl;
            }
            finally {
                ChunkProviderServer.this.a.callbackExecutor.run();
            }
        }
    }
}

