/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutViewCentre;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskDispatcher;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.TriState;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.craftbukkit.v1_21_R7.generator.CustomChunkGenerator;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.TrackingRange;

public class PlayerChunkMap
extends SimpleRegionStorage
implements PlayerChunk.b,
GeneratingChunkMap {
    private static final ChunkResult<List<IChunkAccess>> d = ChunkResult.a("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<IChunkAccess>>> e = CompletableFuture.completedFuture(d);
    private static final byte f = -1;
    private static final byte g = 0;
    private static final byte h = 1;
    private static final Logger i = LogUtils.getLogger();
    private static final int j = 200;
    private static final int k = 20;
    private static final int l = 10000;
    private static final int m = 128;
    public static final int a = 2;
    public static final int b = 32;
    public static final int c = ChunkLevel.a(FullChunkStatus.d);
    public final Long2ObjectLinkedOpenHashMap<PlayerChunk> n = new Long2ObjectLinkedOpenHashMap();
    public volatile Long2ObjectLinkedOpenHashMap<PlayerChunk> o;
    private final Long2ObjectLinkedOpenHashMap<PlayerChunk> p;
    private final List<ChunkGenerationTask> q;
    public final WorldServer r;
    private final LightEngineThreaded s;
    private final IAsyncTaskHandler<Runnable> t;
    private final RandomState u;
    private final ChunkGeneratorStructureState v;
    private final TicketStorage w;
    private final VillagePlace x;
    public final LongSet y;
    private boolean z;
    private final ChunkTaskDispatcher A;
    private final ChunkTaskDispatcher B;
    private final ChunkStatusUpdateListener C;
    public final a D;
    private final String E;
    private final PlayerMap F;
    public final Int2ObjectMap<EntityTracker> G;
    private final Long2ByteMap H;
    private final Long2LongMap I;
    private final LongSet J;
    private final Queue<Runnable> K;
    private final AtomicInteger L;
    public int M;
    private final WorldGenContext N;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();

    public PlayerChunkMap(WorldServer worldserver, Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, StructureTemplateManager structuretemplatemanager, Executor executor, IAsyncTaskHandler<Runnable> iasynctaskhandler, ILightAccess ilightaccess, ChunkGenerator chunkgenerator, ChunkStatusUpdateListener chunkstatusupdatelistener, Supplier<WorldPersistentData> supplier, TicketStorage ticketstorage, int i2, boolean flag) {
        super(new RegionStorageInfo(convertable_conversionsession.f(), worldserver.aq(), "chunk"), convertable_conversionsession.a(worldserver.aq()).resolve("region"), datafixer, flag, DataFixTypes.d, PersistentStructureLegacy.a(worldserver.getTypeKey(), supplier, datafixer));
        this.o = this.n.clone();
        this.p = new Long2ObjectLinkedOpenHashMap();
        this.q = new ArrayList<ChunkGenerationTask>();
        this.y = new LongOpenHashSet();
        this.F = new PlayerMap();
        this.G = new Int2ObjectOpenHashMap();
        this.H = new Long2ByteOpenHashMap();
        this.I = new Long2LongOpenHashMap();
        this.J = new LongLinkedOpenHashSet();
        this.K = Queues.newConcurrentLinkedQueue();
        this.L = new AtomicInteger();
        Path path = convertable_conversionsession.a(worldserver.aq());
        this.E = path.getFileName().toString();
        this.r = worldserver;
        IRegistryCustom iregistrycustom = worldserver.J_();
        long j2 = worldserver.J();
        ChunkGenerator randomGenerator = chunkgenerator;
        if (randomGenerator instanceof CustomChunkGenerator) {
            CustomChunkGenerator customChunkGenerator = (CustomChunkGenerator)randomGenerator;
            randomGenerator = customChunkGenerator.getDelegate();
        }
        if (randomGenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract chunkgeneratorabstract = (ChunkGeneratorAbstract)randomGenerator;
            this.u = RandomState.a(chunkgeneratorabstract.h().a(), iregistrycustom.f(Registries.bm), j2);
        } else {
            this.u = RandomState.a(GeneratorSettingBase.e(), iregistrycustom.f(Registries.bm), j2);
        }
        this.v = chunkgenerator.createState(iregistrycustom.f(Registries.br), this.u, j2, worldserver.spigotConfig);
        this.t = iasynctaskhandler;
        ConsecutiveExecutor consecutiveexecutor = new ConsecutiveExecutor(executor, "worldgen");
        this.C = chunkstatusupdatelistener;
        ConsecutiveExecutor consecutiveexecutor1 = new ConsecutiveExecutor(executor, "light");
        this.A = new ChunkTaskDispatcher(consecutiveexecutor, executor);
        this.B = new ChunkTaskDispatcher(consecutiveexecutor1, executor);
        this.s = new LightEngineThreaded(ilightaccess, this, this.r.F_().e(), consecutiveexecutor1, this.B);
        this.D = new a(ticketstorage, executor, iasynctaskhandler);
        this.w = ticketstorage;
        this.x = new VillagePlace(new RegionStorageInfo(convertable_conversionsession.f(), worldserver.aq(), "poi"), path.resolve("poi"), datafixer, flag, iregistrycustom, worldserver.s(), worldserver);
        this.a(i2);
        this.N = new WorldGenContext(worldserver, chunkgenerator, structuretemplatemanager, this.s, iasynctaskhandler, this::f);
    }

    private void f(ChunkCoordIntPair chunkcoordintpair) {
        this.J.add(chunkcoordintpair.b());
    }

    protected ChunkGenerator a() {
        return this.N.b();
    }

    protected ChunkGeneratorStructureState b() {
        return this.v;
    }

    protected RandomState c() {
        return this.u;
    }

    public boolean a(EntityPlayer entityplayer, int i2, int j2) {
        return entityplayer.X().a(i2, j2) && !entityplayer.g.h.a(ChunkCoordIntPair.d(i2, j2));
    }

    private boolean b(EntityPlayer entityplayer, int i2, int j2) {
        if (!this.a(entityplayer, i2, j2)) {
            return false;
        }
        for (int k2 = -1; k2 <= 1; ++k2) {
            for (int l2 = -1; l2 <= 1; ++l2) {
                if (k2 == 0 && l2 == 0 || this.a(entityplayer, i2 + k2, j2 + l2)) continue;
                return true;
            }
        }
        return false;
    }

    protected LightEngineThreaded d() {
        return this.s;
    }

    public @Nullable PlayerChunk a(long i2) {
        return (PlayerChunk)this.n.get(i2);
    }

    protected @Nullable PlayerChunk b(long i2) {
        return (PlayerChunk)this.o.get(i2);
    }

    public @Nullable ChunkStatus c(long i2) {
        PlayerChunk playerchunk = this.b(i2);
        return playerchunk != null ? playerchunk.u() : null;
    }

    protected IntSupplier d(long i2) {
        return () -> {
            PlayerChunk playerchunk = this.b(i2);
            return playerchunk == null ? ChunkTaskQueue.a - 1 : Math.min(playerchunk.k(), ChunkTaskQueue.a - 1);
        };
    }

    public String a(ChunkCoordIntPair chunkcoordintpair) {
        PlayerChunk playerchunk = this.b(chunkcoordintpair.b());
        if (playerchunk == null) {
            return "null";
        }
        String s2 = playerchunk.j() + "\n";
        ChunkStatus chunkstatus = playerchunk.u();
        IChunkAccess ichunkaccess = playerchunk.p();
        if (chunkstatus != null) {
            s2 = s2 + "St: \u00a7" + chunkstatus.b() + String.valueOf(chunkstatus) + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s2 = s2 + "Ch: \u00a7" + ichunkaccess.n().b() + String.valueOf(ichunkaccess.n()) + "\u00a7r\n";
        }
        FullChunkStatus fullchunkstatus = playerchunk.s();
        s2 = s2 + String.valueOf('\u00a7') + fullchunkstatus.ordinal() + String.valueOf((Object)fullchunkstatus);
        return s2 + "\u00a7r";
    }

    CompletableFuture<ChunkResult<List<IChunkAccess>>> a(PlayerChunk playerchunk, int i2, IntFunction<ChunkStatus> intfunction) {
        if (i2 == 0) {
            ChunkStatus chunkstatus = intfunction.apply(0);
            return playerchunk.a(chunkstatus, this).thenApply(chunkresult -> chunkresult.a(List::of));
        }
        int j2 = MathHelper.i(i2 * 2 + 1);
        ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>> list = new ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>>(j2);
        ChunkCoordIntPair chunkcoordintpair = playerchunk.r();
        for (int k2 = -i2; k2 <= i2; ++k2) {
            for (int l2 = -i2; l2 <= i2; ++l2) {
                int i1 = Math.max(Math.abs(l2), Math.abs(k2));
                long j1 = ChunkCoordIntPair.d(chunkcoordintpair.h + l2, chunkcoordintpair.i + k2);
                PlayerChunk playerchunk1 = this.a(j1);
                if (playerchunk1 == null) {
                    return e;
                }
                ChunkStatus chunkstatus1 = intfunction.apply(i1);
                list.add(playerchunk1.a(chunkstatus1, this));
            }
        }
        return SystemUtils.c(list).thenApply(list1 -> {
            ArrayList<IChunkAccess> list2 = new ArrayList<IChunkAccess>(list1.size());
            for (ChunkResult chunkresult : list1) {
                if (chunkresult == null) {
                    throw this.a(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                IChunkAccess ichunkaccess = chunkresult.b(null);
                if (ichunkaccess == null) {
                    return d;
                }
                list2.add(ichunkaccess);
            }
            return ChunkResult.a(list2);
        });
    }

    public ReportedException a(IllegalStateException illegalstateexception, String s2) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<PlayerChunk> consumer = playerchunk -> playerchunk.t().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.r()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        this.n.values().forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        this.o.values().forEach(consumer);
        CrashReport crashreport = CrashReport.a(illegalstateexception, "Chunk loading");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk loading");
        crashreportsystemdetails.a("Details", s2);
        crashreportsystemdetails.a("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<ChunkResult<Chunk>> a(PlayerChunk playerchunk) {
        return this.a(playerchunk, 2, (int i2) -> ChunkStatus.n).thenApply(chunkresult -> chunkresult.a((T list) -> (Chunk)list.get(list.size() / 2)));
    }

    @Nullable PlayerChunk a(long i2, int j2, @Nullable PlayerChunk playerchunk, int k2) {
        if (!ChunkLevel.f(k2) && !ChunkLevel.f(j2)) {
            return playerchunk;
        }
        if (playerchunk != null) {
            playerchunk.a(j2);
        }
        if (playerchunk != null) {
            if (!ChunkLevel.f(j2)) {
                this.y.add(i2);
            } else {
                this.y.remove(i2);
            }
        }
        if (ChunkLevel.f(j2) && playerchunk == null) {
            playerchunk = (PlayerChunk)this.p.remove(i2);
            if (playerchunk != null) {
                playerchunk.a(j2);
            } else {
                playerchunk = new PlayerChunk(new ChunkCoordIntPair(i2), j2, this.r, this.s, this::a, this);
            }
            this.n.put(i2, (Object)playerchunk);
            this.z = true;
        }
        return playerchunk;
    }

    private void a(ChunkCoordIntPair chunkcoordintpair, IntSupplier intsupplier, int i2, IntConsumer intconsumer) {
        this.A.onLevelChange(chunkcoordintpair, intsupplier, i2, intconsumer);
        this.B.onLevelChange(chunkcoordintpair, intsupplier, i2, intconsumer);
    }

    @Override
    public void close() throws IOException {
        try {
            this.A.close();
            this.B.close();
            this.x.close();
        }
        finally {
            super.close();
        }
    }

    protected void a(boolean flag) {
        if (flag) {
            List<PlayerChunk> list = this.o.values().stream().filter(PlayerChunk::l).peek(PlayerChunk::m).toList();
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                mutableboolean.setFalse();
                list.stream().map(playerchunk -> {
                    IAsyncTaskHandler<Runnable> iasynctaskhandler = this.t;
                    Objects.requireNonNull(playerchunk);
                    iasynctaskhandler.b(playerchunk::h);
                    return playerchunk.p();
                }).filter(ichunkaccess -> ichunkaccess instanceof ProtoChunkExtension || ichunkaccess instanceof Chunk).filter(this::a).forEach(ichunkaccess -> mutableboolean.setTrue());
            } while (mutableboolean.isTrue());
            this.x.a();
            this.b(() -> true);
            this.b(true).join();
        } else {
            this.I.clear();
            long i2 = SystemUtils.c();
            for (PlayerChunk playerchunk2 : this.o.values()) {
                this.a(playerchunk2, i2);
            }
        }
    }

    protected void a(BooleanSupplier booleansupplier) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("poi");
        this.x.a(booleansupplier);
        gameprofilerfiller.b("chunk_unload");
        if (!this.r.z()) {
            this.b(booleansupplier);
        }
        gameprofilerfiller.c();
    }

    public boolean e() {
        return this.s.M_() || !this.p.isEmpty() || !this.n.isEmpty() || this.x.b() || !this.y.isEmpty() || !this.K.isEmpty() || this.A.a() || this.B.a() || this.D.d();
    }

    private void b(BooleanSupplier booleansupplier) {
        Runnable runnable;
        LongIterator longiterator = this.y.iterator();
        while (longiterator.hasNext()) {
            long i2 = longiterator.nextLong();
            PlayerChunk playerchunk = (PlayerChunk)this.n.get(i2);
            if (playerchunk != null) {
                this.n.remove(i2);
                this.p.put(i2, (Object)playerchunk);
                this.z = true;
                this.a(i2, playerchunk);
            }
            longiterator.remove();
        }
        for (int j2 = Math.max(0, this.K.size() - 2000); (j2 > 0 || booleansupplier.getAsBoolean()) && (runnable = this.K.poll()) != null; --j2) {
            runnable.run();
        }
        this.c(booleansupplier);
    }

    private void c(BooleanSupplier booleansupplier) {
        long i2 = SystemUtils.c();
        int j2 = 0;
        LongIterator longiterator = this.J.iterator();
        while (j2 < 20 && this.L.get() < 128 && booleansupplier.getAsBoolean() && longiterator.hasNext()) {
            IChunkAccess ichunkaccess;
            long k2 = longiterator.nextLong();
            PlayerChunk playerchunk = (PlayerChunk)this.o.get(k2);
            IChunkAccess iChunkAccess = ichunkaccess = playerchunk != null ? playerchunk.p() : null;
            if (ichunkaccess != null && ichunkaccess.m()) {
                if (!this.a(playerchunk, i2)) continue;
                ++j2;
                longiterator.remove();
                continue;
            }
            longiterator.remove();
        }
    }

    private void a(long i2, PlayerChunk playerchunk) {
        CompletableFuture<?> completablefuture = playerchunk.g();
        Runnable runnable = () -> {
            CompletableFuture<?> completablefuture1 = playerchunk.g();
            if (completablefuture1 != completablefuture) {
                this.a(i2, playerchunk);
            } else {
                IChunkAccess ichunkaccess = playerchunk.p();
                if (this.p.remove(i2, (Object)playerchunk) && ichunkaccess != null) {
                    if (ichunkaccess instanceof Chunk) {
                        Chunk chunk = (Chunk)ichunkaccess;
                        chunk.b(false);
                    }
                    this.a(ichunkaccess);
                    if (ichunkaccess instanceof Chunk) {
                        Chunk chunk1 = (Chunk)ichunkaccess;
                        this.r.b(chunk1);
                    }
                    this.s.a(ichunkaccess.f());
                    this.s.b();
                    this.I.remove(ichunkaccess.f().b());
                }
            }
        };
        Queue<Runnable> queue = this.K;
        Objects.requireNonNull(this.K);
        ((CompletableFuture)completablefuture.thenRunAsync(runnable, queue::add)).whenComplete((ovoid, throwable) -> {
            if (throwable != null) {
                i.error("Failed to save chunk {}", (Object)playerchunk.r(), throwable);
            }
        });
    }

    protected boolean f() {
        if (!this.z) {
            return false;
        }
        this.o = this.n.clone();
        this.z = false;
        return true;
    }

    private CompletableFuture<IChunkAccess> g(ChunkCoordIntPair chunkcoordintpair) {
        CompletionStage completablefuture = this.k(chunkcoordintpair).thenApplyAsync(optional -> optional.map(nbttagcompound -> {
            SerializableChunkData serializablechunkdata = SerializableChunkData.a((LevelHeightAccessor)this.r, this.r.at(), nbttagcompound);
            if (serializablechunkdata == null) {
                i.error("Chunk file at {} is missing level data, skipping", (Object)chunkcoordintpair);
            }
            return serializablechunkdata;
        }), SystemUtils.h().a("parseChunk"));
        CompletableFuture<?> completablefuture1 = this.x.a(chunkcoordintpair);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)completablefuture).thenCombine(completablefuture1, (optional, object) -> optional)).thenApplyAsync(optional -> {
            Profiler.a().f("chunkLoad");
            if (optional.isPresent()) {
                ProtoChunk ichunkaccess = ((SerializableChunkData)optional.get()).a(this.r, this.x, this.n(), chunkcoordintpair);
                this.a(chunkcoordintpair, ((IChunkAccess)ichunkaccess).n().d());
                return ichunkaccess;
            }
            return this.h(chunkcoordintpair);
        }, (Executor)this.t)).exceptionallyAsync(throwable -> this.a((Throwable)throwable, chunkcoordintpair), (Executor)this.t);
    }

    private IChunkAccess a(Throwable throwable, ChunkCoordIntPair chunkcoordintpair) {
        boolean flag1;
        Throwable throwable1;
        if (throwable instanceof CompletionException) {
            CompletionException completionexception = (CompletionException)throwable;
            throwable1 = completionexception.getCause();
        } else {
            throwable1 = throwable;
        }
        Throwable throwable2 = throwable1;
        if (throwable2 instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable2;
            throwable1 = reportedexception.getCause();
        } else {
            throwable1 = throwable2;
        }
        Throwable throwable3 = throwable1;
        boolean flag = throwable3 instanceof Error;
        boolean bl = flag1 = throwable3 instanceof IOException || throwable3 instanceof NbtException;
        if (!flag) {
            if (!flag1) {
                // empty if block
            }
            this.r.s().a(throwable3, this.n(), chunkcoordintpair);
            return this.h(chunkcoordintpair);
        }
        CrashReport crashreport = CrashReport.a(throwable, "Exception loading chunk");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk being loaded");
        crashreportsystemdetails.a("pos", chunkcoordintpair);
        this.i(chunkcoordintpair);
        throw new ReportedException(crashreport);
    }

    private IChunkAccess h(ChunkCoordIntPair chunkcoordintpair) {
        this.i(chunkcoordintpair);
        return new ProtoChunk(chunkcoordintpair, ChunkConverter.a, this.r, this.r.at(), null);
    }

    private void i(ChunkCoordIntPair chunkcoordintpair) {
        this.H.put(chunkcoordintpair.b(), (byte)-1);
    }

    private byte a(ChunkCoordIntPair chunkcoordintpair, ChunkType chunktype) {
        return this.H.put(chunkcoordintpair.b(), (byte)(chunktype == ChunkType.a ? -1 : 1));
    }

    @Override
    public GenerationChunkHolder e(long i2) {
        PlayerChunk playerchunk = (PlayerChunk)this.n.get(i2);
        playerchunk.n();
        return playerchunk;
    }

    @Override
    public void a(GenerationChunkHolder generationchunkholder) {
        generationchunkholder.o();
    }

    @Override
    public CompletableFuture<IChunkAccess> a(GenerationChunkHolder generationchunkholder, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d) {
        ChunkCoordIntPair chunkcoordintpair = generationchunkholder.r();
        if (chunkstep.a() == ChunkStatus.c) {
            return this.g(chunkcoordintpair);
        }
        try {
            GenerationChunkHolder generationchunkholder1 = staticcache2d.a(chunkcoordintpair.h, chunkcoordintpair.i);
            IChunkAccess ichunkaccess = generationchunkholder1.a(chunkstep.a().c());
            if (ichunkaccess == null) {
                throw new IllegalStateException("Parent chunk missing");
            }
            return chunkstep.a(this.N, staticcache2d, ichunkaccess);
        }
        catch (Exception exception) {
            exception.getStackTrace();
            CrashReport crashreport = CrashReport.a(exception, "Exception generating new chunk");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk to be generated");
            crashreportsystemdetails.a("Status being generated", () -> chunkstep.a().f());
            crashreportsystemdetails.a("Location", String.format(Locale.ROOT, "%d,%d", chunkcoordintpair.h, chunkcoordintpair.i));
            crashreportsystemdetails.a("Position hash", ChunkCoordIntPair.d(chunkcoordintpair.h, chunkcoordintpair.i));
            crashreportsystemdetails.a("Generator", this.a());
            this.t.execute(() -> {
                throw new ReportedException(crashreport);
            });
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public ChunkGenerationTask a(ChunkStatus chunkstatus, ChunkCoordIntPair chunkcoordintpair) {
        ChunkGenerationTask chunkgenerationtask = ChunkGenerationTask.a((GeneratingChunkMap)this, chunkstatus, chunkcoordintpair);
        this.q.add(chunkgenerationtask);
        return chunkgenerationtask;
    }

    private void a(ChunkGenerationTask chunkgenerationtask) {
        GenerationChunkHolder generationchunkholder = chunkgenerationtask.c();
        ChunkTaskDispatcher chunktaskdispatcher = this.A;
        Runnable runnable = () -> {
            CompletableFuture<?> completablefuture = chunkgenerationtask.a();
            if (completablefuture != null) {
                completablefuture.thenRun(() -> this.a(chunkgenerationtask));
            }
        };
        long i2 = generationchunkholder.r().b();
        Objects.requireNonNull(generationchunkholder);
        chunktaskdispatcher.a(runnable, i2, generationchunkholder::k);
    }

    @Override
    public void g() {
        this.q.forEach(this::a);
        this.q.clear();
    }

    public CompletableFuture<ChunkResult<Chunk>> b(PlayerChunk playerchunk) {
        CompletableFuture<ChunkResult<List<IChunkAccess>>> completablefuture = this.a(playerchunk, 1, (int i2) -> ChunkStatus.n);
        return completablefuture.thenApplyAsync(chunkresult -> chunkresult.a((T list) -> {
            Chunk chunk = (Chunk)list.get(list.size() / 2);
            chunk.a(this.r);
            this.r.c(chunk);
            CompletableFuture<?> completablefuture1 = playerchunk.f();
            if (completablefuture1.isDone()) {
                this.a(playerchunk, chunk);
            } else {
                completablefuture1.thenAcceptAsync(object -> this.a(playerchunk, chunk), (Executor)this.t);
            }
            return chunk;
        }), (Executor)this.t);
    }

    private void a(PlayerChunk playerchunk, Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        for (EntityPlayer entityplayer : this.F.a()) {
            if (!entityplayer.X().a(chunkcoordintpair)) continue;
            PlayerChunkMap.a(entityplayer, chunk);
        }
        this.r.p().a(playerchunk);
        this.r.W().a(chunk);
    }

    public CompletableFuture<ChunkResult<Chunk>> c(PlayerChunk playerchunk) {
        return this.a(playerchunk, 1, ChunkLevel::b).thenApply(chunkresult -> chunkresult.a((T list) -> (Chunk)list.get(list.size() / 2)));
    }

    Stream<PlayerChunk> a(ChunkStatus chunkstatus) {
        int i2 = ChunkLevel.a(chunkstatus);
        return this.o.values().stream().filter(playerchunk -> playerchunk.j() <= i2);
    }

    private boolean a(PlayerChunk playerchunk, long i2) {
        if (playerchunk.l() && playerchunk.h()) {
            IChunkAccess ichunkaccess = playerchunk.p();
            if (!(ichunkaccess instanceof ProtoChunkExtension) && !(ichunkaccess instanceof Chunk)) {
                return false;
            }
            if (!ichunkaccess.m()) {
                return false;
            }
            long j2 = ichunkaccess.f().b();
            long k2 = this.I.getOrDefault(j2, -1L);
            if (i2 < k2) {
                return false;
            }
            boolean flag = this.a(ichunkaccess);
            playerchunk.m();
            if (flag) {
                this.I.put(j2, i2 + 10000L);
            }
            return flag;
        }
        return false;
    }

    public boolean a(IChunkAccess ichunkaccess) {
        this.x.b(ichunkaccess.f());
        if (!ichunkaccess.j()) {
            return false;
        }
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        try {
            ChunkStatus chunkstatus = ichunkaccess.n();
            if (chunkstatus.d() != ChunkType.b) {
                if (this.j(chunkcoordintpair)) {
                    return false;
                }
                if (chunkstatus == ChunkStatus.c && ichunkaccess.g().values().stream().noneMatch(StructureStart::b)) {
                    return false;
                }
            }
            Profiler.a().f("chunkSave");
            this.L.incrementAndGet();
            SerializableChunkData serializablechunkdata = SerializableChunkData.a(this.r, ichunkaccess);
            Objects.requireNonNull(serializablechunkdata);
            CompletableFuture<NBTTagCompound> completablefuture = CompletableFuture.supplyAsync(serializablechunkdata::a, SystemUtils.h());
            Objects.requireNonNull(completablefuture);
            this.a(chunkcoordintpair, completablefuture::join).handle((ovoid, throwable) -> {
                if (throwable != null) {
                    this.r.s().b((Throwable)throwable, this.n(), chunkcoordintpair);
                }
                this.L.decrementAndGet();
                return null;
            });
            this.a(chunkcoordintpair, chunkstatus.d());
            return true;
        }
        catch (Exception exception) {
            this.r.s().b(exception, this.n(), chunkcoordintpair);
            return false;
        }
    }

    private boolean j(ChunkCoordIntPair chunkcoordintpair) {
        NBTTagCompound nbttagcompound;
        byte b0 = this.H.get(chunkcoordintpair.b());
        if (b0 != 0) {
            return b0 == 1;
        }
        try {
            nbttagcompound = this.k(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound == null) {
                this.i(chunkcoordintpair);
                return false;
            }
        }
        catch (Exception exception) {
            i.error("Failed to read chunk {}", (Object)chunkcoordintpair, (Object)exception);
            this.i(chunkcoordintpair);
            return false;
        }
        ChunkType chunktype = SerializableChunkData.a(nbttagcompound).d();
        return this.a(chunkcoordintpair, chunktype) == 1;
    }

    protected void a(int i2) {
        int j2 = MathHelper.a(i2, 2, 32);
        if (j2 != this.M) {
            this.M = j2;
            this.D.a(this.M);
            for (EntityPlayer entityplayer : this.F.a()) {
                this.e(entityplayer);
            }
        }
    }

    int b(EntityPlayer entityplayer) {
        return MathHelper.a(entityplayer.H(), 2, this.M);
    }

    private void a(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair) {
        Chunk chunk = this.f(chunkcoordintpair.b());
        if (chunk != null) {
            PlayerChunkMap.a(entityplayer, chunk);
        }
    }

    private static void a(EntityPlayer entityplayer, Chunk chunk) {
        entityplayer.g.h.a(chunk);
    }

    private static void b(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair) {
        entityplayer.g.h.a(entityplayer, chunkcoordintpair);
    }

    public @Nullable Chunk f(long i2) {
        PlayerChunk playerchunk = this.b(i2);
        return playerchunk == null ? null : playerchunk.e();
    }

    public int h() {
        return this.o.size();
    }

    public ChunkMapDistance i() {
        return this.D;
    }

    void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("z").a("level").a("in_memory").a("status").a("full_status").a("accessible_ready").a("ticking_ready").a("entity_ticking_ready").a("ticket").a("spawning").a("block_entity_count").a("ticking_ticket").a("ticking_level").a("block_ticks").a("fluid_ticks").a(writer);
        for (Long2ObjectMap.Entry long2objectmap_entry : this.o.long2ObjectEntrySet()) {
            long i2 = long2objectmap_entry.getLongKey();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
            PlayerChunk playerchunk = (PlayerChunk)long2objectmap_entry.getValue();
            Optional<IChunkAccess> optional = Optional.ofNullable(playerchunk.p());
            Optional<Object> optional1 = optional.flatMap(ichunkaccess -> ichunkaccess instanceof Chunk ? Optional.of((Chunk)ichunkaccess) : Optional.empty());
            csvwriter.a(chunkcoordintpair.h, chunkcoordintpair.i, playerchunk.j(), optional.isPresent(), optional.map(IChunkAccess::n).orElse(null), optional1.map(Chunk::G).orElse(null), PlayerChunkMap.a(playerchunk.c()), PlayerChunkMap.a(playerchunk.a()), PlayerChunkMap.a(playerchunk.b()), this.w.b(i2, false), this.b(chunkcoordintpair), optional1.map(chunk -> chunk.J().size()).orElse(0), this.w.b(i2, true), this.D.a(i2, true), optional1.map(chunk -> chunk.q().a()).orElse(0), optional1.map(chunk -> chunk.r().a()).orElse(0));
        }
    }

    private static String a(CompletableFuture<ChunkResult<Chunk>> completablefuture) {
        try {
            ChunkResult chunkresult = completablefuture.getNow(null);
            return chunkresult != null ? (chunkresult.a() ? "done" : "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<NBTTagCompound>> k(ChunkCoordIntPair chunkcoordintpair) {
        return this.d(chunkcoordintpair).thenApplyAsync(optional -> optional.map(nbttagcompound -> this.upgradeChunkTag((NBTTagCompound)nbttagcompound, chunkcoordintpair)), SystemUtils.h().a("upgradeChunk"));
    }

    private NBTTagCompound upgradeChunkTag(NBTTagCompound nbttagcompound, ChunkCoordIntPair chunkcoordintpair) {
        return this.upgradeChunkTag(nbttagcompound, -1, PlayerChunkMap.a(this.r.getTypeKey(), this.a().c()), chunkcoordintpair, this.r);
    }

    public static NBTTagCompound a(ResourceKey<WorldDimension> resourcekey, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> optional) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.a("dimension", resourcekey.a().toString());
        optional.ifPresent(resourcekey1 -> nbttagcompound.a("generator", resourcekey1.a().toString()));
        return nbttagcompound;
    }

    void a(List<Chunk> list) {
        LongIterator longiterator = this.D.b();
        while (longiterator.hasNext()) {
            Chunk chunk;
            PlayerChunk playerchunk = (PlayerChunk)this.o.get(longiterator.nextLong());
            if (playerchunk == null || (chunk = playerchunk.d()) == null || !this.l(playerchunk.r())) continue;
            list.add(chunk);
        }
    }

    void a(Consumer<Chunk> consumer) {
        this.D.a(i2 -> {
            Chunk chunk;
            PlayerChunk playerchunk = (PlayerChunk)this.o.get(i2);
            if (playerchunk != null && (chunk = playerchunk.d()) != null) {
                consumer.accept(chunk);
            }
        });
    }

    boolean b(ChunkCoordIntPair chunkcoordintpair) {
        return this.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        TriState tristate = this.D.e(chunkcoordintpair.b());
        return tristate == TriState.c ? this.anyPlayerCloseEnoughForSpawningInternal(chunkcoordintpair, reducedRange) : tristate.b(true);
    }

    boolean a(BlockPosition blockposition, int i2) {
        Vec3D vec3d = new Vec3D(blockposition);
        for (EntityPlayer entityplayer : this.F.a()) {
            if (!this.a(entityplayer, vec3d, i2)) continue;
            return true;
        }
        return false;
    }

    private boolean l(ChunkCoordIntPair chunkcoordintpair) {
        return this.anyPlayerCloseEnoughForSpawningInternal(chunkcoordintpair, false);
    }

    private boolean anyPlayerCloseEnoughForSpawningInternal(ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        int chunkRange = this.r.spigotConfig.mobSpawnRange;
        chunkRange = chunkRange > this.r.spigotConfig.viewDistance ? (int)this.r.spigotConfig.viewDistance : chunkRange;
        chunkRange = chunkRange > 8 ? 8 : (int)chunkRange;
        double blockRange = reducedRange ? Math.pow(chunkRange << 4, 2.0) : 16384.0;
        for (EntityPlayer entityplayer : this.F.a()) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, chunkcoordintpair, blockRange)) continue;
            return true;
        }
        return false;
    }

    public List<EntityPlayer> c(ChunkCoordIntPair chunkcoordintpair) {
        long i2 = chunkcoordintpair.b();
        if (!this.D.e(i2).b(true)) {
            return List.of();
        }
        ImmutableList.Builder immutablelist_builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : this.F.a()) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, chunkcoordintpair, 16384.0)) continue;
            immutablelist_builder.add((Object)entityplayer);
        }
        return immutablelist_builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair, double range) {
        if (entityplayer.au()) {
            return false;
        }
        double d0 = PlayerChunkMap.a(chunkcoordintpair, entityplayer.dI());
        return d0 < range;
    }

    private boolean a(EntityPlayer entityplayer, Vec3D vec3d, int i2) {
        if (entityplayer.au()) {
            return false;
        }
        double d0 = entityplayer.dI().f(vec3d);
        return d0 < (double)i2;
    }

    private static double a(ChunkCoordIntPair chunkcoordintpair, Vec3D vec3d) {
        double d0 = SectionPosition.a(chunkcoordintpair.h, 8);
        double d1 = SectionPosition.a(chunkcoordintpair.i, 8);
        double d2 = d0 - vec3d.g;
        double d3 = d1 - vec3d.i;
        return d2 * d2 + d3 * d3;
    }

    private boolean c(EntityPlayer entityplayer) {
        return entityplayer.au() && this.r.U().a(GameRules.ab) == false;
    }

    void a(EntityPlayer entityplayer, boolean flag) {
        boolean flag1 = this.c(entityplayer);
        boolean flag2 = this.F.d(entityplayer);
        if (flag) {
            this.F.a(entityplayer, flag1);
            this.d(entityplayer);
            if (!flag1) {
                this.D.a(SectionPosition.a(entityplayer), entityplayer);
            }
            entityplayer.a(ChunkTrackingView.a);
            this.e(entityplayer);
        } else {
            SectionPosition sectionposition = entityplayer.W();
            this.F.a(entityplayer);
            if (!flag2) {
                this.D.b(sectionposition, entityplayer);
            }
            this.a(entityplayer, ChunkTrackingView.a);
        }
    }

    private void d(EntityPlayer entityplayer) {
        SectionPosition sectionposition = SectionPosition.a(entityplayer);
        entityplayer.a(sectionposition);
    }

    public void a(EntityPlayer entityplayer) {
        boolean flag2;
        for (EntityTracker playerchunkmap_entitytracker : this.G.values()) {
            if (playerchunkmap_entitytracker.c == entityplayer) {
                playerchunkmap_entitytracker.a(this.r.E());
                continue;
            }
            playerchunkmap_entitytracker.b(entityplayer);
        }
        SectionPosition sectionposition = entityplayer.W();
        SectionPosition sectionposition1 = SectionPosition.a(entityplayer);
        boolean flag = this.F.e(entityplayer);
        boolean flag1 = this.c(entityplayer);
        boolean bl = flag2 = sectionposition.s() != sectionposition1.s();
        if (flag2 || flag != flag1) {
            this.d(entityplayer);
            if (!flag) {
                this.D.b(sectionposition, entityplayer);
            }
            if (!flag1) {
                this.D.a(sectionposition1, entityplayer);
            }
            if (!flag && flag1) {
                this.F.b(entityplayer);
            }
            if (flag && !flag1) {
                this.F.c(entityplayer);
            }
            this.e(entityplayer);
        }
    }

    private void e(EntityPlayer entityplayer) {
        ChunkTrackingView.a chunktrackingview_a;
        ChunkCoordIntPair chunkcoordintpair = entityplayer.dM();
        int i2 = this.b(entityplayer);
        ChunkTrackingView chunktrackingview = entityplayer.X();
        if (chunktrackingview instanceof ChunkTrackingView.a && (chunktrackingview_a = (ChunkTrackingView.a)chunktrackingview).a().equals(chunkcoordintpair) && chunktrackingview_a.b() == i2) {
            return;
        }
        this.a(entityplayer, ChunkTrackingView.a(chunkcoordintpair, i2));
    }

    private void a(EntityPlayer entityplayer, ChunkTrackingView chunktrackingview) {
        if (entityplayer.A() == this.r) {
            ChunkTrackingView chunktrackingview1 = entityplayer.X();
            if (chunktrackingview instanceof ChunkTrackingView.a) {
                ChunkTrackingView.a chunktrackingview_a1;
                ChunkTrackingView.a chunktrackingview_a = (ChunkTrackingView.a)chunktrackingview;
                if (!(chunktrackingview1 instanceof ChunkTrackingView.a) || !(chunktrackingview_a1 = (ChunkTrackingView.a)chunktrackingview1).a().equals(chunktrackingview_a.a())) {
                    entityplayer.g.b(new PacketPlayOutViewCentre(chunktrackingview_a.a().h, chunktrackingview_a.a().i));
                }
            }
            ChunkTrackingView.a(chunktrackingview1, chunktrackingview, chunkcoordintpair -> this.a(entityplayer, (ChunkCoordIntPair)chunkcoordintpair), chunkcoordintpair -> PlayerChunkMap.b(entityplayer, chunkcoordintpair));
            entityplayer.a(chunktrackingview);
        }
    }

    @Override
    public List<EntityPlayer> a(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        Set<EntityPlayer> set = this.F.a();
        ImmutableList.Builder immutablelist_builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : set) {
            if ((!flag || !this.b(entityplayer, chunkcoordintpair.h, chunkcoordintpair.i)) && (flag || !this.a(entityplayer, chunkcoordintpair.h, chunkcoordintpair.i))) continue;
            immutablelist_builder.add((Object)entityplayer);
        }
        return immutablelist_builder.build();
    }

    protected void a(Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!(entity instanceof EntityComplexPart)) {
            EntityTypes<?> entitytypes = entity.ay();
            int i2 = entitytypes.o() * 16;
            if ((i2 = TrackingRange.getEntityTrackingRange(entity, i2)) != 0) {
                int j2 = entitytypes.p();
                if (this.G.containsKey(entity.aA())) {
                    throw SystemUtils.b(new IllegalStateException("Entity is already tracked!"));
                }
                EntityTracker playerchunkmap_entitytracker = new EntityTracker(entity, i2, j2, entitytypes.q());
                this.G.put(entity.aA(), (Object)playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.a(this.r.E());
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    this.a(entityplayer, true);
                    for (EntityTracker playerchunkmap_entitytracker1 : this.G.values()) {
                        if (playerchunkmap_entitytracker1.c == entityplayer) continue;
                        playerchunkmap_entitytracker1.b(entityplayer);
                    }
                }
            }
        }
    }

    protected void b(Entity entity) {
        EntityTracker playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.a(entityplayer, false);
            for (EntityTracker playerchunkmap_entitytracker : this.G.values()) {
                playerchunkmap_entitytracker.a(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (EntityTracker)this.G.remove(entity.aA())) != null) {
            playerchunkmap_entitytracker1.a();
        }
    }

    protected void j() {
        for (EntityPlayer entityplayer : this.F.a()) {
            this.e(entityplayer);
        }
        ArrayList list = Lists.newArrayList();
        List<EntityPlayer> list1 = this.r.E();
        for (EntityTracker playerchunkmap_entitytracker : this.G.values()) {
            boolean flag;
            SectionPosition sectionposition = playerchunkmap_entitytracker.e;
            SectionPosition sectionposition1 = SectionPosition.a(playerchunkmap_entitytracker.c);
            boolean bl = flag = !Objects.equals(sectionposition, sectionposition1);
            if (flag) {
                playerchunkmap_entitytracker.a(list1);
                Entity entity = playerchunkmap_entitytracker.c;
                if (entity instanceof EntityPlayer) {
                    list.add((EntityPlayer)entity);
                }
                playerchunkmap_entitytracker.e = sectionposition1;
            }
            if (!flag && !playerchunkmap_entitytracker.c.aF && !this.D.c(sectionposition1.r().b())) continue;
            playerchunkmap_entitytracker.b.a();
        }
        if (!list.isEmpty()) {
            for (EntityTracker playerchunkmap_entitytracker1 : this.G.values()) {
                playerchunkmap_entitytracker1.a(list);
            }
        }
    }

    public void a(Entity entity, Packet<? super PacketListenerPlayOut> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.G.get(entity.aA());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.a(packet);
        }
    }

    public void a(Entity entity, Packet<? super PacketListenerPlayOut> packet, Predicate<EntityPlayer> predicate) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.G.get(entity.aA());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.a(packet, predicate);
        }
    }

    protected void b(Entity entity, Packet<? super PacketListenerPlayOut> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.G.get(entity.aA());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.b(packet);
        }
    }

    public boolean c(Entity entity) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.G.get(entity.aA());
        return playerchunkmap_entitytracker != null ? !playerchunkmap_entitytracker.f.isEmpty() : false;
    }

    public void a(EntityPlayer entityplayer, Consumer<Entity> consumer) {
        for (EntityTracker playerchunkmap_entitytracker : this.G.values()) {
            if (!playerchunkmap_entitytracker.f.contains(entityplayer.g)) continue;
            consumer.accept(playerchunkmap_entitytracker.c);
        }
    }

    public void b(List<IChunkAccess> list) {
        HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
        for (IChunkAccess ichunkaccess : list) {
            Chunk chunk1;
            ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
            Chunk chunk = ichunkaccess instanceof Chunk ? (chunk1 = (Chunk)ichunkaccess) : this.r.d(chunkcoordintpair.h, chunkcoordintpair.i);
            for (EntityPlayer entityplayer : this.a(chunkcoordintpair, false)) {
                map.computeIfAbsent(entityplayer, entityplayer1 -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((entityplayer1, list1) -> entityplayer1.g.b(ClientboundChunksBiomesPacket.a(list1)));
    }

    protected VillagePlace k() {
        return this.x;
    }

    public String l() {
        return this.E;
    }

    void a(ChunkCoordIntPair chunkcoordintpair, FullChunkStatus fullchunkstatus) {
        this.C.onChunkStatusChange(chunkcoordintpair, fullchunkstatus);
    }

    public void a(ChunkCoordIntPair chunkcoordintpair, int i2) {
        int j2 = i2 + 1;
        ChunkCoordIntPair.a(chunkcoordintpair, j2).forEach(chunkcoordintpair1 -> {
            PlayerChunk playerchunk = this.b(chunkcoordintpair1.b());
            if (playerchunk != null) {
                playerchunk.a(this.s.a(chunkcoordintpair1.h, chunkcoordintpair1.i));
            }
        });
    }

    public void b(Consumer<Chunk> consumer) {
        for (PlayerChunk playerchunk : this.o.values()) {
            Chunk chunk = playerchunk.e();
            if (chunk == null) continue;
            consumer.accept(chunk);
        }
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> queue = new ArrayDeque<Runnable>();

        @Override
        public void execute(Runnable runnable) {
            this.queue.add(runnable);
        }

        @Override
        public void run() {
            Runnable task;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    private class a
    extends ChunkMapDistance {
        protected a(TicketStorage ticketstorage, Executor executor, Executor executor1) {
            super(ticketstorage, executor, executor1);
        }

        @Override
        protected boolean a(long i2) {
            return PlayerChunkMap.this.y.contains(i2);
        }

        @Override
        protected @Nullable PlayerChunk b(long i2) {
            return PlayerChunkMap.this.a(i2);
        }

        @Override
        protected @Nullable PlayerChunk a(long i2, int j2, @Nullable PlayerChunk playerchunk, int k2) {
            return PlayerChunkMap.this.a(i2, j2, playerchunk, k2);
        }
    }

    public class EntityTracker
    implements EntityTrackerEntry.a {
        public final EntityTrackerEntry b;
        final Entity c;
        private final int d;
        SectionPosition e;
        public final Set<ServerPlayerConnection> f = Sets.newIdentityHashSet();

        public EntityTracker(Entity entity, int i2, int j2, boolean flag) {
            this.b = new EntityTrackerEntry(PlayerChunkMap.this.r, entity, j2, flag, this, this.f);
            this.c = entity;
            this.d = i2;
            this.e = SectionPosition.a(entity);
        }

        public boolean equals(Object object) {
            return object instanceof EntityTracker ? ((EntityTracker)object).c.aA() == this.c.aA() : false;
        }

        public int hashCode() {
            return this.c.aA();
        }

        @Override
        public void a(Packet<? super PacketListenerPlayOut> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                serverplayerconnection.b(packet);
            }
        }

        @Override
        public void b(Packet<? super PacketListenerPlayOut> packet) {
            this.a(packet);
            Entity entity = this.c;
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.g.b(packet);
            }
        }

        @Override
        public void a(Packet<? super PacketListenerPlayOut> packet, Predicate<EntityPlayer> predicate) {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                if (!predicate.test(serverplayerconnection.p())) continue;
                serverplayerconnection.b(packet);
            }
        }

        @Override
        public void sendToTrackingPlayersFilteredAndSelf(Packet<? super PacketListenerPlayOut> packet, Predicate<EntityPlayer> predicate) {
            this.a(packet, predicate);
            Entity entity = this.c;
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.g.b(packet);
            }
        }

        public void a() {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                this.b.a(serverplayerconnection.p());
            }
        }

        public void a(EntityPlayer entityplayer) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.f.remove(entityplayer.g)) {
                this.b.a(entityplayer);
                if (this.f.isEmpty()) {
                    PlayerChunkMap.this.r.W().b(this.c);
                }
            }
        }

        public void b(EntityPlayer entityplayer) {
            AsyncCatcher.catchOp("player tracker update");
            if (entityplayer != this.c) {
                boolean flag;
                Vec3D vec3d = entityplayer.dI().d(this.c.dI());
                int i2 = PlayerChunkMap.this.b(entityplayer);
                double d1 = vec3d.g * vec3d.g + vec3d.i * vec3d.i;
                double d0 = Math.min(this.b(), i2 * 16);
                double d2 = d0 * d0;
                boolean bl = flag = d1 <= d2 && this.c.a(entityplayer) && PlayerChunkMap.this.a(entityplayer, this.c.dM().h, this.c.dM().i);
                if (!entityplayer.getBukkitEntity().canSee(this.c.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.f.add(entityplayer.g)) {
                        this.b.b(entityplayer);
                        if (this.f.size() == 1) {
                            PlayerChunkMap.this.r.W().a(this.c);
                        }
                        PlayerChunkMap.this.r.W().a(entityplayer, this.c);
                    }
                } else {
                    this.a(entityplayer);
                }
            }
        }

        private int a(int i2) {
            return PlayerChunkMap.this.r.s().c(i2);
        }

        private int b() {
            int i2 = this.d;
            for (Entity entity : this.c.dr()) {
                int j2 = entity.ay().o() * 16;
                if (j2 <= i2) continue;
                i2 = j2;
            }
            return this.a(i2);
        }

        public void a(List<EntityPlayer> list) {
            for (EntityPlayer entityplayer : list) {
                this.b(entityplayer);
            }
        }
    }
}

