/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBisected;
import net.minecraft.world.item.ItemDebugStick;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class PlayerInteractManager {
    private static final double a = 1.0;
    private static final Logger b = LogUtils.getLogger();
    protected WorldServer c;
    protected final EntityPlayer d;
    private EnumGamemode e = EnumGamemode.e;
    private @Nullable EnumGamemode f;
    private boolean g;
    private int h;
    private BlockPosition i = BlockPosition.c;
    private int j;
    private boolean k;
    private BlockPosition l = BlockPosition.c;
    private int m;
    private int n = -1;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPosition interactPosition;
    public EnumHand interactHand;
    public ItemStack interactItemStack;

    public PlayerInteractManager(EntityPlayer entityplayer) {
        this.d = entityplayer;
        this.c = entityplayer.A();
    }

    public boolean a(EnumGamemode enumgamemode) {
        if (enumgamemode == this.e) {
            return false;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.d.getBukkitEntity(), GameMode.getByValue((int)enumgamemode.a()));
        this.c.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        PlayerAbilities playerabilities = this.d.gL();
        this.a(enumgamemode, this.e);
        if (playerabilities.b && enumgamemode != EnumGamemode.d && this.f()) {
            playerabilities.b = false;
        }
        this.d.z();
        this.c.s().aj().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.c, this.d), this.d);
        this.c.h();
        if (enumgamemode == EnumGamemode.b) {
            this.d.hr();
        }
        return true;
    }

    protected void a(EnumGamemode enumgamemode, @Nullable EnumGamemode enumgamemode1) {
        this.f = enumgamemode1;
        this.e = enumgamemode;
        PlayerAbilities playerabilities = this.d.gL();
        enumgamemode.a(playerabilities);
    }

    private boolean f() {
        List<VoxelShape> list = Entity.a((Entity)this.d, this.c, this.d.dj());
        return list.isEmpty() && this.d.b(1.0) < 1.0;
    }

    public EnumGamemode b() {
        return this.e;
    }

    public @Nullable EnumGamemode c() {
        return this.f;
    }

    public boolean d() {
        return this.e.h();
    }

    public boolean e() {
        return this.e.g();
    }

    public void a() {
        this.j = MinecraftServer.currentTick;
        if (this.k) {
            IBlockData iblockdata = this.c.a_(this.l);
            if (iblockdata.l()) {
                this.k = false;
            } else {
                float f2 = this.a(iblockdata, this.l, this.m);
                if (f2 >= 1.0f) {
                    this.k = false;
                    this.a(this.l);
                }
            }
        } else if (this.g) {
            IBlockData iblockdata1 = this.c.a_(this.i);
            if (iblockdata1.l()) {
                this.c.a(this.d.aA(), this.i, -1);
                this.n = -1;
                this.g = false;
            } else {
                this.a(iblockdata1, this.i, this.h);
            }
        }
    }

    private float a(IBlockData iblockdata, BlockPosition blockposition, int i2) {
        int j2 = this.j - i2;
        float f2 = iblockdata.a(this.d, this.d.A(), blockposition) * (float)(j2 + 1);
        int k2 = (int)(f2 * 10.0f);
        if (k2 != this.n) {
            this.c.a(this.d.aA(), blockposition, k2);
            this.n = k2;
        }
        return f2;
    }

    private void a(BlockPosition blockposition, boolean flag, int i2, String s2) {
        if (SharedConstants.U) {
            b.debug("Server ACK {} {} {} {}", new Object[]{i2, blockposition, flag, s2});
        }
    }

    public void a(BlockPosition blockposition, PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype, EnumDirection enumdirection, int i2, int j2) {
        if (!this.d.a(blockposition, 1.0)) {
            this.a(blockposition, false, j2, "too far");
        } else if (blockposition.v() > i2) {
            this.d.g.b(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
            this.a(blockposition, false, j2, "too high");
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.a) {
            if (!this.c.a((Entity)this.d, blockposition)) {
                CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, blockposition, enumdirection, this.d.gK().h(), EnumHand.a);
                this.d.g.b(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
                this.a(blockposition, false, j2, "may not interact");
                this.d.g.b(new ClientboundBlockChangedAckPacket(j2));
                TileEntity tileentity = this.c.c_(blockposition);
                if (tileentity != null) {
                    this.d.g.b(tileentity.ax_());
                }
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, blockposition, enumdirection, this.d.gK().h(), EnumHand.a);
            if (event.isCancelled()) {
                this.d.g.b(new PacketPlayOutBlockChange(this.c, blockposition));
                this.d.g.b(new ClientboundBlockChangedAckPacket(j2));
                TileEntity tileentity = this.c.c_(blockposition);
                if (tileentity != null) {
                    this.d.g.b(tileentity.ax_());
                }
                return;
            }
            if (this.d.gL().d) {
                this.a(blockposition, j2, "creative destroy");
                return;
            }
            if (this.d.fx().a(Items.xU) && ((ItemDebugStick)Items.xU).a(this.d, this.c.a_(blockposition), this.c, blockposition, false, this.d.fx())) {
                this.d.g.b(new PacketPlayOutBlockChange(this.c, blockposition));
                return;
            }
            if (this.d.a((World)this.c, blockposition, this.e)) {
                this.d.g.b(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
                this.a(blockposition, false, j2, "block action restricted");
                return;
            }
            this.h = this.j;
            float f2 = 1.0f;
            IBlockData iblockdata = this.c.a_(blockposition);
            if (event.useInteractedBlock() == Event.Result.DENY) {
                IBlockData data = this.c.a_(blockposition);
                if (data.b() instanceof BlockDoor) {
                    boolean bottom = data.c(BlockDoor.c) == BlockPropertyDoubleBlockHalf.b;
                    this.d.g.b(new PacketPlayOutBlockChange(this.c, blockposition));
                    this.d.g.b(new PacketPlayOutBlockChange(this.c, bottom ? blockposition.d() : blockposition.e()));
                } else if (data.b() instanceof BlockTrapdoor) {
                    this.d.g.b(new PacketPlayOutBlockChange(this.c, blockposition));
                }
            } else if (!iblockdata.l()) {
                EnchantmentManager.a(this.c, this.d.fx(), this.d, this.d, EnumItemSlot.a, Vec3D.b(blockposition), iblockdata, item -> this.d.a((Item)item, EnumItemSlot.a));
                iblockdata.a((World)this.c, blockposition, this.d);
                f2 = iblockdata.a(this.d, this.d.A(), blockposition);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                if (f2 > 1.0f) {
                    this.d.g.b(new PacketPlayOutBlockChange(this.c, blockposition));
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.d, blockposition, this.d.gK().h(), f2 >= 1.0f);
            if (blockEvent.isCancelled()) {
                this.d.g.b(new PacketPlayOutBlockChange(this.c, blockposition));
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f2 = 2.0f;
            }
            if (!iblockdata.l() && f2 >= 1.0f) {
                this.a(blockposition, j2, "insta mine");
            } else {
                if (this.g) {
                    this.d.g.b(new PacketPlayOutBlockChange(this.i, this.c.a_(this.i)));
                    this.a(blockposition, false, j2, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.g = true;
                this.i = blockposition.j();
                int k2 = (int)(f2 * 10.0f);
                this.c.a(this.d.aA(), blockposition, k2);
                this.a(blockposition, true, j2, "actual start of destroying");
                this.n = k2;
            }
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.c) {
            if (blockposition.equals(this.i)) {
                int l2 = this.j - this.h;
                IBlockData iblockdata1 = this.c.a_(blockposition);
                if (!iblockdata1.l()) {
                    float f1 = iblockdata1.a(this.d, this.d.A(), blockposition) * (float)(l2 + 1);
                    if (f1 >= 0.7f) {
                        this.g = false;
                        this.c.a(this.d.aA(), blockposition, -1);
                        this.a(blockposition, j2, "destroyed");
                        return;
                    }
                    if (!this.k) {
                        this.g = false;
                        this.k = true;
                        this.l = blockposition;
                        this.m = this.h;
                    }
                }
            }
            this.a(blockposition, true, j2, "stopped destroying");
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.b) {
            this.g = false;
            if (!Objects.equals(this.i, blockposition)) {
                b.debug("Mismatch in destroy block pos: {} {}", (Object)this.i, (Object)blockposition);
                this.c.a(this.d.aA(), this.i, -1);
                this.a(blockposition, true, j2, "aborted mismatched destroying");
            }
            this.c.a(this.d.aA(), blockposition, -1);
            this.a(blockposition, true, j2, "aborted destroying");
            CraftEventFactory.callBlockDamageAbortEvent(this.d, blockposition, this.d.gK().h());
        }
    }

    public void a(BlockPosition blockposition, int i2, String s2) {
        if (this.destroyBlock(blockposition, i2)) {
            this.a(blockposition, true, i2, s2);
        } else {
            this.d.g.b(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
            this.a(blockposition, false, i2, s2);
        }
    }

    public boolean a(BlockPosition blockposition) {
        return this.destroyBlock(blockposition, -1);
    }

    public boolean destroyBlock(BlockPosition blockposition, int ack) {
        IBlockData iblockdata = this.c.a_(blockposition);
        CraftBlock bblock = CraftBlock.at(this.c, blockposition);
        BlockBreakEvent event = null;
        if (this.d instanceof EntityPlayer) {
            boolean isSwordNoBreak;
            boolean bl = isSwordNoBreak = !this.d.fx().a(iblockdata, (World)this.c, blockposition, (EntityHuman)this.d);
            if (this.c.c_(blockposition) == null && !isSwordNoBreak) {
                PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(blockposition, Blocks.a.m());
                this.d.g.b(packet);
            }
            event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (Player)this.d.getBukkitEntity());
            event.setCancelled(isSwordNoBreak);
            IBlockData nmsData = this.c.a_(blockposition);
            Block nmsBlock = nmsData.b();
            ItemStack itemstack = this.d.a(EnumItemSlot.a);
            if (nmsBlock != null && !event.isCancelled() && !this.e() && this.d.d(nmsBlock.m())) {
                event.setExpToDrop(nmsBlock.getExpDrop(nmsData, this.c, blockposition, itemstack, true));
            }
            this.c.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (isSwordNoBreak) {
                    return false;
                }
                this.d.g.b(new PacketPlayOutBlockChange(this.c, blockposition));
                for (EnumDirection dir : EnumDirection.values()) {
                    this.d.g.b(new PacketPlayOutBlockChange(this.c, blockposition.a(dir)));
                }
                this.d.g.b(new ClientboundBlockChangedAckPacket(ack));
                TileEntity tileentity = this.c.c_(blockposition);
                if (tileentity != null) {
                    this.d.g.b(tileentity.ax_());
                }
                return false;
            }
        }
        if ((iblockdata = this.c.a_(blockposition)).l()) {
            return false;
        }
        TileEntity tileentity = this.c.c_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof GameMasterBlock && !this.d.hi()) {
            this.c.a(blockposition, iblockdata, iblockdata, 3);
            return false;
        }
        if (this.d.a((World)this.c, blockposition, this.e)) {
            return false;
        }
        BlockState state = bblock.getState();
        this.c.captureDrops = new ArrayList();
        IBlockData iblockdata1 = block.a((World)this.c, blockposition, iblockdata, this.d);
        boolean flag = this.c.a(blockposition, false);
        if (SharedConstants.U) {
            b.info("server broke {} {} -> {}", new Object[]{blockposition, iblockdata1, this.c.a_(blockposition)});
        }
        if (flag) {
            block.a((GeneratorAccess)this.c, blockposition, iblockdata1);
        }
        if (!this.d.gM()) {
            ItemStack itemstack = this.d.fx();
            ItemStack itemstack1 = itemstack.v();
            boolean flag1 = this.d.d(iblockdata1);
            itemstack.a(this.c, iblockdata1, blockposition, (EntityHuman)this.d);
            if (flag && flag1 && event.isDropItems()) {
                block.a(this.c, this.d, blockposition, iblockdata1, tileentity, itemstack1);
            }
        }
        if (event.isDropItems()) {
            CraftEventFactory.handleBlockDropItemEvent(bblock, state, this.d, this.c.captureDrops);
        }
        this.c.captureDrops = null;
        if (flag && event != null) {
            iblockdata.b().a(this.c, blockposition, event.getExpToDrop());
        }
        return true;
    }

    public EnumInteractionResult a(EntityPlayer entityplayer, World world, ItemStack itemstack, EnumHand enumhand) {
        ItemStack itemstack1;
        if (this.e == EnumGamemode.d) {
            return EnumInteractionResult.e;
        }
        if (entityplayer.hh().a(itemstack)) {
            return EnumInteractionResult.e;
        }
        int i2 = itemstack.N();
        int j2 = itemstack.o();
        EnumInteractionResult enuminteractionresult = itemstack.a(world, (EntityHuman)entityplayer, enumhand);
        if (enuminteractionresult instanceof EnumInteractionResult.d) {
            EnumInteractionResult.d enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult;
            itemstack1 = Objects.requireNonNullElse(enuminteractionresult_d.d(), entityplayer.b(enumhand));
        } else {
            itemstack1 = entityplayer.b(enumhand);
        }
        if (itemstack1 == itemstack && itemstack1.N() == i2 && itemstack1.a(entityplayer) <= 0 && itemstack1.o() == j2) {
            return enuminteractionresult;
        }
        if (enuminteractionresult instanceof EnumInteractionResult.a && itemstack1.a(entityplayer) > 0 && !entityplayer.fZ()) {
            return enuminteractionresult;
        }
        if (itemstack != itemstack1) {
            entityplayer.a(enumhand, itemstack1);
        }
        if (itemstack1.f()) {
            entityplayer.a(enumhand, ItemStack.l);
        }
        if (!entityplayer.fZ()) {
            entityplayer.cm.b();
        }
        return enuminteractionresult;
    }

    public EnumInteractionResult a(EntityPlayer entityplayer, World world, ItemStack itemstack, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        BlockPosition blockposition = movingobjectpositionblock.b();
        IBlockData iblockdata = world.a_(blockposition);
        boolean cancelledBlock = false;
        if (!iblockdata.b().a(world.Q())) {
            return EnumInteractionResult.d;
        }
        if (this.e == EnumGamemode.d) {
            ITileInventory itileinventory = iblockdata.a(world, blockposition);
            boolean bl = cancelledBlock = !(itileinventory instanceof ITileInventory);
        }
        if (entityplayer.hh().a(itemstack)) {
            cancelledBlock = true;
        }
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entityplayer, Action.RIGHT_CLICK_BLOCK, blockposition, movingobjectpositionblock.c(), itemstack, cancelledBlock, enumhand, movingobjectpositionblock.g());
        this.firedInteract = true;
        this.interactResult = event.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockposition.j();
        this.interactHand = enumhand;
        this.interactItemStack = itemstack.v();
        if (event.useInteractedBlock() == Event.Result.DENY) {
            if (iblockdata.b() instanceof BlockDoor) {
                boolean bottom = iblockdata.c(BlockDoor.c) == BlockPropertyDoubleBlockHalf.b;
                entityplayer.g.b(new PacketPlayOutBlockChange(world, bottom ? blockposition.d() : blockposition.e()));
            } else if (iblockdata.b() instanceof BlockCake) {
                entityplayer.getBukkitEntity().sendHealthUpdate();
            } else if (this.interactItemStack.h() instanceof ItemBisected) {
                entityplayer.g.b(new PacketPlayOutBlockChange(world, blockposition.a(movingobjectpositionblock.c()).d()));
                entityplayer.g.b(new PacketPlayOutBlockChange(world, blockposition.d()));
            }
            entityplayer.getBukkitEntity().updateInventory();
            return event.useItemInHand() != Event.Result.ALLOW ? EnumInteractionResult.a : EnumInteractionResult.e;
        }
        if (this.e == EnumGamemode.d) {
            ITileInventory itileinventory = iblockdata.a(world, blockposition);
            if (itileinventory != null) {
                entityplayer.a(itileinventory);
                return EnumInteractionResult.c;
            }
            return EnumInteractionResult.e;
        }
        boolean flag = !entityplayer.fx().f() || !entityplayer.fy().f();
        boolean flag1 = entityplayer.gA() && flag;
        ItemStack itemstack1 = itemstack.v();
        if (!flag1) {
            EnumInteractionResult enuminteractionresult1;
            EnumInteractionResult enuminteractionresult = iblockdata.a(entityplayer.b(enumhand), world, entityplayer, enumhand, movingobjectpositionblock);
            if (enuminteractionresult.a()) {
                CriterionTriggers.O.a(entityplayer, blockposition, itemstack1);
                return enuminteractionresult;
            }
            if (enuminteractionresult instanceof EnumInteractionResult.f && enumhand == EnumHand.a && (enuminteractionresult1 = iblockdata.a(world, entityplayer, movingobjectpositionblock)).a()) {
                CriterionTriggers.P.a(entityplayer, blockposition);
                return enuminteractionresult1;
            }
        }
        if (!itemstack.f() && !this.interactResult) {
            EnumInteractionResult enuminteractionresult2;
            ItemActionContext itemactioncontext = new ItemActionContext(entityplayer, enumhand, movingobjectpositionblock);
            if (entityplayer.gv()) {
                int i2 = itemstack.N();
                enuminteractionresult2 = itemstack.a(itemactioncontext);
                itemstack.e(i2);
            } else {
                enuminteractionresult2 = itemstack.a(itemactioncontext);
            }
            if (enuminteractionresult2.a()) {
                CriterionTriggers.O.a(entityplayer, blockposition, itemstack1);
            }
            return enuminteractionresult2;
        }
        return EnumInteractionResult.e;
    }

    public void a(WorldServer worldserver) {
        this.c = worldserver;
    }
}

