/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class PlayerSpawnFinder {
    private static final EntitySize a = EntityTypes.cb.n();
    private static final int b = 1024;
    private final WorldServer c;
    private final BlockPosition d;
    private final int e;
    private final int f;
    private final int g;
    private final int h;
    private int i;
    private final CompletableFuture<Vec3D> j = new CompletableFuture();

    private PlayerSpawnFinder(WorldServer worldserver, BlockPosition blockposition, int i2) {
        this.c = worldserver;
        this.d = blockposition;
        this.e = i2;
        long j2 = (long)i2 * 2L + 1L;
        this.f = (int)Math.min(1024L, j2 * j2);
        this.g = PlayerSpawnFinder.a(this.f);
        this.h = RandomSource.a().a(this.f);
    }

    public static CompletableFuture<Vec3D> a(WorldServer worldserver, BlockPosition blockposition) {
        if (worldserver.F_().e() && worldserver.I.j() != EnumGamemode.c) {
            int i2 = Math.max(0, worldserver.U().a(GameRules.Q));
            int j2 = MathHelper.c(worldserver.w().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            PlayerSpawnFinder playerspawnfinder = new PlayerSpawnFinder(worldserver, blockposition, i2);
            playerspawnfinder.a();
            return playerspawnfinder.j;
        }
        return CompletableFuture.completedFuture(PlayerSpawnFinder.a((ICollisionAccess)worldserver, blockposition));
    }

    private void a() {
        int i2;
        if ((i2 = this.i++) < this.f) {
            int j2 = (this.h + this.g * i2) % this.f;
            int k2 = j2 % (this.e * 2 + 1);
            int l2 = j2 / (this.e * 2 + 1);
            int i1 = this.d.u() + k2 - this.e;
            int j1 = this.d.w() + l2 - this.e;
            this.a(i1, j1, i2, () -> {
                BlockPosition blockposition = PlayerSpawnFinder.a(this.c, i1, j1);
                return blockposition != null && PlayerSpawnFinder.b(this.c, blockposition) ? Optional.of(Vec3D.c(blockposition)) : Optional.empty();
            });
        } else {
            this.a(this.d.u(), this.d.w(), i2, () -> Optional.of(PlayerSpawnFinder.a((ICollisionAccess)this.c, this.d)));
        }
    }

    private static Vec3D a(ICollisionAccess icollisionaccess, BlockPosition blockposition) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        while (!PlayerSpawnFinder.b(icollisionaccess, blockposition_mutableblockposition) && blockposition_mutableblockposition.v() < icollisionaccess.aw()) {
            blockposition_mutableblockposition.c(EnumDirection.b);
        }
        blockposition_mutableblockposition.c(EnumDirection.a);
        while (PlayerSpawnFinder.b(icollisionaccess, blockposition_mutableblockposition) && blockposition_mutableblockposition.v() > icollisionaccess.K_()) {
            blockposition_mutableblockposition.c(EnumDirection.a);
        }
        blockposition_mutableblockposition.c(EnumDirection.b);
        return Vec3D.c(blockposition_mutableblockposition);
    }

    private static boolean b(ICollisionAccess icollisionaccess, BlockPosition blockposition) {
        return icollisionaccess.a((Entity)null, a.a(blockposition.c()), true);
    }

    private static int a(int i2) {
        return i2 <= 16 ? i2 - 1 : 17;
    }

    private void a(int i2, int j2, int k2, Supplier<Optional<Vec3D>> supplier) {
        if (!this.j.isDone()) {
            int l2 = SectionPosition.a(i2);
            int i1 = SectionPosition.a(j2);
            this.c.p().a(TicketType.h, new ChunkCoordIntPair(l2, i1), 0).whenCompleteAsync((object, throwable) -> {
                if (throwable == null) {
                    try {
                        Optional optional = (Optional)supplier.get();
                        if (optional.isPresent()) {
                            this.j.complete((Vec3D)optional.get());
                        } else {
                            this.a();
                        }
                    }
                    catch (Throwable throwable1) {
                        throwable = throwable1;
                    }
                }
                if (throwable != null) {
                    CrashReport crashreport = CrashReport.a(throwable, "Searching for spawn");
                    CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Spawn Lookup");
                    BlockPosition blockposition = this.d;
                    Objects.requireNonNull(this.d);
                    crashreportsystemdetails.a("Origin", blockposition::toString);
                    crashreportsystemdetails.a("Radius", () -> Integer.toString(this.e));
                    crashreportsystemdetails.a("Candidate", () -> "[" + i2 + "," + j2 + "]");
                    crashreportsystemdetails.a("Progress", () -> k2 + " out of " + this.f);
                    this.j.completeExceptionally(new ReportedException(crashreport));
                }
            }, (Executor)this.c.s());
        }
    }

    protected static @Nullable BlockPosition a(WorldServer worldserver, int i2, int j2) {
        int k2;
        boolean flag = worldserver.F_().f();
        Chunk chunk = worldserver.d(SectionPosition.a(i2), SectionPosition.a(j2));
        int n2 = k2 = flag ? worldserver.p().g().a(worldserver) : chunk.a(HeightMap.Type.e, i2 & 0xF, j2 & 0xF);
        if (k2 < worldserver.K_()) {
            return null;
        }
        int l2 = chunk.a(HeightMap.Type.b, i2 & 0xF, j2 & 0xF);
        if (l2 <= k2 && l2 > chunk.a(HeightMap.Type.d, i2 & 0xF, j2 & 0xF)) {
            return null;
        }
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i1 = k2 + 1; i1 >= worldserver.K_(); --i1) {
            blockposition_mutableblockposition.d(i2, i1, j2);
            IBlockData iblockdata = worldserver.a_(blockposition_mutableblockposition);
            if (!iblockdata.y().c()) break;
            if (!Block.a(iblockdata.g(worldserver, blockposition_mutableblockposition), EnumDirection.b)) continue;
            return blockposition_mutableblockposition.d().j();
        }
        return null;
    }

    public static @Nullable BlockPosition a(WorldServer worldserver, ChunkCoordIntPair chunkcoordintpair) {
        if (SharedConstants.a(chunkcoordintpair)) {
            return null;
        }
        for (int i2 = chunkcoordintpair.e(); i2 <= chunkcoordintpair.g(); ++i2) {
            for (int j2 = chunkcoordintpair.f(); j2 <= chunkcoordintpair.h(); ++j2) {
                BlockPosition blockposition = PlayerSpawnFinder.a(worldserver, i2, j2);
                if (blockposition == null) continue;
                return blockposition;
            }
        }
        return null;
    }
}

