/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalIoHandler;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.jspecify.annotations.Nullable;

public abstract class EventLoopGroupHolder {
    private static final EventLoopGroupHolder a = new EventLoopGroupHolder("NIO", NioSocketChannel.class, NioServerSocketChannel.class){

        @Override
        protected IoHandlerFactory b() {
            return NioIoHandler.newFactory();
        }
    };
    private static final EventLoopGroupHolder b = new EventLoopGroupHolder("Epoll", EpollSocketChannel.class, EpollServerSocketChannel.class){

        @Override
        protected IoHandlerFactory b() {
            return EpollIoHandler.newFactory();
        }
    };
    private static final EventLoopGroupHolder c = new EventLoopGroupHolder("Kqueue", KQueueSocketChannel.class, KQueueServerSocketChannel.class){

        @Override
        protected IoHandlerFactory b() {
            return KQueueIoHandler.newFactory();
        }
    };
    private static final EventLoopGroupHolder d = new EventLoopGroupHolder("Local", LocalChannel.class, LocalServerChannel.class){

        @Override
        protected IoHandlerFactory b() {
            return LocalIoHandler.newFactory();
        }
    };
    private final String e;
    private final Class<? extends Channel> f;
    private final Class<? extends ServerChannel> g;
    private volatile @Nullable EventLoopGroup h;

    public static EventLoopGroupHolder a(boolean var0) {
        if (var0) {
            if (KQueue.isAvailable()) {
                return c;
            }
            if (Epoll.isAvailable()) {
                return b;
            }
        }
        return a;
    }

    public static EventLoopGroupHolder a() {
        return d;
    }

    EventLoopGroupHolder(String var0, Class<? extends Channel> var1, Class<? extends ServerChannel> var2) {
        this.e = var0;
        this.f = var1;
        this.g = var2;
    }

    private ThreadFactory f() {
        return new ThreadFactoryBuilder().setNameFormat("Netty " + this.e + " IO #%d").setDaemon(true).build();
    }

    protected abstract IoHandlerFactory b();

    private EventLoopGroup g() {
        return new MultiThreadIoEventLoopGroup(this.f(), this.b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventLoopGroup c() {
        EventLoopGroup var0 = this.h;
        if (var0 == null) {
            EventLoopGroupHolder eventLoopGroupHolder = this;
            synchronized (eventLoopGroupHolder) {
                var0 = this.h;
                if (var0 == null) {
                    this.h = var0 = this.g();
                }
            }
        }
        return var0;
    }

    public Class<? extends Channel> d() {
        return this.f;
    }

    public Class<? extends ServerChannel> e() {
        return this.g;
    }
}

