/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.HashedStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTestInstanceBlockStatus;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChangeGameModePacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientTickEndPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSubscriptionRequestPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromBlockPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromEntityPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerLoadedPacket;
import net.minecraft.network.protocol.game.ServerboundSelectBundleItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetTestBlockPacket;
import net.minecraft.network.protocol.game.ServerboundTestInstanceBlockActionPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.TickThrottler;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.PiercingWeapon;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Input;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.CraftInput;
import org.bukkit.craftbukkit.v1_21_R7.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_21_R7.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class PlayerConnection
extends ServerCommonPacketListenerImpl
implements GameProtocols.a,
PacketListenerPlayIn,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger i = LogUtils.getLogger();
    private static final int j = -1;
    private static final int k = 4096;
    private static final int l = 80;
    private static final int m = 5;
    public static final int f = 60;
    private static final IChatBaseComponent n = IChatBaseComponent.c("multiplayer.disconnect.chat_validation_failed");
    private static final IChatBaseComponent o = IChatBaseComponent.c("chat.disabled.invalid_command_signature").a(EnumChatFormat.m);
    private static final int p = 1000;
    public EntityPlayer g;
    public final PlayerChunkSender h;
    private int q;
    private int r = -1;
    private final TickThrottler s = new TickThrottler(20, 200);
    private final TickThrottler t = new TickThrottler(20, 1480);
    private double u;
    private double v;
    private double w;
    private double x;
    private double y;
    private double z;
    private @Nullable net.minecraft.world.entity.Entity A;
    private double B;
    private double C;
    private double D;
    private double E;
    private double F;
    private double G;
    private @Nullable Vec3D H;
    private int I;
    private int J;
    private boolean K;
    private int L;
    private boolean M;
    private int N;
    private int O;
    private int P;
    private boolean Q;
    private @Nullable RemoteChatSession R;
    private SignedMessageChain.b S;
    private final LastSeenMessagesValidator T = new LastSeenMessagesValidator(20);
    private int U;
    private final MessageSignatureCache V = MessageSignatureCache.a();
    private final FutureChain W;
    private boolean X;
    private boolean Y;
    private int Z;
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private boolean hasMoved = false;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private int limitedPackets;
    private long lastLimitedPacket = -1L;

    public PlayerConnection(MinecraftServer minecraftserver, NetworkManager networkmanager, EntityPlayer entityplayer, CommonListenerCookie commonlistenercookie) {
        super(minecraftserver, networkmanager, commonlistenercookie, entityplayer);
        this.y();
        this.h = new PlayerChunkSender(networkmanager.e());
        this.g = entityplayer;
        entityplayer.g = this;
        entityplayer.Y().a();
        UUID uuid = entityplayer.cY();
        Objects.requireNonNull(minecraftserver);
        this.S = SignedMessageChain.b.unsigned(uuid, minecraftserver::ay);
        this.W = new FutureChain(minecraftserver.chatExecutor);
    }

    @Override
    public void d() {
        SpigotTimings.playerConnectionTimer.startTiming();
        if (this.r > -1) {
            this.b(new ClientboundBlockChangedAckPacket(this.r));
            this.r = -1;
        }
        if (this.d.I() || !this.t()) {
            this.e();
            this.s.b();
            this.t.b();
            if (this.g.P() > 0L && this.d.aq() > 0 && SystemUtils.c() - this.g.P() > TimeUnit.MINUTES.toMillis(this.d.aq()) && !this.g.k) {
                this.g.J();
                this.a(IChatBaseComponent.c("multiplayer.disconnect.idling"));
            }
        }
        SpigotTimings.playerConnectionTimer.stopTiming();
    }

    private boolean t() {
        this.m();
        this.g.Y = this.g.dP();
        this.g.Z = this.g.dR();
        this.g.aa = this.g.dV();
        this.g.h();
        this.g.a(this.u, this.v, this.w, this.g.ec(), this.g.ee());
        ++this.q;
        this.P = this.O;
        if (this.K && !this.g.gr() && !this.g.cq() && !this.g.fa()) {
            if (++this.L > this.a(this.g)) {
                i.warn("{} was kicked for floating too long!", (Object)this.g.aq());
                this.a(IChatBaseComponent.c("multiplayer.disconnect.flying"));
                return true;
            }
        } else {
            this.K = false;
            this.L = 0;
        }
        this.A = this.g.du();
        if (this.A != this.g && this.A.dl() == this.g) {
            this.B = this.A.dP();
            this.C = this.A.dR();
            this.D = this.A.dV();
            this.E = this.A.dP();
            this.F = this.A.dR();
            this.G = this.A.dV();
            if (this.M && this.A.dl() == this.g) {
                if (++this.N > this.a(this.A)) {
                    i.warn("{} was kicked for floating a vehicle too long!", (Object)this.g.aq());
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.flying"));
                    return true;
                }
            } else {
                this.M = false;
                this.N = 0;
            }
        } else {
            this.A = null;
            this.M = false;
            this.N = 0;
        }
        return false;
    }

    private int a(net.minecraft.world.entity.Entity entity) {
        double d0 = entity.bt();
        if (d0 < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double d1 = 0.08 / d0;
        return MathHelper.e(80.0 * Math.max(d1, 1.0));
    }

    public void l() {
        this.L = 0;
        this.N = 0;
    }

    public void m() {
        this.u = this.g.dP();
        this.v = this.g.dR();
        this.w = this.g.dV();
        this.x = this.g.dP();
        this.y = this.g.dR();
        this.z = this.g.dV();
    }

    @Override
    public boolean c() {
        return this.e.i() && !this.X;
    }

    @Override
    public boolean a(Packet<?> packet) {
        return super.a(packet) ? true : this.X && this.e.i() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile i() {
        return this.g.gI();
    }

    private <T, R> CompletableFuture<R> a(T t0, BiFunction<ITextFilter, T, CompletableFuture<R>> bifunction) {
        return bifunction.apply(this.g.Y(), (ITextFilter)t0).thenApply(object -> {
            if (!this.c()) {
                i.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<FilteredText> a(String s2) {
        return this.a(s2, ITextFilter::a);
    }

    private CompletableFuture<List<FilteredText>> a(List<String> list) {
        return this.a(list, ITextFilter::a);
    }

    @Override
    public void a(PacketPlayInSteerVehicle packetplayinsteervehicle) {
        PlayerConnectionUtils.a(packetplayinsteervehicle, this, this.g.A());
        if (!packetplayinsteervehicle.b().equals(this.g.ai())) {
            PlayerInputEvent event = new PlayerInputEvent((Player)this.g.getBukkitEntity(), (Input)new CraftInput(packetplayinsteervehicle.b()));
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        this.g.a(packetplayinsteervehicle.b());
        if (this.q()) {
            this.g.J();
            boolean shift = packetplayinsteervehicle.b().f();
            if (this.g.cu() != shift) {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), shift);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.g.h(shift);
                }
            }
        }
    }

    private static boolean b(double d0, double d1, double d2, float f2, float f1) {
        return Double.isNaN(d0) || Double.isNaN(d1) || Double.isNaN(d2) || !Floats.isFinite((float)f1) || !Floats.isFinite((float)f2);
    }

    private static double a(double d0) {
        return MathHelper.a(d0, -3.0E7, 3.0E7);
    }

    private static double b(double d0) {
        return MathHelper.a(d0, -2.0E7, 2.0E7);
    }

    @Override
    public void a(PacketPlayInVehicleMove packetplayinvehiclemove) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packetplayinvehiclemove, this, this.g.A());
        if (PlayerConnection.b(packetplayinvehiclemove.b().a(), packetplayinvehiclemove.b().b(), packetplayinvehiclemove.b().c(), packetplayinvehiclemove.e(), packetplayinvehiclemove.f())) {
            this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_vehicle_movement"));
        } else if (!this.u() && this.q() && (entity = this.g.du()) != this.g && entity.dl() == this.g && entity == this.A) {
            EntityLiving entityliving;
            WorldServer worldserver = this.g.A();
            double prevX = this.g.dP();
            double prevY = this.g.dR();
            double prevZ = this.g.dV();
            float prevYaw = this.g.ec();
            float prevPitch = this.g.ee();
            double d0 = entity.dP();
            double d1 = entity.dR();
            double d2 = entity.dV();
            double d3 = PlayerConnection.a(packetplayinvehiclemove.b().a());
            double d4 = PlayerConnection.b(packetplayinvehiclemove.b().b());
            double d5 = PlayerConnection.a(packetplayinvehiclemove.b().c());
            float f2 = MathHelper.f(packetplayinvehiclemove.e());
            float f1 = MathHelper.f(packetplayinvehiclemove.f());
            double d6 = d3 - this.B;
            double d7 = d4 - this.C;
            double d8 = d5 - this.D;
            double d9 = entity.dN().h();
            double d10 = d6 * d6 + d7 * d7 + d8 * d8;
            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
            this.lastTick = (int)(System.currentTimeMillis() / 50L);
            ++this.O;
            int i2 = this.O - this.P;
            if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                i.debug(this.g.da() + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                i2 = 1;
            }
            this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
            double speed = this.g.gL().b ? (double)(this.g.gL().m * 20.0f) : (double)(this.g.gL().n * 10.0f);
            speed *= 2.0;
            if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.h()) {
                i.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.aq(), this.g.aq(), d6, d7, d8});
                this.b(PacketPlayOutVehicleMove.a(entity));
                return;
            }
            AxisAlignedBB axisalignedbb = entity.dj();
            d6 = d3 - this.E;
            d7 = d4 - this.F;
            d8 = d5 - this.G;
            boolean flag = entity.af;
            if (entity instanceof EntityLiving && (entityliving = (EntityLiving)entity).fl()) {
                entityliving.l();
            }
            entity.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
            double d11 = d7;
            d6 = d3 - entity.dP();
            d7 = d4 - entity.dR();
            if (d7 > -0.5 || d7 < 0.5) {
                d7 = 0.0;
            }
            d8 = d5 - entity.dV();
            d10 = d6 * d6 + d7 * d7 + d8 * d8;
            boolean flag1 = false;
            if (d10 > SpigotConfig.movedWronglyThreshold) {
                flag1 = true;
                i.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.aq(), this.g.aq(), Math.sqrt(d10)});
            }
            if (flag1 && worldserver.a(entity, axisalignedbb) || this.a(worldserver, entity, axisalignedbb, d3, d4, d5)) {
                entity.a(d0, d1, d2, f2, f1);
                this.g.a(d0, d1, d2, this.g.ec(), this.g.ee());
                this.b(PacketPlayOutVehicleMove.a(entity));
                entity.aX();
                return;
            }
            entity.a(d3, d4, d5, f2, f1);
            this.g.a(d3, d4, d5, this.g.ec(), this.g.ee());
            CraftPlayer player = this.getCraftPlayer();
            if (!this.hasMoved) {
                this.lastPosX = prevX;
                this.lastPosY = prevY;
                this.lastPosZ = prevZ;
                this.lastYaw = prevYaw;
                this.lastPitch = prevPitch;
                this.hasMoved = true;
            }
            Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
            Location to = CraftLocation.toBukkit(packetplayinvehiclemove.b(), player.getWorld(), packetplayinvehiclemove.e(), packetplayinvehiclemove.f());
            double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
            float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
            if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.g.fE()) {
                this.lastPosX = to.getX();
                this.lastPosY = to.getY();
                this.lastPosZ = to.getZ();
                this.lastYaw = to.getYaw();
                this.lastPitch = to.getPitch();
                Location oldTo = to.clone();
                PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    this.teleport(from);
                    return;
                }
                if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                    this.g.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                    return;
                }
                if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                    this.justTeleported = false;
                    return;
                }
            }
            this.g.A().p().a(this.g);
            Vec3D vec3d = new Vec3D(entity.dP() - d0, entity.dR() - d1, entity.dV() - d2);
            this.a(vec3d);
            entity.a(packetplayinvehiclemove.g(), vec3d);
            entity.a(vec3d.g, vec3d.h, vec3d.i, packetplayinvehiclemove.g());
            this.g.a(vec3d.g, vec3d.h, vec3d.i);
            this.M = d11 >= -0.03125 && !flag && !this.d.ag() && !entity.em() && !entity.br() && this.b(entity);
            this.E = entity.dP();
            this.F = entity.dR();
            this.G = entity.dV();
        }
    }

    private boolean b(net.minecraft.world.entity.Entity entity) {
        return entity.ao().a(entity.dj().g(0.0625).b(0.0, -0.55, 0.0)).allMatch(BlockBase.BlockData::l);
    }

    @Override
    public void a(PacketPlayInTeleportAccept packetplayinteleportaccept) {
        PlayerConnectionUtils.a(packetplayinteleportaccept, this, this.g.A());
        if (packetplayinteleportaccept.b() == this.I) {
            if (this.H == null) {
                this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"));
                return;
            }
            this.g.a(this.H.g, this.H.h, this.H.i, this.g.ec(), this.g.ee());
            this.x = this.H.g;
            this.y = this.H.h;
            this.z = this.H.i;
            this.g.T();
            this.H = null;
            this.g.A().p().a(this.g);
        }
    }

    @Override
    public void a(ServerboundPlayerLoadedPacket serverboundplayerloadedpacket) {
        PlayerConnectionUtils.a(serverboundplayerloadedpacket, this, this.g.A());
        this.x();
    }

    @Override
    public void a(PacketPlayInRecipeDisplayed packetplayinrecipedisplayed) {
        PlayerConnectionUtils.a(packetplayinrecipedisplayed, this, this.g.A());
        CraftingManager.d craftingmanager_d = this.d.aJ().a(packetplayinrecipedisplayed.b());
        if (craftingmanager_d != null) {
            this.g.L().d(craftingmanager_d.b().a());
        }
    }

    @Override
    public void a(ServerboundSelectBundleItemPacket serverboundselectbundleitempacket) {
        PlayerConnectionUtils.a(serverboundselectbundleitempacket, this, this.g.A());
        this.g.cn.a(serverboundselectbundleitempacket.b(), serverboundselectbundleitempacket.e());
    }

    @Override
    public void a(PacketPlayInRecipeSettings packetplayinrecipesettings) {
        PlayerConnectionUtils.a(packetplayinrecipesettings, this, this.g.A());
        CraftEventFactory.callRecipeBookSettingsEvent(this.g, packetplayinrecipesettings.b(), packetplayinrecipesettings.e(), packetplayinrecipesettings.f());
        this.g.L().a(packetplayinrecipesettings.b(), packetplayinrecipesettings.e(), packetplayinrecipesettings.f());
    }

    @Override
    public void a(PacketPlayInAdvancements packetplayinadvancements) {
        PlayerConnectionUtils.a(packetplayinadvancements, this, this.g.A());
        if (packetplayinadvancements.e() == PacketPlayInAdvancements.Status.a) {
            MinecraftKey minecraftkey = Objects.requireNonNull(packetplayinadvancements.f());
            AdvancementHolder advancementholder = this.d.aB().a(minecraftkey);
            if (advancementholder != null) {
                this.g.U().a(advancementholder);
            }
        }
    }

    @Override
    public void a(PacketPlayInTabComplete packetplayintabcomplete) {
        PlayerConnectionUtils.a(packetplayintabcomplete, this, this.g.A());
        if (!(this.s.isIncrementAndUnderThreshold(1, 500) || this.d.aj().f(this.g.gJ()) || this.d.a(this.g.gJ()))) {
            this.a(IChatBaseComponent.c("disconnect.spam"));
            return;
        }
        StringReader stringreader = new StringReader(packetplayintabcomplete.e());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        ParseResults<CommandListenerWrapper> parseresults = this.d.aF().a().parse(stringreader, this.g.C());
        this.d.aF().a().getCompletionSuggestions(parseresults).thenAccept(suggestions -> {
            if (suggestions.isEmpty()) {
                return;
            }
            Suggestions suggestions1 = suggestions.getList().size() <= 1000 ? suggestions : new Suggestions(suggestions.getRange(), suggestions.getList().subList(0, 1000));
            this.b(new PacketPlayOutTabComplete(packetplayintabcomplete.b(), suggestions1));
        });
    }

    @Override
    public void a(PacketPlayInSetCommandBlock packetplayinsetcommandblock) {
        PlayerConnectionUtils.a(packetplayinsetcommandblock, this, this.g.A());
        if (!this.g.hi()) {
            this.g.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = null;
            TileEntityCommand tileentitycommand = null;
            BlockPosition blockposition = packetplayinsetcommandblock.b();
            TileEntity tileentity = this.g.A().c_(blockposition);
            if (tileentity instanceof TileEntityCommand) {
                TileEntityCommand tileentitycommand1;
                tileentitycommand = tileentitycommand1 = (TileEntityCommand)tileentity;
                commandblocklistenerabstract = tileentitycommand1.a();
            }
            String s2 = packetplayinsetcommandblock.e();
            boolean flag = packetplayinsetcommandblock.f();
            if (commandblocklistenerabstract != null) {
                TileEntityCommand.Type tileentitycommand_type = tileentitycommand.l();
                IBlockData iblockdata = this.g.A().a_(blockposition);
                EnumDirection enumdirection = iblockdata.c(BlockCommand.b);
                IBlockData iblockdata2 = switch (packetplayinsetcommandblock.i()) {
                    case TileEntityCommand.Type.a -> Blocks.lD.m();
                    case TileEntityCommand.Type.b -> Blocks.lC.m();
                    default -> Blocks.gC.m();
                };
                IBlockData iblockdata3 = (IBlockData)((IBlockData)iblockdata2.b(BlockCommand.b, enumdirection)).b(BlockCommand.c, packetplayinsetcommandblock.g());
                if (iblockdata3 != iblockdata) {
                    this.g.A().a(blockposition, iblockdata3, 2);
                    tileentity.c(iblockdata3);
                    this.g.A().q(blockposition).a(tileentity);
                }
                commandblocklistenerabstract.a(s2);
                commandblocklistenerabstract.a(flag);
                if (!flag) {
                    commandblocklistenerabstract.b((IChatBaseComponent)null);
                }
                tileentitycommand.b(packetplayinsetcommandblock.h());
                if (tileentitycommand_type != packetplayinsetcommandblock.i()) {
                    tileentitycommand.f();
                }
                if (this.g.A().Y()) {
                    commandblocklistenerabstract.a(this.g.A());
                }
                if (!UtilColor.b(s2)) {
                    this.g.a(IChatBaseComponent.a(this.g.A().Y() ? "advMode.setCommand.success" : "advMode.setCommand.disabled", new Object[]{s2}));
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCommandMinecart packetplayinsetcommandminecart) {
        PlayerConnectionUtils.a(packetplayinsetcommandminecart, this, this.g.A());
        if (!this.g.hi()) {
            this.g.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = packetplayinsetcommandminecart.a(this.g.A());
            if (commandblocklistenerabstract != null) {
                boolean flag;
                String s2 = packetplayinsetcommandminecart.b();
                commandblocklistenerabstract.a(s2);
                commandblocklistenerabstract.a(packetplayinsetcommandminecart.e());
                if (!packetplayinsetcommandminecart.e()) {
                    commandblocklistenerabstract.b((IChatBaseComponent)null);
                }
                if (flag = this.g.A().Y()) {
                    commandblocklistenerabstract.a(this.g.A());
                }
                if (!UtilColor.b(s2)) {
                    this.g.a(IChatBaseComponent.a(flag ? "advMode.setCommand.success" : "advMode.setCommand.disabled", new Object[]{s2}));
                }
            }
        }
    }

    @Override
    public void a(ServerboundPickItemFromBlockPacket serverboundpickitemfromblockpacket) {
        boolean flag;
        IBlockData iblockdata;
        ItemStack itemstack;
        WorldServer worldserver = this.g.A();
        PlayerConnectionUtils.a(serverboundpickitemfromblockpacket, this, worldserver);
        BlockPosition blockposition = serverboundpickitemfromblockpacket.b();
        if (this.g.a(blockposition, 1.0) && worldserver.t(blockposition) && !(itemstack = (iblockdata = worldserver.a_(blockposition)).a((IWorldReader)worldserver, blockposition, flag = this.g.gv() && serverboundpickitemfromblockpacket.e())).f()) {
            if (flag && this.g.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                PlayerConnection.a(iblockdata, worldserver, blockposition, itemstack);
            }
            this.a(itemstack);
        }
    }

    private static void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack) {
        TileEntity tileentity;
        TileEntity tileEntity = tileentity = iblockdata.x() ? worldserver.c_(blockposition) : null;
        if (tileentity != null) {
            try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(tileentity.v(), i);){
                TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter_j, worldserver.J_());
                tileentity.f(tagvalueoutput);
                tileentity.b(tagvalueoutput);
                ItemBlock.a(itemstack, tileentity.s(), tagvalueoutput);
                itemstack.b(tileentity.t());
            }
        }
    }

    @Override
    public void a(ServerboundPickItemFromEntityPacket serverboundpickitemfromentitypacket) {
        ItemStack itemstack;
        WorldServer worldserver = this.g.A();
        PlayerConnectionUtils.a(serverboundpickitemfromentitypacket, this, worldserver);
        net.minecraft.world.entity.Entity entity = worldserver.b(serverboundpickitemfromentitypacket.b());
        if (entity != null && this.g.b(entity, 3.0) && (itemstack = entity.dZ()) != null && !itemstack.f()) {
            this.a(itemstack);
        }
    }

    private void a(ItemStack itemstack) {
        if (itemstack.a(this.g.A().Q())) {
            PlayerInventory playerinventory = this.g.gK();
            int i2 = playerinventory.d(itemstack);
            if (i2 != -1) {
                if (PlayerInventory.f(i2)) {
                    playerinventory.d(i2);
                } else {
                    playerinventory.e(i2);
                }
            } else if (this.g.gv()) {
                playerinventory.c(itemstack);
            }
            this.b(new PacketPlayOutHeldItemSlot(playerinventory.g()));
            this.g.cm.d();
        }
    }

    @Override
    public void a(PacketPlayInItemName packetplayinitemname) {
        PlayerConnectionUtils.a(packetplayinitemname, this, this.g.A());
        Container container = this.g.cn;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil containeranvil = (ContainerAnvil)container;
            if (!containeranvil.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)containeranvil);
                return;
            }
            containeranvil.a(packetplayinitemname.b());
        }
    }

    @Override
    public void a(PacketPlayInBeacon packetplayinbeacon) {
        PlayerConnectionUtils.a(packetplayinbeacon, this, this.g.A());
        Container container = this.g.cn;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon containerbeacon = (ContainerBeacon)container;
            if (!this.g.cn.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)this.g.cn);
                return;
            }
            containerbeacon.a(packetplayinbeacon.b(), packetplayinbeacon.e());
        }
    }

    @Override
    public void a(PacketPlayInStruct packetplayinstruct) {
        PlayerConnectionUtils.a(packetplayinstruct, this, this.g.A());
        if (this.g.hi()) {
            BlockPosition blockposition = packetplayinstruct.b();
            IBlockData iblockdata = this.g.A().a_(blockposition);
            TileEntity tileentity = this.g.A().c_(blockposition);
            if (tileentity instanceof TileEntityStructure) {
                TileEntityStructure tileentitystructure = (TileEntityStructure)tileentity;
                tileentitystructure.a(packetplayinstruct.f());
                tileentitystructure.a(packetplayinstruct.g());
                tileentitystructure.a(packetplayinstruct.h());
                tileentitystructure.a(packetplayinstruct.i());
                tileentitystructure.a(packetplayinstruct.j());
                tileentitystructure.a(packetplayinstruct.k());
                tileentitystructure.b(packetplayinstruct.l());
                tileentitystructure.a(packetplayinstruct.m());
                tileentitystructure.b(packetplayinstruct.n());
                tileentitystructure.e(packetplayinstruct.o());
                tileentitystructure.f(packetplayinstruct.p());
                tileentitystructure.a(packetplayinstruct.q());
                tileentitystructure.a(packetplayinstruct.r());
                if (tileentitystructure.f()) {
                    String s2 = tileentitystructure.d();
                    if (packetplayinstruct.e() == TileEntityStructure.UpdateType.b) {
                        if (tileentitystructure.D()) {
                            this.g.a(IChatBaseComponent.a("structure_block.save_success", new Object[]{s2}), false);
                        } else {
                            this.g.a(IChatBaseComponent.a("structure_block.save_failure", new Object[]{s2}), false);
                        }
                    } else if (packetplayinstruct.e() == TileEntityStructure.UpdateType.c) {
                        if (!tileentitystructure.F()) {
                            this.g.a(IChatBaseComponent.a("structure_block.load_not_found", new Object[]{s2}), false);
                        } else if (tileentitystructure.a(this.g.A())) {
                            this.g.a(IChatBaseComponent.a("structure_block.load_success", new Object[]{s2}), false);
                        } else {
                            this.g.a(IChatBaseComponent.a("structure_block.load_prepare", new Object[]{s2}), false);
                        }
                    } else if (packetplayinstruct.e() == TileEntityStructure.UpdateType.d) {
                        if (tileentitystructure.C()) {
                            this.g.a(IChatBaseComponent.a("structure_block.size_success", new Object[]{s2}), false);
                        } else {
                            this.g.a(IChatBaseComponent.c("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.g.a(IChatBaseComponent.a("structure_block.invalid_structure_name", new Object[]{packetplayinstruct.g()}), false);
                }
                tileentitystructure.e();
                this.g.A().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(ServerboundSetTestBlockPacket serverboundsettestblockpacket) {
        PlayerConnectionUtils.a(serverboundsettestblockpacket, this, this.g.A());
        if (this.g.hi()) {
            BlockPosition blockposition = serverboundsettestblockpacket.b();
            IBlockData iblockdata = this.g.A().a_(blockposition);
            TileEntity tileentity = this.g.A().c_(blockposition);
            if (tileentity instanceof TestBlockEntity) {
                TestBlockEntity testblockentity = (TestBlockEntity)tileentity;
                testblockentity.a(serverboundsettestblockpacket.e());
                testblockentity.a(serverboundsettestblockpacket.f());
                testblockentity.e();
                this.g.A().a(blockposition, iblockdata, testblockentity.o(), 3);
            }
        }
    }

    @Override
    public void a(ServerboundTestInstanceBlockActionPacket serverboundtestinstanceblockactionpacket) {
        TileEntity tileentity;
        PlayerConnectionUtils.a(serverboundtestinstanceblockactionpacket, this, this.g.A());
        BlockPosition blockposition = serverboundtestinstanceblockactionpacket.b();
        if (this.g.hi() && (tileentity = this.g.A().c_(blockposition)) instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity testinstanceblockentity = (TestInstanceBlockEntity)tileentity;
            if (serverboundtestinstanceblockactionpacket.e() != ServerboundTestInstanceBlockActionPacket.a.b && serverboundtestinstanceblockactionpacket.e() != ServerboundTestInstanceBlockActionPacket.a.a) {
                testinstanceblockentity.a(serverboundtestinstanceblockactionpacket.f());
                if (serverboundtestinstanceblockactionpacket.e() == ServerboundTestInstanceBlockActionPacket.a.d) {
                    EntityPlayer entityplayer = this.g;
                    Objects.requireNonNull(this.g);
                    testinstanceblockentity.a(entityplayer::a);
                } else if (serverboundtestinstanceblockactionpacket.e() == ServerboundTestInstanceBlockActionPacket.a.e) {
                    EntityPlayer entityplayer1 = this.g;
                    Objects.requireNonNull(this.g);
                    testinstanceblockentity.b(entityplayer1::a);
                } else if (serverboundtestinstanceblockactionpacket.e() == ServerboundTestInstanceBlockActionPacket.a.f) {
                    EntityPlayer entityplayer2 = this.g;
                    Objects.requireNonNull(this.g);
                    testinstanceblockentity.c(entityplayer2::a);
                } else if (serverboundtestinstanceblockactionpacket.e() == ServerboundTestInstanceBlockActionPacket.a.g) {
                    EntityPlayer entityplayer3 = this.g;
                    Objects.requireNonNull(this.g);
                    testinstanceblockentity.d(entityplayer3::a);
                }
                IBlockData iblockdata = this.g.A().a_(blockposition);
                this.g.A().a(blockposition, Blocks.a.m(), iblockdata, 3);
            } else {
                IRegistry<GameTestInstance> iregistry = this.g.eo().f(Registries.bv);
                Optional<ResourceKey<GameTestInstance>> optional = serverboundtestinstanceblockactionpacket.f().a();
                Objects.requireNonNull(iregistry);
                Optional optional1 = optional.flatMap(iregistry::a);
                IChatBaseComponent ichatbasecomponent = optional1.isPresent() ? ((GameTestInstance)((Holder.c)optional1.get()).a()).c() : IChatBaseComponent.c("test_instance.description.no_test").a(EnumChatFormat.m);
                Optional<Object> optional2 = serverboundtestinstanceblockactionpacket.e() == ServerboundTestInstanceBlockActionPacket.a.b ? serverboundtestinstanceblockactionpacket.f().a().flatMap(resourcekey -> TestInstanceBlockEntity.a(this.g.A(), resourcekey)) : Optional.empty();
                this.e.a(new ClientboundTestInstanceBlockStatus(ichatbasecomponent, optional2));
            }
            return;
        }
    }

    @Override
    public void a(PacketPlayInSetJigsaw packetplayinsetjigsaw) {
        PlayerConnectionUtils.a(packetplayinsetjigsaw, this, this.g.A());
        if (this.g.hi()) {
            BlockPosition blockposition = packetplayinsetjigsaw.b();
            IBlockData iblockdata = this.g.A().a_(blockposition);
            TileEntity tileentity = this.g.A().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(packetplayinsetjigsaw.e());
                tileentityjigsaw.b(packetplayinsetjigsaw.f());
                tileentityjigsaw.a(ResourceKey.a(Registries.bt, packetplayinsetjigsaw.g()));
                tileentityjigsaw.a(packetplayinsetjigsaw.h());
                tileentityjigsaw.a(packetplayinsetjigsaw.i());
                tileentityjigsaw.a(packetplayinsetjigsaw.k());
                tileentityjigsaw.b(packetplayinsetjigsaw.j());
                tileentityjigsaw.e();
                this.g.A().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInJigsawGenerate packetplayinjigsawgenerate) {
        PlayerConnectionUtils.a(packetplayinjigsawgenerate, this, this.g.A());
        if (this.g.hi()) {
            BlockPosition blockposition = packetplayinjigsawgenerate.b();
            TileEntity tileentity = this.g.A().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(this.g.A(), packetplayinjigsawgenerate.e(), packetplayinjigsawgenerate.f());
            }
        }
    }

    @Override
    public void a(PacketPlayInTrSel packetplayintrsel) {
        PlayerConnectionUtils.a(packetplayintrsel, this, this.g.A());
        int i2 = packetplayintrsel.b();
        Container container = this.g.cn;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant containermerchant = (ContainerMerchant)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(this.g, i2, containermerchant);
            if (tradeSelectEvent.isCancelled()) {
                this.g.getBukkitEntity().updateInventory();
                return;
            }
            if (!containermerchant.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)containermerchant);
                return;
            }
            containermerchant.e(i2);
            containermerchant.h(i2);
        }
    }

    @Override
    public void a(PacketPlayInBEdit packetplayinbedit) {
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.a(IChatBaseComponent.b("Book edited too quickly!"));
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i2 = packetplayinbedit.b();
        if (PlayerInventory.f(i2) || i2 == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packetplayinbedit.f();
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            list.addAll(packetplayinbedit.e());
            Consumer<List> consumer = optional.isPresent() ? list1 -> this.a((FilteredText)list1.get(0), list1.subList(1, list1.size()), i2) : list1 -> this.a((List<FilteredText>)list1, i2);
            this.a(list).thenAcceptAsync(consumer, (Executor)this.d);
        }
    }

    private void a(List<FilteredText> list, int i2) {
        ItemStack handItem = this.g.gK().a(i2);
        ItemStack itemstack = handItem.v();
        if (itemstack.c(DataComponents.ab)) {
            List<Filterable<String>> list1 = list.stream().map(this::a).toList();
            itemstack.b(DataComponents.ab, new WritableBookContent(list1));
            CraftEventFactory.handleEditBookEvent(this.g, i2, handItem, itemstack);
        }
    }

    private void a(FilteredText filteredtext, List<FilteredText> list, int i2) {
        ItemStack itemstack = this.g.gK().a(i2);
        if (itemstack.c(DataComponents.ab)) {
            ItemStack itemstack1 = itemstack.a((IMaterial)Items.wl);
            itemstack1.e(DataComponents.ab);
            List<Filterable<IChatBaseComponent>> list1 = list.stream().map(filteredtext1 -> this.a((FilteredText)filteredtext1).a(IChatBaseComponent::b)).toList();
            itemstack1.b(DataComponents.ac, new WrittenBookContent(this.a(filteredtext), this.g.aq(), 0, list1, true));
            CraftEventFactory.handleEditBookEvent(this.g, i2, itemstack, itemstack1);
            this.g.gK().a(i2, itemstack);
        }
    }

    private Filterable<String> a(FilteredText filteredtext) {
        return this.g.Z() ? Filterable.a(filteredtext.b()) : Filterable.a(filteredtext);
    }

    @Override
    public void a(PacketPlayInEntityNBTQuery packetplayinentitynbtquery) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packetplayinentitynbtquery, this, this.g.A());
        if (this.g.I().hasPermission(Permissions.b) && (entity = this.g.A().a(packetplayinentitynbtquery.e())) != null) {
            try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(entity.es(), i);){
                TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter_j, entity.eo());
                entity.d(tagvalueoutput);
                NBTTagCompound nbttagcompound = tagvalueoutput.b();
                this.b(new PacketPlayOutNBTQuery(packetplayinentitynbtquery.b(), nbttagcompound));
            }
        }
    }

    @Override
    public void a(ServerboundContainerSlotStateChangedPacket serverboundcontainerslotstatechangedpacket) {
        CrafterMenu craftermenu;
        IInventory iinventory;
        Container container;
        PlayerConnectionUtils.a(serverboundcontainerslotstatechangedpacket, this, this.g.A());
        if (!this.g.au() && serverboundcontainerslotstatechangedpacket.e() == this.g.cn.l && (container = this.g.cn) instanceof CrafterMenu && (iinventory = (craftermenu = (CrafterMenu)container).m()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)iinventory;
            crafterblockentity.a(serverboundcontainerslotstatechangedpacket.b(), serverboundcontainerslotstatechangedpacket.f());
        }
    }

    @Override
    public void a(PacketPlayInTileNBTQuery packetplayintilenbtquery) {
        PlayerConnectionUtils.a(packetplayintilenbtquery, this, this.g.A());
        if (this.g.I().hasPermission(Permissions.b)) {
            TileEntity tileentity = this.g.A().c_(packetplayintilenbtquery.e());
            NBTTagCompound nbttagcompound = tileentity != null ? tileentity.c(this.g.eo()) : null;
            this.b(new PacketPlayOutNBTQuery(packetplayintilenbtquery.b(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInFlying packetplayinflying) {
        PlayerConnectionUtils.a(packetplayinflying, this, this.g.A());
        if (PlayerConnection.b(packetplayinflying.a(0.0), packetplayinflying.b(0.0), packetplayinflying.c(0.0), packetplayinflying.a(0.0f), packetplayinflying.b(0.0f))) {
            this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"));
        } else {
            WorldServer worldserver = this.g.A();
            if (!this.g.k && !this.g.fE()) {
                if (this.q == 0) {
                    this.m();
                }
                if (this.q()) {
                    float f2 = MathHelper.f(packetplayinflying.a(this.g.ec()));
                    float f1 = MathHelper.f(packetplayinflying.b(this.g.ee()));
                    if (this.u()) {
                        this.g.b(f2, f1);
                    } else {
                        double d0 = PlayerConnection.a(packetplayinflying.a(this.g.dP()));
                        double d1 = PlayerConnection.b(packetplayinflying.b(this.g.dR()));
                        double d2 = PlayerConnection.a(packetplayinflying.c(this.g.dV()));
                        if (this.g.cq()) {
                            this.g.a(this.g.dP(), this.g.dR(), this.g.dV(), f2, f1);
                            this.g.A().p().a(this.g);
                            this.allowedPlayerTicks = 20;
                        } else {
                            double prevX = this.g.dP();
                            double prevY = this.g.dR();
                            double prevZ = this.g.dV();
                            float prevYaw = this.g.ec();
                            float prevPitch = this.g.ee();
                            double d3 = this.g.dP();
                            double d4 = this.g.dR();
                            double d5 = this.g.dV();
                            double d6 = d0 - this.u;
                            double d7 = d1 - this.v;
                            double d8 = d2 - this.w;
                            double d9 = this.g.dN().h();
                            double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                            if (this.g.gr()) {
                                if (d10 > 1.0) {
                                    this.a(this.g.dP(), this.g.dR(), this.g.dV(), f2, f1);
                                }
                            } else {
                                boolean flag1;
                                boolean flag = this.g.gj();
                                if (worldserver.y().i()) {
                                    ++this.O;
                                    int i2 = this.O - this.P;
                                    this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                                    this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                                    this.lastTick = (int)(System.currentTimeMillis() / 50L);
                                    if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                        i.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.g.aq(), (Object)i2);
                                        i2 = 1;
                                    }
                                    this.allowedPlayerTicks = packetplayinflying.i || d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                                    double speed = this.g.gL().b ? (double)(this.g.gL().m * 20.0f) : (double)(this.g.gL().n * 10.0f);
                                    if (this.a(flag)) {
                                        float f22;
                                        float f3 = f22 = flag ? 300.0f : 100.0f;
                                        if (d10 - d9 > Math.max((double)f22, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0))) {
                                            i.warn("{} moved too quickly! {},{},{}", new Object[]{this.g.aq(), d6, d7, d8});
                                            this.a(this.g.dP(), this.g.dR(), this.g.dV(), this.g.ec(), this.g.ee());
                                            return;
                                        }
                                    }
                                }
                                AxisAlignedBB axisalignedbb = this.g.dj();
                                d6 = d0 - this.x;
                                d7 = d1 - this.y;
                                d8 = d2 - this.z;
                                boolean bl = flag1 = d7 > 0.0;
                                if (this.g.aV() && !packetplayinflying.b() && flag1) {
                                    this.g.u();
                                }
                                boolean flag2 = this.g.af;
                                this.g.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                                this.g.bc = packetplayinflying.b();
                                double d11 = d7;
                                d6 = d0 - this.g.dP();
                                d7 = d1 - this.g.dR();
                                if (d7 > -0.5 || d7 < 0.5) {
                                    d7 = 0.0;
                                }
                                d8 = d2 - this.g.dV();
                                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                                boolean flag3 = false;
                                if (!(this.g.S() || !(d10 > SpigotConfig.movedWronglyThreshold) || this.g.gr() || this.g.ha() || this.g.au() || this.g.hq())) {
                                    flag3 = true;
                                    i.warn("{} moved wrongly!", (Object)this.g.aq());
                                }
                                if (this.g.ar || this.g.gr() || (!flag3 || !worldserver.a((net.minecraft.world.entity.Entity)this.g, axisalignedbb)) && !this.a(worldserver, this.g, axisalignedbb, d0, d1, d2)) {
                                    this.g.a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                    CraftPlayer player = this.getCraftPlayer();
                                    if (!this.hasMoved) {
                                        this.lastPosX = prevX;
                                        this.lastPosY = prevY;
                                        this.lastPosZ = prevZ;
                                        this.lastYaw = prevYaw;
                                        this.lastPitch = prevPitch;
                                        this.hasMoved = true;
                                    }
                                    Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                    Location to = player.getLocation().clone();
                                    if (packetplayinflying.h) {
                                        to.setX(packetplayinflying.a);
                                        to.setY(packetplayinflying.b);
                                        to.setZ(packetplayinflying.c);
                                    }
                                    if (packetplayinflying.i) {
                                        to.setYaw(packetplayinflying.d);
                                        to.setPitch(packetplayinflying.e);
                                    }
                                    double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                    float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                    if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.g.fE()) {
                                        this.lastPosX = to.getX();
                                        this.lastPosY = to.getY();
                                        this.lastPosZ = to.getZ();
                                        this.lastYaw = to.getYaw();
                                        this.lastPitch = to.getPitch();
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event);
                                        if (event.isCancelled()) {
                                            this.teleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                                            this.g.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                    this.g.a(d0, d1, d2, f2, f1);
                                    boolean flag4 = this.g.fW();
                                    this.K = d11 >= -0.03125 && !flag2 && !this.g.au() && !this.d.ag() && !this.g.gL().c && !this.g.d(MobEffects.y) && !flag && !flag4 && this.b(this.g);
                                    this.g.A().p().a(this.g);
                                    Vec3D vec3d = new Vec3D(this.g.dP() - d3, this.g.dR() - d4, this.g.dV() - d5);
                                    this.g.a(packetplayinflying.b(), packetplayinflying.e(), vec3d);
                                    this.g.a(vec3d.g, vec3d.h, vec3d.i, packetplayinflying.b());
                                    this.a(vec3d);
                                    if (flag1) {
                                        this.g.l();
                                    }
                                    if (packetplayinflying.b() || this.g.ez() || this.g.fl() || this.g.au() || flag || flag4) {
                                        this.g.hp();
                                    }
                                    this.g.a(this.g.dP() - d3, this.g.dR() - d4, this.g.dV() - d5);
                                    this.x = this.g.dP();
                                    this.y = this.g.dR();
                                    this.z = this.g.dV();
                                } else {
                                    this.internalTeleport(d3, d4, d5, f2, f1);
                                    this.g.a(this.g.dP() - d3, this.g.dR() - d4, this.g.dV() - d5, packetplayinflying.b());
                                    this.g.aX();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean a(boolean flag) {
        if (this.h()) {
            return false;
        }
        if (this.g.S()) {
            return false;
        }
        GameRules gamerules = this.g.A().U();
        return gamerules.a(GameRules.H) == false ? false : !flag || gamerules.a(GameRules.i) != false;
    }

    private boolean u() {
        if (this.H != null) {
            if (this.q - this.J > 20) {
                this.J = this.q;
                this.a(this.H.g, this.H.h, this.H.i, this.g.ec(), this.g.ee());
            }
            this.allowedPlayerTicks = 20;
            return true;
        }
        this.J = this.q;
        return false;
    }

    private boolean a(IWorldReader iworldreader, net.minecraft.world.entity.Entity entity, AxisAlignedBB axisalignedbb, double d0, double d1, double d2) {
        AxisAlignedBB axisalignedbb1 = entity.dj().d(d0 - entity.dP(), d1 - entity.dR(), d2 - entity.dV());
        Iterable<VoxelShape> iterable = iworldreader.a(entity, axisalignedbb1.h(1.0E-5f), axisalignedbb.g());
        VoxelShape voxelshape = VoxelShapes.a(axisalignedbb.h(1.0E-5f));
        for (VoxelShape voxelshape1 : iterable) {
            if (VoxelShapes.c(voxelshape1, voxelshape, OperatorBoolean.i)) continue;
            return true;
        }
        return false;
    }

    public void a(double d0, double d1, double d2, float f2, float f1) {
        this.teleport(d0, d1, d2, f2, f1, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, f2, f1), Collections.emptySet(), cause);
    }

    public void a(PositionMoveRotation positionmoverotation, Set<Relative> set) {
        this.teleport(positionmoverotation, set, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(PositionMoveRotation positionmoverotation, Set<Relative> set, PlayerTeleportEvent.TeleportCause cause) {
        PositionMoveRotation absolutePosition;
        Location to;
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        if (from.equals((Object)(to = CraftLocation.toBukkit((absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this.g), positionmoverotation, set)).a(), this.getCraftPlayer().getWorld(), absolutePosition.c(), absolutePosition.d())))) {
            this.internalTeleport(positionmoverotation, set);
            return true;
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            set = Collections.emptySet();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            positionmoverotation = new PositionMoveRotation(CraftLocation.toVec3D(to), Vec3D.c, to.getYaw(), to.getPitch());
        }
        this.internalTeleport(positionmoverotation, set);
        return !event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch());
    }

    private void internalTeleport(double d0, double d1, double d2, float f2, float f1) {
        this.internalTeleport(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, f2, f1), Collections.emptySet());
    }

    public void internalTeleport(PositionMoveRotation positionmoverotation, Set<Relative> set) {
        if (Float.isNaN(positionmoverotation.c())) {
            positionmoverotation = new PositionMoveRotation(positionmoverotation.a(), positionmoverotation.b(), 0.0f, positionmoverotation.d());
        }
        if (Float.isNaN(positionmoverotation.d())) {
            positionmoverotation = new PositionMoveRotation(positionmoverotation.a(), positionmoverotation.b(), positionmoverotation.c(), 0.0f);
        }
        this.justTeleported = true;
        this.J = this.q;
        if (++this.I == Integer.MAX_VALUE) {
            this.I = 0;
        }
        this.g.a(positionmoverotation, set);
        this.H = this.g.dI();
        this.lastPosX = this.H.g;
        this.lastPosY = this.H.h;
        this.lastPosZ = this.H.i;
        this.lastYaw = this.g.ec();
        this.lastPitch = this.g.ee();
        this.b(PacketPlayOutPosition.a(this.I, positionmoverotation, set));
    }

    @Override
    public void a(PacketPlayInBlockDig packetplayinblockdig) {
        PlayerConnectionUtils.a(packetplayinblockdig, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        if (this.q()) {
            BlockPosition blockposition = packetplayinblockdig.b();
            this.g.J();
            PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype = packetplayinblockdig.f();
            switch (packetplayinblockdig_enumplayerdigtype) {
                case h: {
                    if (this.g.au()) {
                        return;
                    }
                    ItemStack itemstack = this.g.b(EnumHand.a);
                    if (this.g.c(itemstack, 5)) {
                        return;
                    }
                    PiercingWeapon piercingweapon = itemstack.a(DataComponents.N);
                    if (piercingweapon != null) {
                        piercingweapon.a(this.g, EnumItemSlot.a);
                    }
                    return;
                }
                case g: {
                    if (!this.g.au()) {
                        ItemStack itemstack1 = this.g.b(EnumHand.b);
                        CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack1);
                        CraftItemStack offHand = CraftItemStack.asCraftMirror(this.g.b(EnumHand.a));
                        PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                        this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                        if (swapItemsEvent.isCancelled()) {
                            return;
                        }
                        if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                            this.g.a(EnumHand.b, this.g.b(EnumHand.a));
                        } else {
                            this.g.a(EnumHand.b, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                        }
                        if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                            this.g.a(EnumHand.a, itemstack1);
                        } else {
                            this.g.a(EnumHand.a, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                        }
                        this.g.gf();
                    }
                    return;
                }
                case e: {
                    if (!this.g.au()) {
                        if (this.lastDropTick != MinecraftServer.currentTick) {
                            this.dropCount = 0;
                            this.lastDropTick = MinecraftServer.currentTick;
                        } else {
                            ++this.dropCount;
                            if (this.dropCount >= 20) {
                                i.warn(this.g.da() + " dropped their items too quickly!");
                                this.a(IChatBaseComponent.b("You dropped your items too quickly (Hacking?)"));
                                return;
                            }
                        }
                        this.g.a(false);
                    }
                    return;
                }
                case d: {
                    if (!this.g.au()) {
                        this.g.a(true);
                    }
                    return;
                }
                case f: {
                    this.g.ge();
                    return;
                }
                case a: 
                case b: 
                case c: {
                    this.g.h.a(blockposition, packetplayinblockdig_enumplayerdigtype, packetplayinblockdig.e(), this.g.A().aw(), packetplayinblockdig.g());
                    this.a(packetplayinblockdig.g());
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid player action");
        }
    }

    private static boolean a(EntityPlayer entityplayer, ItemStack itemstack) {
        ItemBucket itembucket;
        if (itemstack.f()) {
            return false;
        }
        Item item = itemstack.h();
        if ((item instanceof ItemBlock || item instanceof ItemBucket && (itembucket = (ItemBucket)item).a() != FluidTypes.a) && !entityplayer.hh().a(itemstack)) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < 30L && this.limitedPackets++ >= 4) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= 30L) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void a(PacketPlayInUseItem packetplayinuseitem) {
        PlayerConnectionUtils.a(packetplayinuseitem, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        if (!this.checkLimit(packetplayinuseitem.timestamp)) {
            return;
        }
        if (this.q()) {
            this.a(packetplayinuseitem.f());
            WorldServer worldserver = this.g.A();
            EnumHand enumhand = packetplayinuseitem.b();
            ItemStack itemstack = this.g.b(enumhand);
            if (itemstack.a(worldserver.Q())) {
                MovingObjectPositionBlock movingobjectpositionblock = packetplayinuseitem.e();
                Vec3D vec3d = movingobjectpositionblock.g();
                BlockPosition blockposition = movingobjectpositionblock.b();
                if (this.g.a(blockposition, 1.0)) {
                    Vec3D vec3d1 = vec3d.d(Vec3D.b(blockposition));
                    double d0 = 1.0000001;
                    if (Math.abs(vec3d1.a()) < 1.0000001 && Math.abs(vec3d1.b()) < 1.0000001 && Math.abs(vec3d1.c()) < 1.0000001) {
                        EnumDirection enumdirection = movingobjectpositionblock.c();
                        this.g.J();
                        int i2 = this.g.A().aw();
                        if (blockposition.v() <= i2) {
                            if (this.H == null && worldserver.a((net.minecraft.world.entity.Entity)this.g, blockposition)) {
                                EnumInteractionResult.d enuminteractionresult_d;
                                this.g.gf();
                                EnumInteractionResult enuminteractionresult = this.g.h.a(this.g, worldserver, itemstack, enumhand, movingobjectpositionblock);
                                if (enuminteractionresult.a()) {
                                    CriterionTriggers.Q.a(this.g, movingobjectpositionblock.b(), itemstack.v());
                                }
                                if (enumdirection == EnumDirection.b && !enuminteractionresult.a() && blockposition.v() >= i2 && PlayerConnection.a(this.g, itemstack)) {
                                    IChatMutableComponent ichatbasecomponent = IChatBaseComponent.a("build.tooHigh", i2).a(EnumChatFormat.m);
                                    this.g.b(ichatbasecomponent, true);
                                } else if (enuminteractionresult instanceof EnumInteractionResult.d && (enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult).e() == EnumInteractionResult.e.c) {
                                    this.g.a(enumhand, true);
                                }
                            }
                        } else {
                            IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.a("build.tooHigh", i2).a(EnumChatFormat.m);
                            this.g.b(ichatbasecomponent1, true);
                        }
                        this.b(new PacketPlayOutBlockChange(worldserver, blockposition));
                        this.b(new PacketPlayOutBlockChange(worldserver, blockposition.a(enumdirection)));
                    } else {
                        i.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.g.gI().name(), vec3d, blockposition});
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInBlockPlace packetplayinblockplace) {
        PlayerConnectionUtils.a(packetplayinblockplace, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        if (!this.checkLimit(packetplayinblockplace.timestamp)) {
            return;
        }
        if (this.q()) {
            this.a(packetplayinblockplace.e());
            WorldServer worldserver = this.g.A();
            EnumHand enumhand = packetplayinblockplace.b();
            ItemStack itemstack = this.g.b(enumhand);
            this.g.J();
            if (!itemstack.f() && itemstack.a(worldserver.Q())) {
                EnumInteractionResult.d enuminteractionresult_d;
                boolean cancelled;
                float f2 = MathHelper.f(packetplayinblockplace.f());
                float f1 = MathHelper.f(packetplayinblockplace.g());
                if (f1 != this.g.ee() || f2 != this.g.ec()) {
                    this.g.b(f2, f1);
                }
                double d0 = this.g.dP();
                double d1 = this.g.dR() + (double)this.g.dk();
                double d2 = this.g.dV();
                Vec3D vec3d = new Vec3D(d0, d1, d2);
                float f3 = MathHelper.b((double)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
                float f4 = MathHelper.a((double)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
                float f5 = -MathHelper.b((double)(-f1 * ((float)Math.PI / 180)));
                float f6 = MathHelper.a((double)(-f1 * ((float)Math.PI / 180)));
                float f7 = f4 * f5;
                float f8 = f3 * f5;
                double d3 = this.g.hm();
                Vec3D vec3d1 = vec3d.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
                MovingObjectPositionBlock movingobjectposition = this.g.A().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.g));
                if (movingobjectposition == null || ((MovingObjectPosition)movingobjectposition).d() != MovingObjectPosition.EnumMovingObjectType.b) {
                    PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.g, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                    cancelled = event.useItemInHand() == Event.Result.DENY;
                } else {
                    PlayerInteractEvent event;
                    MovingObjectPositionBlock movingobjectpositionblock = movingobjectposition;
                    cancelled = this.g.h.firedInteract && this.g.h.interactPosition.equals(movingobjectpositionblock.b()) && this.g.h.interactHand == enumhand && ItemStack.c(this.g.h.interactItemStack, itemstack) ? this.g.h.interactResult : (event = CraftEventFactory.callPlayerInteractEvent((EntityHuman)this.g, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.b(), movingobjectpositionblock.c(), itemstack, true, enumhand, movingobjectpositionblock.g())).useItemInHand() == Event.Result.DENY;
                    this.g.h.firedInteract = false;
                }
                if (cancelled) {
                    this.g.getBukkitEntity().updateInventory();
                    return;
                }
                itemstack = this.g.b(enumhand);
                if (itemstack.f()) {
                    return;
                }
                EnumInteractionResult enuminteractionresult = this.g.h.a(this.g, worldserver, itemstack, enumhand);
                if (enuminteractionresult instanceof EnumInteractionResult.d && (enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult).e() == EnumInteractionResult.e.c) {
                    this.g.a(enumhand, true);
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSpectate packetplayinspectate) {
        PlayerConnectionUtils.a(packetplayinspectate, this, this.g.A());
        if (this.g.au()) {
            for (WorldServer worldserver : this.d.P()) {
                net.minecraft.world.entity.Entity entity = packetplayinspectate.a(worldserver);
                if (entity == null) continue;
                this.g.teleportTo(worldserver, entity.dP(), entity.dR(), entity.dV(), Set.of(), entity.ec(), entity.ee(), true, PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void a(PacketPlayInBoatMove packetplayinboatmove) {
        PlayerConnectionUtils.a(packetplayinboatmove, this, this.g.A());
        net.minecraft.world.entity.Entity entity = this.g.dA();
        if (entity instanceof AbstractBoat) {
            AbstractBoat abstractboat = (AbstractBoat)entity;
            abstractboat.a(packetplayinboatmove.b(), packetplayinboatmove.e());
        }
    }

    @Override
    public void a(DisconnectionDetails disconnectiondetails) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        i.info("{} lost connection: {}", (Object)this.g.aq(), (Object)disconnectiondetails.a().getString());
        this.v();
        super.a(disconnectiondetails);
    }

    private void v() {
        this.W.close();
        this.g.v();
        String quitMessage = this.d.aj().remove(this.g);
        if (quitMessage != null && quitMessage.length() > 0) {
            this.d.aj().broadcastMessage(CraftChatMessage.fromString(quitMessage));
        }
        this.g.Y().b();
    }

    public void a(int i2) {
        if (i2 < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.r = Math.max(i2, this.r);
    }

    @Override
    public void a(PacketPlayInHeldItemSlot packetplayinhelditemslot) {
        PlayerConnectionUtils.a(packetplayinhelditemslot, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        if (packetplayinhelditemslot.b() >= 0 && packetplayinhelditemslot.b() < PlayerInventory.i()) {
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.g.gK().g(), packetplayinhelditemslot.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.b(new PacketPlayOutHeldItemSlot(this.g.gK().g()));
                this.g.J();
                return;
            }
            if (this.g.gK().g() != packetplayinhelditemslot.b() && this.g.ga() == EnumHand.a) {
                this.g.gf();
            }
            this.g.gK().d(packetplayinhelditemslot.b());
            this.g.J();
        } else {
            i.warn("{} tried to set an invalid carried item", (Object)this.g.aq());
            this.a(IChatBaseComponent.b("Invalid hotbar selection (Hacking?)"));
        }
    }

    @Override
    public void a(PacketPlayInChat packetplayinchat) {
        if (this.d.ai()) {
            return;
        }
        Optional<LastSeenMessages> optional = this.a(packetplayinchat.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packetplayinchat.b(), false, () -> {
                PlayerChatMessage playerchatmessage;
                try {
                    playerchatmessage = this.a(packetplayinchat, (LastSeenMessages)optional.get());
                }
                catch (SignedMessageChain.a signedmessagechain_a) {
                    this.a(signedmessagechain_a);
                    return;
                }
                CompletionStage completablefuture = this.a(playerchatmessage.c()).thenApplyAsync(Function.identity(), (Executor)this.d.chatExecutor);
                IChatBaseComponent ichatbasecomponent = this.d.bm().decorate(this.g, playerchatmessage.d());
                this.W.append(completablefuture, filteredtext -> {
                    PlayerChatMessage playerchatmessage1 = playerchatmessage.a(ichatbasecomponent).a(filteredtext.e());
                    this.a(playerchatmessage1);
                });
            }, false);
        }
    }

    @Override
    public void a(ServerboundChatCommandPacket serverboundchatcommandpacket) {
        this.tryHandleChat(serverboundchatcommandpacket.b(), true, () -> {
            if (this.g.w()) {
                return;
            }
            this.b(serverboundchatcommandpacket.b());
            this.detectRateSpam("/" + serverboundchatcommandpacket.b());
        }, true);
    }

    private void b(String s2) {
        String command = "/" + s2;
        i.info(this.g.da() + " issued server command: " + command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), command, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        s2 = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.c(s2);
        if (this.d.ay() && SignableCommand.a(parseresults)) {
            i.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.g.gI().name(), (Object)s2);
            this.g.a(o);
        } else {
            this.d.aF().a(parseresults, s2);
        }
    }

    @Override
    public void a(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket) {
        Optional<LastSeenMessages> optional = this.a(serverboundchatcommandsignedpacket.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(serverboundchatcommandsignedpacket.b(), true, () -> {
                if (this.g.w()) {
                    return;
                }
                this.a(serverboundchatcommandsignedpacket, (LastSeenMessages)optional.get());
                this.detectRateSpam("/" + serverboundchatcommandsignedpacket.b());
            }, true);
        }
    }

    private void a(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket, LastSeenMessages lastseenmessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + serverboundchatcommandsignedpacket.b();
        i.info(this.g.da() + " issued server command: " + (String)command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.c((String)command);
        try {
            map = serverboundchatcommandsignedpacket.b().equals(command) ? this.a(serverboundchatcommandsignedpacket, SignableCommand.b(parseresults), lastseenmessages) : Collections.emptyMap();
        }
        catch (SignedMessageChain.a signedmessagechain_a) {
            this.a(signedmessagechain_a);
            return;
        }
        CommandSigningContext.a commandsigningcontext = new CommandSigningContext.a(map);
        parseresults = net.minecraft.commands.CommandDispatcher.a(parseresults, commandlistenerwrapper -> commandlistenerwrapper.a(commandsigningcontext, this.W));
        this.d.aF().a(parseresults, (String)command);
    }

    private void a(SignedMessageChain.a signedmessagechain_a) {
        i.warn("Failed to update secure chat state for {}: '{}'", (Object)this.g.gI().name(), (Object)signedmessagechain_a.a().getString());
        this.g.a(signedmessagechain_a.a().f().a(EnumChatFormat.m));
    }

    private <S> Map<String, PlayerChatMessage> a(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket, SignableCommand<S> signablecommand, LastSeenMessages lastseenmessages) throws SignedMessageChain.a {
        List<ArgumentSignatures.a> list = serverboundchatcommandsignedpacket.g().a();
        List<SignableCommand.a<S>> list1 = signablecommand.a();
        if (list.isEmpty()) {
            return this.b(list1);
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.a a2 : list) {
            SignableCommand.a<S> signablecommand_a = signablecommand.a(a2.a());
            if (signablecommand_a == null) {
                this.S.setChainBroken();
                throw PlayerConnection.a(serverboundchatcommandsignedpacket.b(), list, list1);
            }
            SignedMessageBody signedmessagebody = new SignedMessageBody(signablecommand_a.c(), serverboundchatcommandsignedpacket.e(), serverboundchatcommandsignedpacket.f(), lastseenmessages);
            map.put(signablecommand_a.a(), this.S.unpack(a2.b(), signedmessagebody));
        }
        for (SignableCommand.a a3 : list1) {
            if (map.containsKey(a3.a())) continue;
            throw PlayerConnection.a(serverboundchatcommandsignedpacket.b(), list, list1);
        }
        return map;
    }

    private <S> Map<String, PlayerChatMessage> b(List<SignableCommand.a<S>> list) throws SignedMessageChain.a {
        HashMap<String, PlayerChatMessage> map = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.a<S> signablecommand_a : list) {
            SignedMessageBody signedmessagebody = SignedMessageBody.a(signablecommand_a.c());
            map.put(signablecommand_a.a(), this.S.unpack(null, signedmessagebody));
        }
        return map;
    }

    private static <S> SignedMessageChain.a a(String s2, List<ArgumentSignatures.a> list, List<SignableCommand.a<S>> list1) {
        String s1 = list.stream().map(ArgumentSignatures.a::a).collect(Collectors.joining(", "));
        String s22 = list1.stream().map(SignableCommand.a::a).collect(Collectors.joining(", "));
        i.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{s2, s1, s22});
        return new SignedMessageChain.a(o);
    }

    private ParseResults<CommandListenerWrapper> c(String s2) {
        CommandDispatcher<CommandListenerWrapper> commanddispatcher = this.d.aF().a();
        return commanddispatcher.parse(s2, this.g.C());
    }

    private void tryHandleChat(String s2, boolean flag, Runnable runnable, boolean sync) {
        if (PlayerConnection.d(s2)) {
            this.a(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"));
        } else if (this.g.eh() || !flag && this.g.G() == EnumChatVisibility.c) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.disabled.options").a(EnumChatFormat.m), false));
        } else {
            this.g.J();
            if (sync) {
                this.d.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> a(LastSeenMessages.b lastseenmessages_b) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.T;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> optional;
            try {
                LastSeenMessages lastseenmessages = this.T.a(lastseenmessages_b);
                optional = Optional.of(lastseenmessages);
            }
            catch (LastSeenMessagesValidator.a lastseenmessagesvalidator_a) {
                i.error("Failed to validate message acknowledgements from {}: {}", (Object)this.g.aq(), (Object)lastseenmessagesvalidator_a.getMessage());
                this.a(n);
                return Optional.empty();
            }
            return optional;
        }
    }

    private static boolean d(String s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (UtilColor.a(s2.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public void chat(String s2, final PlayerChatMessage original, boolean async) {
        if (s2.isEmpty() || this.g.G() == EnumChatVisibility.c) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.a(original);
        if (!async && s2.startsWith("/")) {
            this.handleCommand(s2);
        } else if (this.g.G() != EnumChatVisibility.b) {
            CraftPlayer player = this.getCraftPlayer();
            AsyncPlayerChatEvent event = new AsyncPlayerChatEvent(async, (Player)player, s2, (Set)new LazyPlayerSet(this.d));
            final String originalFormat = event.getFormat();
            final String originalMessage = event.getMessage();
            this.cserver.getPluginManager().callEvent((Event)event);
            if (PlayerChatEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerChatEvent queueEvent = new PlayerChatEvent((Player)player, event.getMessage(), event.getFormat(), event.getRecipients());
                queueEvent.setCancelled(event.isCancelled());
                Waitable waitable = new Waitable(){

                    protected Object evaluate() {
                        Bukkit.getPluginManager().callEvent((Event)queueEvent);
                        if (queueEvent.isCancelled()) {
                            return null;
                        }
                        String message = String.format(queueEvent.getFormat(), queueEvent.getPlayer().getDisplayName(), queueEvent.getMessage());
                        if (((LazyPlayerSet)queueEvent.getRecipients()).isLazy()) {
                            if (!SpigotConfig.bungee && originalFormat.equals(queueEvent.getFormat()) && originalMessage.equals(queueEvent.getMessage()) && queueEvent.getPlayer().getName().equalsIgnoreCase(queueEvent.getPlayer().getDisplayName())) {
                                PlayerConnection.this.d.aj().a(original, PlayerConnection.this.g, ChatMessageType.a(ChatMessageType.e, PlayerConnection.this.g));
                                return null;
                            }
                            for (EntityPlayer recipient : PlayerConnection.this.d.aj().k) {
                                recipient.getBukkitEntity().sendMessage(PlayerConnection.this.g.cY(), message);
                            }
                        } else {
                            for (Player player : queueEvent.getRecipients()) {
                                player.sendMessage(PlayerConnection.this.g.cY(), message);
                            }
                        }
                        PlayerConnection.this.d.console.sendMessage(message);
                        return null;
                    }
                };
                if (async) {
                    this.d.processQueue.add(waitable);
                } else {
                    waitable.run();
                }
                try {
                    waitable.get();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e3) {
                    throw new RuntimeException("Exception processing chat event", e3.getCause());
                }
            } else {
                if (event.isCancelled()) {
                    return;
                }
                s2 = String.format(event.getFormat(), event.getPlayer().getDisplayName(), event.getMessage());
                if (((LazyPlayerSet)event.getRecipients()).isLazy()) {
                    if (!SpigotConfig.bungee && originalFormat.equals(event.getFormat()) && originalMessage.equals(event.getMessage()) && event.getPlayer().getName().equalsIgnoreCase(event.getPlayer().getDisplayName())) {
                        this.d.aj().a(original, this.g, ChatMessageType.a(ChatMessageType.e, this.g));
                        return;
                    }
                    for (EntityPlayer recipient : this.d.aj().k) {
                        recipient.getBukkitEntity().sendMessage(this.g.cY(), s2);
                    }
                } else {
                    for (Player recipient : event.getRecipients()) {
                        recipient.sendMessage(this.g.cY(), s2);
                    }
                }
                this.d.console.sendMessage(s2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCommand(String s2) {
        SpigotTimings.playerCommandTimer.startTiming();
        if (SpigotConfig.logCommands) {
            i.info(this.g.da() + " issued server command: " + s2);
        }
        CraftPlayer player = this.getCraftPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)player, s2, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            SpigotTimings.playerCommandTimer.stopTiming();
            return;
        }
        try {
            if (this.cserver.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
                return;
            }
        }
        catch (CommandException ex) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "An internal error occurred while attempting to perform this command");
            java.util.logging.Logger.getLogger(PlayerConnection.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            SpigotTimings.playerCommandTimer.stopTiming();
        }
    }

    private PlayerChatMessage a(PacketPlayInChat packetplayinchat, LastSeenMessages lastseenmessages) throws SignedMessageChain.a {
        SignedMessageBody signedmessagebody = new SignedMessageBody(packetplayinchat.b(), packetplayinchat.e(), packetplayinchat.f(), lastseenmessages);
        return this.S.unpack(packetplayinchat.g(), signedmessagebody);
    }

    private void a(PlayerChatMessage playerchatmessage) {
        String s2 = playerchatmessage.c();
        if (s2.isEmpty()) {
            i.warn(this.g.da() + " tried to send an empty message");
        } else if (this.getCraftPlayer().isConversing()) {
            final String conversationInput = s2;
            this.d.processQueue.add(new Runnable(){

                @Override
                public void run() {
                    PlayerConnection.this.getCraftPlayer().acceptConversationInput(conversationInput);
                }
            });
        } else if (this.g.G() == EnumChatVisibility.b) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.cannotSend").a(EnumChatFormat.m), false));
        } else {
            this.chat(s2, playerchatmessage, true);
        }
        this.detectRateSpam(s2);
    }

    private void detectRateSpam(String s2) {
        for (String exclude : SpigotConfig.spamExclusions) {
            if (exclude == null || !s2.startsWith(exclude)) continue;
            return;
        }
        if (!(this.s.isIncrementAndUnderThreshold() || this.d.aj().f(this.g.gJ()) || this.d.a(this.g.gJ()))) {
            this.a(IChatBaseComponent.c("disconnect.spam"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(ServerboundChatAckPacket serverboundchatackpacket) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.T;
        synchronized (lastSeenMessagesValidator) {
            try {
                this.T.a(serverboundchatackpacket.b());
            }
            catch (LastSeenMessagesValidator.a lastseenmessagesvalidator_a) {
                i.error("Failed to validate message acknowledgement offset from {}: {}", (Object)this.g.aq(), (Object)lastseenmessagesvalidator_a.getMessage());
                this.a(n);
            }
        }
    }

    @Override
    public void a(PacketPlayInArmAnimation packetplayinarmanimation) {
        Block block;
        PlayerConnectionUtils.a(packetplayinarmanimation, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        this.g.J();
        float f1 = this.g.ee();
        float f2 = this.g.ec();
        double d0 = this.g.dP();
        double d1 = this.g.dR() + (double)this.g.dk();
        double d2 = this.g.dV();
        Location origin = new Location((World)this.g.A().getWorld(), d0, d1, d2, f2, f1);
        double d3 = Math.max(this.g.hm(), this.g.hn());
        RayTraceResult result = this.g.A().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.1, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.g.getBukkitEntity() && this.g.getBukkitEntity().canSee((Entity)entity) && !handle.au() && handle.bX() && !handle.A(this.g);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.g, Action.LEFT_CLICK_AIR, this.g.gK().h(), EnumHand.a);
        } else if (this.g.h.b() == EnumGamemode.c && (block = result.getHitBlock()) != null) {
            Vector hitPosition = result.getHitPosition().subtract(block.getLocation().toVector());
            CraftEventFactory.callPlayerInteractEvent((EntityHuman)this.g, Action.LEFT_CLICK_BLOCK, block, result.getHitBlockFace(), this.g.gK().h(), true, EnumHand.a, hitPosition);
        }
        PlayerAnimationEvent event = new PlayerAnimationEvent((Player)this.getCraftPlayer(), packetplayinarmanimation.b() == EnumHand.a ? PlayerAnimationType.ARM_SWING : PlayerAnimationType.OFF_ARM_SWING);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.g.a(packetplayinarmanimation.b());
    }

    @Override
    public void a(PacketPlayInEntityAction packetplayinentityaction) {
        PlayerConnectionUtils.a(packetplayinentityaction, this, this.g.A());
        if (this.q()) {
            if (this.g.eh()) {
                return;
            }
            switch (packetplayinentityaction.e()) {
                case b: 
                case c: {
                    PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packetplayinentityaction.e() == PacketPlayInEntityAction.EnumPlayerAction.b);
                    this.cserver.getPluginManager().callEvent((Event)e2);
                    if (!e2.isCancelled()) break;
                    return;
                }
            }
            this.g.J();
            switch (packetplayinentityaction.e()) {
                case b: {
                    this.g.i(true);
                    break;
                }
                case c: {
                    this.g.i(false);
                    break;
                }
                case a: {
                    if (!this.g.gr()) break;
                    this.g.a(false, true);
                    this.H = this.g.dI();
                    break;
                }
                case d: {
                    net.minecraft.world.entity.Entity entity = this.g.dA();
                    if (!(entity instanceof IJumpable)) break;
                    IJumpable ijumpable = (IJumpable)((Object)entity);
                    int i2 = packetplayinentityaction.f();
                    if (!ijumpable.a() || i2 <= 0) break;
                    ijumpable.b(i2);
                    break;
                }
                case e: {
                    net.minecraft.world.entity.Entity entity1 = this.g.dA();
                    if (!(entity1 instanceof IJumpable)) break;
                    IJumpable ijumpable1 = (IJumpable)((Object)entity1);
                    ijumpable1.b();
                    break;
                }
                case f: {
                    net.minecraft.world.entity.Entity entity2 = this.g.dz();
                    if (!(entity2 instanceof HasCustomInventoryScreen)) break;
                    HasCustomInventoryScreen hascustominventoryscreen = (HasCustomInventoryScreen)((Object)entity2);
                    hascustominventoryscreen.b(this.g);
                    break;
                }
                case g: {
                    if (this.g.gR()) break;
                    this.g.fK();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid client command!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage playerchatmessage, ChatMessageType.a chatmessagetype_a) {
        if (!this.getCraftPlayer().canSeePlayer(playerchatmessage.k().c())) {
            this.a(playerchatmessage.d(), chatmessagetype_a);
            return;
        }
        this.b(new ClientboundPlayerChatPacket(this.U++, playerchatmessage.k().c(), playerchatmessage.k().b(), playerchatmessage.l(), playerchatmessage.m().a(this.V), playerchatmessage.n(), playerchatmessage.o(), chatmessagetype_a));
        MessageSignature messagesignature = playerchatmessage.l();
        if (messagesignature != null) {
            int i2;
            this.V.a(playerchatmessage.m(), playerchatmessage.l());
            LastSeenMessagesValidator lastSeenMessagesValidator = this.T;
            synchronized (lastSeenMessagesValidator) {
                this.T.a(messagesignature);
                i2 = this.T.a();
            }
            if (i2 > 4096) {
                this.a(IChatBaseComponent.c("multiplayer.disconnect.too_many_pending_chats"));
            }
        }
    }

    public void a(IChatBaseComponent ichatbasecomponent, ChatMessageType.a chatmessagetype_a) {
        this.b(new ClientboundDisguisedChatPacket(ichatbasecomponent, chatmessagetype_a));
    }

    public SocketAddress n() {
        return this.e.d();
    }

    public SocketAddress getRawAddress() {
        return this.e.k.remoteAddress();
    }

    public void o() {
        this.X = true;
        this.v();
        this.b(ClientboundStartConfigurationPacket.a);
        this.e.a(ConfigurationProtocols.d);
    }

    @Override
    public void a(ServerboundPingRequestPacket serverboundpingrequestpacket) {
        this.e.a(new ClientboundPongResponsePacket(serverboundpingrequestpacket.b()));
    }

    @Override
    public void a(PacketPlayInUseEntity packetplayinuseentity) {
        PlayerConnectionUtils.a(packetplayinuseentity, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        if (this.q()) {
            final WorldServer worldserver = this.g.A();
            final net.minecraft.world.entity.Entity entity = packetplayinuseentity.a(worldserver);
            if (entity == this.g && !this.g.au()) {
                this.a(IChatBaseComponent.b("Cannot interact with self!"));
                return;
            }
            this.g.J();
            this.g.h(packetplayinuseentity.b());
            if (entity != null) {
                if (!worldserver.w().a(entity.dK())) {
                    return;
                }
                AxisAlignedBB axisalignedbb = entity.dj();
                if (packetplayinuseentity.a(this.g, axisalignedbb, 3.0)) {
                    packetplayinuseentity.a(new PacketPlayInUseEntity.c(){

                        private void performInteraction(EnumHand enumhand, a playerconnection_a, PlayerInteractEntityEvent event) {
                            ItemStack itemstack = PlayerConnection.this.g.b(enumhand);
                            if (itemstack.a(worldserver.Q())) {
                                ItemStack itemstack1 = itemstack.v();
                                ItemStack itemInHand = PlayerConnection.this.g.b(enumhand);
                                boolean triggerLeashUpdate = itemInHand != null && itemInHand.h() == Items.wZ && entity instanceof EntityInsentient;
                                Item origItem = PlayerConnection.this.g.gK().h() == null ? null : PlayerConnection.this.g.gK().h().h();
                                PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                                if (entity instanceof Bucketable && entity instanceof EntityLiving && origItem != null && origItem.h() == Items.sl && (event.isCancelled() || PlayerConnection.this.g.gK().h() == null || PlayerConnection.this.g.gK().h().h() != origItem)) {
                                    entity.getBukkitEntity().update(PlayerConnection.this.g);
                                    PlayerConnection.this.g.cn.b();
                                }
                                if (triggerLeashUpdate && (event.isCancelled() || PlayerConnection.this.g.gK().h() == null || PlayerConnection.this.g.gK().h().h() != origItem)) {
                                    PlayerConnection.this.b(new PacketPlayOutAttachEntity(entity, ((EntityInsentient)entity).C()));
                                }
                                if (event.isCancelled() || PlayerConnection.this.g.gK().h() == null || PlayerConnection.this.g.gK().h().h() != origItem) {
                                    entity.refreshEntityData(PlayerConnection.this.g);
                                    if (entity instanceof Allay) {
                                        PlayerConnection.this.b(new PacketPlayOutEntityEquipment(entity.aA(), Arrays.stream(EnumItemSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((EntityLiving)entity).a((EnumItemSlot)slot).v())).collect(Collectors.toList())));
                                        PlayerConnection.this.g.cn.b();
                                    }
                                }
                                if (event.isCancelled()) {
                                    return;
                                }
                                EnumInteractionResult enuminteractionresult = playerconnection_a.run(PlayerConnection.this.g, entity, enumhand);
                                if (!itemInHand.f() && itemInHand.N() <= -1) {
                                    PlayerConnection.this.g.cn.b();
                                }
                                if (enuminteractionresult instanceof EnumInteractionResult.d) {
                                    EnumInteractionResult.d enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult;
                                    ItemStack itemstack2 = enuminteractionresult_d.c() ? itemstack1 : ItemStack.l;
                                    CriterionTriggers.U.a(PlayerConnection.this.g, itemstack2, entity);
                                    if (enuminteractionresult_d.e() == EnumInteractionResult.e.c) {
                                        PlayerConnection.this.g.a(enumhand, true);
                                    }
                                }
                            }
                        }

                        @Override
                        public void a(EnumHand enumhand) {
                            this.performInteraction(enumhand, EntityHuman::a, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), enumhand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                        }

                        @Override
                        public void a(EnumHand enumhand, Vec3D vec3d) {
                            this.performInteraction(enumhand, (entityplayer, entity1, enumhand1) -> entity1.a(entityplayer, vec3d, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(vec3d.g, vec3d.h, vec3d.i), enumhand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                        }

                        @Override
                        public void a() {
                            EntityArrow entityarrow;
                            if (!(entity instanceof EntityItem || entity instanceof EntityExperienceOrb || entity == PlayerConnection.this.g && !PlayerConnection.this.g.au() || entity instanceof EntityArrow && !(entityarrow = (EntityArrow)entity).cT())) {
                                ItemStack itemstack = PlayerConnection.this.g.b(EnumHand.a);
                                if (!itemstack.a(worldserver.Q())) {
                                    return;
                                }
                                if (PlayerConnection.this.g.c(itemstack, 5)) {
                                    return;
                                }
                                PlayerConnection.this.g.e(entity);
                                if (!itemstack.f() && itemstack.N() <= -1) {
                                    PlayerConnection.this.g.cn.b();
                                }
                                return;
                            }
                            PlayerConnection.this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_entity_attacked"));
                            i.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.g.aq());
                        }
                    });
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInClientCommand packetplayinclientcommand) {
        PlayerConnectionUtils.a(packetplayinclientcommand, this, this.g.A());
        this.g.J();
        PacketPlayInClientCommand.EnumClientCommand packetplayinclientcommand_enumclientcommand = packetplayinclientcommand.b();
        switch (packetplayinclientcommand_enumclientcommand) {
            case a: {
                if (this.g.k) {
                    this.g.k = false;
                    this.g = this.d.aj().respawn(this.g, true, Entity.RemovalReason.e, PlayerRespawnEvent.RespawnReason.END_PORTAL);
                    this.m();
                    this.y();
                    CriterionTriggers.w.a(this.g, net.minecraft.world.level.World.j, net.minecraft.world.level.World.h);
                    break;
                }
                if (this.g.eZ() > 0.0f) {
                    return;
                }
                this.g = this.d.aj().respawn(this.g, false, Entity.RemovalReason.a, PlayerRespawnEvent.RespawnReason.DEATH);
                this.m();
                this.y();
                if (!this.d.v_()) break;
                this.g.a(EnumGamemode.d);
                this.g.A().U().set(GameRules.ab, false, this.g.A());
                break;
            }
            case b: {
                this.g.K().a(this.g);
            }
        }
    }

    @Override
    public void a(PacketPlayInCloseWindow packetplayinclosewindow) {
        PlayerConnectionUtils.a(packetplayinclosewindow, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.g);
        this.g.s();
    }

    @Override
    public void a(PacketPlayInWindowClick packetplayinwindowclick) {
        PlayerConnectionUtils.a(packetplayinwindowclick, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        this.g.J();
        if (this.g.cn.l == packetplayinwindowclick.b() && this.g.cn.b(this.g)) {
            boolean cancelled = this.g.au();
            if (!this.g.cn.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)this.g.cn);
            } else {
                short i2 = packetplayinwindowclick.f();
                if (!this.g.cn.a(i2)) {
                    i.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.g.aq(), (int)i2, this.g.cn.k.size()});
                } else {
                    boolean flag = packetplayinwindowclick.e() != this.g.cn.j();
                    this.g.cn.h();
                    if (packetplayinwindowclick.f() < -1 && packetplayinwindowclick.f() != -999) {
                        return;
                    }
                    InventoryView inventory = this.g.cn.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType((int)packetplayinwindowclick.f());
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    ItemStack itemstack = ItemStack.l;
                    switch (packetplayinwindowclick.h()) {
                        case a: {
                            if (packetplayinwindowclick.g() == 0) {
                                click = ClickType.LEFT;
                            } else if (packetplayinwindowclick.g() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packetplayinwindowclick.g() != 0 && packetplayinwindowclick.g() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.f() == -999) {
                                if (this.g.cn.g().f()) break;
                                action = packetplayinwindowclick.g() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (packetplayinwindowclick.f() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.g.cn.b(packetplayinwindowclick.f());
                            if (slot == null) break;
                            ItemStack clickedItem = slot.g();
                            ItemStack cursor = this.g.cn.g();
                            if (clickedItem.f()) {
                                if (cursor.f()) break;
                                action = packetplayinwindowclick.g() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.a(this.g)) break;
                            if (cursor.f()) {
                                action = packetplayinwindowclick.g() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.a(cursor)) {
                                if (ItemStack.c(clickedItem, cursor)) {
                                    int toPlace = packetplayinwindowclick.g() == 0 ? cursor.N() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.k() - clickedItem.N());
                                    if ((toPlace = Math.min(toPlace, slot.c.ap_() - clickedItem.N())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.N()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.N() > slot.a()) break;
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.c(cursor, clickedItem) || clickedItem.N() < 0 || clickedItem.N() + cursor.N() > cursor.k()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case b: {
                            if (packetplayinwindowclick.g() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packetplayinwindowclick.g() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packetplayinwindowclick.g() != 0 && packetplayinwindowclick.g() != 1) break;
                            if (packetplayinwindowclick.f() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.g.cn.b(packetplayinwindowclick.f());
                            if (slot != null && slot.a(this.g) && slot.h()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case c: {
                            if ((packetplayinwindowclick.g() < 0 || packetplayinwindowclick.g() >= 9) && packetplayinwindowclick.g() != 40) break;
                            click = packetplayinwindowclick.g() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.g.cn.b(packetplayinwindowclick.f());
                            if (clickedSlot.a(this.g)) {
                                boolean canCleanSwap;
                                ItemStack hotbar = this.g.gK().a(packetplayinwindowclick.g());
                                boolean bl = canCleanSwap = hotbar.f() || clickedSlot.c == this.g.gK() && clickedSlot.a(hotbar);
                                if (clickedSlot.h()) {
                                    if (canCleanSwap) {
                                        action = InventoryAction.HOTBAR_SWAP;
                                        break;
                                    }
                                    action = InventoryAction.HOTBAR_MOVE_AND_READD;
                                    break;
                                }
                                if (!clickedSlot.h() && !hotbar.f() && clickedSlot.a(hotbar)) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case d: {
                            Slot slot;
                            if (packetplayinwindowclick.g() == 2) {
                                click = ClickType.MIDDLE;
                                if (packetplayinwindowclick.f() < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.g.cn.b(packetplayinwindowclick.f());
                                if (slot != null && slot.h() && this.g.gL().d && this.g.cn.g().f()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case e: {
                            Slot slot;
                            if (packetplayinwindowclick.f() >= 0) {
                                if (packetplayinwindowclick.g() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.g.cn.b(packetplayinwindowclick.f());
                                    if (slot != null && slot.h() && slot.a(this.g) && !slot.g().f() && slot.g().h() != Item.a(Blocks.a)) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packetplayinwindowclick.g() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.g.cn.b(packetplayinwindowclick.f());
                                if (slot != null && slot.h() && slot.a(this.g) && !slot.g().f() && slot.g().h() != Item.a(Blocks.a)) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packetplayinwindowclick.g() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case g: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.f() < 0 || this.g.cn.g().f()) break;
                            ItemStack cursor = this.g.cn.g();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftItemType.minecraftToBukkit(cursor.h())) && !inventory.getBottomInventory().contains(CraftItemType.minecraftToBukkit(cursor.h()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packetplayinwindowclick.h() == InventoryClickType.f || this.g.cn.w != 0) {
                        this.g.cn.a(packetplayinwindowclick.f(), (int)packetplayinwindowclick.g(), packetplayinwindowclick.h(), this.g);
                    } else if (packetplayinwindowclick.h() != InventoryClickType.f) {
                        org.bukkit.inventory.ItemStack result;
                        Recipe recipe;
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, (int)packetplayinwindowclick.f(), click, action, (int)packetplayinwindowclick.g()) : new InventoryClickEvent(inventory, type, (int)packetplayinwindowclick.f(), click, action);
                        Inventory top = inventory.getTopInventory();
                        if (packetplayinwindowclick.f() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, (int)packetplayinwindowclick.f(), click, action, (int)packetplayinwindowclick.g()) : new CraftItemEvent(recipe, inventory, type, (int)packetplayinwindowclick.f(), click, action);
                        }
                        if (packetplayinwindowclick.f() == 3 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, (int)packetplayinwindowclick.f(), click, action, (int)packetplayinwindowclick.g()) : new SmithItemEvent(inventory, type, (int)packetplayinwindowclick.f(), click, action);
                        }
                        event.setCancelled(cancelled);
                        Container oldContainer = this.g.cn;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.g.cn != oldContainer) {
                            return;
                        }
                        block8 : switch (event.getResult()) {
                            case ALLOW: 
                            case DEFAULT: {
                                this.g.cn.a(i2, (int)packetplayinwindowclick.g(), packetplayinwindowclick.h(), this.g);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.g.cn.b();
                                        break block8;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.g.g.b(new PacketPlayOutSetSlot(-1, -1, this.g.cm.k(), this.g.cn.g()));
                                        this.g.g.b(new PacketPlayOutSetSlot(this.g.cn.l, this.g.cm.k(), packetplayinwindowclick.f(), this.g.cn.b(packetplayinwindowclick.f()).g()));
                                        break block8;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.g.g.b(new PacketPlayOutSetSlot(this.g.cn.l, this.g.cm.k(), packetplayinwindowclick.f(), this.g.cn.b(packetplayinwindowclick.f()).g()));
                                        break block8;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.g.g.b(new PacketPlayOutSetSlot(-1, -1, this.g.cm.k(), this.g.cn.g()));
                                        break block8;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.g.cn.b();
                        }
                    }
                    for (Int2ObjectMap.Entry int2objectmap_entry : Int2ObjectMaps.fastIterable(packetplayinwindowclick.i())) {
                        this.g.cn.a(int2objectmap_entry.getIntKey(), (HashedStack)int2objectmap_entry.getValue());
                    }
                    this.g.cn.a(packetplayinwindowclick.j());
                    this.g.cn.i();
                    if (flag) {
                        this.g.cn.e();
                    } else {
                        this.g.cn.d();
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInAutoRecipe packetplayinautorecipe) {
        PlayerConnectionUtils.a(packetplayinautorecipe, this, this.g.A());
        this.g.J();
        if (!this.g.au() && this.g.cn.l == packetplayinautorecipe.b()) {
            if (!this.g.cn.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)this.g.cn);
            } else {
                CraftingManager.d craftingmanager_d = this.d.aJ().a(packetplayinautorecipe.e());
                if (craftingmanager_d != null) {
                    Container container;
                    RecipeHolder recipeholder = craftingmanager_d.b();
                    if (this.g.L().b(recipeholder.a()) && (container = this.g.cn) instanceof ContainerRecipeBook) {
                        ContainerRecipeBook containerrecipebook = (ContainerRecipeBook)container;
                        if (recipeholder.b().aq_().c()) {
                            i.debug("Player {} tried to place impossible recipe {}", (Object)this.g, (Object)recipeholder.a().a());
                            return;
                        }
                        Recipe recipe = recipeholder.toBukkitRecipe();
                        if (recipe == null) {
                            return;
                        }
                        PlayerRecipeBookClickEvent event = CraftEventFactory.callRecipeBookClickEvent(this.g, recipe, packetplayinautorecipe.f());
                        recipeholder = this.d.aJ().b(CraftRecipe.toMinecraft(((Keyed)event.getRecipe()).getKey())).orElse(null);
                        if (recipeholder == null) {
                            return;
                        }
                        ContainerRecipeBook.a containerrecipebook_a = containerrecipebook.a(event.isShiftClick(), this.g.ha(), recipeholder, this.g.A(), this.g.gK());
                        if (containerrecipebook_a == ContainerRecipeBook.a.b) {
                            this.b(new PacketPlayOutAutoRecipe(this.g.cn.l, craftingmanager_d.a().b()));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInEnchantItem packetplayinenchantitem) {
        PlayerConnectionUtils.a(packetplayinenchantitem, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        this.g.J();
        if (this.g.cn.l == packetplayinenchantitem.b() && !this.g.au()) {
            if (!this.g.cn.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)this.g.cn);
            } else {
                boolean flag = this.g.cn.a((EntityHuman)this.g, packetplayinenchantitem.e());
                if (flag) {
                    this.g.cn.d();
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCreativeSlot packetplayinsetcreativeslot) {
        PlayerConnectionUtils.a(packetplayinsetcreativeslot, this, this.g.A());
        if (this.g.gv()) {
            boolean flag2;
            boolean flag = packetplayinsetcreativeslot.b() < 0;
            ItemStack itemstack = packetplayinsetcreativeslot.e();
            if (!itemstack.a(this.g.A().Q())) {
                return;
            }
            boolean flag1 = packetplayinsetcreativeslot.b() >= 1 && packetplayinsetcreativeslot.b() <= 45;
            boolean bl = flag2 = itemstack.f() || itemstack.N() <= itemstack.k();
            if (flag || flag1 && !ItemStack.a(this.g.cm.b(packetplayinsetcreativeslot.b()).g(), packetplayinsetcreativeslot.e())) {
                CraftInventoryView inventory = this.g.cm.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packetplayinsetcreativeslot.e());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packetplayinsetcreativeslot.b() < 36) {
                    type = packetplayinsetcreativeslot.b() >= 5 && packetplayinsetcreativeslot.b() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : (int)packetplayinsetcreativeslot.b(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packetplayinsetcreativeslot.b() >= 0) {
                            this.g.cm.b();
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.g.cm.b(packetplayinsetcreativeslot.b()).e(itemstack);
                this.g.cm.a((int)packetplayinsetcreativeslot.b(), itemstack);
                this.g.cm.d();
            } else if (flag && flag2) {
                if (this.t.c()) {
                    this.t.a();
                    this.g.a(itemstack, true);
                } else {
                    i.warn("Player {} was dropping items too fast in creative mode, ignoring.", (Object)this.g.aq());
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInUpdateSign packetplayinupdatesign) {
        List<String> list = Stream.of(packetplayinupdatesign.f()).map(EnumChatFormat::a).collect(Collectors.toList());
        this.a(list).thenAcceptAsync(list1 -> this.a(packetplayinupdatesign, (List<FilteredText>)list1), (Executor)this.d);
    }

    private void a(PacketPlayInUpdateSign packetplayinupdatesign, List<FilteredText> list) {
        if (this.g.fE()) {
            return;
        }
        this.g.J();
        WorldServer worldserver = this.g.A();
        BlockPosition blockposition = packetplayinupdatesign.b();
        if (worldserver.H(blockposition)) {
            TileEntity tileentity = worldserver.c_(blockposition);
            if (!(tileentity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            tileentitysign.a((EntityHuman)this.g, packetplayinupdatesign.e(), list);
        }
    }

    @Override
    public void a(PacketPlayInAbilities packetplayinabilities) {
        PlayerConnectionUtils.a(packetplayinabilities, this, this.g.A());
        if (this.g.gL().c && this.g.gL().b != packetplayinabilities.b()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.g.getBukkitEntity(), packetplayinabilities.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.g.gL().b = packetplayinabilities.b();
            } else {
                this.g.z();
            }
        }
    }

    @Override
    public void a(ServerboundClientInformationPacket serverboundclientinformationpacket) {
        PlayerConnectionUtils.a(serverboundclientinformationpacket, this, this.g.A());
        boolean flag = this.g.a(PlayerModelPart.g);
        this.g.a(serverboundclientinformationpacket.b());
        if (this.g.a(PlayerModelPart.g) != flag) {
            this.d.aj().a(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.h, this.g));
        }
    }

    @Override
    public void a(PacketPlayInDifficultyChange packetplayindifficultychange) {
        PlayerConnectionUtils.a(packetplayindifficultychange, this, this.g.A());
        if (!this.g.I().hasPermission(Permissions.b) && !this.h()) {
            i.warn("Player {} tried to change difficulty to {} without required permissions", (Object)this.g.gI().name(), (Object)packetplayindifficultychange.b().b());
        } else {
            this.d.a(packetplayindifficultychange.b(), false);
        }
    }

    @Override
    public void a(ServerboundChangeGameModePacket serverboundchangegamemodepacket) {
        PlayerConnectionUtils.a(serverboundchangegamemodepacket, this, this.g.A());
        if (!CommandGamemode.a.a(this.g.I())) {
            i.warn("Player {} tried to change game mode to {} without required permissions", (Object)this.g.gI().name(), (Object)serverboundchangegamemodepacket.b().e().getString());
        } else {
            CommandGamemode.a(this.g, serverboundchangegamemodepacket.b());
        }
    }

    @Override
    public void a(PacketPlayInDifficultyLock packetplayindifficultylock) {
        PlayerConnectionUtils.a(packetplayindifficultylock, this, this.g.A());
        if (this.g.I().hasPermission(Permissions.b) || this.h()) {
            this.d.c(packetplayindifficultylock.b());
        }
    }

    @Override
    public void a(ServerboundChatSessionUpdatePacket serverboundchatsessionupdatepacket) {
        PlayerConnectionUtils.a(serverboundchatsessionupdatepacket, this, this.g.A());
        RemoteChatSession.a remotechatsession_a = serverboundchatsessionupdatepacket.b();
        ProfilePublicKey.a profilepublickey_a = this.R != null ? this.R.d().b() : null;
        ProfilePublicKey.a profilepublickey_a1 = remotechatsession_a.b();
        if (!Objects.equals(profilepublickey_a, profilepublickey_a1)) {
            if (profilepublickey_a != null && profilepublickey_a1.b().isBefore(profilepublickey_a.b())) {
                this.a(ProfilePublicKey.a);
            } else {
                try {
                    SignatureValidator signaturevalidator = this.d.ar().a();
                    if (signaturevalidator == null) {
                        i.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.g.gI().name());
                        return;
                    }
                    this.a(remotechatsession_a.a(this.g.gI(), signaturevalidator));
                }
                catch (ProfilePublicKey.b profilepublickey_b) {
                    i.error("Failed to validate profile key: {}", (Object)profilepublickey_b.getMessage());
                    this.a(profilepublickey_b.a());
                }
            }
        }
    }

    @Override
    public void a(ServerboundConfigurationAcknowledgedPacket serverboundconfigurationacknowledgedpacket) {
        if (!this.X) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.e.a(ConfigurationProtocols.b, new ServerConfigurationPacketListenerImpl(this.d, this.e, this.a(this.g.E()), this.g));
    }

    @Override
    public void a(ServerboundChunkBatchReceivedPacket serverboundchunkbatchreceivedpacket) {
        PlayerConnectionUtils.a(serverboundchunkbatchreceivedpacket, this, this.g.A());
        this.h.a(serverboundchunkbatchreceivedpacket.b());
    }

    @Override
    public void a(ServerboundDebugSubscriptionRequestPacket serverbounddebugsubscriptionrequestpacket) {
        PlayerConnectionUtils.a(serverbounddebugsubscriptionrequestpacket, this, this.g.A());
        this.g.a(serverbounddebugsubscriptionrequestpacket.b());
    }

    private void a(RemoteChatSession remotechatsession) {
        this.R = remotechatsession;
        this.S = remotechatsession.a(this.g.cY());
        this.W.append(() -> {
            this.g.a(remotechatsession);
            this.d.aj().a(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.b), List.of(this.g)));
        });
    }

    @Override
    public void a(ServerboundClientTickEndPacket serverboundclienttickendpacket) {
        PlayerConnectionUtils.a(serverboundclienttickendpacket, this, this.g.A());
        if (!this.Q) {
            this.g.a(Vec3D.c);
        }
        this.Q = false;
    }

    private void a(Vec3D vec3d) {
        if (vec3d.h() > (double)1.0E-5f) {
            this.g.J();
        }
        this.g.a(vec3d);
        this.Q = true;
    }

    @Override
    public boolean a() {
        return this.g.gv();
    }

    @Override
    public EntityPlayer p() {
        return this.g;
    }

    public boolean q() {
        return !this.Y && this.Z <= 0;
    }

    public void r() {
        if (this.Z > 0) {
            --this.Z;
        }
    }

    private void x() {
        this.Z = 0;
    }

    public void s() {
        this.Y = true;
    }

    private void y() {
        this.Y = false;
        this.Z = 60;
    }

    @FunctionalInterface
    private static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

