/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.local.LocalAddress;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.NetworkManagerServer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.EventLoopGroupHolder;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.server.network.LegacyPingHandler;
import net.minecraft.server.network.MemoryServerHandshakePacketListenerImpl;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerConnection {
    private static final Logger b = LogUtils.getLogger();
    final MinecraftServer c;
    public volatile boolean a;
    private final List<ChannelFuture> d = Collections.synchronizedList(Lists.newArrayList());
    final List<NetworkManager> e = Collections.synchronizedList(Lists.newArrayList());

    public ServerConnection(MinecraftServer minecraftserver) {
        this.c = minecraftserver;
        this.a = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(@Nullable InetAddress inetaddress, int i2) throws IOException {
        List<ChannelFuture> list = this.d;
        synchronized (list) {
            EventLoopGroupHolder eventloopgroupholder = EventLoopGroupHolder.a(this.c.p());
            this.d.add(((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(eventloopgroupholder.e())).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    try {
                        channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                    }
                    catch (ChannelException channelException) {
                        // empty catch block
                    }
                    ChannelPipeline channelpipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                    if (ServerConnection.this.c.an()) {
                        channelpipeline.addLast("legacy_query", (ChannelHandler)new LegacyPingHandler(ServerConnection.this.d()));
                    }
                    NetworkManager.a(channelpipeline, EnumProtocolDirection.a, false, null);
                    int j2 = ServerConnection.this.c.o();
                    NetworkManager networkmanager = j2 > 0 ? new NetworkManagerServer(j2) : new NetworkManager(EnumProtocolDirection.a);
                    ServerConnection.this.e.add(networkmanager);
                    networkmanager.a(channelpipeline);
                    networkmanager.a(new HandshakeListener(ServerConnection.this.c, networkmanager));
                }
            }).group(eventloopgroupholder.c()).localAddress(inetaddress, i2)).option(ChannelOption.AUTO_READ, (Object)false)).bind().syncUninterruptibly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptConnections() {
        List<ChannelFuture> list = this.d;
        synchronized (list) {
            for (ChannelFuture future : this.d) {
                future.channel().config().setAutoRead(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress a() {
        ChannelFuture channelfuture;
        List<ChannelFuture> list = this.d;
        synchronized (list) {
            channelfuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(EventLoopGroupHolder.a().e())).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.a);
                    networkmanager.a(new MemoryServerHandshakePacketListenerImpl(ServerConnection.this.c, networkmanager));
                    ServerConnection.this.e.add(networkmanager);
                    ChannelPipeline channelpipeline = channel.pipeline();
                    NetworkManager.a(channelpipeline, EnumProtocolDirection.a);
                    if (SharedConstants.aJ > 0) {
                        channelpipeline.addLast("latency", (ChannelHandler)new LatencySimulator(SharedConstants.aJ, SharedConstants.aK));
                    }
                    networkmanager.a(channelpipeline);
                }
            }).group(EventLoopGroupHolder.a().c()).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
            this.d.add(channelfuture);
        }
        return channelfuture.channel().localAddress();
    }

    public void b() {
        this.a = false;
        for (ChannelFuture channelfuture : this.d) {
            try {
                channelfuture.channel().close().sync();
            }
            catch (InterruptedException interruptedexception) {
                b.error("Interrupted whilst closing channel");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void c() {
        List<NetworkManager> list = this.e;
        synchronized (list) {
            if (SpigotConfig.playerShuffle > 0 && MinecraftServer.currentTick % SpigotConfig.playerShuffle == 0) {
                Collections.shuffle(this.e);
            }
            Iterator<NetworkManager> iterator = this.e.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkmanager = iterator.next();
                if (networkmanager.j()) continue;
                if (networkmanager.i()) {
                    try {
                        networkmanager.b();
                    }
                    catch (Exception exception) {
                        if (networkmanager.e()) {
                            throw new ReportedException(CrashReport.a(exception, "Ticking memory connection"));
                        }
                        b.warn("Failed to handle packet for {}", (Object)networkmanager.a(this.c.bn()), (Object)exception);
                        IChatMutableComponent ichatbasecomponent = IChatBaseComponent.b("Internal server error");
                        networkmanager.a(new ClientboundDisconnectPacket(ichatbasecomponent), PacketSendListener.a(() -> networkmanager.a(ichatbasecomponent)));
                        networkmanager.m();
                    }
                    continue;
                }
                if (networkmanager.preparing) continue;
                iterator.remove();
                networkmanager.n();
            }
        }
    }

    public MinecraftServer d() {
        return this.c;
    }

    public List<NetworkManager> e() {
        return this.e;
    }

    private static class LatencySimulator
    extends ChannelInboundHandlerAdapter {
        private static final Timer a = new HashedWheelTimer();
        private final int b;
        private final int c;
        private final List<DelayedMessage> d = Lists.newArrayList();

        public LatencySimulator(int i2, int j2) {
            this.b = i2;
            this.c = j2;
        }

        public void channelRead(ChannelHandlerContext channelhandlercontext, Object object) {
            this.a(channelhandlercontext, object);
        }

        private void a(ChannelHandlerContext channelhandlercontext, Object object) {
            int i2 = this.b + (int)(Math.random() * (double)this.c);
            this.d.add(new DelayedMessage(channelhandlercontext, object));
            a.newTimeout(this::a, (long)i2, TimeUnit.MILLISECONDS);
        }

        private void a(Timeout timeout) {
            DelayedMessage serverconnection_latencysimulator_delayedmessage = this.d.remove(0);
            serverconnection_latencysimulator_delayedmessage.a.fireChannelRead(serverconnection_latencysimulator_delayedmessage.b);
        }

        private static class DelayedMessage {
            public final ChannelHandlerContext a;
            public final Object b;

            public DelayedMessage(ChannelHandlerContext channelhandlercontext, Object object) {
                this.a = channelhandlercontext;
                this.b = object;
            }
        }
    }
}

