/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network.config;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public class PrepareSpawnTask
implements ConfigurationTask {
    static final Logger c = LogUtils.getLogger();
    public static final ConfigurationTask.a a = new ConfigurationTask.a("prepare_spawn");
    public static final int b = 3;
    final MinecraftServer d;
    final EntityPlayer e;
    final LevelLoadListener f;
    private @Nullable c g;

    public PrepareSpawnTask(MinecraftServer minecraftserver, EntityPlayer nameandid) {
        this.d = minecraftserver;
        this.e = nameandid;
        this.f = minecraftserver.bo();
    }

    @Override
    public void a(Consumer<Packet<?>> consumer) {
        try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(c);){
            Optional<ValueInput> optional = this.d.aj().loadPlayerData(this.e).map(nbttagcompound -> TagValueInput.a((ProblemReporter)problemreporter_j, (HolderLookup.a)this.d.bc(), nbttagcompound));
            EntityPlayer.c entityplayer_c = optional.flatMap(valueinput -> valueinput.a(EntityPlayer.c.a)).orElse(EntityPlayer.c.b);
            WorldData.a worlddata_a = this.e.A().C();
            Optional<ResourceKey<World>> optional1 = entityplayer_c.a();
            MinecraftServer minecraftserver = this.d;
            Objects.requireNonNull(this.d);
            WorldServer worldserver = optional1.map(minecraftserver::a).orElseGet(() -> {
                WorldServer worldserver1 = this.d.a(worlddata_a.a());
                return worldserver1 != null ? worldserver1 : this.d.N();
            });
            CompletableFuture completablefuture = entityplayer_c.b().map(CompletableFuture::completedFuture).orElseGet(() -> PlayerSpawnFinder.a(worldserver, worlddata_a.b()));
            Vec2F vec2f = entityplayer_c.c().orElse(new Vec2F(worlddata_a.d(), worlddata_a.e()));
            this.g = new a(worldserver, completablefuture, vec2f);
        }
    }

    @Override
    public boolean a() {
        boolean flag;
        c preparespawntask_c = this.g;
        boolean b0 = false;
        if (preparespawntask_c instanceof a) {
            a preparespawntask_a = (a)preparespawntask_c;
            b preparespawntask_b = preparespawntask_a.b();
            if (preparespawntask_b != null) {
                this.g = preparespawntask_b;
                flag = true;
            } else {
                flag = false;
            }
        } else if (preparespawntask_c instanceof b) {
            b preparespawntask_b1 = (b)preparespawntask_c;
            flag = true;
        } else {
            flag = false;
        }
        return flag;
    }

    public EntityPlayer a(NetworkManager networkmanager, CommonListenerCookie commonlistenercookie) {
        c preparespawntask_c = this.g;
        if (preparespawntask_c instanceof b) {
            b preparespawntask_b = (b)preparespawntask_c;
            return preparespawntask_b.a(networkmanager, commonlistenercookie);
        }
        throw new IllegalStateException("Player spawn was not ready");
    }

    public void c() {
        c preparespawntask_c = this.g;
        if (preparespawntask_c instanceof b) {
            b preparespawntask_b = (b)preparespawntask_c;
            preparespawntask_b.a();
        }
    }

    public void d() {
        c preparespawntask_c = this.g;
        if (preparespawntask_c instanceof a) {
            a preparespawntask_a = (a)preparespawntask_c;
            preparespawntask_a.a();
        }
        this.g = null;
    }

    @Override
    public ConfigurationTask.a b() {
        return a;
    }

    private final class a
    implements c {
        private final WorldServer b;
        private final CompletableFuture<Vec3D> c;
        private final Vec2F d;
        private @Nullable CompletableFuture<?> e;
        private final ChunkLoadCounter f = new ChunkLoadCounter();

        a(WorldServer worldserver, CompletableFuture completablefuture, Vec2F vec2f) {
            this.b = worldserver;
            this.c = completablefuture;
            this.d = vec2f;
        }

        public void a() {
            this.c.cancel(false);
        }

        public @Nullable b b() {
            if (!this.c.isDone()) {
                return null;
            }
            Vec3D vec3d = this.c.join();
            if (this.e == null) {
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(vec3d));
                this.f.a(this.b, () -> {
                    this.e = this.b.p().a(TicketType.g, chunkcoordintpair, 3);
                });
                PrepareSpawnTask.this.f.a(LevelLoadListener.a.d, this.f.c());
                PrepareSpawnTask.this.f.a(this.b.aq(), chunkcoordintpair);
            }
            PrepareSpawnTask.this.f.a(LevelLoadListener.a.d, this.f.a(), this.f.c());
            if (!this.e.isDone()) {
                return null;
            }
            PrepareSpawnTask.this.f.a(LevelLoadListener.a.d);
            PrepareSpawnTask prepareSpawnTask = PrepareSpawnTask.this;
            Objects.requireNonNull(prepareSpawnTask);
            return prepareSpawnTask.new b(this.b, vec3d, this.d);
        }
    }

    private static sealed interface c
    permits a, b {
    }

    private final class b
    implements c {
        private final WorldServer b;
        private final Vec3D c;
        private final Vec2F d;

        b(WorldServer worldserver, Vec3D vec3d, Vec2F vec2f) {
            this.b = worldserver;
            this.c = vec3d;
            this.d = vec2f;
        }

        public void a() {
            this.b.p().b(TicketType.g, new ChunkCoordIntPair(BlockPosition.a(this.c)), 3);
        }

        public EntityPlayer a(NetworkManager networkmanager, CommonListenerCookie commonlistenercookie) {
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(this.c));
            this.b.a(chunkcoordintpair, 3);
            EntityPlayer entityplayer = PrepareSpawnTask.this.e;
            try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(entityplayer.es(), c);){
                Optional<ValueInput> optional = PrepareSpawnTask.this.d.aj().loadPlayerData(PrepareSpawnTask.this.e).map(nbttagcompound -> TagValueInput.a((ProblemReporter)problemreporter_j, (HolderLookup.a)PrepareSpawnTask.this.d.bc(), nbttagcompound));
                Objects.requireNonNull(entityplayer);
                optional.ifPresent(entityplayer::d);
                entityplayer.b(this.c, this.d.j, this.d.k);
                CraftPlayer spawnPlayer = entityplayer.getBukkitEntity();
                PlayerSpawnLocationEvent ev = new PlayerSpawnLocationEvent((Player)spawnPlayer, spawnPlayer.getLocation());
                spawnPlayer.getServer().getPluginManager().callEvent((Event)ev);
                Location loc = ev.getSpawnLocation();
                WorldServer spawnWorld = ((CraftWorld)loc.getWorld()).getHandle();
                entityplayer.spawnIn(spawnWorld, true);
                entityplayer.h.a(entityplayer.A());
                entityplayer.a(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
                PrepareSpawnTask.this.d.aj().a(networkmanager, entityplayer, commonlistenercookie);
                optional.ifPresent(valueinput -> {
                    entityplayer.c((ValueInput)valueinput);
                    entityplayer.b((ValueInput)valueinput);
                });
                EntityPlayer entityPlayer = entityplayer;
                return entityPlayer;
            }
        }
    }
}

