/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.ResourcePackFile;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.PackDetector;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;
import net.minecraft.util.FileUtils;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ResourcePackSourceFolder
implements ResourcePackSource {
    static final Logger a = LogUtils.getLogger();
    private static final PackSelectionConfig b = new PackSelectionConfig(false, ResourcePackLoader.Position.a, false);
    private final Path c;
    private final EnumResourcePackType d;
    private final PackSource e;
    private final DirectoryValidator f;

    public ResourcePackSourceFolder(Path var0, EnumResourcePackType var1, PackSource var2, DirectoryValidator var3) {
        this.c = var0;
        this.d = var1;
        this.e = var2;
        this.f = var3;
    }

    private static String a(Path var0) {
        return var0.getFileName().toString();
    }

    @Override
    public void loadPacks(Consumer<ResourcePackLoader> var0) {
        try {
            FileUtils.c(this.c);
            ResourcePackSourceFolder.a(this.c, this.f, (var1, var2) -> {
                PackLocationInfo var3 = this.b((Path)var1);
                ResourcePackLoader var4 = ResourcePackLoader.a(var3, var2, this.d, b);
                if (var4 != null) {
                    var0.accept(var4);
                }
            });
        }
        catch (IOException var12) {
            a.warn("Failed to list packs in {}", (Object)this.c, (Object)var12);
        }
    }

    private PackLocationInfo b(Path var0) {
        String var1 = ResourcePackSourceFolder.a(var0);
        return new PackLocationInfo("file/" + var1, IChatBaseComponent.b(var1), this.e, Optional.empty());
    }

    public static void a(Path var0, DirectoryValidator var1, BiConsumer<Path, ResourcePackLoader.c> var2) throws IOException {
        a var3 = new a(var1);
        try (DirectoryStream<Path> var4 = Files.newDirectoryStream(var0);){
            for (Path var6 : var4) {
                try {
                    ArrayList<ForbiddenSymlinkInfo> var7 = new ArrayList<ForbiddenSymlinkInfo>();
                    ResourcePackLoader.c var8 = (ResourcePackLoader.c)var3.a(var6, var7);
                    if (!var7.isEmpty()) {
                        a.warn("Ignoring potential pack entry: {}", (Object)ContentValidationException.a(var6, var7));
                        continue;
                    }
                    if (var8 != null) {
                        var2.accept(var6, var8);
                        continue;
                    }
                    a.info("Found non-pack entry '{}', ignoring", (Object)var6);
                }
                catch (IOException var7) {
                    a.warn("Failed to read properties of '{}', ignoring", (Object)var6, (Object)var7);
                }
            }
        }
    }

    static class a
    extends PackDetector<ResourcePackLoader.c> {
        protected a(DirectoryValidator var0) {
            super(var0);
        }

        protected @Nullable ResourcePackLoader.c a(Path var0) {
            FileSystem var1 = var0.getFileSystem();
            if (var1 == FileSystems.getDefault() || var1 instanceof LinkFileSystem) {
                return new ResourcePackFile.a(var0);
            }
            a.info("Can't open pack archive at {}", (Object)var0);
            return null;
        }

        protected ResourcePackLoader.c b(Path var0) {
            return new PathPackResources.a(var0);
        }

        @Override
        protected /* synthetic */ Object c(Path path) throws IOException {
            return this.b(path);
        }

        @Override
        protected /* synthetic */ @Nullable Object d(Path path) throws IOException {
            return this.a(path);
        }
    }
}

